#include	<windows.h>
#include	<dsound.h>
#include	"common.h"
#include	"xmil.h"
#include	"dsounds.h"
#include	"opm.h"
#include	"dosio.h"

#ifdef USE_DSOUND7

extern	LPDIRECTSOUND		pDSound;
static	LPDIRECTSOUNDBUFFER	pDSData7 = NULL;
static	LPDIRECTSOUNDNOTIFY	pDSNotify7 = NULL;
static	LPDIRECTSOUNDBUFFER pDSwave7[WAVEMAX] = { NULL, };

#define	dwEventNum		3
static	HANDLE	opmEvent[3] = { NULL, NULL, NULL };
static	HANDLE	opmThreadHandle = INVALID_HANDLE_VALUE;
static	DWORD	dwThreadID;
static	int		killopmThread = 1;
static	DWORD	DSData7Event = OPM_NOMAKE;
static	BYTE	dsound7enable = 0;


static void dx7_buffer_out(DWORD pos) {

	HRESULT	hr;
	LPBYTE	lpBlockAdd1;
	LPBYTE	lpBlockAdd2;
	DWORD	blockSize1;
	DWORD	blockSize2;

	if (!killopmThread) {
		if ((hr = pDSData7->Lock(pos, ds_halfbuffer,
							(LPVOID*)&lpBlockAdd1, &blockSize1,
							(LPVOID*)&lpBlockAdd2, &blockSize2, 0))
												== DSERR_BUFFERLOST) {
			pDSData7->Restore();
			hr = pDSData7->Lock(pos, ds_halfbuffer,
							(LPVOID*)&lpBlockAdd1, &blockSize1,
							(LPVOID*)&lpBlockAdd2, &blockSize2, 0);
		}
		if (SUCCEEDED(hr)) {
			CopyMemory(lpBlockAdd1, pcmbuffer, blockSize1);
			if (lpBlockAdd2 != NULL) {
				CopyMemory(lpBlockAdd2, pcmbuffer + blockSize1,
													blockSize2);
			}
			pDSData7->Unlock(lpBlockAdd1, blockSize1,
										lpBlockAdd2, blockSize2);
		}
	}
}

static void dx7_buffer_zero(DWORD pos) {

	HRESULT	hr;
	LPBYTE	lpBlockAdd1;
	LPBYTE	lpBlockAdd2;
	DWORD	blockSize1;
	DWORD	blockSize2;

	if (!killopmThread) {
		if ((hr = pDSData7->Lock(pos, ds_halfbuffer,
								(LPVOID*)&lpBlockAdd1, &blockSize1,
								(LPVOID*)&lpBlockAdd2, &blockSize2, 0))
													== DSERR_BUFFERLOST) {
			pDSData7->Restore();
			hr = pDSData7->Lock(DSData7Event, ds_halfbuffer,
								(LPVOID*)&lpBlockAdd1, &blockSize1,
								(LPVOID*)&lpBlockAdd2, &blockSize2, 0);
		}
		if (SUCCEEDED(hr)) {
			ZeroMemory(lpBlockAdd1, blockSize1);
			if (lpBlockAdd2 != NULL) {
				ZeroMemory(lpBlockAdd2, blockSize2);
			}
			pDSData7->Unlock(lpBlockAdd1, blockSize1,
										lpBlockAdd2, blockSize2);
		}
	}
}


DWORD WINAPI opmThreadFunc(LPVOID param) {				// Xbh

	DWORD	act;

	dx7_buffer_zero(0);
	dx7_buffer_zero(ds_halfbuffer);
	pDSData7->Play(0, 0, DSBPLAY_LOOPING);

	while(!*((int *)param)) {
		act = WaitForMultipleObjects(dwEventNum, opmEvent,
													FALSE, INFINITE);
		if (act == WAIT_OBJECT_0) {
			if (dsound7enable) {
				DSData7Event = ds_halfbuffer;
			}
			else {
				dx7_buffer_zero(ds_halfbuffer);
			}
		}
		else if (act == (WAIT_OBJECT_0 + 1)) {
			if (dsound7enable) {
				DSData7Event = 0;
			}
			else {
				dx7_buffer_zero(0);
			}
		}
		else {
			break;
		}
	}
	return(0L);
}


int dx7_InitSoundBuffer(void) {							// obt@쐬

	DSBUFFERDESC		dsbdesc;
    PCMWAVEFORMAT		pcmwf;
	DSBPOSITIONNOTIFY 	pn[3];

	if (pDSound == NULL) {
		return(FAILURE);
	}
	dsounds_makepara();
	INX1F_resetsamplepos();
	DSData7Event = OPM_NOMAKE;

	opmEvent[0] = CreateEvent(NULL, FALSE, FALSE, NULL);
	opmEvent[1] = CreateEvent(NULL, FALSE, FALSE, NULL);
	opmEvent[2] = CreateEvent(NULL, FALSE, FALSE, NULL);

    ZeroMemory(&pcmwf, sizeof(PCMWAVEFORMAT));
    pcmwf.wf.wFormatTag = WAVE_FORMAT_PCM;
    pcmwf.wf.nChannels = PCMCHANNELS;
    pcmwf.wf.nSamplesPerSec = ds_rate;
    pcmwf.wBitsPerSample = PCMBITS;
    pcmwf.wf.nBlockAlign = PCMMUL;
    pcmwf.wf.nAvgBytesPerSec = ds_rate * PCMMUL;

	ZeroMemory(&dsbdesc, sizeof(DSBUFFERDESC));
	dsbdesc.dwSize = sizeof(DSBUFFERDESC);
	dsbdesc.dwFlags = DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_GLOBALFOCUS |
						DSBCAPS_LOCDEFER | DSBCAPS_CTRLPOSITIONNOTIFY;
	dsbdesc.lpwfxFormat = (LPWAVEFORMATEX)&pcmwf;
	dsbdesc.dwBufferBytes = ds_halfbuffer * 2;

	if (FAILED(pDSound->CreateSoundBuffer(&dsbdesc, &pDSData7, NULL))) {
		return(FAILURE);
	}

	if (FAILED(pDSData7->QueryInterface(IID_IDirectSoundNotify,
													(LPVOID*)&pDSNotify7))) {
		return(FAILURE);
	}

	pn[0].dwOffset = 0;
	pn[0].hEventNotify = opmEvent[0];
	pn[1].dwOffset = ds_halfbuffer;
	pn[1].hEventNotify = opmEvent[1];
	pn[2].dwOffset = DSBPN_OFFSETSTOP;
	pn[2].hEventNotify = opmEvent[2];
	if (pDSNotify7->SetNotificationPositions(dwEventNum, pn) != DS_OK) {
		return(FAILURE);
	}

	killopmThread = 0;
	if ((opmThreadHandle = CreateThread(NULL, 0, opmThreadFunc,
							(void *)&killopmThread, 0, &dwThreadID))
												== INVALID_HANDLE_VALUE) {
		killopmThread = 1;
		return(FAILURE);
	}
	return(SUCCESS);
}


void dx7_TermSoundBuffer(void) {

	if (pDSData7 != NULL) {
		pDSData7->Stop();
	}
	killopmThread = 1;

	if (opmThreadHandle != INVALID_HANDLE_VALUE) {
		if (WaitForSingleObject(opmThreadHandle, INFINITE) == WAIT_TIMEOUT) {
			TerminateThread(opmThreadHandle, 0);
		}
		CloseHandle(opmThreadHandle);
		opmThreadHandle = INVALID_HANDLE_VALUE;
	}

	RELEASE(pDSNotify7);

	if (opmEvent[2]) {
		CloseHandle(opmEvent[2]);
		opmEvent[2] = NULL;
	}
	if (opmEvent[1]) {
		CloseHandle(opmEvent[1]);
		opmEvent[1] = NULL;
	}
	if (opmEvent[0]) {
		CloseHandle(opmEvent[0]);
		opmEvent[0] = NULL;
	}

	RELEASE(pDSData7);
}


void dx7_MakeSoundBuffer(DWORD samples) {

	INX1F_makesample(samples);
	dx7_ProcSoundBuffer();
}

void dx7_ProcSoundBuffer(void) {

	if (DSData7Event != OPM_NOMAKE) {
		INX1F_makesample(pcmfreemax);
		dx7_buffer_out(DSData7Event);
		DSData7Event = OPM_NOMAKE;
		INX1F_resetsamplepos();
	}
}


// -----------------------------------------------------------------------

void dx7_WaveInit(void) {

	int		i;

	for (i=0; i<WAVEMAX; i++) {
		pDSwave7[i] = NULL;
	}
}

int dx7_WaveCreate(LPSTR filename, int num, int volume) {

	HRESULT			hr;
	FILEH			src;
	DSBUFFERDESC	dsbdesc;
	PCMWAVEFORMAT	pcmwf;
	WAVE_HEADER		whead;
	WAVE_INFOS		winfo;
	long			seekp;
	LPVOID			lpvPtr1;
	LPVOID			lpvPtr2;
	DWORD			dwBytes1;
	DWORD			dwBytes2;

	if ((pDSound == NULL) || (num >= WAVEMAX)) {
		return(FAILURE);
	}
	if ((src = file_open_c(filename)) == (FILEH)-1) {
		return(FAILURE);
	}
	if ((file_read(src, &whead, sizeof(whead)) != sizeof(whead)) ||
		(whead.head != C4_DWORD('R','I','F','F'))) {
		file_close(src);
		return(FAILURE);
	}
	if ((file_read(src, &whead, 4) != 4) ||
		(whead.head != C4_DWORD('W','A','V','E'))) {
		file_close(src);
		return(FAILURE);
	}
	if ((file_read(src, &whead, sizeof(whead)) != sizeof(whead)) ||
		(whead.head != C4_DWORD('f','m','t',' ')) ||
		(file_read(src, &winfo, sizeof(winfo)) != sizeof(winfo))) {
		file_close(src);
		return(FAILURE);
	}
	seekp = whead.size + 20;
	file_seek(src, seekp, FSEEK_SET);
	if (file_read(src, &whead, sizeof(whead)) != sizeof(whead)) {
		file_close(src);
		return(FAILURE);
	}
	if (whead.head == C4_DWORD('f','a','c','t')) {
		seekp += whead.size + 8;
		file_seek(src, seekp, FSEEK_SET);
		if (file_read(src, &whead, sizeof(whead)) != sizeof(whead)) {
			file_close(src);
			return(FAILURE);
		}
	}
	if (whead.head != C4_DWORD('d','a','t','a')) {
		file_close(src);
		return(FAILURE);
	}

	ZeroMemory(&pcmwf, sizeof(PCMWAVEFORMAT));
	pcmwf.wf.wFormatTag = winfo.format;
	pcmwf.wf.nChannels = winfo.channel;
	pcmwf.wf.nSamplesPerSec = winfo.rate;
	pcmwf.wBitsPerSample = winfo.bit;
	pcmwf.wf.nBlockAlign = winfo.block;
	pcmwf.wf.nAvgBytesPerSec = winfo.rps;

	ZeroMemory(&dsbdesc, sizeof(DSBUFFERDESC));
	dsbdesc.dwSize = sizeof(DSBUFFERDESC);
	dsbdesc.dwFlags = DSBCAPS_GLOBALFOCUS | DSBCAPS_LOCDEFER |
						DSBCAPS_CTRLVOLUME;
	dsbdesc.dwBufferBytes = whead.size;
	dsbdesc.lpwfxFormat = (LPWAVEFORMATEX)&pcmwf;

	if (FAILED(pDSound->CreateSoundBuffer(&dsbdesc, &pDSwave7[num], NULL))) {
		file_close(src);
		return(FAILURE);
	}
	dx7_WaveVolume(num, volume);

	if ((hr = pDSwave7[num]->Lock(0, whead.size,
						&lpvPtr1, &dwBytes1, &lpvPtr2, &dwBytes2, 0))
														== DSERR_BUFFERLOST) {
		pDSwave7[num]->Restore();
		hr = pDSwave7[num]->Lock(0, whead.size,
						&lpvPtr1, &dwBytes1, &lpvPtr2, &dwBytes2, 0);
	} 
	if (SUCCEEDED(hr)) {
		file_lread(src, lpvPtr1, dwBytes1);
		if (dwBytes2) {
			file_lread(src, lpvPtr2, dwBytes2);
		}
		pDSwave7[num]->Unlock(lpvPtr1, dwBytes1, lpvPtr2, dwBytes2);
	}
	return(SUCCESS);
}

int dx7_WavePlay(int num, int lpflg) {

	DWORD	flg = 0;

	if ((num >= WAVEMAX) || (pDSwave7[num] == NULL)) {
		return(FAILURE);
	}
	if (lpflg) {
		flg = DSBPLAY_LOOPING;
	}
//	pDSwave7[num]->SetCurrentPosition(0);
	pDSwave7[num]->Play(0, num+1, flg);
	return(SUCCESS);
}

void dx7_WaveVolume(int num, int volume) {

	if ((num < WAVEMAX) && (pDSwave7[num])) {
		pDSwave7[num]->SetVolume((((DSBVOLUME_MAX - DSBVOLUME_MIN) * volume)
											/ 100) + DSBVOLUME_MIN);
	}
}

void dx7_WaveStop(int num) {

	if ((num < WAVEMAX) && (pDSwave7[num])) {
		pDSwave7[num]->Stop();
	}
}

void dx7_WaveRelease(int num) {

	if ((num < WAVEMAX) && (pDSwave7[num])) {
		pDSwave7[num]->Stop();
		pDSwave7[num]->Release();
	}
}

void dx7_WaveAllTerm(void) {

	int		i;

	for (i=0; i<WAVEMAX; i++) {
		dx7_WaveRelease(i);
	}
}


// --------------------------------------------------------------------------


void dx7_PlayDirectSound(void) {

	dsound7enable = 1;
}

void dx7_StopDirectSound(void) {

	int		i;

	dsound7enable = 0;
	for (i=0; i<WAVEMAX; i++) {
		dx7_WaveStop(i);
	}
}

void dx7_ClearSoundBuffer(void) { }
void dx7_ResetSoundBuffer(void) {

	INX1F_resetsamplepos();
}

#endif
