#include	<windows.h>

#include	"common.h"
#include	"x1.h"
#include	"dosio.h"
#include	"parts.h"

static	char	fontname[] = "FONT.BMP";

#define	FONTYSIZE		16

#define	BMPWIDTH		2048L
#define	BMPHEIGHT		2048L

#define	BMPLINESIZE		(BMPWIDTH / 8)			// ؂^^;

#define	BMPDATASIZE		(BMPLINESIZE * BMPHEIGHT)

											// vg^Cv
void t98ankcpy(BYTE *dst, BYTE *src, WORD from, WORD to);
void t98sjiscpy(BYTE *dst, BYTE *src, WORD from, WORD to);


// YUKI T98  FONT.BMP KNJ_FNTփRs[
BYTE t98fontread(BYTE loaded) {

	FILEH				fh;
	BYTE				loadedt98 = 0;
	BITMAPFILEHEADER	bmf;
	BITMAPINFOHEADER	bmi;
	HANDLE				hbmpdata;
	BYTE				*bmpdata;

	// t@C݂邩H
	if (file_attr_c(fontname) == -1) {
		return(0);							// t@C݂Ȃ
	}

	// A[P[g
	if ((hbmpdata = GlobalAlloc(GPTR, BMPDATASIZE)) == NULL) {
		return(0);							// A[P[gɎs
	}

	// bNyу|C^擾
	if ((bmpdata = (BYTE *)GlobalLock(hbmpdata)) == NULL) {
		GlobalFree(hbmpdata);				// A[P[gɎs
		return(0);
	}

	// t@CI[v
	if ((fh = file_open_c(fontname)) == (FILEH)-1) {
		GlobalUnlock(hbmpdata);				// I[vɎs
		GlobalFree(hbmpdata);
		return(0);
	}

	for (;;) {								// gotogȂ ܂Ȃ
		// BITMAPFILEHEADER ̓ǂݍ
		if (file_read(fh, &bmf, sizeof(BITMAPFILEHEADER))
								!= sizeof(BITMAPFILEHEADER)) {
			break;							// ǂݍݎs
		}

		// ^Cv BMH
		if (bmf.bfType != 0x4d42) {
			break;							// "BM" ł͂Ȃ
		}

		// BITMAPINFOHEADER ̓ǂݍ
		if (file_read(fh, &bmi, sizeof(BITMAPINFOHEADER))
								!= sizeof(BITMAPINFOHEADER)) {
			break;							// ǂݍݎs
		}

		// \̃TCY͐H
		if (bmi.biSize != sizeof(BITMAPINFOHEADER)) {
			break;							// s
		}
		// v[͂PH
		if (bmi.biPlanes != 1) {
			break;							// s
		}
		// PFł邩H
		if (bmi.biBitCount != 1) {
			break;							// s
		}
		// TCY͐H
		if (bmi.biWidth != BMPWIDTH) {
			break;							// s
		}
		// cTCY͐H
		if (bmi.biHeight != BMPHEIGHT) {
			break;							// s
		}
		// C[WTCY͂Ă邩H
		if (bmi.biSizeImage != BMPDATASIZE) {
			break;							// s
		}
		// kH
		if (bmi.biCompression != 0) {
			break;							// s
		}

		// BITMAPf[^
		if (file_seek(fh, bmf.bfOffBits, FSEEK_SET) != bmf.bfOffBits) {
			break;							// V[NɎs
		}

		// BITMAPf[^̓ǂ݂
		if (file_lread(fh, bmpdata, BMPDATASIZE) != BMPDATASIZE) {
			break;							// ɓǂ݂Ȃ
		}

		// 8x16 tHg(`0x7f)͓ǂݍ܂ĂH
		if (!(loaded & FONT_ANK16a)) {
			// ǂݍ܂ĂȂ̂ 8x16tHgRs[
			t98ankcpy(&KNJ_FNT[0x0000], bmpdata, 0, 0x80);
			loadedt98 |= FONT_ANK16a;
		}
		// 8x16 tHg(0x80`)͓ǂݍ܂ĂH
		if (!(loaded & FONT_ANK16b)) {
			// ǂݍ܂ĂȂ̂ 8x16tHgRs[
			t98ankcpy(&KNJ_FNT[0x0800], bmpdata, 0x80, 0x100);
			loadedt98 |= FONT_ANK16b;
		}

		// ꐅ͓ǂݍ܂ĂH
		if (!(loaded & FONT_KNJ1)) {
			// SJISR[h 0x8140 ` 0x84bf ̃Rs[
			t98sjiscpy(&KNJ_FNT[0x01000], bmpdata, 0x8140, 0x84c0);

			// SJISR[h 0x8890 ` 0x989e ̃Rs[
			t98sjiscpy(&KNJ_FNT[0x08000], bmpdata, 0x8890, 0x989f);
			loadedt98 |= FONT_KNJ1;
		}

		// 񐅏͓ǂݍ܂ĂH
		if (!(loaded & FONT_KNJ2)) {
			// SJISR[h 0x989f ` 0x9fff ̃Rs[
			t98sjiscpy(&KNJ_FNT[0x281e0], bmpdata, 0x989f, 0xa000);

			// SJISR[h 0xe040 ` 0xeaaf ̃Rs[
			t98sjiscpy(&KNJ_FNT[0x36e00], bmpdata, 0xe040, 0xeab0);
			loadedt98 |= FONT_KNJ2;
		}

		break;
	}
	file_close(fh);							// n
	GlobalUnlock(hbmpdata);
	GlobalFree(hbmpdata);

	return(loadedt98);
}


// ANK̎w͈͂̃R[h Rs[
static void t98ankcpy(BYTE *dst, BYTE *src, WORD from, WORD to) {

	int		y;
	BYTE	*p;
	WORD	ank;

	for (ank=from; ank<to; ank++) {

		// ANKtHg̃X^[gʒu
		p = src + BMPDATASIZE + ank + (0 * FONTYSIZE * BMPLINESIZE);
		for (y=0; y<FONTYSIZE; y++) {
			p -= BMPLINESIZE;				// BMPȂ̂Ń|C^͈
			*dst++ = ~(*p);
		}
	}
}


// ̎w͈͂̃R[h Rs[
static void t98sjiscpy(BYTE *dst, BYTE *src, WORD from, WORD to) {

	int		y;
	BYTE	*p;
	WORD	sjis;
	WORD	jis;

	for (sjis=from; sjis<to; sjis++) {

		// R[hSJISJISɕϊ
		jis = sjis2jis(sjis);

		// JISR[hH
		if (((jis & 0x0ff) > 0x20) && ((jis & 0x0ff) < 0x7f) &&
			((jis / 0x100) > 0x20) && ((jis / 0x100) < 0x7f))
		{									// 
			// BITMAP̊̃|C^߂
			p = src + BMPDATASIZE + (((jis / 0x100) - 0x20) * 2)
							- ((DWORD)(jis & 0x7f) * FONTYSIZE * BMPLINESIZE);
			// Rs[
			for (y=0; y<FONTYSIZE; y++) {
				p -= BMPLINESIZE;			// BMPȂ̂Ń|C^͈
				*dst++ = ~(*p);
				*dst++ = ~(*(p+1));
			}
		}
		else {								// KiOR[h
			// 0 fill
			ZeroMemory(dst, 2*FONTYSIZE);
			dst += 2*FONTYSIZE;
		}
	}
}

