#include	"z80r.h"
#include	"x1_io.h"
#include	"x1_mem.h"

typedef struct {
	WORD	HSYNC_CLK;
	BYTE	ROM_TYPE;
	BYTE	ROM_SW;
	BYTE	DIP_SW;
	BYTE	SOUND_SW;
} X1_FLAG;

extern	X1_FLAG	x1flg;
extern	BYTE	*RAM0r;
extern	BYTE	*RAM0w;
extern	BYTE	lastmem;
extern	DWORD	h_cntbase;

extern	BYTE	mMAIN[0x10000];
extern	BYTE	mBIOS[0x8000];
extern	BYTE	mBANK[16][0x8000];
extern	BYTE	ANK_FNT[256][8];
extern	BYTE	KNJ_FNT[0x4bc00];
extern	BYTE	GRP_RAM[0x20000];
extern	BYTE	TXT_RAM[0x01800];

#define	GRAM_SIZE		0x10000
#define	GRAM_BANK0		0x00000
#define	GRAM_BANK1		0x10000

#define	GRAM_BANK0L		0x00000
#define	GRAM_BANK0H		0x08000
#define	GRAM_BANK1L		0x10000
#define	GRAM_BANK1H		0x18000

#define GRAM_HALFSTEP	0x08000

#define	TEXT_ANK	0x0000
#define	TEXT_ATR	0x0800
#define	TEXT_KNJ	0x1000

#define	PLANE_B		8
#define	PLANE_R		16
#define	PLANE_G		24

#define	h_cnt	Z80_ICount
extern	WORD	v_cnt;

BYTE reset_x1(BYTE ROM_TYPE, BYTE SOUND_SW, BYTE DIP_SW);

void x1r_init(void);
void x1r_term(void);

void x1r_exec(void);

X1_IOR x1_dipsw_r(WORD port);


typedef struct {
	long	draws;
	long	khz;
} WORKCLOCK_T;

void workclock_reset(void);
WORKCLOCK_T *workclock_get(void);
void makecaption(BYTE flg, WORKCLOCK_T *workclock);


#define	FONT_ANK8		0x01
#define	FONT_ANK16a		0x02
#define	FONT_ANK16b		0x04
#define	FONT_KNJ1		0x08
#define	FONT_KNJ2		0x10

#define	FONT_ANK16		0x06
#define	FONT_KNJ		0x18
#define	FONT_ALL		0x1f


#define	DIP_RESOLUTE	1
#define	DIP_BOOTMEDIA	4

