#include	<windows.h>
#include	<windowsx.h>
#include	<shlobj.h>

#include	"common.h"
#include	"resource.h"
#include	"xmil.h"
#include	"dialog.h"
#include	"draw.h"
#include	"ini.h"
#include	"dosio.h"
#include	"ddraws.h"
#include	"palettes.h"
#include	"dsounds.h"
#include	"x1_io.h"
#include	"x1_sound.h"
#include	"opm.h"

		char	licenced[LICENCED_POS + LICENCED_LENG + 1]
													= "Licenced to ";

LRESULT CALLBACK linkProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp);


#define	GETCHECK(a,b) ((Button_GetCheck(GetDlgItem(a, b)))?1:0)


// AboutDialog : _CAO vV[W

LRESULT CALLBACK AboutDialogProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp) {

	switch (msg) {
		case WM_INITDIALOG:
			if (licenced[LICENCED_POS]) {
				SetDlgItemText(hWnd, IDC_LICENCE, (char *)licenced);
			}
			return(FALSE);
		case WM_COMMAND:
			switch (LOWORD(wp)) {
				case IDOK:
					EndDialog(hWnd, IDOK);
					break;
				default:
					return(FALSE);
			}
		case WM_CLOSE:
			PostMessage(hWnd, WM_COMMAND, IDOK, 0);
			break;
		default:
			return(FALSE);
	}
	return(TRUE);
}

// --------------------------------------------------------------------------

char	*ratehz[] = {"55500", "48000", "44100", "33075", "32000",
						"24000", "22050", "16000", "11025"};

LRESULT CALLBACK CfgDialogProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp) {

#define	WORKSIZE		128

	char	work[WORKSIZE];
	int		i;
	int		cnt;
	BYTE	value;
	WORD	wval;
	BYTE	renewalflg;

	switch (msg) {
		case WM_INITDIALOG:
			for (i=0, cnt=0; i<(sizeof(ratehz) / sizeof(char *)); i++) {
					SendMessage(GetDlgItem(hWnd, IDC_SAMPLERATE),
						CB_INSERTSTRING, (WPARAM)cnt++, (LPARAM)ratehz[i]);
			}
			wsprintf(work, "%u", xmilcfg.samplingrate);
			Edit_SetText(GetDlgItem(hWnd, IDC_SAMPLERATE), work);
			wsprintf(work, "%u", xmilcfg.delayms);
			Edit_SetText(GetDlgItem(hWnd, IDC_SNDBUFFER), work);
			wsprintf(work, "%u", xmilcfg.MOTORVOL);
			Edit_SetText(GetDlgItem(hWnd, IDC_SEEKVOL), work);
			Button_SetCheck(GetDlgItem(hWnd, IDC_HIGHPRY), xmilcfg.SOUNDPLY);
			Button_SetCheck(GetDlgItem(hWnd, IDC_DSOUND3), xmilcfg.DSOUND3);
			Button_Enable(GetDlgItem(hWnd, IDC_DSOUND3), !usedsound3);
			Button_SetCheck(GetDlgItem(hWnd, IDC_PUCHINOISE), xmilcfg.PUCHI);

			if (xmilcfg.TEXTMODE) {
				Button_SetCheck(GetDlgItem(hWnd, IDC_TXTENHANCED), TRUE);
			}
			else {
				Button_SetCheck(GetDlgItem(hWnd, IDC_TXTREAL), TRUE);
			}
			switch(xmilcfg.TEXT400L) {
				case 0:
					Button_SetCheck(GetDlgItem(hWnd, IDC_TXT200), TRUE);
					Edit_Enable(GetDlgItem(hWnd, IDC_TXTVALUE), FALSE);
					break;
				case 1:
					Button_SetCheck(GetDlgItem(hWnd, IDC_TXT400), TRUE);
					Edit_Enable(GetDlgItem(hWnd, IDC_TXTVALUE), FALSE);
					break;
				default:
					Button_SetCheck(GetDlgItem(hWnd, IDC_TXTCSTM), TRUE);
					Edit_Enable(GetDlgItem(hWnd, IDC_TXTVALUE), TRUE);
					break;
			}
			wsprintf(work, "%u", xmilcfg.LINETEXT);
			Edit_SetText(GetDlgItem(hWnd, IDC_TXTVALUE), work);
			wsprintf(work, "%u", xmilcfg.BLKLIGHT);
			Edit_SetText(GetDlgItem(hWnd, IDC_BLKLIGHT), work);
			wsprintf(work, "%u", xmilcfg.LINEDEPTH);
			Edit_SetText(GetDlgItem(hWnd, IDC_LINEDEPTH), work);
			return(FALSE);
		case WM_COMMAND:
			switch (LOWORD(wp)) {
				case IDOK:

					Edit_GetText(GetDlgItem(hWnd, IDC_SAMPLERATE),
													work, WORKSIZE);
					if ((wval = (WORD)ex_a2i(work, 11025, 55500))
											!= xmilcfg.samplingrate) {
						INIT_RENEWAL xmilcfg.samplingrate = wval;
						INIT_SOUNDS
					}
					Edit_GetText(GetDlgItem(hWnd, IDC_SNDBUFFER),
													work, WORKSIZE);
					if ((wval = (WORD)ex_a2i(work, 100, 1000))
											!= xmilcfg.delayms) {
						INIT_RENEWAL xmilcfg.delayms = wval;
						INIT_SOUNDS
					}

					Edit_GetText(GetDlgItem(hWnd, IDC_SEEKVOL),
													work, WORKSIZE);
					if ((value = (BYTE)ex_a2i(work, 0, 100))
												!= xmilcfg.MOTORVOL) {
						INIT_RENEWAL xmilcfg.MOTORVOL = value;
						WAVE_VOLUME(0, value);
						WAVE_VOLUME(1, value);
					}
					value = GETCHECK(hWnd, IDC_HIGHPRY);
					if (xmilcfg.SOUNDPLY != value) {
						INIT_RENEWAL xmilcfg.SOUNDPLY = value;
					}
					value = GETCHECK(hWnd, IDC_PUCHINOISE);
					if (xmilcfg.PUCHI != value) {
						INIT_RENEWAL xmilcfg.PUCHI = value;
						INX1F_PSGmode(value);
					}
					value = GETCHECK(hWnd, IDC_DSOUND3);
					if (xmilcfg.DSOUND3 != value) {
						INIT_RENEWAL xmilcfg.DSOUND3 = value;
					}

					value = GETCHECK(hWnd, IDC_TXTENHANCED);
					if (xmilcfg.TEXTMODE != value) {
						INIT_RENEWAL xmilcfg.TEXTMODE = value;
						textdrawproc_renewal();
					}
					renewalflg = 0;
					if (Button_GetCheck(GetDlgItem(hWnd, IDC_TXT200))) {
						value = 0;
					}
					else if (Button_GetCheck(GetDlgItem(hWnd, IDC_TXT400))) {
						value = 1;
					}
					else {
						value = 2;
					}
					if (xmilcfg.TEXT400L != value) {
						xmilcfg.TEXT400L = value;
						renewalflg = 1;
					}
					Edit_GetText(GetDlgItem(hWnd, IDC_TXTVALUE),
													work, WORKSIZE);
					if ((value = (BYTE)ex_a2i(work, 0, 255))
												!= xmilcfg.LINETEXT) {
						xmilcfg.LINETEXT = value;
						renewalflg = 1;
					}
					Edit_GetText(GetDlgItem(hWnd, IDC_BLKLIGHT),
													work, WORKSIZE);
					if ((value = (BYTE)ex_a2i(work, 0, 255))
												!= xmilcfg.BLKLIGHT) {
						xmilcfg.BLKLIGHT = value;
						renewalflg = 1;
					}
					Edit_GetText(GetDlgItem(hWnd, IDC_LINEDEPTH),
													work, WORKSIZE);
					if ((value = (BYTE)ex_a2i(work, 0, 255))
												!= xmilcfg.LINEDEPTH) {
						xmilcfg.LINEDEPTH = value;
						renewalflg = 1;
					}
					if (renewalflg) {
						INIT_RENEWAL
						reflesh_palette();
						palandply = 1;
					}
					EndDialog(hWnd, IDOK);
					break;
				case IDCANCEL:
					EndDialog(hWnd, IDCANCEL);
					break;
				case IDC_TXT200:
				case IDC_TXT400:
				case IDC_TXTCSTM:
					Edit_Enable(GetDlgItem(hWnd, IDC_TXTVALUE),
							Button_GetCheck(GetDlgItem(hWnd, IDC_TXTCSTM)));
					return(FALSE);
				default:
					return(FALSE);
			}
			break;
		case WM_CLOSE:
			PostMessage(hWnd, WM_COMMAND, IDCANCEL, 0);
			break;
		default:
			return(FALSE);
	}
	return(TRUE);
}
