#include	<windows.h>

#include	"common.h"
#include	"xmil.h"
#include	"x1.h"
#include	"x1_crtc.h"
#include	"x1_pcg.h"
#include	"x1_vram.h"
#include	"ddraws.h"
#include	"draw.h"
#include	"draw.mcr"
#include	"draw_sub.h"
#include	"draw_sub.mcr"


extern	BYTE	dispflg;
extern	BYTE	*dispp;
extern	BYTE	*dispp2;

extern	WORD	vramsize;
extern	BYTE	blinktest;
extern	BYTE	fontlpcnt;
extern	BYTE	vramylpcnt;
extern	WORD	vramylpad;
extern	BYTE	fonttype;


static LABEL void pcg_effect12line(void) {

	__asm {
				dec		cl
				mov		eax, SCREEN_WIDTH*2
				mul		ecx
				mov		ecx, eax

pcgeffect_lp:	mov		eax, [ecx+edi+SCREEN_WIDTH*0+0]
				xor		eax, esi
				mov		[ecx*2+edi+SCREEN_WIDTH*0+0], eax
				mov		[ecx*2+edi+SCREEN_WIDTH*2+0], eax
				add		eax, ebx
				mov		[ecx*2+edi+SCREEN_WIDTH*1+0], eax
				mov		[ecx*2+edi+SCREEN_WIDTH*3+0], eax
				mov		eax, [ecx+edi+SCREEN_WIDTH*0+4]
				xor		eax, esi
				mov		[ecx*2+edi+SCREEN_WIDTH*0+4], eax
				mov		[ecx*2+edi+SCREEN_WIDTH*2+4], eax
				add		eax, ebx
				mov		[ecx*2+edi+SCREEN_WIDTH*1+4], eax
				mov		[ecx*2+edi+SCREEN_WIDTH*3+4], eax
				sub		ecx, SCREEN_WIDTH*2
				jns		pcgeffect_lp
				ret
	}
}



void width80x25_200line(void) {					// 80x25 200line [h

	DWORD	*v;
	BYTE	atr;
	WORD	newline = 0;
	WORD	yp = 0;

		__asm {
				push	esi
				push	edi

				mov		eax, offset screenmap
				mov		v, eax
				xor		bx, bx
				mov		fontycnt, bl
				movzx	esi, crtc.TXT_TOP
				mov		cx, vramsize
				or		cx, cx
				je		dischr_end

dispchrlpst:	and		esi, (TRAM_MAX - 1)

				movzx	edx, byte ptr updatetmp[esi]
				mov		al, dispflg
				test	dl, al
				je		updatechr_e
				not		al
				and		updatetmp[esi], al
				mov		newline, 1

				push	bx
				push	cx
				push	esi

				mov		dh, TXT_RAM[esi + TEXT_ATR]
				test	dh, blinktest
				je		notblinks
				xor		dh, X1ATR_REVERSE
notblinks:		bt		dx, 4
				sbb		si, 0

				movzx	ecx, byte ptr TXT_RAM[esi + TEXT_ANK]
				mov		ch, TXT_RAM[esi + TEXT_KNJ]

				test	byte ptr TXT_RAM[esi + TEXT_ATR], 20h
				je		outtextchr

				// pcg
				test	ch, 90h
				mov		ch, 0
				jne		textpcgext
					// PCG̏o
					FAST_PCG8OUT
					// XLbvCo[X
					PCGEFFECT15KHz(2)
					jmp		putgraph

textpcgext:			// 16hbgPCG̏o
					FAST_PCG16OUT
					test	fonttype, KNJ_24KHz
					je		pcg16_15khz
					test	atr, X1ATR_REVERSE
					je		putgraph
					// 24KHz[h̃o[X
					TEXT16_REVERSE
					jmp		putgraph
					// 15KHz[h̃o[X
pcg16_15khz:		PCGEFFECT15KHz(1)
					jmp		putgraph

				// chr
outtextchr:		test	ch, 80h
				jne		kanjiext
					// ANK
					mov		edi, v
					mov		ch, 0
					mov		eax, edx
					and		ax, 15
					mov		dl, dh
					and		dx, (X1ATR_COLOR or X1ATR_REVERSE)
					test	fonttype, ANK_24KHz
					jne		ank24khz
					lea		esi, ANK_FNT[ecx*8]
					mov		cl, fontlpcnt
					call	txt8effects[eax*4]
					jmp		putgraph
ank24khz:			shl		cx, 4
					lea		esi, KNJ_FNT[ecx]
					movzx	ecx, fontlpcnt
					call	txt16effects[eax*4]
					jmp		putgraph

kanjiext:			bt		cx, 14
					pushf
					push	edx
					call	adr2jis_x1t
					mov		cx, ax
					call	getfontjis
					mov		esi, eax
					pop		edx
					popf
					adc		esi, 0
					mov		edi, v
					mov		eax, edx
					and		ax, 15
					mov		dl, dh
					and		dx, (X1ATR_COLOR or X1ATR_REVERSE)
					movzx	ecx, fontlpcnt
					test	fonttype, KNJ_24KHz
					jne		knj24khz
					call	knj8effects[eax*4]
					jmp		putgraph
knj24khz:			call	knj16effects[eax*4]

putgraph:		pop		esi
				push	esi
				rol		si, 5
				add		esi, dispp
				mov		edi, v
				movzx	ecx, vramylpcnt
grphcpy_lp:		movzx	ebx, byte ptr [esi+PLANE_B]
				mov		eax, bmp2byte_table[ebx*8 + BMP2B_BLUE]
				mov		edx, bmp2byte_table[ebx*8 + BMP2B_BLUE + 4]
				movzx	ebx, byte ptr [esi+PLANE_R]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_RED]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_RED + 4]
				movzx	ebx, byte ptr [esi+PLANE_G]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_GREEN]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_GREEN + 4]
				or		[edi+SCREEN_WIDTH*0+0], eax
				or		eax, 40404040h
				add		[edi+SCREEN_WIDTH*1+0], eax
				or		[edi+SCREEN_WIDTH*0+4], edx
				or		edx, 40404040h
				add		[edi+SCREEN_WIDTH*1+4], edx
				inc		esi
				add		edi, SCREEN_WIDTH*2
				loop	grphcpy_lp

				pop		esi
				pop		cx
				pop		bx
updatechr_e:
				VRAMADRRESS_INC
				dec		cx
				jne		dispchrlpst
dischr_end:
				pop		edi
				pop		esi
		}
}


void width80x12_200line(void) {					// 80x12 200line [h

	WORD	p;
	DWORD	*v;
	BYTE	atr, ank, knj;
	int		i;
	BYTE	newline = 0;
	BYTE	x = 0;
	int		y = 0;
	int		times;
	BYTE	*q;
	WORD	r;
	BYTE	upt;

	fontycnt = 0;
	p = crtc.TXT_TOP;
	v = (DWORD *)screenmap;

	times = vramsize;
	while((times--) && (p < (TRAM_MAX/2))) {
		if (updatetmp[p] & dispflg) {
			updatetmp[p] ^= dispflg;
			upt = updatetmp[p];
			newline = 1;
			r = p;
			atr = TXT_RAM[r + TEXT_ATR];
			if (atr & blinktest) {
				atr ^= X1ATR_REVERSE;
			}
			if (upt & 0x10) {
				r--;
			}
			ank = TXT_RAM[r + TEXT_ANK];
			knj = TXT_RAM[r + TEXT_KNJ];
			if (TXT_RAM[r + TEXT_ATR] & 0x20) {
				if (knj & 0x90) {
					__asm {
						push	esi
						push	edi

						// PCG16hbg̏o
						PCG16OUT

						// {X^o[X
						PCG16_DOUBLERASTER15

						pop		edi
						pop		esi
					}
				}
				else {
					__asm {
						push	esi
						push	edi

						// PCG̏o
						PCG8OUT
											// XLbvCEo[X
						mov		cl, fontlpcnt			// ecx = 0̔
						mov		ebx, 40404040h
						mov		edi, v
						xor		esi, esi
						test	atr, X1ATR_REVERSE
						je		pcgplaneeffectr
						mov		esi, 38383838h
pcgplaneeffectr:		call	pcg_effect12line

						pop		edi
						pop		esi
					}
				}
			}
			else {
				if (!(knj & 0x80)) {
					__asm {
						push	esi
						push	edi

						// TEXT̏o
						TEXT16OUT

						// TEXT̔{X^
						TEXT_DOUBLERASTER(1)

						pop		edi
						pop		esi
					}
				}
				else {
					q = getfontjis(adr2jis_x1t(((WORD)knj << 8) | ank));
					if (knj & 0x40) {
						q++;
					}
					__asm {
						push	esi
						push	edi

						// ̏o
						KANJI16OUT

						// ̔{X^
						TEXT_DOUBLERASTER(2)

						pop		edi
						pop		esi
					}
				}
			}

			__asm {
					push	esi
					push	edi
					movzx	esi, p
					rol		si, 5
					add		esi, dispp
					mov		edi, v
					mov		cl, vramylpcnt

grphcpy_lp:			movzx	ebx, byte ptr [esi + PLANE_B]
					mov		eax, bmp2byte_table[ebx*8 + BMP2B_BLUE]
					mov		edx, bmp2byte_table[ebx*8 + BMP2B_BLUE + 4]
					movzx	ebx, byte ptr [esi + PLANE_R]
					or		eax, bmp2byte_table[ebx*8 + BMP2B_RED]
					or		edx, bmp2byte_table[ebx*8 + BMP2B_RED + 4]
					movzx	ebx, byte ptr [esi + PLANE_G]
					or		eax, bmp2byte_table[ebx*8 + BMP2B_GREEN]
					or		edx, bmp2byte_table[ebx*8 + BMP2B_GREEN + 4]
					or		[edi+SCREEN_WIDTH*0+0], eax
					or		eax, 40404040h
					add		[edi+SCREEN_WIDTH*1+0], eax
					or		[edi+SCREEN_WIDTH*0+4], edx
					or		edx, 40404040h
					add		[edi+SCREEN_WIDTH*1+4], edx

					movzx	ebx, byte ptr [esi + PLANE_B + GRAM_HALFSTEP]
					mov		eax, bmp2byte_table[ebx*8 + BMP2B_BLUE]
					mov		edx, bmp2byte_table[ebx*8 + BMP2B_BLUE + 4]
					movzx	ebx, byte ptr [esi + PLANE_R + GRAM_HALFSTEP]
					or		eax, bmp2byte_table[ebx*8 + BMP2B_RED]
					or		edx, bmp2byte_table[ebx*8 + BMP2B_RED + 4]
					movzx	ebx, byte ptr [esi + PLANE_G + GRAM_HALFSTEP]
					or		eax, bmp2byte_table[ebx*8 + BMP2B_GREEN]
					or		edx, bmp2byte_table[ebx*8 + BMP2B_GREEN + 4]
					or		[edi+SCREEN_WIDTH*2+0], eax
					or		eax, 40404040h
					add		[edi+SCREEN_WIDTH*3+0], eax
					or		[edi+SCREEN_WIDTH*2+4], edx
					or		edx, 40404040h
					add		[edi+SCREEN_WIDTH*3+4], edx

					inc		esi
					add		edi, SCREEN_WIDTH*4
					dec		cl
					jne		grphcpy_lp
					pop		edi
					pop		esi
			}
		}
		p++;
		v += 2;
		if (++x >= crtc.TXT_XL) {

			if (updatetmp[p-1] & 4) {					// c{p`悾
				fontycnt += vramylpcnt;
			}
			else {
				fontycnt = vramylpcnt*2;
			}
			fontycnt &= 15;

			v += vramylpad - (x << 1);
			x = 0;
			if (newline) {
				newline = 0;
				for (i=0; i<vramylpcnt*4; i++) {
					renewalline[y++] |= 3;
				}
			}
			else {
				y += vramylpcnt*4;
			}
		}
	}
}


void width80x25_400line(void) {					// 80x25 400line [h

	DWORD	*v;
	BYTE	atr;
	WORD	newline = 0;
	WORD	yp = 0;

		__asm {
				push	esi
				push	edi

				mov		eax, offset screenmap
				mov		v, eax
				xor		bx, bx
				mov		fontycnt, bl
				movzx	esi, crtc.TXT_TOP
				mov		cx, vramsize
				or		cx, cx
				je		dischr_end

dispchrlpst:	and		esi, (TRAM_MAX - 1)

				movzx	edx, byte ptr updatetmp[esi]
				test	dl, UPDATE_VRAM
				je		updatechr_e
				and		updatetmp[esi], (~UPDATE_VRAM)
				mov		newline, 1

				push	bx
				push	cx
				push	esi

				mov		dh, TXT_RAM[esi + TEXT_ATR]
				test	dh, blinktest
				je		notblinks
				xor		dh, X1ATR_REVERSE
notblinks:		bt		dx, 4
				sbb		si, 0

				movzx	ecx, byte ptr TXT_RAM[esi + TEXT_ANK]
				mov		ch, TXT_RAM[esi + TEXT_KNJ]

				test	byte ptr TXT_RAM[esi + TEXT_ATR], 20h
				je		outtextchr

				// pcg
				test	ch, 90h
				mov		ch, 0
				jne		textpcgext
					// PCG̏o
					FAST_PCG8OUT
					// o[X
					PCGEFFECT24KHz
					jmp		putgraph

textpcgext:			// 16hbgPCG̏o
					FAST_PCG16OUT
					test	atr, X1ATR_REVERSE
					je		putgraph
					// 24KHz[h̃o[X
					TEXT16_REVERSE
					jmp		putgraph

				// chr
outtextchr:		test	ch, 80h
				jne		kanjiext
					// eLXg̏o
					FAST_TEXT16OUT
					jmp		putgraph

kanjiext:			FAST_KANJI16OUT

putgraph:		pop		esi
				push	esi
				rol		si, 5
				mov		edi, v
				mov		cl, vramylpcnt
grphcpy400_lp:	movzx	ebx, byte ptr GRP_RAM[esi + PLANE_B + GRAM_BANK0]
				mov		eax, bmp2byte_table[ebx*8 + BMP2B_BLUE]
				mov		edx, bmp2byte_table[ebx*8 + BMP2B_BLUE + 4]
				movzx	ebx, byte ptr GRP_RAM[esi + PLANE_R + GRAM_BANK0]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_RED]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_RED + 4]
				movzx	ebx, byte ptr GRP_RAM[esi + PLANE_G + GRAM_BANK0]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_GREEN]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_GREEN + 4]
				or		[edi+SCREEN_WIDTH*0+0], eax
				or		[edi+SCREEN_WIDTH*0+4], edx
				movzx	ebx, byte ptr GRP_RAM[esi + PLANE_B + GRAM_BANK1]
				mov		eax, bmp2byte_table[ebx*8 + BMP2B_BLUE]
				mov		edx, bmp2byte_table[ebx*8 + BMP2B_BLUE + 4]
				movzx	ebx, byte ptr GRP_RAM[esi + PLANE_R + GRAM_BANK1]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_RED]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_RED + 4]
				movzx	ebx, byte ptr GRP_RAM[esi + PLANE_G + GRAM_BANK1]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_GREEN]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_GREEN + 4]
				or		[edi+SCREEN_WIDTH*1+0], eax
				or		[edi+SCREEN_WIDTH*1+4], edx

				inc		esi
				add		edi, SCREEN_WIDTH*2
				dec		cl
				jne		grphcpy400_lp

				pop		esi
				pop		cx
				pop		bx
updatechr_e:
				VRAMADRRESS_INC
				dec		cx
				jne		dispchrlpst
dischr_end:
				pop		edi
				pop		esi
		}
}


void width80x12_400line(void) {					// 80x12 400line [h

	DWORD	*v;
	BYTE	atr;
	WORD	newline = 0;
	WORD	yp = 0;

		__asm {
				push	esi
				push	edi

				mov		eax, offset screenmap
				mov		v, eax
				xor		bx, bx
				mov		fontycnt, bl
				movzx	esi, crtc.TXT_TOP
				mov		cx, vramsize
				or		cx, cx
				je		dischr_end

dispchrlpst:	and		esi, (TRAM_MAX - 1)

				movzx	edx, byte ptr updatetmp[esi]
				test	dl, UPDATE_VRAM
				je		updatechr_e
				and		updatetmp[esi], (~UPDATE_VRAM)
				mov		newline, 1

				push	bx
				push	cx
				push	esi

				mov		dh, TXT_RAM[esi + TEXT_ATR]
				test	dh, blinktest
				je		notblinks
				xor		dh, X1ATR_REVERSE
notblinks:		bt		dx, 4
				sbb		si, 0

				movzx	ecx, byte ptr TXT_RAM[esi + TEXT_ANK]
				mov		ch, TXT_RAM[esi + TEXT_KNJ]

				test	byte ptr TXT_RAM[esi + TEXT_ATR], 20h
				je		outtextchr

				// pcg

				test	ch, 90h
				mov		ch, 0
				jne		textpcgext
					// PCG̏o
					FAST_PCG8OUT
					// o[X
					mov		cl, fontlpcnt			// ecx = 0̔
					xor		ebx, ebx
					mov		edi, v
					xor		esi, esi
					test	atr, X1ATR_REVERSE
					je		pcgplaneeffectr
					mov		esi, 38383838h
pcgplaneeffectr:	call	pcg_effect12line
					jmp		putgraph

textpcgext:			// 16hbgPCG̏o
					FAST_PCG16OUT
					// {X^o[X
					PCG16_DOUBLERASTER24
					jmp		putgraph

				// chr
outtextchr:		test	ch, 80h
				jne		kanjiext
					// eLXg̏o
					FAST_TEXT16OUT
					// {X^
					TEXT_DOUBLERASTER(3)
					jmp		putgraph

						// ̏o
kanjiext:				FAST_KANJI16OUT
						// {X^
						TEXT_DOUBLERASTER(4)

putgraph:		pop		esi
				push	esi
				rol		si, 5
				mov		edi, v
				mov		cl, vramylpcnt

grphcpy400_lp:	movzx	ebx, byte ptr GRP_RAM[esi + PLANE_B + GRAM_BANK0L]
				mov		eax, bmp2byte_table[ebx*8 + BMP2B_BLUE]
				mov		edx, bmp2byte_table[ebx*8 + BMP2B_BLUE + 4]
				movzx	ebx, byte ptr GRP_RAM[esi + PLANE_R + GRAM_BANK0L]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_RED]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_RED + 4]
				movzx	ebx, byte ptr GRP_RAM[esi + PLANE_G + GRAM_BANK0L]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_GREEN]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_GREEN + 4]
				or		[edi+SCREEN_WIDTH*0+0], eax
				or		[edi+SCREEN_WIDTH*0+4], edx
				movzx	ebx, byte ptr GRP_RAM[esi + PLANE_B + GRAM_BANK1L]
				mov		eax, bmp2byte_table[ebx*8 + BMP2B_BLUE]
				mov		edx, bmp2byte_table[ebx*8 + BMP2B_BLUE + 4]
				movzx	ebx, byte ptr GRP_RAM[esi + PLANE_R + GRAM_BANK1L]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_RED]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_RED + 4]
				movzx	ebx, byte ptr GRP_RAM[esi + PLANE_G + GRAM_BANK1L]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_GREEN]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_GREEN + 4]
				or		[edi+SCREEN_WIDTH*1+0], eax
				or		[edi+SCREEN_WIDTH*1+4], edx
				movzx	ebx, byte ptr GRP_RAM[esi + PLANE_B + GRAM_BANK0H]
				mov		eax, bmp2byte_table[ebx*8 + BMP2B_BLUE]
				mov		edx, bmp2byte_table[ebx*8 + BMP2B_BLUE + 4]
				movzx	ebx, byte ptr GRP_RAM[esi + PLANE_R + GRAM_BANK0H]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_RED]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_RED + 4]
				movzx	ebx, byte ptr GRP_RAM[esi + PLANE_G + GRAM_BANK0H]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_GREEN]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_GREEN + 4]
				or		[edi+SCREEN_WIDTH*2+0], eax
				or		[edi+SCREEN_WIDTH*2+4], edx
				movzx	ebx, byte ptr GRP_RAM[esi + PLANE_B + GRAM_BANK1H]
				mov		eax, bmp2byte_table[ebx*8 + BMP2B_BLUE]
				mov		edx, bmp2byte_table[ebx*8 + BMP2B_BLUE + 4]
				movzx	ebx, byte ptr GRP_RAM[esi + PLANE_R + GRAM_BANK1H]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_RED]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_RED + 4]
				movzx	ebx, byte ptr GRP_RAM[esi + PLANE_G + GRAM_BANK1H]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_GREEN]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_GREEN + 4]
				or		[edi+SCREEN_WIDTH*3+0], eax
				or		[edi+SCREEN_WIDTH*3+4], edx
				inc		esi
				add		edi, SCREEN_WIDTH*4
				dec		cl
				jne		grphcpy400_lp

				pop		esi
				pop		cx
				pop		bx
updatechr_e:
				VRAMADRRESS_INC2
				dec		cx
				jne		dispchrlpst
dischr_end:
				pop		edi
				pop		esi
		}
}


// --------------------------------------------------------------------------

void width80x20_15khz(void) {					// 80x20 15KHz [h

	WORD	p;
	DWORD	*v;
	BYTE	atr, ank, knj;
	int		i;
	BYTE	newline = 0;
	BYTE	x = 0;
	int		y = 0;
	int		times;
	BYTE	*q;
	WORD	r;
	BYTE	upt;

	fontycnt = 0;
	p = crtc.TXT_TOP;
	v = (DWORD *)screenmap;

	times = vramsize;
	while((times--) && (p < TRAM_MAX)) {
		if (updatetmp[p] & UPDATE_TRAM) {
			updatetmp[p] &= (BYTE)~(UPDATE_TRAM);
			upt = updatetmp[p];
			newline = 1;
			r = p;
			atr = TXT_RAM[r + TEXT_ATR];
			if (atr & blinktest) {
				atr ^= X1ATR_REVERSE;
			}
			if (upt & 0x10) {
				r--;
			}
			ank = TXT_RAM[r + TEXT_ANK];
			knj = TXT_RAM[r + TEXT_KNJ];
			if (TXT_RAM[r + TEXT_ATR] & 0x20) {
				if (knj & 0x90) {
					__asm {
						push	esi
						push	edi

						// 16hbgPCG̏o
						PCG16OUT

						test	fonttype, KNJ_24KHz
						je		pcg16_15khz
						test	atr, X1ATR_REVERSE
						je		pcg16end

						// 24KHz[h̃o[X
						TEXT16_REVERSE
						jmp		pcg16end

						// 15KHz[h̃o[X
pcg16_15khz:			PCGEFFECT15KHz(3)
pcg16end:
						pop		edi
						pop		esi
					}
				}
				else {
					__asm {
						push	esi
						push	edi

						// PCG̏o
						PCG8OUT

						// XLbvCo[X
						PCGEFFECT15KHz(4)

						pop		edi
						pop		esi
					}
				}
			}
			else {
				if (!(knj & 0x80)) {
					__asm {
						push	esi
						push	edi
						movzx	esi, ank
						mov		edi, v
						movzx	edx, atr
						and		dl, (X1ATR_COLOR or X1ATR_REVERSE)
						movzx	ecx, fontlpcnt
						movzx	eax, byte ptr upt
						and		al, 15
						test	fonttype, ANK_24KHz
						jne		ank24khz
						shl		si, 3
						add		esi, offset ANK_FNT
						call	txt8effects[eax*4]
						jmp		ankputend
ank24khz:				shl		si, 4
						add		esi, offset KNJ_FNT
						call	txt16effects[eax*4]
ankputend:				pop		edi
						pop		esi
					}
				}
				else {
					q = getfontjis(adr2jis_x1t(((WORD)knj << 8) | ank));
					if (knj & 0x40) {
						q++;
					}
					__asm {
						push	esi
						push	edi
						mov		esi, q
						mov		edi, v
						movzx	edx, atr
						and		dl, (X1ATR_COLOR or X1ATR_REVERSE)
						movzx	ecx, fontlpcnt
						movzx	eax, byte ptr upt
						and		al, 15
						test	fonttype, KNJ_24KHz
						jne		knj24khz
						call	knj8effects[eax*4]
						jmp		knjputend
knj24khz:				call	knj16effects[eax*4]
knjputend:				pop		edi
						pop		esi
					}
				}
			}

			__asm {
					push	edi

					mov		eax, 040404040h
					mov		edi, v
					movzx	ecx, fontlpcnt
add_skiplinelp:		add		[edi+SCREEN_WIDTH*1+0], eax
					add		[edi+SCREEN_WIDTH*1+4], eax
					add		edi, SCREEN_WIDTH*2
					loop	add_skiplinelp

					xor		edx, edx
					mov		[edi+SCREEN_WIDTH*2+0], edx
					mov		[edi+SCREEN_WIDTH*2+4], edx
					mov		[edi+SCREEN_WIDTH*3+0], eax
					mov		[edi+SCREEN_WIDTH*3+4], eax

					movzx	ebx, p
					test	byte ptr TXT_RAM[ebx + TEXT_KNJ], X1KNJ_ULINE
					je		putunderline
					mov		edx, 01010101h					// underline !!

putunderline:		add		eax, edx
					mov		[edi+SCREEN_WIDTH*0+0], edx
					mov		[edi+SCREEN_WIDTH*0+4], edx
					mov		[edi+SCREEN_WIDTH*1+0], eax
					mov		[edi+SCREEN_WIDTH*1+4], eax

					pop		edi
			}
		}
		p++;
		v += 2;
		if (++x >= crtc.TXT_XL) {

			if (updatetmp[p-1] & 4) {					// c{p`悾
				fontycnt += vramylpcnt;
			}
			else {
				fontycnt = vramylpcnt*2;
			}
			fontycnt &= 15;

			v += vramylpad - (x << 1);
			x = 0;
			if (newline) {
				newline = 0;
				for (i=0; i<vramylpcnt*2; i++) {
					renewalline[y++] |= 3;
				}
			}
			else {
				y += vramylpcnt*2;
			}
		}
	}
}


void width80x10_15khz(void) {					// 80x10 15KHz [h

	WORD	p;
	DWORD	*v;
	BYTE	atr, ank, knj;
	int		i;
	BYTE	newline = 0;
	BYTE	x = 0;
	int		y = 0;
	int		times;
	BYTE	*q;
	WORD	r;
	BYTE	upt;

	fontycnt = 0;
	p = crtc.TXT_TOP;
	v = (DWORD *)screenmap;

	times = vramsize;
	while((times--) && (p < (TRAM_MAX/2))) {
		if (updatetmp[p] & dispflg) {
			updatetmp[p] ^= dispflg;
			upt = updatetmp[p];
			newline = 1;
			r = p;
			atr = TXT_RAM[r + TEXT_ATR];
			if (atr & blinktest) {
				atr ^= X1ATR_REVERSE;
			}
			if (upt & 0x10) {
				r--;
			}
			ank = TXT_RAM[r + TEXT_ANK];
			knj = TXT_RAM[r + TEXT_KNJ];
			if (TXT_RAM[r + TEXT_ATR] & 0x20) {
				if (knj & 0x90) {
					__asm {
						push	esi
						push	edi

						// PCG16hbg̏o
						PCG16OUT

						// {X^o[X
						PCG16_DOUBLERASTER15

						pop		edi
						pop		esi
					}
				}
				else {
					__asm {
						push	esi
						push	edi

						// PCG 8x8
						PCG8OUT

						// XLbvCEo[X
						mov		cl, fontlpcnt			// ecx = 0̔
						mov		ebx, 40404040h
						mov		edi, v
						xor		esi, esi
						test	atr, X1ATR_REVERSE
						je		pcgplaneeffectr
						mov		esi, 38383838h
pcgplaneeffectr:		call	pcg_effect12line

						pop		edi
						pop		esi
					}
				}
			}
			else {
				if (!(knj & 0x80)) {
					__asm {
						push	esi
						push	edi

						// TEXT̏o
						TEXT16OUT

						// TEXT̔{X^
						TEXT_DOUBLERASTER(5)

						pop		edi
						pop		esi
					}
				}
				else {
					q = getfontjis(adr2jis_x1t(((WORD)knj << 8) | ank));
					if (knj & 0x40) {
						q++;
					}
					__asm {
						push	esi
						push	edi

						// ̏o
						KANJI16OUT

						// ̔{X^
						TEXT_DOUBLERASTER(6)

						pop		edi
						pop		esi
					}
				}
			}

			__asm {
					push	edi

					mov		eax, 040404040h
					mov		edi, v
					movzx	ecx, fontlpcnt
					shl		cl, 1
add_skiplinelp:		add		[edi+SCREEN_WIDTH*1+0], eax
					add		[edi+SCREEN_WIDTH*1+4], eax
					add		edi, SCREEN_WIDTH*2
					loop	add_skiplinelp

					xor		edx, edx
					mov		[edi+SCREEN_WIDTH*4+0], edx
					mov		[edi+SCREEN_WIDTH*4+4], edx
					mov		[edi+SCREEN_WIDTH*5+0], eax
					mov		[edi+SCREEN_WIDTH*5+4], eax
					mov		[edi+SCREEN_WIDTH*6+0], edx
					mov		[edi+SCREEN_WIDTH*6+4], edx
					mov		[edi+SCREEN_WIDTH*7+0], eax
					mov		[edi+SCREEN_WIDTH*7+4], eax

					movzx	ebx, p
					test	byte ptr TXT_RAM[ebx + TEXT_KNJ], X1KNJ_ULINE
					je		putunderline
					mov		edx, 01010101h					// underline !!

putunderline:		add		eax, edx
					mov		[edi+SCREEN_WIDTH*0+0], edx
					mov		[edi+SCREEN_WIDTH*0+4], edx
					mov		[edi+SCREEN_WIDTH*1+0], eax
					mov		[edi+SCREEN_WIDTH*1+4], eax
					mov		[edi+SCREEN_WIDTH*2+0], edx
					mov		[edi+SCREEN_WIDTH*2+4], edx
					mov		[edi+SCREEN_WIDTH*3+0], eax
					mov		[edi+SCREEN_WIDTH*3+4], eax

					pop		edi
			}
		}
		p++;
		v += 2;
		if (++x >= crtc.TXT_XL) {

			if (updatetmp[p-1] & 4) {					// c{p`悾
				fontycnt += vramylpcnt;
			}
			else {
				fontycnt = vramylpcnt*2;
			}
			fontycnt &= 15;

			v += vramylpad - (x << 1);
			x = 0;
			if (newline) {
				newline = 0;
				for (i=0; i<vramylpcnt*4; i++) {
					renewalline[y++] |= 3;
				}
			}
			else {
				y += vramylpcnt*4;
			}
		}
	}
}


void width80x20_24khz(void) {					// 80x20 24KHz [h

	WORD	p;
	DWORD	*v;
	BYTE	atr, ank, knj;
	int		i;
	BYTE	newline = 0;
	BYTE	x = 0;
	int		y = 0;
	int		times;
	BYTE	*q;
	WORD	r;
	BYTE	upt;

	fontycnt = 0;
	p = crtc.TXT_TOP;
	v = (DWORD *)screenmap;

	times = vramsize;
	while((times--) && (p < TRAM_MAX)) {
		if (updatetmp[p] & UPDATE_TRAM) {
			updatetmp[p] &= (BYTE)~(UPDATE_TRAM);
			upt = updatetmp[p];
			newline = 1;
			r = p;
			atr = TXT_RAM[r + TEXT_ATR];
			if (atr & blinktest) {
				atr ^= X1ATR_REVERSE;
			}
			if (upt & 0x10) {
				r--;
			}
			ank = TXT_RAM[r + TEXT_ANK];
			knj = TXT_RAM[r + TEXT_KNJ];
			if (TXT_RAM[r + TEXT_ATR] & 0x20) {
				if (knj & 0x90) {
					__asm {
						push	esi
						push	edi

						// 16hbgPCG̏o
						PCG16OUT

						test	atr, X1ATR_REVERSE
						je		pcg16end

						// 24KHz[h̃o[X
						TEXT16_REVERSE
pcg16end:
						pop		edi
						pop		esi
					}
				}
				else {
					__asm {
						push	esi
						push	edi

						// PCG̏o
						PCG8OUT

						// o[X
						PCGEFFECT24KHz

						pop		edi
						pop		esi
					}
				}
			}
			else {
				if (!(knj & 0x80)) {
					__asm {
						push	esi
						push	edi

						TEXT16OUT

						pop		edi
						pop		esi
					}
				}
				else {
					q = getfontjis(adr2jis_x1t(((WORD)knj << 8) | ank));
					if (knj & 0x40) {
						q++;
					}
					__asm {
						push	esi
						push	edi

						KANJI16OUT

						pop		edi
						pop		esi
					}
				}
			}

			__asm {
					push	edi
					mov		edi, v
					movzx	ecx, fontlpcnt
					mov		eax, SCREEN_WIDTH*2
					mul		ecx
					add		edi, eax

					xor		eax, eax
					xor		edx, edx

					movzx	ebx, p
					test	byte ptr TXT_RAM[ebx + TEXT_KNJ], X1KNJ_ULINE
					je		putunderline
					mov		edx, 01010101h					// underline !!
putunderline:		mov		[edi+SCREEN_WIDTH*0+0], eax
					mov		[edi+SCREEN_WIDTH*0+4], eax
					mov		[edi+SCREEN_WIDTH*1+0], edx
					mov		[edi+SCREEN_WIDTH*1+4], edx
					mov		[edi+SCREEN_WIDTH*2+0], eax
					mov		[edi+SCREEN_WIDTH*2+4], eax
					mov		[edi+SCREEN_WIDTH*3+0], eax
					mov		[edi+SCREEN_WIDTH*3+4], eax

					pop		edi
			}
		}
		p++;
		v += 2;
		if (++x >= crtc.TXT_XL) {

			if (updatetmp[p-1] & 4) {					// c{p`悾
				fontycnt += vramylpcnt;
			}
			else {
				fontycnt = vramylpcnt*2;
			}
			fontycnt &= 15;

			v += vramylpad - (x << 1);
			x = 0;
			if (newline) {
				newline = 0;
				for (i=0; i<vramylpcnt*2; i++) {
					renewalline[y++] |= 3;
				}
			}
			else {
				y += vramylpcnt*2;
			}
		}
	}
}



void width80x10_24khz(void) {					// 80x10 24KHz [h

	WORD	p;
	DWORD	*v;
	BYTE	atr, ank, knj;
	int		i;
	BYTE	newline = 0;
	BYTE	x = 0;
	int		y = 0;
	int		times;
	BYTE	*q;
	WORD	r;
	BYTE	upt;

	fontycnt = 0;
	p = crtc.TXT_TOP;
	v = (DWORD *)screenmap;

	times = vramsize;
	while((times--) && (p < (TRAM_MAX/2))) {
		if (updatetmp[p] & UPDATE_TRAM) {
			updatetmp[p] &= (BYTE)~(UPDATE_TRAM);
			upt = updatetmp[p];
			newline = 1;
			r = p;
			atr = TXT_RAM[r + TEXT_ATR];
			if (atr & blinktest) {
				atr ^= X1ATR_REVERSE;
			}
			if (upt & 0x10) {
				r--;
			}
			ank = TXT_RAM[r + TEXT_ANK];
			knj = TXT_RAM[r + TEXT_KNJ];
			if (TXT_RAM[r + TEXT_ATR] & 0x20) {
				if (knj & 0x90) {
					__asm {
						push	esi
						push	edi

						// PCG16hbg̏o
						PCG16OUT

						// {X^o[X
						PCG16_DOUBLERASTER24

						pop		edi
						pop		esi
					}
				}
				else {
					__asm {
						push	esi
						push	edi

						// PCG̏o
						PCG8OUT

						// o[X
						mov		cl, fontlpcnt			// ecx = 0̔
						xor		ebx, ebx
						mov		edi, v
						xor		esi, esi
						test	atr, X1ATR_REVERSE
						je		pcgplaneeffectr
						mov		esi, 38383838h
pcgplaneeffectr:		call	pcg_effect12line

						pop		edi
						pop		esi
					}
				}
			}
			else {
				if (!(knj & 0x80)) {
					__asm {
						push	esi
						push	edi

						TEXT16OUT

						TEXT_DOUBLERASTER(7)

						pop		edi
						pop		esi
					}
				}
				else {
					q = getfontjis(adr2jis_x1t(((WORD)knj << 8) | ank));
					if (knj & 0x40) {
						q++;
					}
					__asm {
						push	esi
						push	edi

						KANJI16OUT

						TEXT_DOUBLERASTER(8)

						pop		edi
						pop		esi
					}
				}
			}

			__asm {
					push	edi
					mov		edi, v
					movzx	ecx, fontlpcnt
					mov		eax, SCREEN_WIDTH*4
					mul		ecx
					add		edi, eax

					xor		eax, eax
					xor		edx, edx

					movzx	ebx, p
					test	byte ptr TXT_RAM[ebx + TEXT_KNJ], X1KNJ_ULINE
					je		putunderline
					mov		edx, 01010101h					// underline !!
putunderline:		mov		[edi+SCREEN_WIDTH*0+0], eax
					mov		[edi+SCREEN_WIDTH*0+4], eax
					mov		[edi+SCREEN_WIDTH*1+0], eax
					mov		[edi+SCREEN_WIDTH*1+4], eax
					mov		[edi+SCREEN_WIDTH*2+0], edx
					mov		[edi+SCREEN_WIDTH*2+4], edx
					mov		[edi+SCREEN_WIDTH*3+0], edx
					mov		[edi+SCREEN_WIDTH*3+4], edx
					mov		[edi+SCREEN_WIDTH*4+0], eax
					mov		[edi+SCREEN_WIDTH*4+4], eax
					mov		[edi+SCREEN_WIDTH*5+0], eax
					mov		[edi+SCREEN_WIDTH*5+4], eax
					mov		[edi+SCREEN_WIDTH*6+0], eax
					mov		[edi+SCREEN_WIDTH*6+4], eax
					mov		[edi+SCREEN_WIDTH*7+0], eax
					mov		[edi+SCREEN_WIDTH*7+4], eax

					pop		edi
			}
		}
		p++;
		v += 2;
		if (++x >= crtc.TXT_XL) {

			if (updatetmp[p-1] & 4) {					// c{p`悾
				fontycnt += vramylpcnt;
			}
			else {
				fontycnt = vramylpcnt*2;
			}
			fontycnt &= 15;

			v += vramylpad - (x << 1);
			x = 0;
			if (newline) {
				newline = 0;
				for (i=0; i<vramylpcnt*4; i++) {
					renewalline[y++] |= 3;
				}
			}
			else {
				y += vramylpcnt*4;
			}
		}
	}
}


