#include	<windows.h>
#include	<dsound.h>
#include	"common.h"
#include	"xmil.h"
#include	"dsounds.h"
#include	"opm.h"
#include	"dosio.h"


//	DSBUFFERDESC\̃TCYDirectX3̕ɂȂ
//	DirectX3@\gpĂƂĂ ȂB

#ifdef USE_DSOUND7
	#define	DSBUFFERDESC_SIZE	20			// DirectX3 Structsize
#else
	#define	DSBUFFERDESC_SIZE	sizeof(DSBUFFERDESC)
#endif

#ifndef DSBVOLUME_MAX
#define	DSBVOLUME_MAX			0
#endif
#ifndef DSBVOLUME_MIN
#define	DSBVOLUME_MIN			(-10000)
#endif


extern	LPDIRECTSOUND		pDSound;
static	LPDIRECTSOUNDBUFFER	pDSData3 = NULL;
static	LPDIRECTSOUNDBUFFER pDSwave3[WAVEMAX] = { NULL, };

static	BYTE	DSData3Event = 0xff;



static void dx3_buffer_out(DWORD pos) {

	HRESULT	hr;
	LPBYTE	lpBlockAdd1;
	LPBYTE	lpBlockAdd2;
	DWORD	blockSize1;
	DWORD	blockSize2;

	if ((hr = pDSData3->Lock(pos, ds_halfbuffer,
								(LPVOID*)&lpBlockAdd1, &blockSize1,
								(LPVOID*)&lpBlockAdd2, &blockSize2, 0))
													== DSERR_BUFFERLOST) {
		pDSData3->Restore();
		hr = pDSData3->Lock(pos, ds_halfbuffer,
								(LPVOID*)&lpBlockAdd1, &blockSize1,
								(LPVOID*)&lpBlockAdd2, &blockSize2, 0);
	}
	if (SUCCEEDED(hr)) {
		CopyMemory(lpBlockAdd1, pcmbuffer, blockSize1);
		if (lpBlockAdd2 != NULL) {
			CopyMemory(lpBlockAdd2, pcmbuffer + blockSize1, blockSize2);
		}
		pDSData3->Unlock(lpBlockAdd1, blockSize1,
									lpBlockAdd2, blockSize2);
	}
}

void dx3_ClearSoundBuffer(void) {

	LPBYTE	lpBlockAdd1, lpBlockAdd2;
	DWORD	blockSize1, blockSize2;

	if (SUCCEEDED(pDSData3->Lock(0, ds_halfbuffer * 2,
								(LPVOID*)&lpBlockAdd1, &blockSize1,
								(LPVOID*)&lpBlockAdd2, &blockSize2, 0))) {
		ZeroMemory(lpBlockAdd1, blockSize1);
		if (lpBlockAdd2 != NULL) {
			ZeroMemory(lpBlockAdd2, blockSize2);
		}
		pDSData3->Unlock(lpBlockAdd1, blockSize1, lpBlockAdd2, blockSize2);
	}

}

int dx3_InitSoundBuffer(void) {

	DSBUFFERDESC		dsbdesc;
	PCMWAVEFORMAT		pcmwf;

	if (pDSound == NULL) {
		return(FAILURE);
	}
	dsounds_makepara();
	INX1F_resetsamplepos();
	DSData3Event = 0xff;

    ZeroMemory(&pcmwf, sizeof(PCMWAVEFORMAT));
    pcmwf.wf.wFormatTag = WAVE_FORMAT_PCM;
    pcmwf.wf.nChannels = PCMCHANNELS;
    pcmwf.wf.nSamplesPerSec = ds_rate;
    pcmwf.wBitsPerSample = PCMBITS;
    pcmwf.wf.nBlockAlign = PCMMUL;
    pcmwf.wf.nAvgBytesPerSec = ds_rate * PCMMUL;

	ZeroMemory(&dsbdesc, sizeof(DSBUFFERDESC));
	dsbdesc.dwSize = DSBUFFERDESC_SIZE;
	dsbdesc.dwFlags = DSBCAPS_CTRLPAN | DSBCAPS_CTRLVOLUME |
						DSBCAPS_CTRLFREQUENCY |
						DSBCAPS_STICKYFOCUS | DSBCAPS_GETCURRENTPOSITION2;
	dsbdesc.lpwfxFormat = (LPWAVEFORMATEX)&pcmwf;
	dsbdesc.dwBufferBytes = ds_halfbuffer * 2;

	if (FAILED(pDSound->CreateSoundBuffer(&dsbdesc, &pDSData3, NULL))) {
		return(FAILURE);
	}
	dx3_ClearSoundBuffer();
	return(SUCCESS);
}


void dx3_TermSoundBuffer(void) {

	if (pDSData3 != NULL) {
		pDSData3->Stop();
	}
	RELEASE(pDSData3);
}


void dx3_MakeSoundBuffer(DWORD samples) {

	INX1F_makesample(samples);
}

void dx3_ProcSoundBuffer(void) {

	DWORD	pos, wpos;

	if ((pDSData3 != NULL) &&
		(pDSData3->GetCurrentPosition(&pos, &wpos) == DS_OK)) {
		if (pos >= ds_halfbuffer) {
			if (DSData3Event != 0) {
				DSData3Event = 0;
				INX1F_makesample(pcmfreemax);
				dx3_buffer_out(0);
				INX1F_resetsamplepos();
			}
		}
		else {
			if (DSData3Event != 1) {
				DSData3Event = 1;
				INX1F_makesample(pcmfreemax);
				dx3_buffer_out(ds_halfbuffer);
				INX1F_resetsamplepos();
			}
		}
	}
}

void dx3_ResetSoundBuffer(void) {

	INX1F_resetsamplepos();
}


// -----------------------------------------------------------------------

void dx3_WaveInit(void) {

	int		i;

	for (i=0; i<WAVEMAX; i++) {
		pDSwave3[i] = NULL;
	}
}

int dx3_WaveCreate(LPSTR filename, int num, int volume) {

	HRESULT			hr;
	FILEH			src;
	DSBUFFERDESC	dsbdesc;
	PCMWAVEFORMAT	pcmwf;
	WAVE_HEADER		whead;
	WAVE_INFOS		winfo;
	long			seekp;
	LPVOID			lpvPtr1;
	LPVOID			lpvPtr2;
	DWORD			dwBytes1;
	DWORD			dwBytes2;

	if ((pDSound == NULL) || (num >= WAVEMAX)) {
		return(FAILURE);
	}
	if ((src = file_open_c(filename)) == (FILEH)-1) {
		return(FAILURE);
	}
	if ((file_read(src, &whead, sizeof(whead)) != sizeof(whead)) ||
		(whead.head != C4_DWORD('R','I','F','F'))) {
		file_close(src);
		return(FAILURE);
	}
	if ((file_read(src, &whead, 4) != 4) ||
		(whead.head != C4_DWORD('W','A','V','E'))) {
		file_close(src);
		return(FAILURE);
	}
	if ((file_read(src, &whead, sizeof(whead)) != sizeof(whead)) ||
		(whead.head != C4_DWORD('f','m','t',' ')) ||
		(file_read(src, &winfo, sizeof(winfo)) != sizeof(winfo))) {
		file_close(src);
		return(FAILURE);
	}
	seekp = whead.size + 20;
	file_seek(src, seekp, FSEEK_SET);
	if (file_read(src, &whead, sizeof(whead)) != sizeof(whead)) {
		file_close(src);
		return(FAILURE);
	}
	if (whead.head == C4_DWORD('f','a','c','t')) {
		seekp += whead.size + 8;
		file_seek(src, seekp, FSEEK_SET);
		if (file_read(src, &whead, sizeof(whead)) != sizeof(whead)) {
			file_close(src);
			return(FAILURE);
		}
	}
	if (whead.head != C4_DWORD('d','a','t','a')) {
		file_close(src);
		return(FAILURE);
	}

	ZeroMemory(&pcmwf, sizeof(PCMWAVEFORMAT));
	pcmwf.wf.wFormatTag = winfo.format;
	pcmwf.wf.nChannels = winfo.channel;
	pcmwf.wf.nSamplesPerSec = winfo.rate;
	pcmwf.wBitsPerSample = winfo.bit;
	pcmwf.wf.nBlockAlign = winfo.block;
	pcmwf.wf.nAvgBytesPerSec = winfo.rps;

	ZeroMemory(&dsbdesc, sizeof(DSBUFFERDESC));
	dsbdesc.dwSize = DSBUFFERDESC_SIZE;
	dsbdesc.dwFlags = DSBCAPS_CTRLPAN | DSBCAPS_CTRLVOLUME |
						DSBCAPS_CTRLFREQUENCY | DSBCAPS_STATIC | 
						DSBCAPS_STICKYFOCUS | DSBCAPS_GETCURRENTPOSITION2;
	dsbdesc.dwBufferBytes = whead.size;
	dsbdesc.lpwfxFormat = (LPWAVEFORMATEX)&pcmwf;

	if (FAILED(pDSound->CreateSoundBuffer(&dsbdesc, &pDSwave3[num], NULL))) {
		file_close(src);
		return(FAILURE);
	}
	dx3_WaveVolume(num, volume);

	if ((hr = pDSwave3[num]->Lock(0, whead.size,
						&lpvPtr1, &dwBytes1, &lpvPtr2, &dwBytes2, 0))
														== DSERR_BUFFERLOST) {
		pDSwave3[num]->Restore();
		hr = pDSwave3[num]->Lock(0, whead.size,
						&lpvPtr1, &dwBytes1, &lpvPtr2, &dwBytes2, 0);
	} 
	if (SUCCEEDED(hr)) {
		file_lread(src, lpvPtr1, dwBytes1);
		if (dwBytes2) {
			file_lread(src, lpvPtr2, dwBytes2);
		}
		pDSwave3[num]->Unlock(lpvPtr1, dwBytes1, lpvPtr2, dwBytes2);
	}
	return(SUCCESS);
}

int dx3_WavePlay(int num, int lpflg) {

	DWORD	flg = 0;

	if ((num >= WAVEMAX) || (pDSwave3[num] == NULL)) {
		return(FAILURE);
	}
	if (lpflg) {
		flg = DSBPLAY_LOOPING;
	}
//	pDSwave3[num]->SetCurrentPosition(0);
	pDSwave3[num]->Play(0, 0, flg);
	return(SUCCESS);
}

void dx3_WaveVolume(int num, int volume) {

	if ((num < WAVEMAX) && (pDSwave3[num])) {
		pDSwave3[num]->SetVolume((((DSBVOLUME_MAX - DSBVOLUME_MIN) * volume)
											/ 100) + DSBVOLUME_MIN);
	}
}

void dx3_WaveStop(int num) {

	if ((num < WAVEMAX) && (pDSwave3[num])) {
		pDSwave3[num]->Stop();
	}
}

void dx3_WaveRelease(int num) {

	if ((num < WAVEMAX) && (pDSwave3[num])) {
		pDSwave3[num]->Stop();
		pDSwave3[num]->Release();
	}
}

void dx3_WaveAllTerm(void) {

	int		i;

	for (i=0; i<WAVEMAX; i++) {
		dx3_WaveRelease(i);
	}
}


// --------------------------------------------------------------------------


void dx3_PlayDirectSound(void) {

	if (pDSData3 != NULL) {
		pDSData3->Play(0, 0, DSBPLAY_LOOPING);
	}
}

void dx3_StopDirectSound(void) {

	int		i;

	if (pDSData3 != NULL) {
		pDSData3->Stop();
	}
	for (i=0; i<WAVEMAX; i++) {
		dx3_WaveStop(i);
	}
}

