#define		OPM_CLOCK		4000000L			// X1 & X68000 OPM 4MHz

#define		MAXCHANNEL		8

#define		SIN_BITS		10
#define		EVC_BITS		10
#define		ENV_BITS		16
#define		KF_BITS			6
#define		FREQ_BITS		16

#define		ENVTBL_BIT		14
#define		SINTBL_BIT		15

#define		FREQ_RATE		(1L << (21-FREQ_BITS))

#define		TL_BITS			(FREQ_BITS+2)

#define		OPM_OUTSB		(TL_BITS + 2 - 16)			// OPM output 16bit
#define		OPM_OUTSB_8		(OPM_OUTSB + 8)				// OPM output 8bit
#define		OPM_MAXOUT		(0x7fffL<<OPM_OUTSB)
#define		OPM_MINOUT		(-0x8000L<<OPM_OUTSB)


#define		SIN_ENT			(1L << SIN_BITS)
#define		EVC_ENT			(1L << EVC_BITS)

#define		EC_ATTACK		0								// ATTACK start
#define		EC_DECAY		(EVC_ENT << ENV_BITS)			// DECAY start
#define		EC_OFF			((2L * EVC_ENT) << ENV_BITS)	// OFF

#define		EG_STEP			(96.0/EVC_ENT)					// dB step
#define		TL_MAX			(EVC_ENT * 2)


#define		SLOT1			0				// slot number
#define		SLOT2			2
#define		SLOT3			1
#define		SLOT4			3

#define 	EM_ATTACK		4
#define 	EM_DECAY1		3
#define 	EM_DECAY2		2
#define 	EM_RELEASE		1
#define 	EM_OFF			0


typedef struct {
	long	*detune1;			// detune1
	WORD	detune2;			// detune2
	WORD	totallevel;			// total level
	long	decaylevel;			// decay level
	long	*attack;			// attack raito
	long	*decay1;			// decay1 raito
	long	*decay2;			// decay2 raito
	long	*release;			// release raito
	long 	freq_cnt;			// frequency count
	long	freq_inc;			// frequency step
	BYTE	keyscale;			// key scale
	BYTE	multiple;			// multiple

	BYTE	env_mode;			// envelope mode
	BYTE	envraito;			// envelope raito
	long	env_cnt;			// envelope count
	long	env_end;			// envelope end count
	long	env_inc;			// envelope step
	long	env_inc_attack;		// envelope attack step
	long	env_inc_decay1;		// envelope decay1 step
	long	env_inc_decay2;		// envelope decay2 step
	long	env_inc_release;	// envelope release step
} OPM_SLOT;


typedef struct {
	OPM_SLOT	SLOT[4];
	BYTE	algorhythm;			// algorythm
	BYTE	feedback;			// self feedback
	long	op1fb;				// operator1 feedback
	long	*connect1;			// operator1 connect
	long	*connect3;			// operator3 connect
	long	*connect2;			// operator2 connect
	long	*connect4;			// operator4 connect
	WORD	keynote;			// key note
	BYTE	keyfunc;			// key function
	BYTE	kcode;				// key code
	BYTE	pan;				// pan
	BYTE	padding;
} OPM_CH;



typedef struct {
	WORD	tune1;		// 0
	WORD	tune2;		// 2
	WORD	tune3;		// 4
	BYTE	noise;		// 6
	BYTE	mixer;		// 7
	BYTE	vol1;		// 8
	BYTE	vol2;		// 9
	BYTE	vol3;		// a
	WORD	envtime;	// b
	BYTE	env;		// d
	BYTE	io1;
	BYTE	io2;
} PSGTABLE;


typedef	union {
	BYTE		data[16];
	PSGTABLE	val;
} PSG_T;


typedef struct {
	WORD	psg_freq;
	WORD	psg_sound_cnt;
	BYTE	*psg_volp;
	WORD	psg_puchinoise;
} PSG_CH;

#define		PSGENV_INC			15
#define		PSGENV_ONESHOT		16
#define		PSGENV_LASTON		32
#define		PSGENV_ONECYCLE		64

