#include	<windows.h>

#include	"common.h"
#include	"x1.h"
#include	"dosio.h"
#include	"parts.h"

static	char	fontname[] = "CGROM.DAT";

											// vg^Cv
void ank8cnv(BYTE *src, int datacount);		// X68K datacount = 2
void x68ksjiscpy(BYTE *dst, BYTE *src, WORD from, WORD to);


// 񂶂傳 thanx
BYTE x68kfontread(BYTE loaded) {

	FILEH				fh;
	BYTE				loadedx68kfont = 0;
	HANDLE				hwork;
	BYTE				*work;

	// t@C݂邩H
	if (file_attr_c(fontname) == -1) {
		return(0);							// t@C݂Ȃ
	}

	// A[P[g
	if ((hwork = GlobalAlloc(GPTR, 0x3B800)) == NULL) {
		return(0);							// A[P[gɎs
	}

	// bNyу|C^擾
	if ((work = (BYTE *)GlobalLock(hwork)) == NULL) {
		GlobalFree(hwork);					// A[P[gɎs
		return(0);
	}

	// t@CI[v
	if ((fh = file_open_c(fontname)) == (FILEH)-1) {
		GlobalUnlock(hwork);				// I[vɎs
		GlobalFree(hwork);
		return(0);
	}

	for (;;) {								// gotogȂ ܂Ȃ
		// CGROM.DAT ̓ǂݍ
		if (file_lread(fh, work, 0x3B800) != 0x3B800) {
			break;							// ǂݍݎs
		}

		// 8dot ANKǂޕKv邩
		if (!(loaded & FONT_ANK8)) {
			ank8cnv(work + 0x3A000, 2);
			loadedx68kfont |= FONT_ANK8;
		}

		// 16dot ASCIIǂޕKv邩
		if (!(loaded & FONT_ANK16a)) {
			memcpy(&KNJ_FNT[0x0000], work + 0x3A800, 0x800);
			loadedx68kfont |= FONT_ANK16a;
		}

		// 16dot ANK(0x80`)ǂޕKv邩
		if (!(loaded & FONT_ANK16b)) {
			memcpy(&KNJ_FNT[0x0800], work + 0x3B000, 0x800);
			loadedx68kfont |= FONT_ANK16b;
		}

		// ꐅǂݍށH
		if (!(loaded & FONT_KNJ1)) {

			// SJISR[h 0x8140 ` 0x84bf ̃Rs[
			x68ksjiscpy(&KNJ_FNT[0x01000], work, 0x8140, 0x84c0);

			// SJISR[h 0x8890 ` 0x989e ̃Rs[
			x68ksjiscpy(&KNJ_FNT[0x08000], work, 0x8890, 0x989f);

			loadedx68kfont |= FONT_KNJ1;
		}

		// 񐅏ǂޕKv͂H
		if (!(loaded & FONT_KNJ2)) {

			// SJISR[h 0x989f ` 0x9fff ̃Rs[
			x68ksjiscpy(&KNJ_FNT[0x281e0], work, 0x989f, 0xa000);

			// SJISR[h 0xe040 ` 0xeaaf ̃Rs[
			x68ksjiscpy(&KNJ_FNT[0x36e00], work, 0xe040, 0xeab0);

			loadedx68kfont |= FONT_KNJ2;
		}

		break;
	}
	file_close(fh);

	// 
	GlobalUnlock(hwork);
	GlobalFree(hwork);

	return(loadedx68kfont);
}



// ̎w͈͂̃R[h Rs[
static void x68ksjiscpy(BYTE *dst, BYTE *src, WORD from, WORD to) {

	int		y;
	BYTE	*p;
	WORD	sjis;
	WORD	jis;

	for (sjis=from; sjis<to; sjis++) {

		// R[hSJISJISɕϊ
		jis = sjis2jis(sjis);

		p = NULL;

		// JISR[hH
		if (((jis & 0x0ff) >= 0x21) && ((jis & 0x0ff) <= 0x7e)) {
			if ((jis >= 0x2100) && (jis < 0x2900)) {
				p = src + 0x00000
					+ (((((jis / 0x100) - 0x21) * 0x5e)
						+ ((jis & 0xff) - 0x21)) * 0x20);
			}
			else if ((jis >= 0x3000) && (jis < 0x5000)) {
				p = src + 0x05E00
					+ (((((jis / 0x100) - 0x30) * 0x5e)
						+ ((jis & 0xff) - 0x21)) * 0x20);
			}
			else if ((jis >= 0x5000) && (jis < 0x7400)) {
				p = src + 0x1D600
					+ (((((jis / 0x100) - 0x50) * 0x5e)
						+ ((jis & 0xff) - 0x21)) * 0x20);
			}
		}

		if (p != NULL) {					// KiR[hȂ
			// Rs[
			for (y=0; y<16; y++) {
				*dst++ = *p++;
				*dst++ = *p++;
			}
		}
		else {								// KiOR[h
			// 0 fill
			ZeroMemory(dst, 32);
			dst += 32;
		}
	}
}

