#include	<windows.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	"x1.h"
#include	"dosio.h"
#include	"x1_dma.h"
#include	"x1_fdc.h"
#include	"fdd_2d.h"
#include	"fdd_d88.h"
#include	"fdd_mtr.h"

#include	"trace.h"

		FDC_REGS	FDC;
		BYTE		FDC_c[4];
		char		FDC_NAME[4][X1_MAX_PATH];
		char		FDC_PATH[X1_MAX_PATH];
		BYTE		WRITEPT[4] = {0, 0, 0, 0};
		BYTE		DISKNUM[4] = {0, 0, 0, 0};
		BYTE		driveset = 0;
		BYTE		fdcdummyread = 0;

const	BYTE		fdctype[] = {1,1,1,1,1,1,1,1,2,2,2,2,3,4,3,3};
		WORD		readdiag = 0;

/***********************************************************************
	ecc itbs[̏oɑ֐j
***********************************************************************/

short x1_fdimage(LPSTR fname) {

	int		leng;
	char	*p;

	leng = strlen(fname);
	if (leng > 3) {
		p = &fname[leng-3];
		if (strcmp(p, ".2D") == 0 || strcmp(p, ".2d") == 0) {
			return(DRV_FMT2D);
		}
	}
	if (leng > 4) {
		p = &fname[leng-4];
		if (strcmp(p, ".D88") == 0 || strcmp(p, ".d88") == 0 ||
			strcmp(p, ".88D") == 0 || strcmp(p, ".88d") == 0) {
			return(DRV_FMT88);
		}
	}
	return(DRV_EMPTY);
}


short x1_eject_fd(short drv) {

	if (drv < 0 || drv > 3) {
		return(0);
	}
	switch(DISKNUM[drv]) {
		case DRV_EMPTY:
			return(0);
		case DRV_FMT2D:
			return(fdd_eject_2d(drv));
	}
	return(fdd_eject_d88(drv));
}

short x1_set_fd(short drv, short dskno, LPSTR fname) {

	if (drv < 0 || drv > 3) {
		return(1);
	}
	if ((!fname) || (!fname[0])) {
		return(x1_eject_fd(drv));
	}
	switch(x1_fdimage(fname)) {
		case DRV_EMPTY:
			return(1);
		case DRV_FMT2D:
			return(fdd_set_2d(drv, fname));
	}
	return(fdd_set_d88(drv, fname));
}


LPSTR x1_get_fname(short drv) {

	return(FDC_NAME[drv]);
}


/***********************************************************************
	ecb ^I
***********************************************************************/


void init_fdc(void) {

	FDDMTR_INIT;
	ZeroMemory(&FDC, sizeof(FDC));
	FDC.step = 1;
	ZeroMemory(FDC_c, 4);
}


BYTE fdd_stat(void) {

	switch(DISKNUM[FDC.drv]) {
		case DRV_EMPTY:
			return(0);
		case DRV_FMT2D:
			return(fdd_stat_2d());
	}
	return(fdd_stat_d88());
}


/***********************************************************************
	ecb iwP猩h^nɑ֐j
***********************************************************************/

int inc_off(void) {

	BYTE	ret;

	if (!FDC.motor) {
		return(0);
	}
	if (fdcdummyread) {
		fdcdummyread--;
		return(0);
	}
	else {
		switch(DISKNUM[FDC.drv]) {
			case DRV_EMPTY:
				return(0);
			case DRV_FMT2D:
				ret = fdd_incoff_2d();
				break;
			default:
				ret = fdd_incoff_d88();
				break;
		}
		if (ret) {
			dma.DMA_REDY = 8;	// <- DMA  ިݺ޳  ر
		}
	}
	return(ret);
}


X1_IOW x1_fdc_w(WORD port, BYTE value) {

	short	cmnd;

	TRACEOUT(port, value);

	port &= 0xf;
	if (port == 8) {						// 
		driveset = 0;
		FDC.cmnd = value;
		cmnd = value >> 4;
		FDC.type = fdctype[cmnd];
		FDC.skip = 2;
		switch(cmnd) {
			case 0:							// ؽı
				if (value & 8) {			// LAYDOCK
					FDC.skip = 0;
					FDC.busyclock = 20;		// ver0.25 (now testing)
					FDC.busystart = h_cntbase + h_cnt;
				}
				FDC.motor = 0x80;			// ӰOn?
				FDC.treg = FDC.c = 0;
				FDDMTR_MOVE;
				FDC.step = 1;
#if 1										// ver0.25
				FDC.rreg = FDC.r = 0;		// ޾ܰ
#endif
				break;
			case 1:							// 
				FDC.motor = 0x80;			// ӰOn
				FDC.step = (char)(FDC.c<=FDC.data?1:-1);
#if 1
				FDC.rreg = FDC.r = 0;
#endif
#if 1
				FDC.treg = FDC.c = FDC.data;
#else												// 傢
				{
					int	seek = FDC.c + FDC.data - FDC.treg;
					if (seek >= (164/2)) {
						FDC.c = (164/2) - 1;
					}
					else if (seek < 0) {
						FDC.c = 0;
					}
					else {
						FDC.c = (BYTE)seek;
					}
					FDC.treg = FDC.c;
				}
#endif
				FDDMTR_MOVE;
				break;
			case 2: case 3:					// ï
				if (FDC.motor) {
					FDC.c += FDC.step;
					if (cmnd & 1) {
						FDDMTR_MOVE;
						FDC.treg = FDC.c;
					}
				}
				break;
			case 4: case 5:					// ïߥ
				if (FDC.motor) {
					FDC.step = 1;
					FDC.c++;
					if (cmnd & 1) {
						FDDMTR_MOVE;
						FDC.treg = FDC.c;
					}
				}
				break;
			case 6: case 7:					// ïߥ
				if (FDC.motor) {
					FDC.step = -1;
					FDC.c--;
					if (cmnd & 1) {
						FDDMTR_MOVE;
						FDC.treg = FDC.c;
					}
				}
				break;

			case 0x8: case 0x9:				// ذ ް
			case 0xa: case 0xb:				// ײ  ް
				FDC.off = 0;
				fdcdummyread = 2;
				if (FDC.motor) {
					if (dma.DMA_ENBL) {
						dma.DMA_REDY = 0;		// <- DMA  ިݺ޳
//						FDC.skip = 0;			// DMAŊ荞݂Ď鎖I
					}
				}
				break;

			case 0xc:							// ذ ڽ
				FDC.crc_off = 0;
				fdcdummyread = 2;
				if (FDC.motor) {				// ver0.25
					if (dma.DMA_ENBL) {
						dma.DMA_REDY = 0;		// <- DMA  ިݺ޳
					}
				}
				switch(DISKNUM[FDC.drv]) {
					case DRV_EMPTY:
						break;
					case DRV_FMT2D:
						fdd_crc_2d();
						break;
					default:
						fdd_crc_d88();
						break;
				}
				break;

			case 0xd:						// ̫.
				fdcdummyread = 0;			// KvȂH
				FDC.skip = 0;				// 000330
				dma.DMA_REDY = 8;			// ver0.25
				break;

			case 0xe:						// ذ ׯ
				readdiag = 0;
				break;

			case 0xf:						// ײ  ׯ
				switch(DISKNUM[FDC.drv]) {
					case DRV_EMPTY:
					case DRV_FMT2D:
						break;
					default:
						if (FDC.motor) {	// ver0.25
							init_tao_d88();
							if (dma.DMA_ENBL) {
								dma.DMA_REDY = 0;
							}
						}
						break;
				}
				break;
		}
	}
	else {
		cmnd = FDC.cmnd >> 4;
		switch(port) {
			case 0x9:				// ׯ
				FDC.treg = value;
				break;
			case 0xa:				// 
				FDDMTR_WAITSEC(value);
				FDC.rreg = FDC.r = value;
				break;
			case 0xb: // ް
				FDC.data = value;
				if (cmnd==0x0a || cmnd==0x0b) {
					switch(DISKNUM[FDC.drv]) {
						case DRV_EMPTY:
							break;
						case DRV_FMT2D:
							fdd_write_2d();
							break;
						default:
							fdd_write_d88();
							break;
					}
					inc_off();
				}
				else if (cmnd==0x0f) {					// TRACK WRITE !!!
					switch(DISKNUM[FDC.drv]) {
						case DRV_EMPTY:
						case DRV_FMT2D:
							break;
						default:
							fdd_wtao_d88(value);
							break;
					}
				}
				break;
			case 0xc: // ײ/
				driveset = 1;
#if 1													// ARSYS !!!
				FDC_c[FDC.drv] = FDC.c;	
				FDC.c = FDC_c[value & 0x03];			// XTAL !!!
#else
				FDC_TBL[FDC.drv] = FDC;
				FDC = FDC_TBL[value & 0x03];
#endif
				FDC.motor = (BYTE)(value & 0x80);
				FDC.drv = value & 0x03;
				FDC.h = (BYTE)(value & 0x10?1:0);

				FDC.cmnd = 0;							// T&E SORCERIAN
//				FDC.data = 0;							// e̓`
				FDC.type = 0;

				FDDMTR_DRVSET;
#if 0
	if (value == 1) {
		if ((!trace_sw) && (FDC.r == 7)) {
			debug_status();
			trace_sw = 1;
		}
	}
#endif
				if (!FDC.motor) {
					FDC.rreg = FDC.r = 0;				// SACOM TELENET !!!
#if 0													// XTAL !!!
					FDC.c = 0;
					FDC.step = 1;
#endif
				}
				break;
		}
	}
}

X1_IOR x1_fdc_r(WORD port) {

static	BYTE	timeoutwait;
static	BYTE	last_r;
static	short	last_off;
		BYTE	ans;
		BYTE	cmnd;

	TRACEIN(port);

	cmnd = (BYTE)(FDC.cmnd >> 4);

	if ((port &= 0xf) != 8) {
		last_r = -1;
		last_off = -1;
		timeoutwait = 4;
	}
	switch(port) {
		case 0x8:	// ð
			ans = 0;
			fdcdummyread = 0;
			if (FDC.skip) {
				FDC.skip--;
				return(1);
			}
			if (FDC.busyclock) {					// ver0.25
				if (((h_cntbase + h_cnt) - FDC.busystart) < FDC.busyclock) {
					TRACE_("busy", 1);
					return(1);
				}
				FDC.busyclock = 0;
			}
			if (!DISKNUM[FDC.drv]) {
				if (FDC.type == 1 && FDC.c == 0) {	// hCu`FbN !!!
					return(0x84);					// ڑĂ鎞
				}
				return(0x80);
			}
			if (FDC.type == 2) {
				if (last_r == FDC.r && last_off == FDC.off &&
						!(--timeoutwait)) {
					inc_off();
					timeoutwait = 4;
				}
				last_r = FDC.r;
				last_off = FDC.off;
			}							// Read Writê݂̕ωł
			if (!((ans = fdd_stat()) & 2)) {
				dma.DMA_REDY = 8;				// <- DMA  ިݺ޳  ر
			}
#if 1
			if (driveset) {					// 0xffc@ゾ
				ans &= 0xc4;
			}
#endif
			TRACE_("FDC status", ans);
			return(ans);

		case 0x9:							// ׯ
			return(FDC.treg);

		case 0xa:							// 
			return(FDC.rreg);				// ver0.25

		case 0xb:							// ް
			if (FDC.motor) {
				if (cmnd==0x08 || cmnd==0x09) {	// ذޥް
					switch(DISKNUM[FDC.drv]) {
						case DRV_EMPTY:
							break;
						case DRV_FMT2D:
							fdd_read_2d();
							break;
						default:
							fdd_read_d88();		// WOODY POCO !!!
							break;
					}
					inc_off();
				}
				else if (cmnd==0x0c) {			// ذޥڽ
					if (FDC.crc_off < 6) {		// ver0.25
						FDC.data = FDC.crc_dat[FDC.crc_off];
#ifdef TRACE
{
	char	buf[256];
	wsprintf(buf, "crc: %3d %2d %02x -> %04x/%04x",
						(FDC.c << 1) + FDC.h, FDC.r, FDC.crc_off, R.HL.W,
							dma.CNT_B.w);
	TRACE_(buf, FDC.data);
}
#endif
						if (fdcdummyread) {		// ver0.25
							fdcdummyread--;
						}
						else {
							FDC.crc_off++;
						}
					}
				}
				else if (cmnd == 0x0e) {		// ver0.25(prepart)
					FDC.data = 0;
					readdiag++;
				}
			}
			return(FDC.data);					// WOODY POCO !!!

//		case 0xc:								// FM
//		case 0xd:								// MFM
		case 0xe:								// 1.6M
			FDC.media = 1;
			return(0xff);
		case 0xf:								// 500K/1M
			FDC.media = 0;
			return(0xff);
	}
	return(0);
}

