//----------------------------------------------------------------------------
//
//  Z80R : Z80 Engine  for Intel x86 Protectmode (80386 later)
//
//                                       Copyright by Studio Milmake 1999-2000
//
//----------------------------------------------------------------------------

#include	<windows.h>

#include	"common.h"
#include	"x1_io.h"
#include	"x1_mem.h"
#include	"z80r.h"
#include	"z80r_mcr.h"

extern	Z80RPUB	_code_cb(void);

extern	BYTE	cycles_xx[];
extern	BYTE	cycles_ed[];

extern	Z80ROPCODE	opcode_dd[];
extern	Z80ROPCODE	opcode_ed[];
extern	Z80ROPCODE	opcode_fd[];

Z80RASM _rlca(void) {

	__asm {
				mov		ax, R_Z80AF
				and		al, 0ech
				rol		ah, 1
#if 1
				adc		al, 0
#else
				jnc		rlca_noc
				or		al, C_FLAG
rlca_noc:
#endif
				mov		R_Z80AF, ax
				ret
	}
}

Z80RASM _rrca(void) {

	__asm {
				mov		ax, R_Z80AF
				and		al, 0ech
				ror		ah, 1
#if 1
				adc		al, 0
#else
				jnc		rrca_noc
				or		al, C_FLAG
rrca_noc:
#endif
				mov		R_Z80AF, ax
				ret
	}
}

Z80RASM _rla(void) {

	__asm {
				mov		dx, R_Z80AF
				mov		ah, dl
				and		dl, 0ech
				sahf
				rcl		dh, 1
#if 1
				adc		dl, 0
#else
				jnc		rla_noc
				or		dl, C_FLAG
rla_noc:
#endif
				mov		R_Z80AF, dx
				ret
	}
}

Z80RASM _rra(void) {

	__asm {
				mov		dx, R_Z80AF
				mov		ah, dl
				and		dl, 0ech
				sahf
				rcr		dh, 1
#if 1
				adc		dl, 0
#else
				jnc		rra_noc
				or		dl, C_FLAG
rra_noc:
#endif
				mov		R_Z80AF, dx
				ret
	}
}

Z80RASM _daa(void) {

	__asm {
				mov		ax, R_Z80AF
				mov		dx, ax
				and		ah, 0fh
				and		dl, N_FLAG
				jne		short dashighchk
				cmp		ah, 10
				jb		short daachkh
				or		dl, H_FLAG
				jmp		daalowdeg
daachkh:		test	al, H_FLAG
				je		short ddahighdeg
daalowdeg:		add		dh, 6
				jc		short daahighdeg
ddahighdeg:		cmp		dh, 9fh
				ja		short daahighdeg
				test	al, C_FLAG
				je		short daa_otherflag
daahighdeg:		add		dh, 60h
				or		dl, C_FLAG
				jmp		daa_otherflag
dashighchk:		cmp		dh, 99h
				ja		short dashighdeg
				test	al, C_FLAG
				je		short daslowchk
dashighdeg:		sub		dh, 60h
				or		dl, C_FLAG
daslowchk:		cmp		ah, 9
				ja		short daslogdeg
				test	al, H_FLAG
				je		short daa_otherflag
daslogdeg:		sub		ah, 6
				jns		short dasnos
				or		dl, H_FLAG
dasnos:			sub		dh, 6
				jnc		short daa_otherflag
				test	al, H_FLAG
				jne		short daa_otherflag
				or		dl, C_FLAG
daa_otherflag:	xor		eax, eax
				mov		al, dh
				or		dl, ZSPtable[eax]
				mov		R_Z80AF, dx
				ret
	}
}

Z80RASM _ccf(void) {

	__asm {
				mov		al, R_Z80F
				and		al, not (H_FLAG or N_FLAG)
				test	al, C_FLAG
				je		cffnoc
				or		al, H_FLAG
cffnoc:			xor		al, C_FLAG
				mov		R_Z80F, al
				ret
	}
}

Z80RASM _cpl(void) {

	__asm {
				not		R_Z80A
				or		R_Z80F, (H_FLAG or N_FLAG)
				ret
	}
}

Z80RASM _scf(void) {

	__asm {
				and		R_Z80F, not (H_FLAG or N_FLAG)
				or		R_Z80F, C_FLAG
				ret
	}
}

Z80RASM _halt(void) {

	__asm {
				dec		R_Z80PC
				or		Z80_IFF, 1 shl IFF_HALT
				ret
	}
}

Z80RASM _di(void) {

	__asm {
				or		Z80_IFF, 1 shl IFF_IFLAG
				ret
	}
}
Z80RASM _ei(void) {

extern	Z80ROPCODE opcode_main[];
extern	BYTE	cycles_main[];

	__asm {
#if 0
				and		Z80_IFF, not ((1 shl IFF_IFLAG) or (1 shl IFF_IRQ) or (1 shl IFF_NMI))
#else
				and		Z80_IFF, not (1 shl IFF_IFLAG)
				movzx	ecx, R_Z80PC
				call	fast_RDMEM
				cmp		al, 0fbh
				je		ei_ret
				inc		R.R
				inc		R_Z80PC
				movzx	edx, cycles_main[eax]
				add		Z80_ICount, dx
				jmp		opcode_main[eax*4]
ei_ret:
#endif
				ret
	}
}

Z80RASM _ld_nop(void) { __asm { ret } }
Z80RASM _ld_xbc_a(void) { LDx_B(R_Z80BC, R_Z80A) }
Z80RASM _ld_xde_a(void) { LDx_B(R_Z80DE, R_Z80A) }
Z80RASM _ld_xhl_a(void) { LDx_B(R_Z80HL, R_Z80A) }
Z80RASM _ld_xhl_b(void) { LDx_B(R_Z80HL, R_Z80B) }
Z80RASM _ld_xhl_c(void) { LDx_B(R_Z80HL, R_Z80C) }
Z80RASM _ld_xhl_d(void) { LDx_B(R_Z80HL, R_Z80D) }
Z80RASM _ld_xhl_e(void) { LDx_B(R_Z80HL, R_Z80E) }
Z80RASM _ld_xhl_l(void) { LDx_B(R_Z80HL, R_Z80L) }
Z80RASM _ld_xhl_h(void) { LDx_B(R_Z80HL, R_Z80H) }

Z80RASM	_ld_xhl_byte(void) {

	GET_PC_BYTE
	__asm {
				mov		cx, R_Z80HL
				mov		dl, al
				jmp		fast_WRMEM
	}
}

Z80RASM _ld_xbyte_a(void) {

	GET_PC_WORD
	__asm {
				mov		cx, ax
				mov		dl, R_Z80A
				jmp		fast_WRMEM
	}
}

Z80RASM _ld_xword_hl(void) { LDx_W(R_Z80HL) }

Z80RASM _ld_a_xbyte(void) {

	GET_PC_WORD
	__asm {
				mov		cx, ax
				call	fast_RDMEM
				mov		R_Z80A, al
				ret
	}
}

Z80RASM _ld_a_byte(void) { LDB_b(R_Z80A) }
Z80RASM _ld_b_byte(void) { LDB_b(R_Z80B) }
Z80RASM _ld_c_byte(void) { LDB_b(R_Z80C) }
Z80RASM _ld_d_byte(void) { LDB_b(R_Z80D) }
Z80RASM _ld_e_byte(void) { LDB_b(R_Z80E) }
Z80RASM _ld_l_byte(void) { LDB_b(R_Z80L) }
Z80RASM _ld_h_byte(void) { LDB_b(R_Z80H) }

Z80RASM _ld_a_xbc(void) { LDB_x(R_Z80A, R_Z80BC) }
Z80RASM _ld_a_xde(void) { LDB_x(R_Z80A, R_Z80DE) }
Z80RASM _ld_a_xhl(void) { LDB_x(R_Z80A, R_Z80HL) }
Z80RASM _ld_b_xhl(void) { LDB_x(R_Z80B, R_Z80HL) }
Z80RASM _ld_c_xhl(void) { LDB_x(R_Z80C, R_Z80HL) }
Z80RASM _ld_d_xhl(void) { LDB_x(R_Z80D, R_Z80HL) }
Z80RASM _ld_e_xhl(void) { LDB_x(R_Z80E, R_Z80HL) }
Z80RASM _ld_l_xhl(void) { LDB_x(R_Z80L, R_Z80HL) }
Z80RASM _ld_h_xhl(void) { LDB_x(R_Z80H, R_Z80HL) }

Z80RASM _ld_a_b(void) { MCR_LD(R_Z80A, R_Z80B) }
Z80RASM _ld_a_c(void) { MCR_LD(R_Z80A, R_Z80C) }
Z80RASM _ld_a_d(void) { MCR_LD(R_Z80A, R_Z80D) }
Z80RASM _ld_a_e(void) { MCR_LD(R_Z80A, R_Z80E) }
Z80RASM _ld_a_l(void) { MCR_LD(R_Z80A, R_Z80L) }
Z80RASM _ld_a_h(void) { MCR_LD(R_Z80A, R_Z80H) }
Z80RASM _ld_b_a(void) { MCR_LD(R_Z80B, R_Z80A) }
Z80RASM _ld_b_c(void) { MCR_LD(R_Z80B, R_Z80C) }
Z80RASM _ld_b_d(void) { MCR_LD(R_Z80B, R_Z80D) }
Z80RASM _ld_b_e(void) { MCR_LD(R_Z80B, R_Z80E) }
Z80RASM _ld_b_l(void) { MCR_LD(R_Z80B, R_Z80L) }
Z80RASM _ld_b_h(void) { MCR_LD(R_Z80B, R_Z80H) }
Z80RASM _ld_c_a(void) { MCR_LD(R_Z80C, R_Z80A) }
Z80RASM _ld_c_b(void) { MCR_LD(R_Z80C, R_Z80B) }
Z80RASM _ld_c_d(void) { MCR_LD(R_Z80C, R_Z80D) }
Z80RASM _ld_c_e(void) { MCR_LD(R_Z80C, R_Z80E) }
Z80RASM _ld_c_l(void) { MCR_LD(R_Z80C, R_Z80L) }
Z80RASM _ld_c_h(void) { MCR_LD(R_Z80C, R_Z80H) }
Z80RASM _ld_d_a(void) { MCR_LD(R_Z80D, R_Z80A) }
Z80RASM _ld_d_b(void) { MCR_LD(R_Z80D, R_Z80B) }
Z80RASM _ld_d_c(void) { MCR_LD(R_Z80D, R_Z80C) }
Z80RASM _ld_d_e(void) { MCR_LD(R_Z80D, R_Z80E) }
Z80RASM _ld_d_l(void) { MCR_LD(R_Z80D, R_Z80L) }
Z80RASM _ld_d_h(void) { MCR_LD(R_Z80D, R_Z80H) }
Z80RASM _ld_e_a(void) { MCR_LD(R_Z80E, R_Z80A) }
Z80RASM _ld_e_b(void) { MCR_LD(R_Z80E, R_Z80B) }
Z80RASM _ld_e_c(void) { MCR_LD(R_Z80E, R_Z80C) }
Z80RASM _ld_e_d(void) { MCR_LD(R_Z80E, R_Z80D) }
Z80RASM _ld_e_l(void) { MCR_LD(R_Z80E, R_Z80L) }
Z80RASM _ld_e_h(void) { MCR_LD(R_Z80E, R_Z80H) }
Z80RASM _ld_l_a(void) { MCR_LD(R_Z80L, R_Z80A) }
Z80RASM _ld_l_b(void) { MCR_LD(R_Z80L, R_Z80B) }
Z80RASM _ld_l_c(void) { MCR_LD(R_Z80L, R_Z80C) }
Z80RASM _ld_l_d(void) { MCR_LD(R_Z80L, R_Z80D) }
Z80RASM _ld_l_e(void) { MCR_LD(R_Z80L, R_Z80E) }
Z80RASM _ld_l_h(void) { MCR_LD(R_Z80L, R_Z80H) }
Z80RASM _ld_h_a(void) { MCR_LD(R_Z80H, R_Z80A) }
Z80RASM _ld_h_b(void) { MCR_LD(R_Z80H, R_Z80B) }
Z80RASM _ld_h_c(void) { MCR_LD(R_Z80H, R_Z80C) }
Z80RASM _ld_h_d(void) { MCR_LD(R_Z80H, R_Z80D) }
Z80RASM _ld_h_e(void) { MCR_LD(R_Z80H, R_Z80E) }
Z80RASM _ld_h_l(void) { MCR_LD(R_Z80H, R_Z80L) }

Z80RASM	_ld_sp_hl(void) { MCR_LD_W	(R_Z80SP, R_Z80HL) }
Z80RASM _ld_bc_word(void) { LDW_w(R_Z80BC) }
Z80RASM _ld_de_word(void) { LDW_w(R_Z80DE) }
Z80RASM _ld_hl_word(void) { LDW_w(R_Z80HL) }
Z80RASM _ld_sp_word(void) { LDW_w(R_Z80SP) }
Z80RASM _ld_hl_xword(void) { LDW_x(R_Z80HL) }

Z80RASM _inc_a(void) { MCR_INC(R_Z80A) }
Z80RASM _inc_b(void) { MCR_INC(R_Z80B) }
Z80RASM _inc_c(void) { MCR_INC(R_Z80C) }
Z80RASM _inc_d(void) { MCR_INC(R_Z80D) }
Z80RASM _inc_e(void) { MCR_INC(R_Z80E) }
Z80RASM _inc_h(void) { MCR_INC(R_Z80H) }
Z80RASM _inc_l(void) { MCR_INC(R_Z80L) }
Z80RASM _inc_bc(void) { MCR_INC_W(R_Z80BC) }
Z80RASM _inc_de(void) { MCR_INC_W(R_Z80DE) }
Z80RASM _inc_hl(void) {	MCR_INC_W(R_Z80HL) }
Z80RASM _inc_sp(void) {	MCR_INC_W(R_Z80SP) }
Z80RASM _inc_xhl(void) { MCR_INC_MEM(R_Z80HL) }

Z80RASM _dec_a(void) { MCR_DEC(R_Z80A) }
Z80RASM _dec_b(void) { MCR_DEC(R_Z80B) }
Z80RASM _dec_c(void) { MCR_DEC(R_Z80C) }
Z80RASM _dec_d(void) { MCR_DEC(R_Z80D) }
Z80RASM _dec_e(void) { MCR_DEC(R_Z80E) }
Z80RASM _dec_h(void) { MCR_DEC(R_Z80H) }
Z80RASM _dec_l(void) { MCR_DEC(R_Z80L) }
Z80RASM _dec_bc(void) { MCR_DEC_W(R_Z80BC) }
Z80RASM _dec_de(void) { MCR_DEC_W(R_Z80DE) }
Z80RASM _dec_hl(void) {	MCR_DEC_W(R_Z80HL) }
Z80RASM _dec_sp(void) {	MCR_DEC_W(R_Z80SP) }
Z80RASM _dec_xhl(void) { MCR_DEC_MEM(R_Z80HL) }

Z80RASM _add_hl_bc(void) { MCR_ADD_W(R_Z80HL, R_Z80BC) }
Z80RASM _add_hl_de(void) { MCR_ADD_W(R_Z80HL, R_Z80DE) }
Z80RASM _add_hl_hl(void) { MCR_ADDx2(R_Z80HL) }
Z80RASM _add_hl_sp(void) { MCR_ADD_W(R_Z80HL, R_Z80SP) }

Z80RASM _add_a_a(void) { regADD(R_Z80A) }
Z80RASM _add_a_b(void) { regADD(R_Z80B) }
Z80RASM _add_a_c(void) { regADD(R_Z80C) }
Z80RASM _add_a_d(void) { regADD(R_Z80D) }
Z80RASM _add_a_e(void) { regADD(R_Z80E) }
Z80RASM _add_a_h(void) { regADD(R_Z80H) }
Z80RASM _add_a_l(void) { regADD(R_Z80L) }
Z80RASM _add_a_byte(void) { OP_BYTE	MCR_ADD }
Z80RASM _add_a_xhl(void) { OP_XHL	MCR_ADD }

Z80RASM _adc_a_a(void) { regADC(R_Z80A) }
Z80RASM _adc_a_b(void) { regADC(R_Z80B) }
Z80RASM _adc_a_c(void) { regADC(R_Z80C) }
Z80RASM _adc_a_d(void) { regADC(R_Z80D) }
Z80RASM _adc_a_e(void) { regADC(R_Z80E) }
Z80RASM _adc_a_h(void) { regADC(R_Z80H) }
Z80RASM _adc_a_l(void) { regADC(R_Z80L) }
Z80RASM _adc_a_byte(void) { OP_BYTE	MCR_ADC }
Z80RASM _adc_a_xhl(void) { OP_XHL	MCR_ADC }

Z80RASM _sub_a(void) {
	__asm {
				mov		R_Z80AF, Z_FLAG or N_FLAG
				ret
	}
}

Z80RASM _sub_b(void) { regSUB(R_Z80B) }
Z80RASM _sub_c(void) { regSUB(R_Z80C) }
Z80RASM _sub_d(void) { regSUB(R_Z80D) }
Z80RASM _sub_e(void) { regSUB(R_Z80E) }
Z80RASM _sub_h(void) { regSUB(R_Z80H) }
Z80RASM _sub_l(void) { regSUB(R_Z80L) }
Z80RASM _sub_byte(void) { OP_BYTE	MCR_SUB }
Z80RASM _sub_xhl(void) { OP_XHL		MCR_SUB }

Z80RASM _sbc_a_a(void) { regSBC(R_Z80A) }
Z80RASM _sbc_a_b(void) { regSBC(R_Z80B) }
Z80RASM _sbc_a_c(void) { regSBC(R_Z80C) }
Z80RASM _sbc_a_d(void) { regSBC(R_Z80D) }
Z80RASM _sbc_a_e(void) { regSBC(R_Z80E) }
Z80RASM _sbc_a_h(void) { regSBC(R_Z80H) }
Z80RASM _sbc_a_l(void) { regSBC(R_Z80L) }
Z80RASM _sbc_a_byte(void) { OP_BYTE	MCR_SBC }
Z80RASM _sbc_a_xhl(void) { OP_XHL	MCR_SBC }

Z80RASM _and_a(void) {

	__asm {
				movzx	eax, R_Z80A
				mov		al, ZSPtable[eax]
				or		al, H_FLAG
				mov		R_Z80F, al
				ret
	}
}

Z80RASM _and_b(void) { regAND(R_Z80B) }
Z80RASM _and_c(void) { regAND(R_Z80C) }
Z80RASM _and_d(void) { regAND(R_Z80D) }
Z80RASM _and_e(void) { regAND(R_Z80E) }
Z80RASM _and_h(void) { regAND(R_Z80H) }
Z80RASM _and_l(void) { regAND(R_Z80L) }
Z80RASM _and_byte(void) { OP_BYTE	MCR_AND }
Z80RASM _and_xhl(void) { OP_XHL		MCR_AND }

Z80RASM _or_a(void) {

	__asm {
				movzx	eax, R_Z80A
				mov		al, ZSPtable[eax]
				mov		R_Z80F, al
				ret
	}
}

Z80RASM _or_b(void) { regOR(R_Z80B) }
Z80RASM _or_c(void) { regOR(R_Z80C) }
Z80RASM _or_d(void) { regOR(R_Z80D) }
Z80RASM _or_e(void) { regOR(R_Z80E) }
Z80RASM _or_h(void) { regOR(R_Z80H) }
Z80RASM _or_l(void) { regOR(R_Z80L) }
Z80RASM _or_byte(void) { OP_BYTE	MCR_OR }
Z80RASM _or_xhl(void) { OP_XHL		MCR_OR }

Z80RASM _xor_a(void) {

	__asm {
				mov		R_Z80AF, Z_FLAG or V_FLAG
				ret
	}
}

Z80RASM _xor_b(void) { regXOR(R_Z80B) }
Z80RASM _xor_c(void) { regXOR(R_Z80C) }
Z80RASM _xor_d(void) { regXOR(R_Z80D) }
Z80RASM _xor_e(void) { regXOR(R_Z80E) }
Z80RASM _xor_h(void) { regXOR(R_Z80H) }
Z80RASM _xor_l(void) { regXOR(R_Z80L) }
Z80RASM _xor_byte(void) { OP_BYTE	MCR_XOR }
Z80RASM _xor_xhl(void) { OP_XHL		MCR_XOR }

Z80RASM _cp_a(void) {
	__asm {
				mov		R_Z80F, Z_FLAG or N_FLAG
				ret
	}
}

Z80RASM _cp_b(void) { regCP(R_Z80B) }
Z80RASM _cp_c(void) { regCP(R_Z80C) }
Z80RASM _cp_d(void) { regCP(R_Z80D) }
Z80RASM _cp_e(void) { regCP(R_Z80E) }
Z80RASM _cp_h(void) { regCP(R_Z80H) }
Z80RASM _cp_l(void) { regCP(R_Z80L) }
Z80RASM _cp_byte(void) { OP_BYTE	MCR_CP }
Z80RASM _cp_xhl(void) { OP_XHL		MCR_CP }

Z80RASM _ex_xsp_hl(void) { MCR_EX_XSP(R_Z80HL) }
Z80RASM _ex_af_af(void) { MCR_EX(R_Z80AF, R_Z80AF2) }
Z80RASM _ex_de_hl(void) { MCR_EX(R_Z80DE, R_Z80HL) }
Z80RASM _exx(void) {

	MCR_EXX(R_Z80BC, R_Z80BC2)
	MCR_EXX(R_Z80DE, R_Z80DE2)
	MCR_EX (R_Z80HL, R_Z80HL2)
}

Z80RASM _call(void) { MCR_CALL }
Z80RASM _call_c(void)  { MCR_CALLFLG(C_FLAG) }
Z80RASM _call_z(void)  { MCR_CALLFLG(Z_FLAG) }
Z80RASM _call_m(void)  { MCR_CALLFLG(S_FLAG) }
Z80RASM _call_pe(void) { MCR_CALLFLG(V_FLAG) }
Z80RASM _call_nc(void) { MCR_CALLNFLG(C_FLAG) }
Z80RASM _call_nz(void) { MCR_CALLNFLG(Z_FLAG) }
Z80RASM _call_p(void)  { MCR_CALLNFLG(S_FLAG) }
Z80RASM _call_po(void) { MCR_CALLNFLG(V_FLAG) }

Z80RASM _ret(void) { MCR_RET }
Z80RASM _ret_c(void)  { MCR_RETFLG(C_FLAG) }
Z80RASM _ret_z(void)  { MCR_RETFLG(Z_FLAG) }
Z80RASM _ret_m(void)  { MCR_RETFLG(S_FLAG) }
Z80RASM _ret_pe(void) { MCR_RETFLG(V_FLAG) }
Z80RASM _ret_nc(void) { MCR_RETNFLG(C_FLAG) }
Z80RASM _ret_nz(void) { MCR_RETNFLG(Z_FLAG) }
Z80RASM _ret_p(void)  { MCR_RETNFLG(S_FLAG) }
Z80RASM _ret_po(void) { MCR_RETNFLG(V_FLAG) }

Z80RASM _jp(void) { MCR_JP }
Z80RASM _jp_c(void)  { MCR_JPFLG(C_FLAG) }
Z80RASM _jp_z(void)  { MCR_JPFLG(Z_FLAG) }
Z80RASM _jp_m(void)  { MCR_JPFLG(S_FLAG) }
Z80RASM _jp_pe(void) { MCR_JPFLG(V_FLAG) }
Z80RASM _jp_nc(void) { MCR_JPNFLG(C_FLAG) }
Z80RASM _jp_nz(void) { MCR_JPNFLG(Z_FLAG) }
Z80RASM _jp_p(void)  { MCR_JPNFLG(S_FLAG) }
Z80RASM _jp_po(void) { MCR_JPNFLG(V_FLAG) }

Z80RASM _jr(void) { MCR_JR }
Z80RASM _jr_c(void)  { MCR_JRFLG(C_FLAG) }
Z80RASM _jr_z(void)  { MCR_JRFLG(Z_FLAG) }
Z80RASM _jr_nc(void) { MCR_JRNFLG(C_FLAG) }
Z80RASM _jr_nz(void) { MCR_JRNFLG(Z_FLAG) }
Z80RASM	_djnz(void)  { MCR_DJNZ }
Z80RASM _jp_hl(void) { MCR_LD_W(R_Z80PC, R_Z80HL) }

Z80RASM	_push_af(void) { MCR_PUSH(R_Z80AF) }
Z80RASM	_push_bc(void) { MCR_PUSH(R_Z80BC) }
Z80RASM	_push_de(void) { MCR_PUSH(R_Z80DE) }
Z80RASM	_push_hl(void) { MCR_PUSH(R_Z80HL) }

Z80RASM	_pop_af(void) { MCR_POP(R_Z80AF) }
Z80RASM	_pop_bc(void) { MCR_POP(R_Z80BC) }
Z80RASM	_pop_de(void) { MCR_POP(R_Z80DE) }
Z80RASM	_pop_hl(void) { MCR_POP(R_Z80HL) }

Z80RASM _rst_00(void) { MCR_RST(0x00) }
Z80RASM _rst_08(void) { MCR_RST(0x08) }
Z80RASM _rst_10(void) { MCR_RST(0x10) }
Z80RASM _rst_18(void) { MCR_RST(0x18) }
Z80RASM _rst_20(void) { MCR_RST(0x20) }
Z80RASM _rst_28(void) { MCR_RST(0x28) }
Z80RASM _rst_30(void) { MCR_RST(0x30) }
Z80RASM _rst_38(void) { MCR_RST(0x38) }

Z80RASM _out_byte_a(void) {

	GET_PC_BYTE
	__asm {
				mov		dl, al
				mov		cl, al
				mov		ch, R_Z80A
				jmp		Z80_Out
	}
}

Z80RASM _in_a_byte(void) {

	GET_PC_BYTE
	__asm {
				mov		cl, al
				mov		ch, R_Z80A
				call	Z80_In
				mov		R_Z80A, al
				ret
	}
}


Z80RASM _dd(void) {

	__asm {
				inc		R.R
				GET_PC_BYTE
				mov		dl, cycles_xx[eax]
				add		Z80_ICount, dx
				jmp		opcode_dd[eax*4]
	}
}

Z80RASM _ed(void) {

	__asm {
				inc		R.R
				GET_PC_BYTE
				mov		dl, cycles_ed[eax]
				add		Z80_ICount, dx
				jmp		opcode_ed[eax*4]
	}
}

Z80RASM _fd(void) {

	__asm {
				inc		R.R
				GET_PC_BYTE
				mov		dl, cycles_xx[eax]
				add		Z80_ICount, dx
				jmp		opcode_fd[eax*4]
	}
}



Z80ROPCODE opcode_main[256] = {
		_ld_nop,		_ld_bc_word,	_ld_xbc_a,		_inc_bc,		// 00
		_inc_b,			_dec_b,			_ld_b_byte,		_rlca,
		_ex_af_af,		_add_hl_bc,		_ld_a_xbc,		_dec_bc,
		_inc_c,			_dec_c,			_ld_c_byte,		_rrca,

		_djnz,			_ld_de_word,	_ld_xde_a,		_inc_de,		// 10
		_inc_d,			_dec_d,			_ld_d_byte,		_rla,
		_jr,			_add_hl_de,		_ld_a_xde,		_dec_de,
		_inc_e,			_dec_e,			_ld_e_byte,		_rra,

		_jr_nz,			_ld_hl_word,	_ld_xword_hl,	_inc_hl,		// 20
		_inc_h,			_dec_h,			_ld_h_byte,		_daa,
		_jr_z,			_add_hl_hl,		_ld_hl_xword,	_dec_hl,
		_inc_l,			_dec_l,			_ld_l_byte,		_cpl,

		_jr_nc,			_ld_sp_word,	_ld_xbyte_a,	_inc_sp,		// 30
		_inc_xhl,		_dec_xhl,		_ld_xhl_byte,	_scf,
		_jr_c,			_add_hl_sp,		_ld_a_xbyte,	_dec_sp,
		_inc_a,			_dec_a,			_ld_a_byte,		_ccf,

		_ld_nop,		_ld_b_c,		_ld_b_d,		_ld_b_e,		// 40
		_ld_b_h,		_ld_b_l,		_ld_b_xhl,		_ld_b_a,
		_ld_c_b,		_ld_nop,		_ld_c_d,		_ld_c_e,
		_ld_c_h,		_ld_c_l,		_ld_c_xhl,		_ld_c_a,

		_ld_d_b,		_ld_d_c,		_ld_nop,		_ld_d_e,		// 50
		_ld_d_h,		_ld_d_l,		_ld_d_xhl,		_ld_d_a,
		_ld_e_b,		_ld_e_c,		_ld_e_d,		_ld_nop,
		_ld_e_h,		_ld_e_l,		_ld_e_xhl,		_ld_e_a,

		_ld_h_b,		_ld_h_c,		_ld_h_d,		_ld_h_e,		// 60
		_ld_nop,		_ld_h_l,		_ld_h_xhl,		_ld_h_a,
		_ld_l_b,		_ld_l_c,		_ld_l_d,		_ld_l_e,
		_ld_l_h,		_ld_nop,		_ld_l_xhl,		_ld_l_a,

		_ld_xhl_b,		_ld_xhl_c,		_ld_xhl_d,		_ld_xhl_e,		// 70
		_ld_xhl_h,		_ld_xhl_l,		_halt,			_ld_xhl_a,
		_ld_a_b,		_ld_a_c,		_ld_a_d,		_ld_a_e,
		_ld_a_h,		_ld_a_l,		_ld_a_xhl,		_ld_nop,

		_add_a_b,		_add_a_c,		_add_a_d,		_add_a_e,		// 80
		_add_a_h,		_add_a_l,		_add_a_xhl,		_add_a_a,
		_adc_a_b,		_adc_a_c,		_adc_a_d,		_adc_a_e,
		_adc_a_h,		_adc_a_l,		_adc_a_xhl,		_adc_a_a,

		_sub_b,			_sub_c,			_sub_d,			_sub_e,			// 90
		_sub_h,			_sub_l,			_sub_xhl,		_sub_a,
		_sbc_a_b,		_sbc_a_c,		_sbc_a_d,		_sbc_a_e,
		_sbc_a_h,		_sbc_a_l,		_sbc_a_xhl,		_sbc_a_a,

		_and_b,			_and_c,			_and_d,			_and_e,			// a0
		_and_h,			_and_l,			_and_xhl,		_and_a,
		_xor_b,			_xor_c,			_xor_d,			_xor_e,
		_xor_h,			_xor_l,			_xor_xhl,		_xor_a,

		_or_b,			_or_c,			_or_d,			_or_e,			// b0
		_or_h,			_or_l,			_or_xhl,		_or_a,
		_cp_b,			_cp_c,			_cp_d,			_cp_e,
		_cp_h,			_cp_l,			_cp_xhl,		_cp_a,

		_ret_nz,		_pop_bc,		_jp_nz,			_jp,			// c0
		_call_nz,		_push_bc,		_add_a_byte,	_rst_00,
		_ret_z,			_ret,			_jp_z,			_code_cb,
		_call_z,		_call,			_adc_a_byte,	_rst_08,

		_ret_nc,		_pop_de,		_jp_nc,			_out_byte_a,	// d0
		_call_nc,		_push_de,		_sub_byte,		_rst_10,
		_ret_c,			_exx,			_jp_c,			_in_a_byte,
		_call_c,		_dd,			_sbc_a_byte,	_rst_18,

		_ret_po,		_pop_hl,		_jp_po,			_ex_xsp_hl,		// e0
		_call_po,		_push_hl,		_and_byte,		_rst_20,
		_ret_pe,		_jp_hl,			_jp_pe,			_ex_de_hl,
		_call_pe,		_ed,			_xor_byte,		_rst_28,

		_ret_p,			_pop_af,		_jp_p,			_di,			// f0
		_call_p,		_push_af,		_or_byte,		_rst_30,
		_ret_m,			_ld_sp_hl,		_jp_m,			_ei,
		_call_m,		_fd,			_cp_byte,		_rst_38};

