/*
 * Scramble Driver
 *
 *
 *    notes:
 *      all gfx are loaded into RAM at 0x5000
 *      currently only works with scobra video hardware
 */

#include "laser.h"
#include "romlist.h"

extern volatile byte IType;
extern volatile byte IFlag;
byte bGame;
reg scrambleRegs;

//byte *orgchar1;

BITMAP *piccie;       // Temporary screen in memory
BITMAP *chars[256];         // All the characters
BITMAP *sprites[65];        // All the sprites

void warpchars();

byte rdmem_scramble(word A) {
        byte ReturnValue=0x00;
        switch (A) {
                case 0x8100:
                        if (get_keyboard(SYS_KEY_ESC)) {
                                exit_laser(0);
                        }
                        if(get_keyboard(SYS_KEY_LEFT)) ReturnValue|=0x10;
                        if(get_keyboard(SYS_KEY_RIGHT)) ReturnValue|=0x20;
                        if(get_keyboard(SYS_KEY_SPACE)) ReturnValue=0x08;    /* button 1 */
                        //if(get_keyboard(SYS_KEY_CONTROL)) ReturnValue|=0x04;  /* button 2 */
                        if(get_keyboard(SYS_KEY_3)) ReturnValue|=0x40;
                        break;
                case 0x8101:
                        if(get_keyboard(KEY_1)) {
                                ReturnValue|=0x01;
                        } else {
                                ReturnValue|=0xFF;
                        }
                        break;
                case 0x8102:
                        ReturnValue|=(1<<0);
                        //ReturnValue|=0x00;
                        break;
                default:
                        ReturnValue=RAM[A];
        }

        return ReturnValue;
}

void wrmem_scramble(word A, byte V) {

        if(A<0x4000) {
                return; /* End of ROM address */
        } else {
                RAM[A] = V;
        }
}

byte doin_scramble(byte Port) {
        return 0x00;
}

void doout_scramble(byte Port, byte Value) {
}

void NMI_scramble() {
        IFlag = 1;
        IType = (IType == 1 ? 2 : 1);
}

word interrupt_scramble() {
int count1,count2,count3;
        int offset,x,y;
        int y1,x1;

        sys_interrupt();

        for (y=0;y<32;y++) {
                for (x=0;x<5;x++) {
                        offset = RAM[0x4800 + (31-y)*32 + x];
                        blit(chars[offset], piccie, 0, 0, y*8, x*8, 8, 8);
                }
        }

        for (y=0;y<32;y++) {
                for (x=5;x<7;x++)  {
                        offset = RAM[0x4800 + (31-y)*32 + x];
                        blit(chars[offset], piccie, 0, 0, ((y*8+(char)RAM[0x500c])%256), x*8, 8, 8);
                }
        }

        for (y=0;y<32;y++) {
                for (x=7;x<0x18;x++) {
                        offset = RAM[0x4800 + (31-y)*32 + x];
                        blit(chars[offset], piccie, 0, 0, y*8, x*8, 8, 8);
                }
        }

        for(y=0;y<32;y++) {
                for(x=0x18;x<0x1c;x++) {
                        offset = RAM[0x4800 + (31-y)*32 + x];
                        blit(chars[offset], piccie, 0, 0, (unsigned char)((y*8)+(char)RAM[0x5030]%256), x*8, 8, 8);
                }
        }

        for(y=0;y<32;y++) {
                //for(x=0x1c;x<32;x++) {
                for(x=0x18;x<32;x++) {//4800
                        offset = RAM[0x4800 + (31-y)*32 + x];
         //blit(chars[offset], piccie, 0, 0, y*8, X*8, 8, 8);
                        blit(chars[offset], piccie, 0, 0, (unsigned char)((y*8)+(char)RAM[0x5030]%256), x*8, 8, 8);
                }
        }
piccie->line[251-RAM[0x507f]][RAM[0x507d]]=2;
        //putpixel(screen,251-RAM[0x507f],RAM[0x507d],2);

        for(offset=0;offset<20;offset+=4) {
                piccie->line[251-RAM[0x5063+offset]][RAM[0x5061+offset]]=1;
                //putpixel(screen,251-RAM[0x5063+offset],RAM[0x5061+offset],1);
        }

        for(count1=0x5040;count1<0x5060;count1+=4) {
                count2=RAM[count1+1];
                count3=count2 >> 6;

                count2&=0x3f;

                x=RAM[count1];
                y=RAM[count1+3];

                if(x && y && count2) {
                        switch(count3) {
                                case (0):  draw_sprite(piccie,sprites[count2], RAM[count1],RAM[count1+3]);break;
                                case (1):  draw_sprite_v_flip(piccie,sprites[count2],RAM[count1], RAM[count1+3]);break;
                                case (2):  draw_sprite_h_flip(piccie,sprites[count2],RAM[count1], RAM[count1+3]);break;
                                default:  draw_sprite_vh_flip(piccie,sprites[count2],RAM[count1], RAM[count1+3]);break;
                        }
                }
        }
        blit(piccie,screen,16,0,0,0,224,256);


        return(0x0066);
}

void patch_scramble(reg *R) {
        return;
}

int init_scramble(tagRomList gameRom[]) {
        int i,ii;

        /* Allocate RAM */
        if(!(RAM = malloc (sizeof (char) * 0x10000))) {
                exit_msg();
                printf("ERROR: Too low on memory to continue.\r\n");
                return(1);
        }

        if(loadRoms(gameRom)!=0) {
                free(RAM);
                return(1);
        }

        piccie = create_bitmap(256,256);             // Allocate memory for temp screen (in memory)

        for(i=0;i<256;i++)
                chars[i]=create_bitmap(8,8);      // Allocate memory for charset

        for(i=0;i<65;i++)
                sprites[i]=create_bitmap(16,16);  // Allocate memory for sprites

        for (i=0;i<256;i++)
                for (ii=0;ii<256;ii++)
                        piccie->line[i][ii] = 0;        // Clear the temp screen

        warpchars();

        for (i=0;i<256;i++) {
                pal(i,0,0,0); /* Set all colours to black */
        }

        pal(1, 255,  0,  0);   /* Red */
        pal(2,  0, 255,  0);   /* Green */
        pal(3, 255, 255, 255); /* White */

        /* Reset all Z80 Registers */
        ResetZ80(&scrambleRegs);

        return(0);
}

void start_scramble() {
        /* Start Z80 Emulatation */
        Z80(scrambleRegs);
}

void shutdown_scramble() {
        free(RAM);
}

void warpchars () {

  byte byte1,byte2,tempbyte;
  word offset;
  word y;
  int teller,no;
  int count,count1;
  word line,colum;

  no=0;
  for (teller=0;teller<256;teller++) {

    offset = teller * 8;
    no=teller;
    for (y=0;y<8;y++) {

      byte1=RAM[0x5000 + offset+ y];
      byte2=RAM[0x5000 + offset + y + 0x800];

      tempbyte = byte1 & 0x80;
      tempbyte = tempbyte >> 6;
      tempbyte = tempbyte + ((byte2 & 0x80) >> 7);
      chars[no]->line[0][7-y]=tempbyte;

      tempbyte = byte1 & 0x40;
      tempbyte = tempbyte >> 5;
      tempbyte = tempbyte + ((byte2 & 0x40) >> 6);
      chars[no]->line[1][7-y]=tempbyte;

      tempbyte = byte1 & 0x20;
      tempbyte = tempbyte >> 4;
      tempbyte = tempbyte + ((byte2 & 0x20) >> 5);
      chars[no]->line[2][7-y]=tempbyte;

      tempbyte = byte1 & 0x10;
      tempbyte = tempbyte >> 3;
      tempbyte = tempbyte + ((byte2 & 0x10) >> 4);
      chars[no]->line[3][7-y]=tempbyte;


      tempbyte = byte1 & 0x08;
      tempbyte = tempbyte >> 2;
      tempbyte = tempbyte + ((byte2 & 0x8) >> 3);
      chars[no]->line[4][7-y]=tempbyte;

      tempbyte = byte1 & 0x04;
      tempbyte = tempbyte >> 1;
      tempbyte = tempbyte + ((byte2 & 0x4) >> 2);
      chars[no]->line[5][7-y]=tempbyte;

      tempbyte = byte1 & 0x02;
      tempbyte = tempbyte + ((byte2 & 0x2) >> 1);
      chars[no]->line[6][7-y]=tempbyte;

      tempbyte = byte1 & 0x01;
      tempbyte = tempbyte << 1;
      tempbyte = tempbyte + (byte2 & 0x1);
      chars[no]->line[7][7-y]=tempbyte;
   
    }
  }
  printf("Got the characters\n");

  // Built sprites from the characters
  // The End uses only 128 characters and 32 sprites.
  for(count1=0;count1<64;count1++){
	blit(chars[count1*4], sprites[count1],0,0,8,0,8,8);
	blit(chars[count1*4+1], sprites[count1],0,0,8,8,8,8);
	blit(chars[count1*4+2], sprites[count1],0,0,0,0,8,8);
	blit(chars[count1*4+3], sprites[count1],0,0,0,8,8,8);
}

//  Routine to show all the 16x16 sprites.
//
        for (count=0;count<65;count++) {
                colum = (count*16) % 256;
                line  = (count / 16)*16;
                draw_sprite(piccie,sprites[count], colum, line);
        }

        blit(piccie,screen,0,0,0,0,256,256);

        clear(piccie);
        blit(piccie,screen,0,0,0,0,256,256);
}

