
#ifndef __KEYBOARD_H__
#define __KEYBOARD_H__



class keyboard {
public:
  typedef bool (*pool_keyboard)(int);

private:
  unsigned char _mask;
  pool_keyboard _pool;
  int _map[7][8];

public:
  keyboard(pool_keyboard);
  
  void set_mask(unsigned char mask) { _mask = mask; }
  unsigned char read();
  
  /*
      mask bit = 0 1 2 3 4 5 6 
   0  Down  Enter (-)  .    0      On    Graph
   1  Left  +     3    2    1      ->    Trace
   2  Right -     6    5    4      Ln    Zoom
   3  Up    *     9    8    7      Log   Window
   4  '\0'  /     )    (    ,      X^2   Y=
   5  '\0'  ^     Tan  Cos  Sin    X^-1  2nd
   6  '\0'  Clear Vars Prgm Matrix Math  Mode
   7  '\0'  '\0' '\0'  Stat XT     Alpha Del
  */
  // Mask 0
  void set_button_down(int c) { _map[0][0] = c; }
  void set_button_left(int c) { _map[0][1] = c; }
  void set_button_right(int c) { _map[0][2] = c; }
  void set_button_up(int c) { _map[0][3] = c; }
  // Mask 1
  void set_button_enter(int c) { _map[1][0] = c; }
  void set_button_add(int c) { _map[1][1] = c; }
  void set_button_minus(int c) { _map[1][2] = c; }
  void set_button_mul(int c) { _map[1][3] = c; }
  void set_button_divide(int c) { _map[1][4] = c; }
  void set_button_power(int c) { _map[1][5] = c; }
  void set_button_clear(int c) { _map[1][6] = c; }
  // Mask 2
  void set_button_neg(int c) { _map[2][0] = c; }
  void set_button_3(int c) { _map[2][1] = c; }
  void set_button_6(int c) { _map[2][2] = c; }
  void set_button_9(int c) { _map[2][3] = c; }
  void set_button_closebrace(int c) { _map[2][4] = c; }
  void set_button_tan(int c) { _map[2][5] = c; }
  void set_button_vars(int c) { _map[2][6] = c; }
  // Mask 3
  void set_button_dot(int c) { _map[3][0] = c; }
  void set_button_2(int c) { _map[3][1] = c; }
  void set_button_5(int c) { _map[3][2] = c; }
  void set_button_8(int c) { _map[3][3] = c; }
  void set_button_openbrace(int c) { _map[3][4] = c; }
  void set_button_cos(int c) { _map[3][5] = c; }
  void set_button_pgrm(int c) { _map[3][6] = c; }
  void set_button_stat(int c) { _map[3][7] = c; }
  // Mask 4
  void set_button_0(int c) { _map[4][0] = c; }
  void set_button_1(int c) { _map[4][1] = c; }
  void set_button_4(int c) { _map[4][2] = c; }
  void set_button_7(int c) { _map[4][3] = c; }
  void set_button_comma(int c) { _map[4][4] = c; }
  void set_button_sin(int c) { _map[4][5] = c; }
  void set_button_matrix(int c) { _map[4][6] = c; }
  void set_button_xttheta(int c) { _map[4][7] = c; }
  // Mask 5
  void set_button_on(int c) { _map[5][0] = c; }
  void set_button_store(int c) { _map[5][1] = c; }
  void set_button_ln(int c) { _map[5][2] = c; }
  void set_button_log(int c) { _map[5][3] = c; }
  void set_button_xsquare(int c) { _map[5][4] = c; }
  void set_button_xinv(int c) { _map[5][5] = c; }
  void set_button_math(int c) { _map[5][6] = c; }
  void set_button_alpha(int c) { _map[5][7] = c; }
  // Mask 6
  void set_button_graph(int c) { _map[6][0] = c; }
  void set_button_trace(int c) { _map[6][1] = c; }
  void set_button_zoom(int c) { _map[6][2] = c; }
  void set_button_window(int c) { _map[6][3] = c; }
  void set_button_equation(int c) { _map[6][4] = c; }
  void set_button_2nd(int c) { _map[6][5] = c; }
  void set_button_mode(int c) { _map[6][6] = c; }
  void set_button_del(int c) { _map[6][7] = c; }

};



#endif
