
#include "keyboard.h"


keyboard::keyboard(pool_keyboard pool):_mask(0),_pool(pool) {
  for(int i = 0; i < 7; ++i)
    for(int j = 0; j < 8; ++j) 
      _map[i][j] = -1;
}



unsigned char keyboard::read() {
  unsigned char keys = 0;
  unsigned char mask = ~_mask;
  for(int i = 0; i < 7; ++i, mask >>= 1) {
    if(mask & 1) {
      for(int j = 0; j < 8; ++j) {
      	if(_map[i][j] != -1 && _pool && _pool(_map[i][j]))
      	  keys |= (1 << j);  
      }
    }
  }
  return ~keys;
}
