
#include <cstring>
#include <fstream>
#include "raze.h"
#include "memory.h"



const unsigned char memory::MAX_ROM_BANKS = 8;
const unsigned int memory::BANK_SIZE = 0x4000;



memory::memory() {
  _rom_bank = 0;
  _rom = new unsigned char[MAX_ROM_BANKS * BANK_SIZE];
  _ram = new unsigned char[2 * BANK_SIZE];
}



memory::~memory() {
  delete[] _rom;
  delete[] _ram;
}



void memory::reset(const char* romfile) {

  std::ifstream ifs;
  ifs.open(romfile, std::ios::binary);
  if(ifs.is_open()) {
    ifs.read(reinterpret_cast<char*>(_rom), MAX_ROM_BANKS * BANK_SIZE);
    ifs.close();
  }

  z80_init_memmap();

  z80_map_fetch(0x0000, 0x3FFF, &_rom[0]);
  z80_map_fetch(0x4000, 0x7FFF, &_rom[_rom_bank * BANK_SIZE]);
  z80_map_fetch(0x8000, 0xFFFF, &_ram[0]);

  z80_add_read(0x0000, 0x3FFF, Z80_MAP_DIRECT, &_rom[0]);
  z80_map_read(0x4000, 0x7FFF, &_rom[_rom_bank * BANK_SIZE]);
  z80_add_read(0x8000, 0xFFFF, Z80_MAP_DIRECT, &_ram[0]);
      
  z80_add_write(0x8000, 0xFFFF, Z80_MAP_DIRECT, &_ram[0]);

  z80_end_memmap();
}



void memory::switch_rom_bank(unsigned char bank) {
  if(bank < MAX_ROM_BANKS) {
    _rom_bank = bank;
    z80_map_fetch(0x4000, 0x7FFF, &_rom[_rom_bank * BANK_SIZE]);
    z80_map_read(0x4000, 0x7FFF, &_rom[_rom_bank * BANK_SIZE]);
  }
}
