
#ifndef __TI82_H__
#define __TI82_H__



class t6a04;
class memory;
class keyboard;

class ti82 {
public:
  static const int PORT_LINK;
  static const int PORT_KEYBOARD;
  static const int PORT_ROMPAGE;
  static const int PORT_STATUS;
  static const int PORT_INTERRUPT;
  static const int PORT_DISPLAYCONTROL;
  static const int PORT_DISPLAYDATA;
	
private:
  t6a04* _lcd;
  memory* _mem;
  keyboard* _keyb;

  static ti82* _instance;
  static void raze_port_write(unsigned short port, unsigned char value);
  static unsigned char raze_port_read(unsigned short port);

  void port_write(unsigned short port, unsigned char value);
  unsigned char port_read(unsigned short port);	

public:
  
  void reset(t6a04* lcd, memory* mem, keyboard* keyb);
  void run();
  
  static ti82* get_instance();
  static void delete_instance();
	
};



#endif
