
#include "t6a04.h"
#include "memory.h"
#include "keyboard.h"
#include "raze.h"
#include "ti82.h"


const int ti82::PORT_LINK = 0x00;
const int ti82::PORT_KEYBOARD = 0x01;
const int ti82::PORT_ROMPAGE  = 0x02;
const int ti82::PORT_STATUS = 0x03;
const int ti82::PORT_INTERRUPT = 0x04;
const int ti82::PORT_DISPLAYCONTROL = 0x10;
const int ti82::PORT_DISPLAYDATA = 0x11;
ti82* ti82::_instance = 0;



ti82* ti82::get_instance() {
  if(!_instance)
    _instance = new ti82;
  return _instance;
}



void ti82::delete_instance() {
  if(_instance) {
    delete _instance;
    _instance = 0;	
  }	
}



unsigned char ti82::port_read(unsigned short port) {
  unsigned char ret = 0xFF;
  switch(port & 0xFF) {
  case PORT_LINK:  
    break;
  case PORT_KEYBOARD:
    ret = _keyb->read();
    break;
  case PORT_ROMPAGE:
    ret = _mem->get_current_rom_bank();
    break;
  case PORT_STATUS:
    ret = 8 | 2;
    break;
  case PORT_INTERRUPT:
    break;
  case PORT_DISPLAYCONTROL:
    ret = _lcd->read_control();
    break;
  case PORT_DISPLAYDATA:
    ret = _lcd->read_display();
    break;
  default:
    break;
  }
  return ret;
}



void ti82::port_write(unsigned short port, unsigned char value) {
  switch(port & 0xFF) {
  case PORT_LINK:
    break;
  case PORT_KEYBOARD:
    _keyb->set_mask(value);
    break;
  case PORT_ROMPAGE:
    _mem->switch_rom_bank(value & 0x7);
    break;
  case PORT_STATUS:
    break;
  case PORT_INTERRUPT:
    break;
  case PORT_DISPLAYCONTROL:
    _lcd->write_control(value);
    break;
  case PORT_DISPLAYDATA:
    _lcd->write_display(value);
    break;
  default:
    break;
  }
}



void ti82::raze_port_write(unsigned short port, unsigned char value) {
  get_instance()->port_write(port, value);
}



unsigned char ti82::raze_port_read(unsigned short port) {
  return get_instance()->port_read(port);
}



void ti82::reset(t6a04* lcd, memory* mem, keyboard* keyb) {
  _lcd = lcd;
  _mem = mem;
  _keyb = keyb;
  z80_set_in(&raze_port_read);
  z80_set_out(&raze_port_write);
  z80_reset();
  z80_set_reg(Z80_REG_IM, 1);
  z80_set_reg(Z80_REG_PC, 0x646);
}



void ti82::run() {
  z80_emulate(200000);
  z80_raise_IRQ(0xFF);
  z80_lower_IRQ(); 
}
