
#include "keyboard.h"
#include "memory.h"
#include "t6a04.h"
#include "ti82.h"
#include "allegro.h"


static keyboard* keyb;
static memory* mem;
static t6a04* lcd;



static bool is_key_pressed(int client) {
  return !!key[client];
}


static void virtual_machine_init() {
  mem = new memory;
  lcd = new t6a04;
  keyb = new keyboard(is_key_pressed);
  
  keyb->set_button_equation(KEY_F1);
  keyb->set_button_window(KEY_F2);
  keyb->set_button_zoom(KEY_F3);
  keyb->set_button_trace(KEY_F4);
  keyb->set_button_graph(KEY_F5);

  keyb->set_button_down(KEY_DOWN);
  keyb->set_button_left(KEY_LEFT);
  keyb->set_button_right(KEY_RIGHT);
  keyb->set_button_up(KEY_UP);
  
  keyb->set_button_0(KEY_0_PAD);
  keyb->set_button_1(KEY_1_PAD);
  keyb->set_button_2(KEY_2_PAD);
  keyb->set_button_3(KEY_3_PAD);
  keyb->set_button_4(KEY_4_PAD);
  keyb->set_button_5(KEY_5_PAD);
  keyb->set_button_6(KEY_6_PAD);
  keyb->set_button_7(KEY_7_PAD);
  keyb->set_button_8(KEY_8_PAD);
  keyb->set_button_9(KEY_9_PAD);
  keyb->set_button_enter(KEY_ENTER_PAD);
  keyb->set_button_add(KEY_PLUS_PAD);
  keyb->set_button_minus(KEY_MINUS_PAD);
  keyb->set_button_mul(KEY_ASTERISK);
  keyb->set_button_divide(KEY_SLASH_PAD);
  keyb->set_button_dot(KEY_DEL_PAD);
  keyb->set_button_neg(KEY_HOME);
  
  keyb->set_button_pgrm(KEY_F6);
  keyb->set_button_stat(KEY_F7);
  keyb->set_button_math(KEY_F8);
  keyb->set_button_matrix(KEY_F9);
  keyb->set_button_vars(KEY_F10);
  keyb->set_button_mode(KEY_F11);
  
  keyb->set_button_clear(KEY_SPACE);
  keyb->set_button_store(KEY_TAB);
  keyb->set_button_alpha(KEY_LCONTROL);
  keyb->set_button_2nd(KEY_LSHIFT);
  keyb->set_button_del(KEY_DEL);

  keyb->set_button_tan(KEY_T);
  keyb->set_button_cos(KEY_C);
  keyb->set_button_sin(KEY_S);
  keyb->set_button_xttheta(KEY_X);

  keyb->set_button_openbrace(KEY_PGUP);
  keyb->set_button_closebrace(KEY_PGDN);
  keyb->set_button_power(KEY_P);
  keyb->set_button_comma(KEY_V);
  keyb->set_button_ln(KEY_N);
  keyb->set_button_log(KEY_L);
  keyb->set_button_xsquare(KEY_B);
  keyb->set_button_xinv(KEY_I);

  lcd->reset();
  mem->reset();
  
  ti82::get_instance()->reset(lcd, mem, keyb);
}


static void virtual_machine_shutdown() {
  delete mem;
  delete lcd;
  delete keyb;
  ti82::delete_instance();
}


int main() {
  virtual_machine_init();
  allegro_init();
  install_keyboard();
  set_gfx_mode(GFX_AUTODETECT_WINDOWED, 320, 200, 0, 0);
  set_window_title("TI82 Emulator");
  BITMAP* display = create_bitmap(t6a04::SCREEN_WIDTH, t6a04::SCREEN_HEIGHT);
  clear_bitmap(display);
  int w = display->w * 3;
  int h = display->h * 3;
  int x = (320 - w) / 2;
  int y = (200 - h) / 2; 
  while(!key[KEY_ESC]) {
    ti82::get_instance()->run();
    const unsigned char* lcd_ptr = lcd->get_screen_ptr();
    for(int j = 0; j < t6a04::SCREEN_HEIGHT; ++j) {
      for(int i = 0; i < t6a04::SCREEN_WIDTH; i += 8) {
      	int ii = i;
        for(unsigned char k = 0x80; k > 0; k >>= 1) {
          int col = (*lcd_ptr & k) ? 0x00 : 0xFF;
          putpixel(display, ii, j, makecol(col, col, col));
          ++ii;
        }
        ++lcd_ptr;
      }
    }
    stretch_blit(display, screen, 0, 0, display->w, display->h, x, y, w, h);
  }
  release_bitmap(display);
  remove_keyboard();
  set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
  allegro_exit();
  virtual_machine_shutdown();
  return 0;
}
END_OF_MAIN();
