
#ifndef __T6A04_H__
#define __T6A04_H__



class t6a04 {
public:

  static const int SCREEN_WIDTH;
  static const int SCREEN_HEIGHT;

private:

  typedef enum {
    CURSOR_INC_UP,
    CURSOR_INC_DOWN,
    CURSOR_INC_LEFT,
    CURSOR_INC_RIGHT
  } cursor_increment;
  
  bool _cursor_mode_changed;
  cursor_increment _cursor;
  unsigned char _x, _y;
  bool _column_width8;
  bool _display_on;
  unsigned char _screen[768];

  void update_coordinates();

public:

  t6a04() { reset(); }
  
  void reset();
  
  unsigned char read_control();
  void write_control(unsigned char cmd);
  
  unsigned char read_display();
  void write_display(unsigned char data);
  
  const unsigned char* get_screen_ptr() { return _screen; }  

};



#endif
