;
; GIF Lib v2.0
; macros to create, manage and send a gif packet
;
; (c) wiRe / Napalm 2002
;


; gif tag flags
GIF_AD                          EQU         0x0E
GIF_NOP                         EQU         0x0F



; call this (optional) to declare an empty gif packet
GIF_DECLARE_PACKET              MACRO       _name, _items
  _name                         TABLE       ALIGN 16
    size                        DD          items
                                DD          0
    items                       DD          (_items)*2+2 DUP(0)
  _name                         ENDT
GIF_DECLARE_PACKET              ENDM

; this one is needed if we want to reset a packet back to start
; or to initialize a packet, not created by gif_declare_packet
; waste: at
GIF_BEGIN_PACKET                MACRO       _name
                                la          at, (_name)+16
                                sd          at, -16(at)
GIF_BEGIN_PACKET                ENDM

; add gif tag to packet
; waste: at,v0,v1
GIF_ADD_TAG                     MACRO       _name, _nloop, _eop, _pre, _prim, _flg
                                la          at, _name
                                ld          v1, 0(at)
                                lid         v0, (1<<60)|((_flg)<<56)|((_prim)<<47)|((_pre)<<46)|((_eop)<<15)|(_nloop)
                                sd          v0, 0(v1)
                                li          v0, GIF_AD
                                sd          v0, 8(v1)
                                addiu       v1, 16
                                sd          v1, 0(at)
GIF_ADD_TAG                     ENDM

; add gif register and data value to packet after creating a tag
; the new data value (dword) must be located in the ps2-register specified by _datreg
; waste: at,v0,v1
GIF_ADD_DATA                    MACRO       _name, _reg, _datreg
                                la          at, _name
                                ld          v1, 0(at)
                                sd          _datreg, 0(v1)
                                li          v0, _reg
                                sd          v0, 8(v1)
                                addiu       v1, 16
                                sd          v1, 0(at)
GIF_ADD_DATA                    ENDM

; same as gif_dd_data except that the third parameter specifies an immediate value,
; not a register
; waste: at,v0,v1
GIF_ADD_DATA_IMM                MACRO       _name, _reg, _dat
                                la          at, _name
                                ld          v1, 0(at)
                                lid         v0, _dat
                                sd          v0, 0(v1)
                                li          v0, _reg
                                sd          v0, 8(v1)
                                addiu       v1, 16
                                sd          v1, 0(at)
GIF_ADD_DATA_IMM                ENDM

; finally we could send our packet to ps2 by calling this macro
; waste: at,a0,v0,v1
GIF_SEND_PACKET                 MACRO       _name
                                SysFlushCache
                                la          a0, (_name)+16
                                ld          v0, -16(a0)
                                sub         v0, a0
                                srl         v0, 4
                                blez        v0, $+12
                                nop
                                jal         Dma02SendGif
                                nop
GIF_SEND_PACKET                 ENDM



; if u want create a constant gif packet in memory use this macro for the tag
GIF_TAG                         MACRO       _nloop, _eop, _pre, _prim, _flg, _nreg, _regs
                                DD          (_nreg<<60)|((_flg)<<56)|((_prim)<<47)|((_pre)<<46)|(0x50<<24)|((_eop)<<15)|(_nloop), _regs
GIF_TAG                         ENDM

; if u want create a constant gif packet in memory use this macro for the register=data instructions
GIF_DATA                        MACRO       _reg, _dat
                                DD          _dat, _reg
GIF_DATA                        ENDM
