;
; PS2 equates
; set of general macro definitions for ps2 assembler
;
; (c) wiRe / Napalm 2002
;


; Load Address macro
la MACRO _reg,_addr
  IF (_addr)>>16 == 0
  ori _reg,zero,_addr
  ELSE
  lui _reg,(_addr)>>16
  ori _reg,(_addr)&0xFFFF
  ENDIF
la ENDM

; Load Immidiate macro
li MACRO _reg,_imm
  IF (_imm)>>16 == 0
  ori _reg,zero,_imm
  ELSE
  lui _reg,(_imm)>>16
  ori _reg,(_imm)&0xFFFF
  ENDIF
li ENDM

; Load Immidiate Double (64bit) macro
lid MACRO _reg,_imm
  lui _reg,(_imm)>>48
  ori _reg,((_imm)>>32)&0xFFFF
  dsll _reg,16
  ori _reg,((_imm)>>16)&0xFFFF
  dsll _reg,16
  ori _reg,(_imm)&0xFFFF
lid ENDM

; push onto stack
push MACRO reg
  subiu sp,8
  sd reg,0(sp)
push ENDM

pushw MACRO reg
  subiu sp,4
  sw reg,0(sp)
pushw ENDM

; pop/pull from stack
pop MACRO reg
  ld reg,0(sp)
  addiu sp,8
pop ENDM

popw MACRO reg
  lw reg,0(sp)
  addiu sp,4
popw ENDM
