#ifndef __NES_H__
#define __NES_H__
/************************************************************************************************/
#pragma warning(disable:4100)
/************************************************************************************************/
#include "types.h"
/************************************************************************************************/
#define VERSION_NES			"0.04"
#define LINE0LINES			0.5
#define SCREENLINES			240
#define VBLANKLINES			23
#define FPS						60
#define SCANLINES				(LINE0LINES + SCREENLINES + VBLANKLINES)
#define NTSC_COLORBURST		3579545.4545454545
#define PAL_COLORBURST		4433618.75
#ifdef NES_PALMODE
	#define CPU_HZ				((PAL_COLORBURST * 6) / 16)
#else
	#define CPU_HZ				((NTSC_COLORBURST * 6) / 12)
#endif
#define FRAMECYCLES			(CPU_HZ / FPS)
#define LINECYCLES			(FRAMECYCLES / SCANLINES)
#define LINE0CYCLES			(LINECYCLES * LINE0LINES)
#define SCREENCYCLES			(LINECYCLES * SCREENLINES)
#define VBLANKCYCLES			(LINECYCLES * VBLANKLINES)
#define STARTSCANLINE		-1
#define VBLANKSCANLINE		240
#define ENDSCANLINE			262
#define NUMSCANLINES			(ENDSCANLINE - STARTSCANLINE)
#define NUMCPUBANKS			16
#define CPUADDRSHIFT			12
#define CPUADDRMASK			0x0fff
#define PPUADDRSHIFT			10
#define PPUADDRMASK			0x03ff
#define BANK_OP				1
#define BANK_READ				2
#define BANK_WRITE			4
#define MIRROR_H				0
#define MIRROR_V				1
#define MIRROR_1L				2
#define MIRROR_1H				4
#define MIRROR_4				8
#define FILEMODE_NONE		0
#define FILEMODE_NES			1
#define FILEMODE_UNIF		2
#define FILEMODE_FDS			3
#define FILEMODE_FILES		4
#define FILE_READ				0
#define FILE_WRITE			1
#define FILE_APPEND			2
#define PPU_CONTROL1			0
#define PPU_CONTROL2			1
#define PPU_STATUS			2
#define PPU_LOOPYVALUE		3
#define PPU_LOOPYTEMP		4
#define PPU_LOOPYX			5
#define PPU_ADDR				6
#define PPU_INC				7
#define BADOPCODE				0x08000000
#define OUTOFSYNC				0x04000000
/************************************************************************************************/
typedef struct nesfile_s
	{
	u32 prgsize;
	u32 chrsize;
	u8 mirroring;
	u8 sramenabled;
	u32 mapper;
	u8 *trainer;
	u8 *prg;
	u8 *chr;
	} nesfile_t;
typedef struct ggcode_s
	{
	u8 used;
	u16 addr;
	u8 value;
	u8 check;
	u8 checkvalue;
	} ggcode_t;
/*********************************************************************************************/
#include "nescpu.h"
#include "nesppu.h"
#include "nesapu.h"
/************************************************************************************************/
class file_c
	{
	private:
	public:
		char filename[512];
		virtual int open(char *fn,int mode = FILE_READ){return(1);}
		virtual void close(){}
		virtual u32 read(void *buffer,u32 size){return(0);}
		virtual u32 write(void *buffer,u32 size){return(0);}
		virtual u32 len(){return(0);}
		virtual void seek(u32 pos){}
	};
class nes_c;
class mapper_c
	{
	protected:
		nes_c *pnes;
		char desc[128];
		int num;
	public:
		mapper_c(nes_c *pn){pnes = pn;}
		char *getname(){return(desc);}
		int getnumber(){return(num);}
		void setnes(nes_c *pn){pnes = pn;}
		virtual void init(){}
		virtual void uninit(){}
		virtual u8 read(u32 addr){return((u8)(addr >> 8));}
		virtual void write(u32 addr,u8 value){}
		virtual void scanline(int scanline,u32 cycles){}
		virtual void tileread(u8 tile,u8 highpt){}
		virtual void loaddata(u8 *spot){}
		virtual void savedata(u8 *spot){}
		virtual void sync(){}
	};
#if 1 //#ifndef DLLCOMPILE	//not available to dlls
class nes_c//:public nesbase_c
	{
	protected:
		u32 cycles; //num cycles executed
		double cyclestoexec; //cycles to execute next frame
		int numscanline; //scanline we are on
		u32 sramsize; //kbytes of sram
		u8 sramenabled; //sram used or not
		u32 prgmask;
		u32 chrmask;
		u32 srammask;
		u8 mirroring; //mirroring currently used
		u8 *prg;
		u8 *chr;
		u32 r4016reads,r4017reads;
		u8 r4016strobe;
		int filemode;
		int romloadtype; //type of rom to load when loadrom is called instead of other load*'s
		u8 mapperwrites[NUMCPUBANKS];
		u8 rompages[NUMCPUBANKS];
		u8 *srampages[NUMCPUBANKS];
		file_c *sramfile;
		char *sramfilename;
		u8 *gamegenierom;
		int gamegenieon;
		ggcode_t ggcodes[3];
		u32 framecycles,framecyclecounter;
		double wantedframecycles,wantedframecyclecounter,preciseframecyclecounter;
		double lastframecycles; //cycles not executed from last frame
	public:
		nescpu_c *cpu;
		nesppu_c *ppu;
		nesapu_c *apu;
		nesfile_t *nesfile;
		mapper_c *mapper;
		u32 prgsize; //kbytes of prg
		u32 chrsize; //kbytes of chr
		u32 r4016,r4017;
		u8 ram[0x0800];
		u8 *sram;
		nes_c();
		~nes_c();
		void setcpu(nescpu_c *ncpu){cpu = ncpu;cpu->setnes(this);}
		void setppu(nesppu_c *nppu){ppu = nppu;ppu->setnes(this);}
		void setapu(nesapu_c *napu){apu = napu;apu->setnes(this);}
		void setmapper(mapper_c *m){mapper = m;}
		void setromloadtype(int t){this->romloadtype = t;}
		void setmirroring(u8 m){mirroring = m;ppu->setmirroring(mirroring);}
		void setwrite(int b){mapperwrites[b] = 1;}
		void setprgrom(int b){rompages[b] = 1;}
		void setsramfile(file_c *newfile,char *fn){sramfile = newfile;sramfilename = fn;}
		void setsramenable(int e,int kb = 8);
		void setsramsize(u8 k);
		void setsrambank4(u8 page,u8 bank);
		void setsrambank8(u8 page,u8 bank);
		void savesram();
		void loadsram();
		void setgamegenie(int offon,file_c *genierom = 0);
		void setcpubank(u8 page,u8 *bank);
		u32 createmask(u32 size);
		int loadrom(file_c *p,file_c *c = 0,file_c *h = 0);
		int loadromnes(file_c *f);
		int loadromunif(file_c *f);
		int loadromfds(file_c *f);
		int loadromfiles(file_c *p,file_c *c,file_c *h = 0);
		void unloadrom();
		void setpalette(u32 *newpalette);
		int savestate(file_c *file);
		int loadstate(file_c *file);
		u8 read(u32 addr);
		void write(u32 addr,u8 value);
		void reset();
		int scanline(void *dest);
		int scanline_nocpu(void *dest);
		void setcpupage4(u8 page,int bank);
		void setcpupage8(u8 page,int bank);
		void setcpupage16(u8 page,int bank);
		void setcpupage32(u8 page,int bank);
	};
#endif
/************************************************************************************************/
#endif