#include <dsound.h>
#include <stdio.h>
#include "dxsound.h"
/*********************************************************************************************/
funcs_t *funcs;
#define SO_FORCE8BIT 1
#define SO_SECONDARY 2
#define SO_GFOCUS    4
#define SO_D16VOL    8
int soundoptions = 0;
LPDIRECTSOUND ppDS=0;
LPDIRECTSOUNDBUFFER ppbuf=0;
LPDIRECTSOUNDBUFFER ppbufsec=0;
LPDIRECTSOUNDBUFFER ppbufw;
DSBUFFERDESC DSBufferDesc;
WAVEFORMATEX wfa;
WAVEFORMATEX wf;
int disabled=1,inited=0;
int DSBufferSize=0;
int bittage;
//extern HWND hWnd; //from squeem.cpp
int ddrval;
static signed short MBuffer[2048];
 static VOID *feegle[2];
 static DWORD dook[2];
 static DWORD writepos=0,playpos=0,lplaypos=0;
static int soundbufsize=2048;
void CheckDStatus()
{
  DWORD status;
  status=0;
  IDirectSoundBuffer_GetStatus(ppbufw, &status);

  if(status&DSBSTATUS_BUFFERLOST)
   IDirectSoundBuffer_Restore(ppbufw);

  if(!(status&DSBSTATUS_PLAYING))
  {
   writepos=(soundbufsize)<<bittage;
   IDirectSoundBuffer_SetFormat(ppbufw,&wf);
   IDirectSoundBuffer_Play(ppbufw,0,0,DSBPLAY_LOOPING);
  }
}
void BlockingCheck()
{
  MSG msg;
  while( PeekMessage( &msg, 0, 0, 0, PM_NOREMOVE ) ) {
     if( GetMessage( &msg, 0,  0, 0)>0 )
     {
     TranslateMessage(&msg);
     DispatchMessage(&msg);          
     }
   } 
}
/*********************************************************************************************/
void dxsound_c::pause()
{
IDirectSoundBuffer_Stop(ppbufw);
disabled = 1;
}
/*********************************************************************************************/
void dxsound_c::resume()
{
CheckDStatus();
disabled = 0;
}
/*********************************************************************************************/
u16 *Buffer=0;
int dxsound_c::play()
{
if(inited == 0)
	return(1);
if(disabled == 0)
	{
int Check = 0;
 int P;
//Buffer = (u16*)buf;
//u16 *Buffer = new u16[size];
for(int i=0;i<size;i++)Buffer[i] = ((byte*)buf)[i] * 64;
//word *Buffer = (word*)buf;
// if(soundlog)
//  WriteWaveData(Buffer, size, Check);

 if(!bittage)
 {
  if(Check)
   for(P=0;P<size;P++)
    {
     int mixer;
     mixer=Buffer[P]>>7;
     if(mixer>128) mixer=128;
     if(mixer<-128) mixer=-128;
     Buffer[P]=0;
     *(((byte*)MBuffer)+P)=((char)mixer)^128;
    }
  else
   for(P=0;P<size;P++)
    {
     *(((byte*)MBuffer)+P)=((char)(Buffer[P]>>7))^128;
     Buffer[P]=0;
    }
 }
 else
 {
  if(Check)
  {
   if(soundoptions&SO_D16VOL)
   {
    for(P=0;P<size;P++)
     {
      int mixer;
      mixer=Buffer[P]<<1;
      if(mixer>32767) mixer=32767;
      if(mixer<-32768) mixer=-32768;
      Buffer[P]=0;
      MBuffer[P]=mixer;
     }
   }
   else
   {
    for(P=0;P<size;P++)
     {
      int mixer;
      mixer=Buffer[P];
      if(mixer>32767) mixer=32767;
      if(mixer<-32768) mixer=-32768;
      Buffer[P]=0;
      MBuffer[P]=mixer;
     }
   }
  }
  else
  {
   if(soundoptions&SO_D16VOL)
   {
    for(P=0;P<size;P++)
     {
      MBuffer[P]=Buffer[P]<<1;
      Buffer[P]=0;
     }
   }
   else
   {
    for(P=0;P<size;P++)
     {
      MBuffer[P]=Buffer[P];
      Buffer[P]=0;
     }
   }
  }
 }
  ilicpo:
  CheckDStatus();
  IDirectSoundBuffer_GetCurrentPosition(ppbufw,&playpos,0);

  if(writepos>=DSBufferSize) 
   if(playpos<lplaypos)
    writepos-=DSBufferSize;
  lplaypos=playpos;

  /* If the write position is beyond the fill buffer, block. */
  if(writepos >= (playpos + (soundbufsize << bittage)))
  //if(!(writepos<playpos+((soundbufsize)<<bittage)))
  {
   BlockingCheck();
   goto ilicpo;
  }

  {
   feegle[0]=feegle[1]=0;
   dook[0]=dook[1]=0;

   
   ddrval=IDirectSoundBuffer_Lock(ppbufw,(writepos%DSBufferSize),size<<bittage,&feegle[0],&dook[0],&feegle[1],&dook[1],0);
   if(ddrval!=DS_OK)
    goto nolock;

   if(feegle[1]!=0 && feegle[1]!=feegle[0])
   {
     memcpy(feegle[0],(byte *)MBuffer,dook[0]);
     memcpy(feegle[1],((byte *)MBuffer)+dook[0],dook[1]);
   }
   else
   {
     memcpy(feegle[0],(byte *)MBuffer,dook[0]);
   }

   IDirectSoundBuffer_Unlock(ppbufw,feegle[0],dook[0],feegle[1],dook[1]);
   writepos+=size<<bittage;
  }
 nolock:;
 ///////// Ending
	}
return(0);
}
/*********************************************************************************************/
int dxsound_c::init(HWND hwnd,u8 *buffer,u32 bufsize,u32 bits,u32 hz)
{
 DSCAPS dscaps;
 DSBCAPS dsbcaps;
 int rate;
 rate=44100;

uninit();
inited = 0;
buf = buffer;
size = bufsize;
disabled = 1;
Buffer = new u16[size];
 memset(&wf,0x00,sizeof(wf));
 wf.wFormatTag = WAVE_FORMAT_PCM;
 wf.nChannels = 1;
 wf.nSamplesPerSec = rate;

 ddrval=DirectSoundCreate(0,&ppDS,0);
 if (ddrval != DS_OK)
 {
  printf("DirectSound: Error creating DirectSound object.");
  return(1);
 }
 IDirectSound_Compact(ppDS);
 if(soundoptions&SO_FORCE8BIT)
  bittage=0;
 else
 {
  bittage=1;
  ddrval=IDirectSound_GetCaps(ppDS,&dscaps);
  if(ddrval==DS_OK)
  {
   if(!(dscaps.dwFlags&DSCAPS_PRIMARY16BIT))
    bittage=0;
  }
 }
 wf.wBitsPerSample=8<<bittage;
 wf.nBlockAlign = bittage+1;
 wf.nAvgBytesPerSec = wf.nSamplesPerSec * wf.nBlockAlign;

 if(soundoptions&SO_SECONDARY)
  ddrval=IDirectSound_SetCooperativeLevel(ppDS,hwnd,DSSCL_EXCLUSIVE);
 else
  ddrval=IDirectSound_SetCooperativeLevel(ppDS,hwnd,DSSCL_WRITEPRIMARY);
 if (ddrval != DS_OK)
 {
  printf("DirectSound: Error setting cooperative level.");
 if(ppbufsec)
 {
  IDirectSoundBuffer_Stop(ppbufsec);
  IDirectSoundBuffer_Release(ppbufsec);
  ppbufsec=0;
 }
 if(ppbuf)
 {
  IDirectSoundBuffer_Stop(ppbuf);
  IDirectSoundBuffer_Release(ppbuf);
  ppbuf=0;
 }
 if(ppDS)
 {
  IDirectSound_Release(ppDS);
  ppDS=0;
 }
  return(1);
 }

 memset(&DSBufferDesc,0x00,sizeof(DSBUFFERDESC));
 DSBufferDesc.dwSize=sizeof(DSBufferDesc);
 if(soundoptions&SO_SECONDARY)
  DSBufferDesc.dwFlags=DSBCAPS_PRIMARYBUFFER;
 else
  DSBufferDesc.dwFlags=DSBCAPS_PRIMARYBUFFER|DSBCAPS_GETCURRENTPOSITION2;

 ddrval=IDirectSound_CreateSoundBuffer(ppDS,&DSBufferDesc,&ppbuf,0);
 if (ddrval != DS_OK)
 {
  printf("DirectSound: Error creating primary buffer.");
 if(ppbufsec)
 {
  IDirectSoundBuffer_Stop(ppbufsec);
  IDirectSoundBuffer_Release(ppbufsec);
  ppbufsec=0;
 }
 if(ppbuf)
 {
  IDirectSoundBuffer_Stop(ppbuf);
  IDirectSoundBuffer_Release(ppbuf);
  ppbuf=0;
 }
 if(ppDS)
 {
  IDirectSound_Release(ppDS);
  ppDS=0;
 }
  return(1);
 }
 memset(&wfa,0x00,sizeof(wfa));
 
 ddrval=IDirectSoundBuffer_SetFormat(ppbuf,&wf);
 if (ddrval != DS_OK)
 {
  printf("DirectSound: Error setting primary buffer format.");
 if(ppbufsec)
 {
  IDirectSoundBuffer_Stop(ppbufsec);
  IDirectSoundBuffer_Release(ppbufsec);
  ppbufsec=0;
 }
 if(ppbuf)
 {
  IDirectSoundBuffer_Stop(ppbuf);
  IDirectSoundBuffer_Release(ppbuf);
  ppbuf=0;
 }
 if(ppDS)
 {
  IDirectSound_Release(ppDS);
  ppDS=0;
 }
  return(1);
 }
 IDirectSoundBuffer_GetFormat(ppbuf,&wfa,sizeof(wfa),0);

 if(soundoptions&SO_SECONDARY)
 {
  memset(&DSBufferDesc,0x00,sizeof(DSBUFFERDESC));  
  DSBufferDesc.dwSize=sizeof(DSBufferDesc);
  DSBufferDesc.dwFlags=DSBCAPS_GETCURRENTPOSITION2;
  if(soundoptions&SO_GFOCUS)
   DSBufferDesc.dwFlags|=DSBCAPS_GLOBALFOCUS;
  DSBufferDesc.dwBufferBytes=32768;
  DSBufferDesc.lpwfxFormat=&wfa;  
  ddrval=IDirectSound_CreateSoundBuffer(ppDS, &DSBufferDesc, &ppbufsec, 0);
  if (ddrval != DS_OK)
  {
   printf("DirectSound: Error creating secondary buffer.");
 if(ppbufsec)
 {
  IDirectSoundBuffer_Stop(ppbufsec);
  IDirectSoundBuffer_Release(ppbufsec);
  ppbufsec=0;
 }
 if(ppbuf)
 {
  IDirectSoundBuffer_Stop(ppbuf);
  IDirectSoundBuffer_Release(ppbuf);
  ppbuf=0;
 }
 if(ppDS)
 {
  IDirectSound_Release(ppDS);
  ppDS=0;
 }
   return(1);
  }
 }

// sprintf(TempArray,"%d\n",wfa.nSamplesPerSec);
// printNonFatal(TempArray);
 if(soundoptions&SO_SECONDARY)
 {
  DSBufferSize=32768;
  IDirectSoundBuffer_SetCurrentPosition(ppbufsec,0);
  ppbufw=ppbufsec;
 }
 else
 {
  memset(&dsbcaps,0,sizeof(dsbcaps));
  dsbcaps.dwSize=sizeof(dsbcaps);
  ddrval=IDirectSoundBuffer_GetCaps(ppbuf,&dsbcaps);
  if (ddrval != DS_OK)
  {
   printf("DirectSound: Error getting buffer capabilities.");
 if(ppbufsec)
 {
  IDirectSoundBuffer_Stop(ppbufsec);
  IDirectSoundBuffer_Release(ppbufsec);
  ppbufsec=0;
 }
 if(ppbuf)
 {
  IDirectSoundBuffer_Stop(ppbuf);
  IDirectSoundBuffer_Release(ppbuf);
  ppbuf=0;
 }
 if(ppDS)
 {
  IDirectSound_Release(ppDS);
  ppDS=0;
 }
   return(1);
  }

  DSBufferSize=dsbcaps.dwBufferBytes;

  if(DSBufferSize<8192)
  {
   printf("DirectSound: Primary buffer size is too small!");
 if(ppbufsec)
 {
  IDirectSoundBuffer_Stop(ppbufsec);
  IDirectSoundBuffer_Release(ppbufsec);
  ppbufsec=0;
 }
 if(ppbuf)
 {
  IDirectSoundBuffer_Stop(ppbuf);
  IDirectSoundBuffer_Release(ppbuf);
  ppbuf=0;
 }
 if(ppDS)
 {
  IDirectSound_Release(ppDS);
  ppDS=0;
 }
   return(1);
  }
  ppbufw=ppbuf;
 }
disabled = 0;
inited = 1;
return(0);
}
/*********************************************************************************************/
void dxsound_c::uninit()
{
if(Buffer)
	{
	delete[] Buffer;
	Buffer = 0;
	}
if(ppbufsec)
	{
	ppbufsec->Stop();
	ppbufsec->Release();
	ppbufsec = 0;
	}
if(ppbuf)
	{
	ppbuf->Stop();
	ppbuf->Release();
	ppbuf = 0;
	}
if(ppDS)
	{
	ppDS->Release();
	ppDS = 0;
	}
disabled = 1;
inited = 0;
}
/*********************************************************************************************/
extern "C" void *newobject(nes_c *nes)
{
return(new dxsound_c);
}
/************************************************************************************************/
extern "C" void deleteobject(void *o)
{
delete o;
}
/************************************************************************************************/
dllinfo_t dllinfo = {DLL_SOUND,newobject,deleteobject,"dxsound (fceu code) 1.00"};
extern "C" __declspec(dllexport) dllinfo_t *loaddll(funcs_t *f,dll_t *dll)
{
funcs = f;
return((dllinfo_t*)&dllinfo);
}
/************************************************************************************************/
