#ifndef __MATTAPU_H__
#define __MATTAPU_H__
/************************************************************************************************/
#define DLLCOMPILE
/************************************************************************************************/
#include "dllinclude.h"
#include "nes_apu.h"
/************************************************************************************************/
class mattapu_c:public nesapu_c
	{
	private:
		u8 regs[0x16];
		u8 *buffer;
		u32 buffersize;
		int bits;
		int hz;
		apu_t *apu;
	public:
		void setbuffer(u8 *buf,u32 bufsize,int b,int soundhz);
		void getregs(u8 *dest);
		void setregs(u8 *dest);
		int init();
		void uninit();
		u8 read(u32 addr);
		void write(u32 addr,u8 value);
		void frame();
		void reset();
		void cpuirq(){pnes->cpu->irq();}
		void cputakecycles(u32 n){pnes->cpu->takecycles(n);}
	};
/************************************************************************************************/
#endif