#include "mattcpu.h"
/************************************************************************************************/
funcs_t *funcs;
/************************************************************************************************/
void mattcpu_c::init()
{
NESReadHandler = new nes6502_memread[2];
NESWriteHandler = new nes6502_memwrite[2];
NESReadHandler[0].min_range = 0x2000;
NESReadHandler[0].max_range = 0xffff;
NESReadHandler[0].read_func = 0;
NESReadHandler[1].min_range = 0;
NESReadHandler[1].max_range = 0;
NESReadHandler[1].read_func = 0;
NESWriteHandler[0].min_range = 0x2000;
NESWriteHandler[0].max_range = 0xffff;
NESWriteHandler[0].write_func = 0;
NESWriteHandler[1].min_range = 0;
NESWriteHandler[1].max_range = 0;
NESWriteHandler[1].write_func = 0;
context = new nes6502_context;
nes6502_init();
}
/************************************************************************************************/
void mattcpu_c::uninit()
{
delete[] NESReadHandler;
delete[] NESWriteHandler;
delete context;
}
/************************************************************************************************/
void mattcpu_c::getdata(cpu6502_t *data)
{
int i;

nes6502_getcontext(context);
data->a = context->a_reg;
data->x = context->x_reg;
data->y = context->y_reg;
data->s = context->s_reg;
data->f = context->p_reg;
data->pc = context->pc_reg;
data->needirq = context->int_pending;
data->readfunc = NESReadHandler[0].read_func;
data->writefunc = NESWriteHandler[0].write_func;
for(i=0;i<NUMCPUBANKS;i++)
	{
	data->oppages[i] = context->mem_page[i];
	data->readpages[i] = context->mem_page[i];
	data->writepages[i] = context->mem_page[i];
	}
}
/************************************************************************************************/
void mattcpu_c::setdata(cpu6502_t *data)
{
int i;

nes6502_getcontext(context);
context->a_reg = data->a;
context->x_reg = data->x;
context->y_reg = data->y;
context->s_reg = data->s;
context->p_reg = data->f;
context->pc_reg = data->pc;
context->int_pending = data->needirq;
context->read_handler = NESReadHandler;
context->write_handler = NESWriteHandler;
NESReadHandler[0].read_func = data->readfunc;
NESWriteHandler[0].write_func = data->writefunc;
for(i=0;i<16;i++)
	{
	context->mem_page[i] = 0;
	if(data->writepages[i])
		context->mem_page[i] = data->writepages[i];
	else if(data->readpages[i])
		context->mem_page[i] = data->readpages[i];
	else if(data->oppages[i])
		context->mem_page[i] = data->oppages[i];
	}
nes6502_setcontext(context);
}
/************************************************************************************************/
void mattcpu_c::setread(readfunc_t newread)
{
nes6502_getcontext(context);
context->read_handler = NESReadHandler;
NESReadHandler[0].read_func = newread;
nes6502_setcontext(context);
}
/************************************************************************************************/
void mattcpu_c::setwrite(writefunc_t newwrite)
{
nes6502_getcontext(context);
context->write_handler = NESWriteHandler;
NESWriteHandler[0].write_func = newwrite;
nes6502_setcontext(context);
}
/************************************************************************************************/
void mattcpu_c::reset()
{
context->read_handler = NESReadHandler;
context->write_handler = NESWriteHandler;
nes6502_setcontext(context);
nes6502_reset();
}
/************************************************************************************************/
u32 mattcpu_c::exec(u32 cycles)
{
return(nes6502_execute(cycles)); //matts core emulates bad opcodes :(
/*cycles -= lesscycles;
lesscycles = 0;
return(dead6502_exec(cycles));*/
}
/************************************************************************************************/
void mattcpu_c::nmi()
{
nes6502_nmi();
}
/************************************************************************************************/
void mattcpu_c::irq()
{
nes6502_irq();
}
/************************************************************************************************/
u8 *mattcpu_c::getbank(u8 page,u8 type)
{
nes6502_getcontext(context);
return(context->mem_page[page]);
}
/************************************************************************************************/
void mattcpu_c::setbank(u8 page,u8 *data,u8 type)
{
nes6502_getcontext(context);
context->mem_page[page] = data;
nes6502_setcontext(context);
}
/************************************************************************************************/
u32 mattcpu_c::gettotalcycles()
{
return(nes6502_getcycles(0));
}
/************************************************************************************************/
extern "C" u32 disasm6502(char *buffer,u32 opcodepos,u8 (*read6502)(u32 addr));
u32 mattcpu_c::disassembleopcode(char *str,u32 pc)
{
return((u32)disasm6502(str,pc,NESReadHandler[0].read_func));
}
/************************************************************************************************/
u32 mattcpu_c::getvector(int n)
{
switch(n)
	{
	case CPU_NMI:return(nes6502_getbyte(0xfffa) | (nes6502_getbyte(0xfffb) << 8));
	case CPU_RESET:return(nes6502_getbyte(0xfffc) | (nes6502_getbyte(0xfffd) << 8));
	case CPU_IRQ:return(nes6502_getbyte(0xfffe) | (nes6502_getbyte(0xffff) << 8));
	}
return(0);
}
/************************************************************************************************/
extern "C" void *newobject(nes_c *nes)
{
return(new mattcpu_c);
}
/************************************************************************************************/
extern "C" void deleteobject(void *o)
{
delete o;
}
/************************************************************************************************/
dllinfo_t dllinfo = {DLL_CPU,newobject,deleteobject,"mattcpu 1.00"};
extern "C" __declspec(dllexport) dllinfo_t *loaddll(funcs_t *f,dll_t *dll)
{
funcs = f;
return((dllinfo_t*)&dllinfo);
}
/************************************************************************************************/
