#ifndef __MATTCPU_H__
#define __MATTCPU_H__
/************************************************************************************************/
#define DLLCOMPILE
/************************************************************************************************/
#include "dllinclude.h"
#include "nes6502.h"
/************************************************************************************************/
class mattcpu_c:public nescpu_c
	{
	private:
		nes6502_memread *NESReadHandler;
		nes6502_memwrite *NESWriteHandler;
		nes6502_context *context;
	public:
		void takecycles(u32 n){nes6502_setdma(n);}
		void init();
		void uninit();
		void getdata(cpu6502_t *data);
		void setdata(cpu6502_t *data);
		void setread(readfunc_t newread);
		void setwrite(writefunc_t newwrite);
		void reset();
		u32 exec(u32 cycles);
		void nmi();
		void irq();
		u8 *getbank(u8 page,u8 type);
		void setbank(u8 page,u8 *data,u8 type);
		u32 gettotalcycles();
		u32 disassembleopcode(char *str,u32 pc);
		u32 getvector(int v);
	};
/************************************************************************************************/
#endif