#ifndef __NESCPU_H__
#define __NESCPU_H__
/*********************************************************************************************/
#if NUMCPUBANKS != 16
#error NUMCPUBANKS isnt 16, fix it
#endif
/*********************************************************************************************/
#define CPU_NMI					0x01
#define CPU_IRQ					0x02
#define CPU_RESET					0x04
/*********************************************************************************************/
typedef u8 (*readfunc_t)(u32);
typedef void (*writefunc_t)(u32,u8);
typedef void (*linefunc_t)(u32);
typedef struct cpu6502_s
	{
	u8 a,x,y,s,f;
	u32 pc;
	u8 needirq;
	u8 *oppages[NUMCPUBANKS];
	u8 *readpages[NUMCPUBANKS];
	u8 *writepages[NUMCPUBANKS];
	readfunc_t opfunc;
	readfunc_t readfunc;
	writefunc_t writefunc;
	} cpu6502_t;
/*********************************************************************************************/
class nes_c;
class nescpu_c
	{
	protected:
		nes_c *pnes;
	public:
		virtual void setnes(nes_c *pn){pnes = pn;}
		virtual void takecycles(u32 n){}
		virtual void init(){}
		virtual void uninit(){}
		virtual void getdata(cpu6502_t *data){}
		virtual void setdata(cpu6502_t *data){}
		virtual void setread(readfunc_t newread){}
		virtual void setwrite(writefunc_t newwrite){}
		virtual void reset(){}
		virtual u32 exec(u32 cycles){return(0);}
		virtual void nmi(){}
		virtual void irq(){}
		virtual u8 *getbank(u8 page,u8 type){return(0);}
		virtual void setbank(u8 page,u8 *data,u8 type){}
		virtual u32 gettotalcycles(){return(0);}
		virtual u32 disassembleopcode(char *str,u32 pc){return(0);}
		virtual u32 getvector(int v){return(0);}
	};
#ifndef DLLCOMPILE //make this not available to the dlls
class cpu_c:public nescpu_c
	{
	protected:
		nes_c *pnes;
	public:
		void takecycles(u32 n);
		void init();
		void uninit(){}
		void getdata(cpu6502_t *data);
		void setdata(cpu6502_t *data);
		void setread(readfunc_t newread);
		void setwrite(writefunc_t newwrite);
		void reset();
		u32 exec(u32 cycles);
		void nmi();
		void irq();
		u8 *getbank(u8 page,u8 type);
		void setbank(u8 page,u8 *data,u8 type);
		u32 gettotalcycles();
		u32 disassembleopcode(char *str,u32 pc);
		u32 getvector(int v);
	};
#endif
/*********************************************************************************************/
#endif