#ifndef __NESPPU_H__
#define __NESPPU_H__
/************************************************************************************************/
#define NUMPPUBANKS	16
/************************************************************************************************/
typedef void (emphasis_t)(int);
typedef struct ppustate_s
	{
	u32 ppupages[NUMPPUBANKS];
	u8 nametables[4][0x400]; //nametable data
	u8 vram[0x2000 * 2]; //any vram data
	u32 vramsize; //0 for no vram
	u8 control1,control2,status,loopyx;
	u32 loopyvalue,loopytemp,ppuaddr;
	u8 sprmem[256],sprmemaddr; //sprite stuff
	u8 pal[32]; //the palette
	u8 r2007buf,r2007buflatch;
	u8 r20052006toggle;
	} ppustate_t;
/************************************************************************************************/
class nes_c;
class video_c;
class nesppu_c
	{
	protected:
		nes_c *pnes;
	public:
		u8 *ppupages[NUMPPUBANKS];
		u8 nametables[4][0x400];
		u8 *vram;
		u32 vramsize;
		u8 control1,control2,status,loopyx;
		u32 loopyvalue,loopytemp,ppuaddr;
		u8 sprmem[256],sprmemaddr;
		u8 pal[32];
		virtual void setemphasis(emphasis_t *f){}
		virtual void setnes(nes_c *pn){pnes = pn;}
		virtual void sprite0hit(){}
		virtual int init(){return(0);}
		virtual void uninit(){}
		virtual void getstate(ppustate_t *dest){}
		virtual void setstate(ppustate_t *src){}
		virtual void setchr(u32 size,u8 *chr){}
		virtual void setvram(u32 size){}
		virtual void hardreset(){}
		virtual void softreset(){}
		virtual u8 read(u32 addr){return(0);}
		virtual void write(u32 addr,u8 value){}
		virtual void beginscanline(int numscanline){}
		virtual int endscanline(int numscanline,void *dest){return(0);}
		virtual void setmirroring(int m){}
		virtual void setppubank(u8 page,u8 *bank){}
		virtual void setvrampage1(u8 page,int bank){}
		virtual void setvrampage2(u8 page,int bank){}
		virtual void setvrampage4(u8 page,int bank){}
		virtual void setvrampage8(u8 page,int bank){}
		virtual void setchrpage1(u8 page,int bank){}
		virtual void setchrpage2(u8 page,int bank){}
		virtual void setchrpage4(u8 page,int bank){}
		virtual void setchrpage8(u8 page,int bank){}
		virtual void setpalettes(u16 *p16,u16 *p17,u32 *p32){}
		virtual void setrenderbpp(int b){}
		virtual void renderscanline_null(void *dest,int line){}
		virtual void renderscanline_8(void *dest,int line){}
		virtual void renderscanline_16(void *dest,int line){}
		virtual void renderscanline_17(void *dest,int line){}
		virtual void renderscanline_32(void *dest,int line){}
	};
#ifndef DLLCOMPILE //make this not available to the dlls
class ppu_c:public nesppu_c
	{
	protected:
	public:
		void setemphasis(emphasis_t *f);
		void sprite0hit();
		int init();
		void uninit();
//		void getstate(ppustate_t *dest);
//		void setstate(ppustate_t *src);
		void setchr(u32 size,u8 *chr);
		void setvram(u32 size);
		void hardreset();
		void softreset();
		u8 read(u32 addr);
		void write(u32 addr,u8 value);
		void beginscanline(int numscanline);
		int endscanline(int numscanline,void *dest);
		void setmirroring(int m);
		void setppubank(u8 page,u8 *bank);
		void setvrampage1(u8 page,int bank);
		void setvrampage2(u8 page,int bank);
		void setvrampage4(u8 page,int bank);
		void setvrampage8(u8 page,int bank);
		void setchrpage1(u8 page,int bank);
		void setchrpage2(u8 page,int bank);
		void setchrpage4(u8 page,int bank);
		void setchrpage8(u8 page,int bank);
/*		void setpalettes(u16 *p16,u16 *p17,u32 *p32);
		void setrenderbpp(int b);
		void renderscanline_null(void *dest,int line); //use default for now (lazyness) :P
		void renderscanline_8(void *dest,int line);
		void renderscanline_16(void *dest,int line);
		void renderscanline_17(void *dest,int line);
		void renderscanline_32(void *dest,int line);*/
	};
#endif
/************************************************************************************************/
#endif