#include "mattapu.h"
/************************************************************************************************/
funcs_t *funcs;
/************************************************************************************************/
static mattapu_c *pmattapu;  //sucks :(
extern "C" void irq(){pmattapu->cpuirq();}
extern "C" u8 cpuread(u32 addr){return(funcs->nesread(addr));}
extern "C" void takecycles(u32 n){pmattapu->cputakecycles(n);}
/************************************************************************************************/
void mattapu_c::setbuffer(u8 *buf,u32 bufsize,int b,int soundhz)
{
buffer = buf;
buffersize = bufsize;
bits = b;
hz = soundhz;
}
/************************************************************************************************/
void mattapu_c::getregs(u8 *dest)
{
memcpy(dest,regs,0x16);
}
/************************************************************************************************/
void mattapu_c::setregs(u8 *dest)
{
int i;

memcpy(regs,dest,0x16);
for(i=0;i<0x16;i++)
	write(i + 0x4000,regs[i]);
}
/************************************************************************************************/
int mattapu_c::init()
{
apu = apu_create(0,hz,60,bits);
pmattapu = this;
apu->irq_callback = irq;
apu->irqclear_callback = 0;//nes_clearfiq;
apu->read_callback = 0;//cpuread;
apu->takecycles_callback = takecycles;
return(0);
}
/************************************************************************************************/
void mattapu_c::uninit()
{
if(apu)
	{
	apu_destroy(&apu);
	apu = 0;
	}
}
/************************************************************************************************/
u8 mattapu_c::read(u32 addr)
{
if(apu)
	return(apu_read(addr));
return(0);
}
/************************************************************************************************/
void mattapu_c::write(u32 addr,u8 value)
{
if(apu)
	{
	regs[addr & 0x1f] = value;
	apu_write(addr,value);
	}
}
/************************************************************************************************/
void mattapu_c::frame()
{
if(apu)
	apu_process(buffer,hz / 60);
}
/************************************************************************************************/
void mattapu_c::reset()
{
int i;

if(apu)
	{
/*	if(pnes->cpu)
		apu->cpu = pnes->cpu;
	else
		funcs->msg("mattapu_c::reset: bug!  parent nes has no cpu!\n");*/
	apu_reset();
	}
for(i=0;i<0x16;i++)
	regs[i] = 0;
}
/************************************************************************************************/
extern "C" void *newobject(nes_c *nes)
{
return(new mattapu_c);
}
/************************************************************************************************/
extern "C" void deleteobject(void *o)
{
delete o;
}
/************************************************************************************************/
dllinfo_t dllinfo = {DLL_APU,newobject,deleteobject,"mattapu (nes_apu v1.2) 1.00"};
extern "C" __declspec(dllexport) dllinfo_t *loaddll(funcs_t *f,dll_t *dll)
{
funcs = f;
return((dllinfo_t*)&dllinfo);
}
/************************************************************************************************/
