#include <SDL_audio.h>
#include <SDL_error.h>
#include "sdlsound.h"
/*********************************************************************************************/
funcs_t *funcs;
/*********************************************************************************************/
void sdlsound_c::pause()
{
SDL_PauseAudio(1);
disabled = 1;
}
/*********************************************************************************************/
void sdlsound_c::resume()
{
SDL_PauseAudio(0);
disabled = 0;
}
/*********************************************************************************************/
int sdlsound_c::play()
{
SDL_PauseAudio(0);
return(0);
}
/*********************************************************************************************/
u8 b[8192];
void fill_audio(void *udata, Uint8 *stream, int len)
{
//SDL_MixAudio(stream,(u8*)udata,len,SDL_MIX_MAXVOLUME);
//for(int i=0;i<len;i++)
//	b[i] = ((u8*)udata)[i]/2;
SDL_MixAudio(stream,(u8*)udata,len,SDL_MIX_MAXVOLUME/2);
}
int sdlsound_c::init(HWND hwnd,u8 *buffer,u32 bufsize,u32 bits,u32 hz)
{
buf = buffer;
size = bufsize;

        SDL_AudioSpec wanted;

        /* Set the audio format */
        wanted.freq = hz;
if(bits == 8)
        wanted.format = AUDIO_U8;
else
        wanted.format = AUDIO_U16;
        wanted.channels = 1;    /* 1 = mono, 2 = stereo */
        wanted.samples = (wanted.freq / 60);  /* Good low-latency value for callback */
        wanted.callback = fill_audio;
        wanted.userdata = buf;

        /* Open the audio device, forcing the desired format */
        if ( SDL_OpenAudio(&wanted, 0) < 0 ) {
                funcs->msg("Couldn't open audio: %s\n", SDL_GetError());
                return(-1);
        }
funcs->msg("sdlsound_c::init: bits:%d  hz:%d\n",wanted.format==AUDIO_U8?8:16,hz);
return(0);
}
/*********************************************************************************************/
void sdlsound_c::uninit()
{
SDL_CloseAudio();
}
/*********************************************************************************************/
extern "C" void *newobject(nes_c *nes)
{
return(new sdlsound_c);
}
/************************************************************************************************/
extern "C" void deleteobject(void *o)
{
delete o;
}
/************************************************************************************************/
dllinfo_t dllinfo = {DLL_SOUND,newobject,deleteobject,"sdlsound 1.00"};
extern "C" __declspec(dllexport) dllinfo_t *loaddll(funcs_t *f,dll_t *dll)
{
funcs = f;
return((dllinfo_t*)&dllinfo);
}
/************************************************************************************************/
