#ifndef __DLLINCLUDE_H__
#define __DLLINCLUDE_H__
/************************************************************************************************/
#include <windows.h>
#include "types.h"
#include "nes.h"
/************************************************************************************************/
#define DLL_VIDEO		0x01
#define DLL_INPUT		0x02
#define DLL_SOUND		0x04
#define DLL_CPU		0x10
#define DLL_PPU		0x20
#define DLL_APU		0x40
/************************************************************************************************/
typedef void* regkey_t;
typedef struct registryfuncs_s
	{
	regkey_t (*create)(LPCSTR keyname);
	regkey_t (*open)(LPCSTR keyname);
	void (*close)(regkey_t regkey);
	LONG (*query_dword)(regkey_t regkey,char *valuename,DWORD *dest,DWORD def);
	LONG (*query_sz)(regkey_t regkey,char *valuename,char *dest,char *def);
	LONG (*set_dword)(regkey_t regkey,char *valuename,DWORD data);
	LONG (*set_sz)(regkey_t regkey,char *valuename,char *data);
	} registryfuncs_t;
typedef struct funcs_s
	{
	void (*msg)(char *,...);
	readfunc_t nesread;
	writefunc_t neswrite;
	u32 (*createmask)(u32 n);
	registryfuncs_t regfuncs;
	} funcs_t;
typedef struct dllinfo_s
	{
	int type; //type of dll
	void *(*newobject)(nes_c*);
	void (*deleteobject)(void*);
	char name[64];
	} dllinfo_t;
typedef struct dll_s
	{
	HINSTANCE instance;
	char filename[_MAX_PATH];
	dllinfo_t *dllinfo;
	} dll_t;
/************************************************************************************************/
class video_c
	{
	protected:
		int bpp;
	public:
		virtual void blitstart(){}
		virtual void blitstop(){}
		virtual int init(HWND wnd,HINSTANCE inst,int w,int h,int bpp = 0){return(0);}
		virtual void uninit(){}
		virtual void resize(){}
		virtual void setpaletteentry(u32 index,u32 color){} //for 8bit color
		virtual void *getline(){return(0);}
		virtual int getbpp(){return(0);}
	};
class input_c
	{
	protected:
		u32 *joy1,*joy2;
	public:
		virtual void setjoy1(u32 *j1){joy1 = j1;}
		virtual void setjoy2(u32 *j2){joy2 = j2;}
		virtual int init(HWND wnd,HINSTANCE inst){return(0);}
		virtual void uninit(){}
		virtual void update(){}
		virtual void config(HWND hwnd){}
	};
class sound_c
	{
	public:
		virtual void pause(){}
		virtual void resume(){}
		virtual int play(){return(0);}
		virtual int init(HWND hwnd,u8 *buffer,u32 bufsize,u32 bits,u32 hz){return(0);}
		virtual void uninit(){}
	};
/************************************************************************************************/
#endif