/*
 * DAPPLE, Apple ][, ][+, //e Emulator
 * Copyright 2002, 2003 Steve Nickolas, portions by Holger Picker
 *
 * Component:  VIDEO: routines for pixmap and video redraw
 * Revision:   (1.25) 2003.0111
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* this code was contributed to Dapple */

//#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <allegro.h>
#include "dapple.h"

/* changed_this */
#include "font.h"
/*extern unsigned char AppleFont[2048]; */

extern unsigned char memstore80;
extern unsigned char bankram1[49152];
extern int gm;

extern int chartrans (int mode, unsigned int mychar);

extern Charset charmode;

#define i18n(x) ((unsigned char) chartrans(charmode,x))
//#define virtplot(x,y,c) virtscreen[(y*640)+x]=c
//#define virtplot(x,y,c) putpixel(screen,x,y,c)


/* Methods:

   - virtsetmode
   - virtsethresmode
   - virtgethresmode
   - virtsetmonochrome
   - virtgetmonochrome
   - virtsetpalette
   - virtgetpalette
   - virtpaletteset
   - virtpalettesetd
   - virtpaletteput
   - virtpaletteinit
   - virtcacheinit
   - virtinit
   - virtreset
   - virtstore
   - virtrestore
   - virtline
   - virtplot
   - virtscreencopy
   - virtwrite0400
   - virtwrite0800
   - virtwrite2000
   - virtwrite4000

*/

/* cache flags */
/* the lower 8 bits including cachepage are resevered for the switch counter */
#define cachechanged	0
#define cachepage	0x000001        /* (0 = page 1/ 1 = page 2) */
#define cachetext40	0x000100
#define cachetext40f	0x000200
#define cachetext80	0x000400
#define cachelres40	0x000800
#define cachelres80	0x001000
#define cachehres	0x002000
#define cachehreso	0x004000
#define cachedhrs	0x008000

/* videomodes */
#define modetext40	0
#define modetext80	1       /* not implemented yet */
#define modelres40	2
#define modelres80	3       /* not implemented yet */
#define modehres	4
#define modedhrs	5       /* not really implemented yet */

static unsigned char virthresmode;
static unsigned char virtmonochrome;
static unsigned char virtmonocol0;
static unsigned char virtmonocol1;
static unsigned char virtmonocol2;
static unsigned char virtmonocol3;
static unsigned int virtmodetop;
static unsigned int virtmodedown;
static unsigned int virttextpage;       /* 0x0400 or 0x0800 */
static unsigned int virthrespage;       /* 0x2000 or 0x4000 */
static unsigned int virtsplit;
unsigned int virtcachemode;
unsigned char virtcopy;                 /* screen update necessary? */
unsigned char virt80col;                /* 40col or 80col? */
unsigned char virtaltchar;              /* alternate charset? */
unsigned char virtiou;                  /* IOU active? */
unsigned char virtdhres;                /* Double Hires activated? */
unsigned char virtvideobyte;            /* byte put on the data bus by the graphic circuit */

static unsigned char colourtabe[8];
static unsigned char colourtabo[8];
static unsigned char colourtabe2[8];
static unsigned char colourtabo2[8];

/* screen palette */
static unsigned char virtpaletter[256];
static unsigned char virtpaletteg[256];
static unsigned char virtpaletteb[256];
static unsigned char virtpalette;

/* virtual screen buffer */
unsigned char virtscreen[128000];
static unsigned int virtcache[192];

static unsigned int textline[0x400] = {
                0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      /* 0x0400 */
                0,      0,      0,      0,      0,      0,      0,      0,      0,      0,
                0,      0,      0,      0,      0,      0,      0,      0,      0,      0,
                0,      0,      0,      0,      0,      0,      0,      0,      0,      0,
                64,     64,     64,     64,     64,     64,     64,     64,     64,     64,     /* 0x0428 */
                64,     64,     64,     64,     64,     64,     64,     64,     64,     64,
                64,     64,     64,     64,     64,     64,     64,     64,     64,     64,
                64,     64,     64,     64,     64,     64,     64,     64,     64,     64,
                128,    128,    128,    128,    128,    128,    128,    128,    128,    128,    /* 0x0450 */
                128,    128,    128,    128,    128,    128,    128,    128,    128,    128,
                128,    128,    128,    128,    128,    128,    128,    128,    128,    128,
                128,    128,    128,    128,    128,    128,    128,    128,    128,    128,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                8,      8,      8,      8,      8,      8,      8,      8,      8,      8,      /* 0x0480 */
                8,      8,      8,      8,      8,      8,      8,      8,      8,      8,
                8,      8,      8,      8,      8,      8,      8,      8,      8,      8,
                8,      8,      8,      8,      8,      8,      8,      8,      8,      8,
                72,     72,     72,     72,     72,     72,     72,     72,     72,     72,     /* 0x04a8 */
                72,     72,     72,     72,     72,     72,     72,     72,     72,     72,
                72,     72,     72,     72,     72,     72,     72,     72,     72,     72,
                72,     72,     72,     72,     72,     72,     72,     72,     72,     72,
                136,    136,    136,    136,    136,    136,    136,    136,    136,    136,    /* 0x04d0 */
                136,    136,    136,    136,    136,    136,    136,    136,    136,    136,
                136,    136,    136,    136,    136,    136,    136,    136,    136,    136,
                136,    136,    136,    136,    136,    136,    136,    136,    136,    136,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                16,     16,     16,     16,     16,     16,     16,     16,     16,     16,     /* 0x0500 */
                16,     16,     16,     16,     16,     16,     16,     16,     16,     16,
                16,     16,     16,     16,     16,     16,     16,     16,     16,     16,
                16,     16,     16,     16,     16,     16,     16,     16,     16,     16,
                80,     80,     80,     80,     80,     80,     80,     80,     80,     80,     /* 0x0528 */
                80,     80,     80,     80,     80,     80,     80,     80,     80,     80,
                80,     80,     80,     80,     80,     80,     80,     80,     80,     80,
                80,     80,     80,     80,     80,     80,     80,     80,     80,     80,
                144,    144,    144,    144,    144,    144,    144,    144,    144,    144,    /* 0x0550 */
                144,    144,    144,    144,    144,    144,    144,    144,    144,    144,
                144,    144,    144,    144,    144,    144,    144,    144,    144,    144,
                144,    144,    144,    144,    144,    144,    144,    144,    144,    144,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                24,     24,     24,     24,     24,     24,     24,     24,     24,     24,     /* 0x0580 */
                24,     24,     24,     24,     24,     24,     24,     24,     24,     24,
                24,     24,     24,     24,     24,     24,     24,     24,     24,     24,
                24,     24,     24,     24,     24,     24,     24,     24,     24,     24,
                88,     88,     88,     88,     88,     88,     88,     88,     88,     88,     /* 0x05a8 */
                88,     88,     88,     88,     88,     88,     88,     88,     88,     88,
                88,     88,     88,     88,     88,     88,     88,     88,     88,     88,
                88,     88,     88,     88,     88,     88,     88,     88,     88,     88,
                152,    152,    152,    152,    152,    152,    152,    152,    152,    152,    /* 0x05d0 */
                152,    152,    152,    152,    152,    152,    152,    152,    152,    152,
                152,    152,    152,    152,    152,    152,    152,    152,    152,    152,
                152,    152,    152,    152,    152,    152,    152,    152,    152,    152,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                32,     32,     32,     32,     32,     32,     32,     32,     32,     32,     /* 0x0600 */
                32,     32,     32,     32,     32,     32,     32,     32,     32,     32,
                32,     32,     32,     32,     32,     32,     32,     32,     32,     32,
                32,     32,     32,     32,     32,     32,     32,     32,     32,     32,
                96,     96,     96,     96,     96,     96,     96,     96,     96,     96,     /* 0x0628 */
                96,     96,     96,     96,     96,     96,     96,     96,     96,     96,
                96,     96,     96,     96,     96,     96,     96,     96,     96,     96,
                96,     96,     96,     96,     96,     96,     96,     96,     96,     96,
                160,    160,    160,    160,    160,    160,    160,    160,    160,    160,    /* 0x0650 */
                160,    160,    160,    160,    160,    160,    160,    160,    160,    160,
                160,    160,    160,    160,    160,    160,    160,    160,    160,    160,
                160,    160,    160,    160,    160,    160,    160,    160,    160,    160,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                40,     40,     40,     40,     40,     40,     40,     40,     40,     40,     /* 0x0680 */
                40,     40,     40,     40,     40,     40,     40,     40,     40,     40,
                40,     40,     40,     40,     40,     40,     40,     40,     40,     40,
                40,     40,     40,     40,     40,     40,     40,     40,     40,     40,
                104,    104,    104,    104,    104,    104,    104,    104,    104,    104,    /* 0x06a8 */
                104,    104,    104,    104,    104,    104,    104,    104,    104,    104,
                104,    104,    104,    104,    104,    104,    104,    104,    104,    104,
                104,    104,    104,    104,    104,    104,    104,    104,    104,    104,
                168,    168,    168,    168,    168,    168,    168,    168,    168,    168,    /* 0x06d0 */
                168,    168,    168,    168,    168,    168,    168,    168,    168,    168,
                168,    168,    168,    168,    168,    168,    168,    168,    168,    168,
                168,    168,    168,    168,    168,    168,    168,    168,    168,    168,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                48,     48,     48,     48,     48,     48,     48,     48,     48,     48,     /* 0x0700 */
                48,     48,     48,     48,     48,     48,     48,     48,     48,     48,
                48,     48,     48,     48,     48,     48,     48,     48,     48,     48,
                48,     48,     48,     48,     48,     48,     48,     48,     48,     48,
                112,    112,    112,    112,    112,    112,    112,    112,    112,    112,    /* 0x0728 */
                112,    112,    112,    112,    112,    112,    112,    112,    112,    112,
                112,    112,    112,    112,    112,    112,    112,    112,    112,    112,
                112,    112,    112,    112,    112,    112,    112,    112,    112,    112,
                176,    176,    176,    176,    176,    176,    176,    176,    176,    176,    /* 0x0750 */
                176,    176,    176,    176,    176,    176,    176,    176,    176,    176,
                176,    176,    176,    176,    176,    176,    176,    176,    176,    176,
                176,    176,    176,    176,    176,    176,    176,    176,    176,    176,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                56,     56,     56,     56,     56,     56,     56,     56,     56,     56,     /* 0x0780 */
                56,     56,     56,     56,     56,     56,     56,     56,     56,     56,
                56,     56,     56,     56,     56,     56,     56,     56,     56,     56,
                56,     56,     56,     56,     56,     56,     56,     56,     56,     56,
                120,    120,    120,    120,    120,    120,    120,    120,    120,    120,    /* 0x07a8 */
                120,    120,    120,    120,    120,    120,    120,    120,    120,    120,
                120,    120,    120,    120,    120,    120,    120,    120,    120,    120,
                120,    120,    120,    120,    120,    120,    120,    120,    120,    120,
                184,    184,    184,    184,    184,    184,    184,    184,    184,    184,    /* 0x07d0 */
                184,    184,    184,    184,    184,    184,    184,    184,    184,    184,
                184,    184,    184,    184,    184,    184,    184,    184,    184,    184,
                184,    184,    184,    184,    184,    184,    184,    184,    184,    184,
                255,    255,    255,    255,    255,    255,    255,    255                     /* screenhole */
              };


static unsigned int textaddr[192] = {
                0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
                0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080,
                0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
                0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
                0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200,
                0x0280, 0x0280, 0x0280, 0x0280, 0x0280, 0x0280, 0x0280, 0x0280,
                0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
                0x0380, 0x0380, 0x0380, 0x0380, 0x0380, 0x0380, 0x0380, 0x0380,
                0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
                0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8,
                0x0128, 0x0128, 0x0128, 0x0128, 0x0128, 0x0128, 0x0128, 0x0128,
                0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
                0x0228, 0x0228, 0x0228, 0x0228, 0x0228, 0x0228, 0x0228, 0x0228,
                0x02a8, 0x02a8, 0x02a8, 0x02a8, 0x02a8, 0x02a8, 0x02a8, 0x02a8,
                0x0328, 0x0328, 0x0328, 0x0328, 0x0328, 0x0328, 0x0328, 0x0328,
                0x03a8, 0x03a8, 0x03a8, 0x03a8, 0x03a8, 0x03a8, 0x03a8, 0x03a8,
                0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050,
                0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0,
                0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150,
                0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0,
                0x0250, 0x0250, 0x0250, 0x0250, 0x0250, 0x0250, 0x0250, 0x0250,
                0x02d0, 0x02d0, 0x02d0, 0x02d0, 0x02d0, 0x02d0, 0x02d0, 0x02d0,
                0x0350, 0x0350, 0x0350, 0x0350, 0x0350, 0x0350, 0x0350, 0x0350,
                0x03d0, 0x03d0, 0x03d0, 0x03d0, 0x03d0, 0x03d0, 0x03d0, 0x03d0
                };


static unsigned int hresline[0x2000] = {
                0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      /* 0x2000 */
                0,      0,      0,      0,      0,      0,      0,      0,      0,      0,
                0,      0,      0,      0,      0,      0,      0,      0,      0,      0,
                0,      0,      0,      0,      0,      0,      0,      0,      0,      0,
                64,     64,     64,     64,     64,     64,     64,     64,     64,     64,     /* 0x2028 */
                64,     64,     64,     64,     64,     64,     64,     64,     64,     64,
                64,     64,     64,     64,     64,     64,     64,     64,     64,     64,
                64,     64,     64,     64,     64,     64,     64,     64,     64,     64,
                128,    128,    128,    128,    128,    128,    128,    128,    128,    128,    /* 0x2050 */
                128,    128,    128,    128,    128,    128,    128,    128,    128,    128,
                128,    128,    128,    128,    128,    128,    128,    128,    128,    128,
                128,    128,    128,    128,    128,    128,    128,    128,    128,    128,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                8,      8,      8,      8,      8,      8,      8,      8,      8,      8,      /* 0x2080 */
                8,      8,      8,      8,      8,      8,      8,      8,      8,      8,
                8,      8,      8,      8,      8,      8,      8,      8,      8,      8,
                8,      8,      8,      8,      8,      8,      8,      8,      8,      8,
                72,     72,     72,     72,     72,     72,     72,     72,     72,     72,     /* 0x20a8 */
                72,     72,     72,     72,     72,     72,     72,     72,     72,     72,
                72,     72,     72,     72,     72,     72,     72,     72,     72,     72,
                72,     72,     72,     72,     72,     72,     72,     72,     72,     72,
                136,    136,    136,    136,    136,    136,    136,    136,    136,    136,    /* 0x20d0 */
                136,    136,    136,    136,    136,    136,    136,    136,    136,    136,
                136,    136,    136,    136,    136,    136,    136,    136,    136,    136,
                136,    136,    136,    136,    136,    136,    136,    136,    136,    136,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                16,     16,     16,     16,     16,     16,     16,     16,     16,     16,     /* 0x2100 */
                16,     16,     16,     16,     16,     16,     16,     16,     16,     16,
                16,     16,     16,     16,     16,     16,     16,     16,     16,     16,
                16,     16,     16,     16,     16,     16,     16,     16,     16,     16,
                80,     80,     80,     80,     80,     80,     80,     80,     80,     80,     /* 0x2128 */
                80,     80,     80,     80,     80,     80,     80,     80,     80,     80,
                80,     80,     80,     80,     80,     80,     80,     80,     80,     80,
                80,     80,     80,     80,     80,     80,     80,     80,     80,     80,
                144,    144,    144,    144,    144,    144,    144,    144,    144,    144,    /* 0x2150 */
                144,    144,    144,    144,    144,    144,    144,    144,    144,    144,
                144,    144,    144,    144,    144,    144,    144,    144,    144,    144,
                144,    144,    144,    144,    144,    144,    144,    144,    144,    144,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                24,     24,     24,     24,     24,     24,     24,     24,     24,     24,     /* 0x2180 */
                24,     24,     24,     24,     24,     24,     24,     24,     24,     24,
                24,     24,     24,     24,     24,     24,     24,     24,     24,     24,
                24,     24,     24,     24,     24,     24,     24,     24,     24,     24,
                88,     88,     88,     88,     88,     88,     88,     88,     88,     88,     /* 0x21a8 */
                88,     88,     88,     88,     88,     88,     88,     88,     88,     88,
                88,     88,     88,     88,     88,     88,     88,     88,     88,     88,
                88,     88,     88,     88,     88,     88,     88,     88,     88,     88,
                152,    152,    152,    152,    152,    152,    152,    152,    152,    152,    /* 0x21d0 */
                152,    152,    152,    152,    152,    152,    152,    152,    152,    152,
                152,    152,    152,    152,    152,    152,    152,    152,    152,    152,
                152,    152,    152,    152,    152,    152,    152,    152,    152,    152,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                32,     32,     32,     32,     32,     32,     32,     32,     32,     32,     /* 0x2200 */
                32,     32,     32,     32,     32,     32,     32,     32,     32,     32,
                32,     32,     32,     32,     32,     32,     32,     32,     32,     32,
                32,     32,     32,     32,     32,     32,     32,     32,     32,     32,
                96,     96,     96,     96,     96,     96,     96,     96,     96,     96,     /* 0x2228 */
                96,     96,     96,     96,     96,     96,     96,     96,     96,     96,
                96,     96,     96,     96,     96,     96,     96,     96,     96,     96,
                96,     96,     96,     96,     96,     96,     96,     96,     96,     96,
                160,    160,    160,    160,    160,    160,    160,    160,    160,    160,    /* 0x2250 */
                160,    160,    160,    160,    160,    160,    160,    160,    160,    160,
                160,    160,    160,    160,    160,    160,    160,    160,    160,    160,
                160,    160,    160,    160,    160,    160,    160,    160,    160,    160,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                40,     40,     40,     40,     40,     40,     40,     40,     40,     40,     /* 0x2280 */
                40,     40,     40,     40,     40,     40,     40,     40,     40,     40,
                40,     40,     40,     40,     40,     40,     40,     40,     40,     40,
                40,     40,     40,     40,     40,     40,     40,     40,     40,     40,
                104,    104,    104,    104,    104,    104,    104,    104,    104,    104,    /* 0x22a8 */
                104,    104,    104,    104,    104,    104,    104,    104,    104,    104,
                104,    104,    104,    104,    104,    104,    104,    104,    104,    104,
                104,    104,    104,    104,    104,    104,    104,    104,    104,    104,
                168,    168,    168,    168,    168,    168,    168,    168,    168,    168,    /* 0x22d0 */
                168,    168,    168,    168,    168,    168,    168,    168,    168,    168,
                168,    168,    168,    168,    168,    168,    168,    168,    168,    168,
                168,    168,    168,    168,    168,    168,    168,    168,    168,    168,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                48,     48,     48,     48,     48,     48,     48,     48,     48,     48,     /* 0x2300 */
                48,     48,     48,     48,     48,     48,     48,     48,     48,     48,
                48,     48,     48,     48,     48,     48,     48,     48,     48,     48,
                48,     48,     48,     48,     48,     48,     48,     48,     48,     48,
                112,    112,    112,    112,    112,    112,    112,    112,    112,    112,    /* 0x2328 */
                112,    112,    112,    112,    112,    112,    112,    112,    112,    112,
                112,    112,    112,    112,    112,    112,    112,    112,    112,    112,
                112,    112,    112,    112,    112,    112,    112,    112,    112,    112,
                176,    176,    176,    176,    176,    176,    176,    176,    176,    176,    /* 0x2350 */
                176,    176,    176,    176,    176,    176,    176,    176,    176,    176,
                176,    176,    176,    176,    176,    176,    176,    176,    176,    176,
                176,    176,    176,    176,    176,    176,    176,    176,    176,    176,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                56,     56,     56,     56,     56,     56,     56,     56,     56,     56,     /* 0x2380 */
                56,     56,     56,     56,     56,     56,     56,     56,     56,     56,
                56,     56,     56,     56,     56,     56,     56,     56,     56,     56,
                56,     56,     56,     56,     56,     56,     56,     56,     56,     56,
                120,    120,    120,    120,    120,    120,    120,    120,    120,    120,    /* 0x23a8 */
                120,    120,    120,    120,    120,    120,    120,    120,    120,    120,
                120,    120,    120,    120,    120,    120,    120,    120,    120,    120,
                120,    120,    120,    120,    120,    120,    120,    120,    120,    120,
                184,    184,    184,    184,    184,    184,    184,    184,    184,    184,    /* 0x23d0 */
                184,    184,    184,    184,    184,    184,    184,    184,    184,    184,
                184,    184,    184,    184,    184,    184,    184,    184,    184,    184,
                184,    184,    184,    184,    184,    184,    184,    184,    184,    184,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */

                1,      1,      1,      1,      1,      1,      1,      1,      1,      1,      /* 0x2400 */
                1,      1,      1,      1,      1,      1,      1,      1,      1,      1,
                1,      1,      1,      1,      1,      1,      1,      1,      1,      1,
                1,      1,      1,      1,      1,      1,      1,      1,      1,      1,
                65,     65,     65,     65,     65,     65,     65,     65,     65,     65,     /* 0x2428 */
                65,     65,     65,     65,     65,     65,     65,     65,     65,     65,
                65,     65,     65,     65,     65,     65,     65,     65,     65,     65,
                65,     65,     65,     65,     65,     65,     65,     65,     65,     65,
                129,    129,    129,    129,    129,    129,    129,    129,    129,    129,    /* 0x2450 */
                129,    129,    129,    129,    129,    129,    129,    129,    129,    129,
                129,    129,    129,    129,    129,    129,    129,    129,    129,    129,
                129,    129,    129,    129,    129,    129,    129,    129,    129,    129,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                9,      9,      9,      9,      9,      9,      9,      9,      9,      9,      /* 0x2480 */
                9,      9,      9,      9,      9,      9,      9,      9,      9,      9,
                9,      9,      9,      9,      9,      9,      9,      9,      9,      9,
                9,      9,      9,      9,      9,      9,      9,      9,      9,      9,
                73,     73,     73,     73,     73,     73,     73,     73,     73,     73,     /* 0x24a8 */
                73,     73,     73,     73,     73,     73,     73,     73,     73,     73,
                73,     73,     73,     73,     73,     73,     73,     73,     73,     73,
                73,     73,     73,     73,     73,     73,     73,     73,     73,     73,
                137,    137,    137,    137,    137,    137,    137,    137,    137,    137,    /* 0x24d0 */
                137,    137,    137,    137,    137,    137,    137,    137,    137,    137,
                137,    137,    137,    137,    137,    137,    137,    137,    137,    137,
                137,    137,    137,    137,    137,    137,    137,    137,    137,    137,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                17,     17,     17,     17,     17,     17,     17,     17,     17,     17,     /* 0x2500 */
                17,     17,     17,     17,     17,     17,     17,     17,     17,     17,
                17,     17,     17,     17,     17,     17,     17,     17,     17,     17,
                17,     17,     17,     17,     17,     17,     17,     17,     17,     17,
                81,     81,     81,     81,     81,     81,     81,     81,     81,     81,     /* 0x2528 */
                81,     81,     81,     81,     81,     81,     81,     81,     81,     81,
                81,     81,     81,     81,     81,     81,     81,     81,     81,     81,
                81,     81,     81,     81,     81,     81,     81,     81,     81,     81,
                145,    145,    145,    145,    145,    145,    145,    145,    145,    145,    /* 0x2550 */
                145,    145,    145,    145,    145,    145,    145,    145,    145,    145,
                145,    145,    145,    145,    145,    145,    145,    145,    145,    145,
                145,    145,    145,    145,    145,    145,    145,    145,    145,    145,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                25,     25,     25,     25,     25,     25,     25,     25,     25,     25,     /* 0x2580 */
                25,     25,     25,     25,     25,     25,     25,     25,     25,     25,
                25,     25,     25,     25,     25,     25,     25,     25,     25,     25,
                25,     25,     25,     25,     25,     25,     25,     25,     25,     25,
                89,     89,     89,     89,     89,     89,     89,     89,     89,     89,     /* 0x25a8 */
                89,     89,     89,     89,     89,     89,     89,     89,     89,     89,
                89,     89,     89,     89,     89,     89,     89,     89,     89,     89,
                89,     89,     89,     89,     89,     89,     89,     89,     89,     89,
                153,    153,    153,    153,    153,    153,    153,    153,    153,    153,    /* 0x25d0 */
                153,    153,    153,    153,    153,    153,    153,    153,    153,    153,
                153,    152,    153,    153,    153,    153,    153,    153,    153,    153,
                153,    153,    153,    153,    153,    153,    153,    153,    153,    153,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                33,     33,     33,     33,     33,     33,     33,     33,     33,     33,     /* 0x2600 */
                33,     33,     33,     33,     33,     33,     33,     33,     33,     33,
                33,     33,     33,     33,     33,     33,     33,     33,     33,     33,
                33,     33,     33,     33,     33,     33,     33,     33,     33,     33,
                97,     97,     97,     97,     97,     97,     97,     97,     97,     97,     /* 0x2628 */
                97,     97,     97,     97,     97,     97,     97,     97,     97,     97,
                97,     97,     97,     97,     97,     97,     97,     97,     97,     97,
                97,     97,     97,     97,     97,     97,     97,     97,     97,     97,
                161,    161,    161,    161,    161,    161,    161,    161,    161,    161,    /* 0x2650 */
                161,    161,    161,    161,    161,    161,    161,    161,    161,    161,
                161,    161,    161,    161,    161,    161,    161,    161,    161,    161,
                161,    161,    161,    161,    161,    161,    161,    161,    161,    161,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                41,     41,     41,     41,     41,     41,     41,     41,     41,     41,     /* 0x2680 */
                41,     41,     41,     41,     41,     41,     41,     41,     41,     41,
                41,     41,     41,     41,     41,     41,     41,     41,     41,     41,
                41,     41,     41,     41,     41,     41,     41,     41,     41,     41,
                105,    105,    105,    105,    105,    105,    105,    105,    105,    105,    /* 0x26a8 */
                105,    105,    105,    105,    105,    105,    105,    105,    105,    105,
                105,    105,    105,    105,    105,    105,    105,    105,    105,    105,
                105,    105,    105,    105,    105,    105,    105,    105,    105,    105,
                169,    169,    169,    169,    169,    169,    169,    169,    169,    169,    /* 0x26d0 */
                169,    169,    169,    169,    169,    169,    169,    169,    169,    169,
                169,    169,    169,    169,    169,    169,    169,    169,    169,    169,
                169,    169,    169,    169,    169,    169,    169,    169,    169,    169,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                49,     49,     49,     49,     49,     49,     49,     49,     49,     49,     /* 0x2700 */
                49,     49,     49,     49,     49,     49,     49,     49,     49,     49,
                49,     49,     49,     49,     49,     49,     49,     49,     49,     49,
                49,     49,     49,     49,     49,     49,     49,     49,     49,     49,
                113,    113,    113,    113,    113,    113,    113,    113,    113,    113,    /* 0x2728 */
                113,    113,    113,    113,    113,    113,    113,    113,    113,    113,
                113,    113,    113,    113,    113,    113,    113,    113,    113,    113,
                113,    113,    113,    113,    113,    113,    113,    113,    113,    113,
                177,    177,    177,    177,    177,    177,    177,    177,    177,    177,    /* 0x2750 */
                177,    177,    177,    177,    177,    177,    177,    177,    177,    177,
                177,    177,    177,    177,    177,    177,    177,    177,    177,    177,
                177,    177,    177,    177,    177,    177,    177,    177,    177,    177,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                57,     57,     57,     57,     57,     57,     57,     57,     57,     57,     /* 0x2780 */
                57,     57,     57,     57,     57,     57,     57,     57,     57,     57,
                57,     57,     57,     57,     57,     57,     57,     57,     57,     57,
                57,     57,     57,     57,     57,     57,     57,     57,     57,     57,
                121,    121,    121,    121,    121,    121,    121,    121,    121,    121,    /* 0x27a8 */
                121,    121,    121,    121,    121,    121,    121,    121,    121,    121,
                121,    121,    121,    121,    121,    121,    121,    121,    121,    121,
                121,    121,    121,    121,    121,    121,    121,    121,    121,    121,
                185,    185,    185,    185,    185,    185,    185,    185,    185,    185,    /* 0x27d0 */
                185,    185,    185,    185,    185,    185,    185,    185,    185,    185,
                185,    185,    185,    185,    185,    185,    185,    185,    185,    185,
                185,    185,    185,    185,    185,    185,    185,    185,    185,    185,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */

                2,      2,      2,      2,      2,      2,      2,      2,      2,      2,      /* 0x2800 */
                2,      2,      2,      2,      2,      2,      2,      2,      2,      2,
                2,      2,      2,      2,      2,      2,      2,      2,      2,      2,
                2,      2,      2,      2,      2,      2,      2,      2,      2,      2,
                66,     66,     66,     66,     66,     66,     66,     66,     66,     66,     /* 0x2828 */
                66,     66,     66,     66,     66,     66,     66,     66,     66,     66,
                66,     66,     66,     66,     66,     66,     66,     66,     66,     66,
                66,     66,     66,     66,     66,     66,     66,     66,     66,     66,
                130,    130,    130,    130,    130,    130,    130,    130,    130,    130,    /* 0x2850 */
                130,    130,    130,    130,    130,    130,    130,    130,    130,    130,
                130,    130,    130,    130,    130,    130,    130,    130,    130,    130,
                130,    130,    130,    130,    130,    130,    130,    130,    130,    130,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                10,     10,     10,     10,     10,     10,     10,     10,     10,     10,     /* 0x2880 */
                10,     10,     10,     10,     10,     10,     10,     10,     10,     10,
                10,     10,     10,     10,     10,     10,     10,     10,     10,     10,
                10,     10,     10,     10,     10,     10,     10,     10,     10,     10,
                74,     74,     74,     74,     74,     74,     74,     74,     74,     74,     /* 0x28a8 */
                74,     74,     74,     74,     74,     74,     74,     74,     74,     74,
                74,     74,     74,     74,     74,     74,     74,     74,     74,     74,
                74,     74,     74,     74,     74,     74,     74,     74,     74,     74,
                138,    138,    138,    138,    138,    138,    138,    138,    138,    138,    /* 0x28d0 */
                138,    138,    138,    138,    138,    138,    138,    138,    138,    138,
                138,    138,    138,    138,    138,    138,    138,    138,    138,    138,
                138,    138,    138,    138,    138,    138,    138,    138,    138,    138,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                18,     18,     18,     18,     18,     18,     18,     18,     18,     18,     /* 0x2900 */
                18,     18,     18,     18,     18,     18,     18,     18,     18,     18,
                18,     18,     18,     18,     18,     18,     18,     18,     18,     18,
                18,     18,     18,     18,     18,     18,     18,     18,     18,     18,
                82,     82,     82,     82,     82,     82,     82,     82,     82,     82,     /* 0x2928 */
                82,     82,     82,     82,     82,     82,     82,     82,     82,     82,
                82,     82,     82,     82,     82,     82,     82,     82,     82,     82,
                82,     82,     82,     82,     82,     82,     82,     82,     82,     82,
                146,    146,    146,    146,    146,    146,    146,    146,    146,    146,    /* 0x2950 */
                146,    146,    146,    146,    146,    146,    146,    146,    146,    146,
                146,    146,    146,    146,    146,    146,    146,    146,    146,    146,
                146,    146,    146,    146,    146,    146,    146,    146,    146,    146,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                26,     26,     26,     26,     26,     26,     26,     26,     26,     26,     /* 0x2980 */
                26,     26,     26,     26,     26,     26,     26,     26,     26,     26,
                26,     26,     26,     26,     26,     26,     26,     26,     26,     26,
                26,     26,     26,     26,     26,     26,     26,     26,     26,     26,
                90,     90,     90,     90,     90,     90,     90,     90,     90,     90,     /* 0x29a8 */
                90,     90,     90,     90,     90,     90,     90,     90,     90,     90,
                90,     90,     90,     90,     90,     90,     90,     90,     90,     90,
                90,     90,     90,     90,     90,     90,     90,     90,     90,     90,
                154,    154,    154,    154,    154,    154,    154,    154,    154,    154,    /* 0x29d0 */
                154,    154,    154,    154,    154,    154,    154,    154,    154,    154,
                154,    154,    154,    154,    154,    154,    154,    154,    154,    154,
                154,    154,    154,    154,    154,    154,    154,    154,    154,    154,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                34,     34,     34,     34,     34,     34,     34,     34,     34,     34,     /* 0x2a00 */
                34,     34,     34,     34,     34,     34,     34,     34,     34,     34,
                34,     34,     34,     34,     34,     34,     34,     34,     34,     34,
                34,     34,     34,     34,     34,     34,     34,     34,     34,     34,
                98,     98,     98,     98,     98,     98,     98,     98,     98,     98,     /* 0x2a28 */
                98,     98,     98,     98,     98,     98,     98,     98,     98,     98,
                98,     98,     98,     98,     98,     98,     98,     98,     98,     98,
                98,     98,     98,     98,     98,     98,     98,     98,     98,     98,
                162,    162,    162,    162,    162,    162,    162,    162,    162,    162,    /* 0x2a50 */
                162,    162,    162,    162,    162,    162,    162,    162,    162,    162,
                162,    162,    162,    162,    162,    162,    162,    162,    162,    162,
                162,    162,    162,    162,    162,    162,    162,    162,    162,    162,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                42,     42,     42,     42,     42,     42,     42,     42,     42,     42,     /* 0x2a80 */
                42,     42,     42,     42,     42,     42,     42,     42,     42,     42,
                42,     42,     42,     42,     42,     42,     42,     42,     42,     42,
                42,     42,     42,     42,     42,     42,     42,     42,     42,     42,
                106,    106,    106,    106,    106,    106,    106,    106,    106,    106,    /* 0x2aa8 */
                106,    106,    106,    106,    106,    106,    106,    106,    106,    106,
                106,    106,    106,    106,    106,    106,    106,    106,    106,    106,
                106,    106,    106,    106,    106,    106,    106,    106,    106,    106,
                170,    170,    170,    170,    170,    170,    170,    170,    170,    170,    /* 0x2ad0 */
                170,    170,    170,    170,    170,    170,    170,    170,    170,    170,
                170,    170,    170,    170,    170,    170,    170,    170,    170,    170,
                170,    170,    170,    170,    170,    170,    170,    170,    170,    170,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                50,     50,     50,     50,     50,     50,     50,     50,     50,     50,     /* 0x2b00 */
                50,     50,     50,     50,     50,     50,     50,     50,     50,     50,
                50,     50,     50,     50,     50,     50,     50,     50,     50,     50,
                50,     50,     50,     50,     50,     50,     50,     50,     50,     50,
                114,    114,    114,    114,    114,    114,    114,    114,    114,    114,    /* 0x2b28 */
                114,    114,    114,    114,    114,    114,    114,    114,    114,    114,
                114,    114,    114,    114,    114,    114,    114,    114,    114,    114,
                114,    114,    114,    114,    114,    114,    114,    114,    114,    114,
                178,    178,    178,    178,    178,    178,    178,    178,    178,    178,    /* 0x2b50 */
                178,    178,    178,    178,    178,    178,    178,    178,    178,    178,
                178,    178,    178,    178,    178,    178,    178,    178,    178,    178,
                178,    178,    178,    178,    178,    178,    178,    178,    178,    178,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                58,     58,     58,     58,     58,     58,     58,     58,     58,     58,     /* 0x2b80 */
                58,     58,     58,     58,     58,     58,     58,     58,     58,     58,
                58,     58,     58,     58,     58,     58,     58,     58,     58,     58,
                58,     58,     58,     58,     58,     58,     58,     58,     58,     58,
                122,    122,    122,    122,    122,    122,    122,    122,    122,    122,    /* 0x2ba8 */
                122,    122,    122,    122,    122,    122,    122,    122,    122,    122,
                122,    122,    122,    122,    122,    122,    122,    122,    122,    122,
                122,    122,    122,    122,    122,    122,    122,    122,    122,    122,
                186,    186,    186,    186,    186,    186,    186,    186,    186,    186,    /* 0x2bd0 */
                186,    186,    186,    186,    186,    186,    186,    186,    186,    186,
                186,    186,    186,    186,    186,    186,    186,    186,    186,    186,
                186,    186,    186,    186,    186,    186,    186,    186,    186,    186,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */

                3,      3,      3,      3,      3,      3,      3,      3,      3,      3,      /* 0x2c00 */
                3,      3,      3,      3,      3,      3,      3,      3,      3,      3,
                3,      3,      3,      3,      3,      3,      3,      3,      3,      3,
                3,      3,      3,      3,      3,      3,      3,      3,      3,      3,
                67,     67,     67,     67,     67,     67,     67,     67,     67,     67,     /* 0x2c28 */
                67,     67,     67,     67,     67,     67,     67,     67,     67,     67,
                67,     67,     67,     67,     67,     67,     67,     67,     67,     67,
                67,     67,     67,     67,     67,     67,     67,     67,     67,     67,
                131,    131,    131,    131,    131,    131,    131,    131,    131,    131,    /* 0x2c50 */
                131,    131,    131,    131,    131,    131,    131,    131,    131,    131,
                131,    131,    131,    131,    131,    131,    131,    131,    131,    131,
                131,    131,    131,    131,    131,    131,    131,    131,    131,    131,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                11,     11,     11,     11,     11,     11,     11,     11,     11,     11,     /* 0x2c80 */
                11,     11,     11,     11,     11,     11,     11,     11,     11,     11,
                11,     11,     11,     11,     11,     11,     11,     11,     11,     11,
                11,     11,     11,     11,     11,     11,     11,     11,     11,     11,
                75,     75,     75,     75,     75,     75,     75,     75,     75,     75,     /* 0x2ca8 */
                75,     75,     75,     75,     75,     75,     75,     75,     75,     75,
                75,     75,     75,     75,     75,     75,     75,     75,     75,     75,
                75,     75,     75,     75,     75,     75,     75,     75,     75,     75,
                139,    139,    139,    139,    139,    139,    139,    139,    139,    139,    /* 0x2cd0 */
                139,    139,    139,    139,    139,    139,    139,    139,    139,    139,
                139,    139,    139,    139,    139,    139,    139,    139,    139,    139,
                139,    139,    139,    139,    139,    139,    139,    139,    139,    139,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                19,     19,     19,     19,     19,     19,     19,     19,     19,     19,     /* 0x2d00 */
                19,     19,     19,     19,     19,     19,     19,     19,     19,     19,
                19,     19,     19,     19,     19,     19,     19,     19,     19,     19,
                19,     19,     19,     19,     19,     19,     19,     19,     19,     19,
                83,     83,     83,     83,     83,     83,     83,     83,     83,     83,     /* 0x2d28 */
                83,     83,     83,     83,     83,     83,     83,     83,     83,     83,
                83,     83,     83,     83,     83,     83,     83,     83,     83,     83,
                83,     83,     83,     83,     83,     83,     83,     83,     83,     83,
                147,    147,    147,    147,    147,    147,    147,    147,    147,    147,    /* 0x2d50 */
                147,    147,    147,    147,    147,    147,    147,    147,    147,    147,
                147,    147,    147,    147,    147,    147,    147,    147,    147,    147,
                147,    147,    147,    147,    147,    147,    147,    147,    147,    147,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                27,     27,     27,     27,     27,     27,     27,     27,     27,     27,     /* 0x2d80 */
                27,     27,     27,     27,     27,     27,     27,     27,     27,     27,
                27,     27,     27,     27,     27,     27,     27,     27,     27,     27,
                27,     27,     27,     27,     27,     27,     27,     27,     27,     27,
                91,     91,     91,     91,     91,     91,     91,     91,     91,     91,     /* 0x2da8 */
                91,     91,     91,     91,     91,     91,     91,     91,     91,     91,
                91,     91,     91,     91,     91,     91,     91,     91,     91,     91,
                91,     91,     91,     91,     91,     91,     91,     91,     91,     91,
                155,    155,    155,    155,    155,    155,    155,    155,    155,    155,    /* 0x2dd0 */
                155,    155,    155,    155,    155,    155,    155,    155,    155,    155,
                155,    155,    155,    155,    155,    155,    155,    155,    155,    155,
                155,    155,    155,    155,    155,    155,    155,    155,    155,    155,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                35,     35,     35,     35,     35,     35,     35,     35,     35,     35,     /* 0x2e00 */
                35,     35,     35,     35,     35,     35,     35,     35,     35,     35,
                35,     35,     35,     35,     35,     35,     35,     35,     35,     35,
                35,     35,     35,     35,     35,     35,     35,     35,     35,     35,
                99,     99,     99,     99,     99,     99,     99,     99,     99,     99,     /* 0x2e28 */
                99,     99,     99,     99,     99,     99,     99,     99,     99,     99,
                99,     99,     99,     99,     99,     99,     99,     99,     99,     99,
                99,     99,     99,     99,     99,     99,     99,     99,     99,     99,
                163,    163,    163,    163,    163,    163,    163,    163,    163,    163,    /* 0x2e50 */
                163,    163,    163,    163,    163,    163,    163,    163,    163,    163,
                163,    163,    163,    163,    163,    163,    163,    163,    163,    163,
                163,    163,    163,    163,    163,    163,    163,    163,    163,    163,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                43,     43,     43,     43,     43,     43,     43,     43,     43,     43,     /* 0x2e80 */
                43,     43,     43,     43,     43,     43,     43,     43,     43,     43,
                43,     43,     43,     43,     43,     43,     43,     43,     43,     43,
                43,     43,     43,     43,     43,     43,     43,     43,     43,     43,
                107,    107,    107,    107,    107,    107,    107,    107,    107,    107,    /* 0x2ea8 */
                107,    107,    107,    107,    107,    107,    107,    107,    107,    107,
                107,    107,    107,    107,    107,    107,    107,    107,    107,    107,
                107,    107,    107,    107,    107,    107,    107,    107,    107,    107,
                171,    171,    171,    171,    171,    171,    171,    171,    171,    171,    /* 0x2ed0 */
                171,    171,    171,    171,    171,    171,    171,    171,    171,    171,
                171,    171,    171,    171,    171,    171,    171,    171,    171,    171,
                171,    171,    171,    171,    171,    171,    171,    171,    171,    171,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                51,     51,     51,     51,     51,     51,     51,     51,     51,     51,     /* 0x2f00 */
                51,     51,     51,     51,     51,     51,     51,     51,     51,     51,
                51,     51,     51,     51,     51,     51,     51,     51,     51,     51,
                51,     51,     51,     51,     51,     51,     51,     51,     51,     51,
                115,    115,    115,    115,    115,    115,    115,    115,    115,    115,    /* 0x2f28 */
                115,    115,    115,    115,    115,    115,    115,    115,    115,    115,
                115,    115,    115,    115,    115,    115,    115,    115,    115,    115,
                115,    115,    115,    115,    115,    115,    115,    115,    115,    115,
                179,    179,    179,    179,    179,    179,    179,    179,    179,    179,    /* 0x2f50 */
                179,    179,    179,    179,    179,    179,    179,    179,    179,    179,
                179,    179,    179,    179,    179,    179,    179,    179,    179,    179,
                179,    179,    179,    179,    179,    179,    179,    179,    179,    179,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                59,     59,     59,     59,     59,     59,     59,     59,     59,     59,     /* 0x2f80 */
                59,     59,     59,     59,     59,     59,     59,     59,     59,     59,
                59,     59,     59,     59,     59,     59,     59,     59,     59,     59,
                59,     59,     59,     59,     59,     59,     59,     59,     59,     59,
                123,    123,    123,    123,    123,    123,    123,    123,    123,    123,    /* 0x2fa8 */
                123,    123,    123,    123,    123,    123,    123,    123,    123,    123,
                123,    123,    123,    123,    123,    123,    123,    123,    123,    123,
                123,    123,    123,    123,    123,    123,    123,    123,    123,    123,
                187,    187,    187,    187,    187,    187,    187,    187,    187,    187,    /* 0x2fd0 */
                187,    187,    187,    187,    187,    187,    187,    187,    187,    187,
                187,    187,    187,    187,    187,    187,    187,    187,    187,    187,
                187,    187,    187,    187,    187,    187,    187,    187,    187,    187,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */

                4,      4,      4,      4,      4,      4,      4,      4,      4,      4,      /* 0x3000 */
                4,      4,      4,      4,      4,      4,      4,      4,      4,      4,
                4,      4,      4,      4,      4,      4,      4,      4,      4,      4,
                4,      4,      4,      4,      4,      4,      4,      4,      4,      4,
                68,     68,     68,     68,     68,     68,     68,     68,     68,     68,     /* 0x3028 */
                68,     68,     68,     68,     68,     68,     68,     68,     68,     68,
                68,     68,     68,     68,     68,     68,     68,     68,     68,     68,
                68,     68,     68,     68,     68,     68,     68,     68,     68,     68,
                132,    132,    132,    132,    132,    132,    132,    132,    132,    132,    /* 0x3050 */
                132,    132,    132,    132,    132,    132,    132,    132,    132,    132,
                132,    132,    132,    132,    132,    132,    132,    132,    132,    132,
                132,    132,    132,    132,    132,    132,    132,    132,    132,    132,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                12,     12,     12,     12,     12,     12,     12,     12,     12,     12,     /* 0x3080 */
                12,     12,     12,     12,     12,     12,     12,     12,     12,     12,
                12,     12,     12,     12,     12,     12,     12,     12,     12,     12,
                12,     12,     12,     12,     12,     12,     12,     12,     12,     12,
                76,     76,     76,     76,     76,     76,     76,     76,     76,     76,     /* 0x30a8 */
                76,     76,     76,     76,     76,     76,     76,     76,     76,     76,
                76,     76,     76,     76,     76,     76,     76,     76,     76,     76,
                76,     76,     76,     76,     76,     76,     76,     76,     76,     76,
                140,    140,    140,    140,    140,    140,    140,    140,    140,    140,    /* 0x30d0 */
                140,    140,    140,    140,    140,    140,    140,    140,    140,    140,
                140,    140,    140,    140,    140,    140,    140,    140,    140,    140,
                140,    140,    140,    140,    140,    140,    140,    140,    140,    140,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                20,     20,     20,     20,     20,     20,     20,     20,     20,     20,     /* 0x3100 */
                20,     20,     20,     20,     20,     20,     20,     20,     20,     20,
                20,     20,     20,     20,     20,     20,     20,     20,     20,     20,
                20,     20,     20,     20,     20,     20,     20,     20,     20,     20,
                84,     84,     84,     84,     84,     84,     84,     84,     84,     84,     /* 0x3128 */
                84,     84,     84,     84,     84,     84,     84,     84,     84,     84,
                84,     84,     84,     84,     84,     84,     84,     84,     84,     84,
                84,     84,     84,     84,     84,     84,     84,     84,     84,     84,
                148,    148,    148,    148,    148,    148,    148,    148,    148,    148,    /* 0x3150 */
                148,    148,    148,    148,    148,    148,    148,    148,    148,    148,
                148,    148,    148,    148,    148,    148,    148,    148,    148,    148,
                148,    148,    148,    148,    148,    148,    148,    148,    148,    148,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                28,     28,     28,     28,     28,     28,     28,     28,     28,     28,     /* 0x3180 */
                28,     28,     28,     28,     28,     28,     28,     28,     28,     28,
                28,     28,     28,     28,     28,     28,     28,     28,     28,     28,
                28,     28,     28,     28,     28,     28,     28,     28,     28,     28,
                92,     92,     92,     92,     92,     92,     92,     92,     92,     92,     /* 0x31a8 */
                92,     92,     92,     92,     92,     92,     92,     92,     92,     92,
                92,     92,     92,     92,     92,     92,     92,     92,     92,     92,
                92,     92,     92,     92,     92,     92,     92,     92,     92,     92,
                156,    156,    156,    156,    156,    156,    156,    156,    156,    156,    /* 0x31d0 */
                156,    156,    156,    156,    156,    156,    156,    156,    156,    156,
                156,    156,    156,    156,    156,    156,    156,    156,    156,    156,
                156,    156,    156,    156,    156,    156,    156,    156,    156,    156,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                36,     36,     36,     36,     36,     36,     36,     36,     36,     36,     /* 0x3200 */
                36,     36,     36,     36,     36,     36,     36,     36,     36,     36,
                36,     36,     36,     36,     36,     36,     36,     36,     36,     36,
                36,     36,     36,     36,     36,     36,     36,     36,     36,     36,
                100,    100,    100,    100,    100,    100,    100,    100,    100,    100,    /* 0x3228 */
                100,    100,    100,    100,    100,    100,    100,    100,    100,    100,
                100,    100,    100,    100,    100,    100,    100,    100,    100,    100,
                100,    100,    100,    100,    100,    100,    100,    100,    100,    100,
                164,    164,    164,    164,    164,    164,    164,    164,    164,    164,    /* 0x3250 */
                164,    164,    164,    164,    164,    164,    164,    164,    164,    164,
                164,    164,    164,    164,    164,    164,    164,    164,    164,    164,
                164,    164,    164,    164,    164,    164,    164,    164,    164,    164,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                44,     44,     44,     44,     44,     44,     44,     44,     44,     44,     /* 0x3280 */
                44,     44,     44,     44,     44,     44,     44,     44,     44,     44,
                44,     44,     44,     44,     44,     44,     44,     44,     44,     44,
                44,     44,     44,     44,     44,     44,     44,     44,     44,     44,
                108,    108,    108,    108,    108,    108,    108,    108,    108,    108,    /* 0x32a8 */
                108,    108,    108,    108,    108,    108,    108,    108,    108,    108,
                108,    108,    108,    108,    108,    108,    108,    108,    108,    108,
                108,    108,    108,    108,    108,    108,    108,    108,    108,    108,
                172,    172,    172,    172,    172,    172,    172,    172,    172,    172,    /* 0x32d0 */
                172,    172,    172,    172,    172,    172,    172,    172,    172,    172,
                172,    172,    172,    172,    172,    172,    172,    172,    172,    172,
                172,    172,    172,    172,    172,    172,    172,    172,    172,    172,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                52,     52,     52,     52,     52,     52,     52,     52,     52,     52,     /* 0x3300 */
                52,     52,     52,     52,     52,     52,     52,     52,     52,     52,
                52,     52,     52,     52,     52,     52,     52,     52,     52,     52,
                52,     52,     52,     52,     52,     52,     52,     52,     52,     52,
                116,    116,    116,    116,    116,    116,    116,    116,    116,    116,    /* 0x3328 */
                116,    116,    116,    116,    116,    116,    116,    116,    116,    116,
                116,    116,    116,    116,    116,    116,    116,    116,    116,    116,
                116,    116,    116,    116,    116,    116,    116,    116,    116,    116,
                180,    180,    180,    180,    180,    180,    180,    180,    180,    180,    /* 0x3350 */
                180,    180,    180,    180,    180,    180,    180,    180,    180,    180,
                180,    180,    180,    180,    180,    180,    180,    180,    180,    180,
                180,    180,    180,    180,    180,    180,    180,    180,    180,    180,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                60,     60,     60,     60,     60,     60,     60,     60,     60,     60,     /* 0x3380 */
                60,     60,     60,     60,     60,     60,     60,     60,     60,     60,
                60,     60,     60,     60,     60,     60,     60,     60,     60,     60,
                60,     60,     60,     60,     60,     60,     60,     60,     60,     60,
                124,    124,    124,    124,    124,    124,    124,    124,    124,    124,    /* 0x33a8 */
                124,    124,    124,    124,    124,    124,    124,    124,    124,    124,
                124,    124,    124,    124,    124,    124,    124,    124,    124,    124,
                124,    124,    124,    124,    124,    124,    124,    124,    124,    124,
                188,    188,    188,    188,    188,    188,    188,    188,    188,    188,    /* 0x33d0 */
                188,    188,    188,    188,    188,    188,    188,    188,    188,    188,
                188,    188,    188,    188,    188,    188,    188,    188,    188,    188,
                188,    188,    188,    188,    188,    188,    188,    188,    188,    188,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */

                5,      5,      5,      5,      5,      5,      5,      5,      5,      5,      /* 0x3400 */
                5,      5,      5,      5,      5,      5,      5,      5,      5,      5,
                5,      5,      5,      5,      5,      5,      5,      5,      5,      5,
                5,      5,      5,      5,      5,      5,      5,      5,      5,      5,
                69,     69,     69,     69,     69,     69,     69,     69,     69,     69,     /* 0x3428 */
                69,     69,     69,     69,     69,     69,     69,     69,     69,     69,
                69,     69,     69,     69,     69,     69,     69,     69,     69,     69,
                69,     69,     69,     69,     69,     69,     69,     69,     69,     69,
                133,    133,    133,    133,    133,    133,    133,    133,    133,    133,    /* 0x3450 */
                133,    133,    133,    133,    133,    133,    133,    133,    133,    133,
                133,    133,    133,    133,    133,    133,    133,    133,    133,    133,
                133,    133,    133,    133,    133,    133,    133,    133,    133,    133,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                13,     13,     13,     13,     13,     13,     13,     13,     13,     13,     /* 0x3480 */
                13,     13,     13,     13,     13,     13,     13,     13,     13,     13,
                13,     13,     13,     13,     13,     13,     13,     13,     13,     13,
                13,     13,     13,     13,     13,     13,     13,     13,     13,     13,
                77,     77,     77,     77,     77,     77,     77,     77,     77,     77,     /* 0x34a8 */
                77,     77,     77,     77,     77,     77,     77,     77,     77,     77,
                77,     77,     77,     77,     77,     77,     77,     77,     77,     77,
                77,     77,     77,     77,     77,     77,     77,     77,     77,     77,
                141,    141,    141,    141,    141,    141,    141,    141,    141,    141,    /* 0x34d0 */
                141,    141,    141,    141,    141,    141,    141,    141,    141,    141,
                141,    141,    141,    141,    141,    141,    141,    141,    141,    141,
                141,    141,    141,    141,    141,    141,    141,    141,    141,    141,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                21,     21,     21,     21,     21,     21,     21,     21,     21,     21,     /* 0x3500 */
                21,     21,     21,     21,     21,     21,     21,     21,     21,     21,
                21,     21,     21,     21,     21,     21,     21,     21,     21,     21,
                21,     21,     21,     21,     21,     21,     21,     21,     21,     21,
                85,     85,     85,     85,     85,     85,     85,     85,     85,     85,     /* 0x3528 */
                85,     85,     85,     85,     85,     85,     85,     85,     85,     85,
                85,     85,     85,     85,     85,     85,     85,     85,     85,     85,
                85,     85,     85,     85,     85,     85,     85,     85,     85,     85,
                149,    149,    149,    149,    149,    149,    149,    149,    149,    149,    /* 0x3550 */
                149,    149,    149,    149,    149,    149,    149,    149,    149,    149,
                149,    149,    149,    149,    149,    149,    149,    149,    149,    149,
                149,    149,    149,    149,    149,    149,    149,    149,    149,    149,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                29,     29,     29,     29,     29,     29,     29,     29,     29,     29,     /* 0x3580 */
                29,     29,     29,     29,     29,     29,     29,     29,     29,     29,
                29,     29,     29,     29,     29,     29,     29,     29,     29,     29,
                29,     29,     29,     29,     29,     29,     29,     29,     29,     29,
                93,     93,     93,     93,     93,     93,     93,     93,     93,     93,     /* 0x35a8 */
                93,     93,     93,     93,     93,     93,     93,     93,     93,     93,
                93,     93,     93,     93,     93,     93,     93,     93,     93,     93,
                93,     93,     93,     93,     93,     93,     93,     93,     93,     93,
                157,    157,    157,    157,    157,    157,    157,    157,    157,    157,    /* 0x35d0 */
                157,    157,    157,    157,    157,    157,    157,    157,    157,    157,
                157,    157,    157,    157,    157,    157,    157,    157,    157,    157,
                157,    157,    157,    157,    157,    157,    157,    157,    157,    157,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                37,     37,     37,     37,     37,     37,     37,     37,     37,     37,     /* 0x3600 */
                37,     37,     37,     37,     37,     37,     37,     37,     37,     37,
                37,     37,     37,     37,     37,     37,     37,     37,     37,     37,
                37,     37,     37,     37,     37,     37,     37,     37,     37,     37,
                101,    101,    101,    101,    101,    101,    101,    101,    101,    101,    /* 0x3628 */
                101,    101,    101,    101,    101,    101,    101,    101,    101,    101,
                101,    101,    101,    101,    101,    101,    101,    101,    101,    101,
                101,    101,    101,    101,    101,    101,    101,    101,    101,    101,
                165,    165,    165,    165,    165,    165,    165,    165,    165,    165,    /* 0x3650 */
                165,    165,    165,    165,    165,    165,    165,    165,    165,    165,
                165,    165,    165,    165,    165,    165,    165,    165,    165,    165,
                165,    165,    165,    165,    165,    165,    165,    165,    165,    165,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                45,     45,     45,     45,     45,     45,     45,     45,     45,     45,     /* 0x3680 */
                45,     45,     45,     45,     45,     45,     45,     45,     45,     45,
                45,     45,     45,     45,     45,     45,     45,     45,     45,     45,
                45,     45,     45,     45,     45,     45,     45,     45,     45,     45,
                109,    109,    109,    109,    109,    109,    109,    109,    109,    109,    /* 0x36a8 */
                109,    109,    109,    109,    109,    109,    109,    109,    109,    109,
                109,    109,    109,    109,    109,    109,    109,    109,    109,    109,
                109,    109,    109,    109,    109,    109,    109,    109,    109,    109,
                173,    173,    173,    173,    173,    173,    173,    173,    173,    173,    /* 0x36d0 */
                173,    173,    173,    173,    173,    173,    173,    173,    173,    173,
                173,    173,    173,    173,    173,    173,    173,    173,    173,    173,
                173,    173,    173,    173,    173,    173,    173,    173,    173,    173,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                53,     53,     53,     53,     53,     53,     53,     53,     53,     53,     /* 0x3700 */
                53,     53,     53,     53,     53,     53,     53,     53,     53,     53,
                53,     53,     53,     53,     53,     53,     53,     53,     53,     53,
                53,     53,     53,     53,     53,     53,     53,     53,     53,     53,
                117,    117,    117,    117,    117,    117,    117,    117,    117,    117,    /* 0x3728 */
                117,    117,    117,    117,    117,    117,    117,    117,    117,    117,
                117,    117,    117,    117,    117,    117,    117,    117,    117,    117,
                117,    117,    117,    117,    117,    117,    117,    117,    117,    117,
                181,    181,    181,    181,    181,    181,    181,    181,    181,    181,    /* 0x3750 */
                181,    181,    181,    181,    181,    181,    181,    181,    181,    181,
                181,    181,    181,    181,    181,    181,    181,    181,    181,    181,
                181,    181,    181,    181,    181,    181,    181,    181,    181,    181,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                61,     61,     61,     61,     61,     61,     61,     61,     61,     61,     /* 0x3780 */
                61,     61,     61,     61,     61,     61,     61,     61,     61,     61,
                61,     61,     61,     61,     61,     61,     61,     61,     61,     61,
                61,     61,     61,     61,     61,     61,     61,     61,     61,     61,
                125,    125,    125,    125,    125,    125,    125,    125,    125,    125,    /* 0x37a8 */
                125,    125,    125,    125,    125,    125,    125,    125,    125,    125,
                125,    125,    125,    125,    125,    125,    125,    125,    125,    125,
                125,    125,    125,    125,    125,    125,    125,    125,    125,    125,
                189,    189,    189,    189,    189,    189,    189,    189,    189,    189,    /* 0x37d0 */
                189,    189,    189,    189,    189,    189,    189,    189,    189,    189,
                189,    189,    189,    189,    189,    189,    189,    189,    189,    189,
                189,    189,    189,    189,    189,    189,    189,    189,    189,    189,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */

                6,      6,      6,      6,      6,      6,      6,      6,      6,      6,      /* 0x3800 */
                6,      6,      6,      6,      6,      6,      6,      6,      6,      6,
                6,      6,      6,      6,      6,      6,      6,      6,      6,      6,
                6,      6,      6,      6,      6,      6,      6,      6,      6,      6,
                70,     70,     70,     70,     70,     70,     70,     70,     70,     70,     /* 0x3828 */
                70,     70,     70,     70,     70,     70,     70,     70,     70,     70,
                70,     70,     70,     70,     70,     70,     70,     70,     70,     70,
                70,     70,     70,     70,     70,     70,     70,     70,     70,     70,
                134,    134,    134,    134,    134,    134,    134,    134,    134,    134,    /* 0x3850 */
                134,    134,    134,    134,    134,    134,    134,    134,    134,    134,
                134,    134,    134,    134,    134,    134,    134,    134,    134,    134,
                134,    134,    134,    134,    134,    134,    134,    134,    134,    134,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                14,     14,     14,     14,     14,     14,     14,     14,     14,     14,     /* 0x3880 */
                14,     14,     14,     14,     14,     14,     14,     14,     14,     14,
                14,     14,     14,     14,     14,     14,     14,     14,     14,     14,
                14,     14,     14,     14,     14,     14,     14,     14,     14,     14,
                78,     78,     78,     78,     78,     78,     78,     78,     78,     78,     /* 0x38a8 */
                78,     78,     78,     78,     78,     78,     78,     78,     78,     78,
                78,     78,     78,     78,     78,     78,     78,     78,     78,     78,
                78,     78,     78,     78,     78,     78,     78,     78,     78,     78,
                142,    142,    142,    142,    142,    142,    142,    142,    142,    142,    /* 0x38d0 */
                142,    142,    142,    142,    142,    142,    142,    142,    142,    142,
                142,    142,    142,    142,    142,    142,    142,    142,    142,    142,
                142,    142,    142,    142,    142,    142,    142,    142,    142,    142,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                22,     22,     22,     22,     22,     22,     22,     22,     22,     22,     /* 0x3900 */
                22,     22,     22,     22,     22,     22,     22,     22,     22,     22,
                22,     22,     22,     22,     22,     22,     22,     22,     22,     22,
                22,     22,     22,     22,     22,     22,     22,     22,     22,     22,
                86,     86,     86,     86,     86,     86,     86,     86,     86,     86,     /* 0x3928 */
                86,     86,     86,     86,     86,     86,     86,     86,     86,     86,
                86,     86,     86,     86,     86,     86,     86,     86,     86,     86,
                86,     86,     86,     86,     86,     86,     86,     86,     86,     86,
                150,    150,    150,    150,    150,    150,    150,    150,    150,    150,    /* 0x3950 */
                150,    150,    150,    150,    150,    150,    150,    150,    150,    150,
                150,    150,    150,    150,    150,    150,    150,    150,    150,    150,
                150,    150,    150,    150,    150,    150,    150,    150,    150,    150,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                30,     30,     30,     30,     30,     30,     30,     30,     30,     30,     /* 0x3980 */
                30,     30,     30,     30,     30,     30,     30,     30,     30,     30,
                30,     30,     30,     30,     30,     30,     30,     30,     30,     30,
                30,     30,     30,     30,     30,     30,     30,     30,     30,     30,
                94,     94,     94,     94,     94,     94,     94,     94,     94,     94,     /* 0x39a8 */
                94,     94,     94,     94,     94,     94,     94,     94,     94,     94,
                94,     94,     94,     94,     94,     94,     94,     94,     94,     94,
                94,     94,     94,     94,     94,     94,     94,     94,     94,     94,
                158,    158,    158,    158,    158,    158,    158,    158,    158,    158,    /* 0x39d0 */
                158,    158,    158,    158,    158,    158,    158,    158,    158,    158,
                158,    158,    158,    158,    158,    158,    158,    158,    158,    158,
                158,    158,    158,    158,    158,    158,    158,    158,    158,    158,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                38,     38,     38,     38,     38,     38,     38,     38,     38,     38,     /* 0x3a00 */
                38,     38,     38,     38,     38,     38,     38,     38,     38,     38,
                38,     38,     38,     38,     38,     38,     38,     38,     38,     38,
                38,     38,     38,     38,     38,     38,     38,     38,     38,     38,
                102,    102,    102,    102,    102,    102,    102,    102,    102,    102,    /* 0x3a28 */
                102,    102,    102,    102,    102,    102,    102,    102,    102,    102,
                102,    102,    102,    102,    102,    102,    102,    102,    102,    102,
                102,    102,    102,    102,    102,    102,    102,    102,    102,    102,
                166,    166,    166,    166,    166,    166,    166,    166,    166,    166,    /* 0x3a50 */
                166,    166,    166,    166,    166,    166,    166,    166,    166,    166,
                166,    166,    166,    166,    166,    166,    166,    166,    166,    166,
                166,    166,    166,    166,    166,    166,    166,    166,    166,    166,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                46,     46,     46,     46,     46,     46,     46,     46,     46,     46,     /* 0x3a80 */
                46,     46,     46,     46,     46,     46,     46,     46,     46,     46,
                46,     46,     46,     46,     46,     46,     46,     46,     46,     46,
                46,     46,     46,     46,     46,     46,     46,     46,     46,     46,
                110,    110,    110,    110,    110,    110,    110,    110,    110,    110,    /* 0x3aa8 */
                110,    110,    110,    110,    110,    110,    110,    110,    110,    110,
                110,    110,    110,    110,    110,    110,    110,    110,    110,    110,
                110,    110,    110,    110,    110,    110,    110,    110,    110,    110,
                174,    174,    174,    174,    174,    174,    174,    174,    174,    174,    /* 0x3ad0 */
                174,    174,    174,    174,    174,    174,    174,    174,    174,    174,
                174,    174,    174,    174,    174,    174,    174,    174,    174,    174,
                174,    174,    174,    174,    174,    174,    174,    174,    174,    174,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                54,     54,     54,     54,     54,     54,     54,     54,     54,     54,     /* 0x3b00 */
                54,     54,     54,     54,     54,     54,     54,     54,     54,     54,
                54,     54,     54,     54,     54,     54,     54,     54,     54,     54,
                54,     54,     54,     54,     54,     54,     54,     54,     54,     54,
                118,    118,    118,    118,    118,    118,    118,    118,    118,    118,    /* 0x3b28 */
                118,    118,    118,    118,    118,    118,    118,    118,    118,    118,
                118,    118,    118,    118,    118,    118,    118,    118,    118,    118,
                118,    118,    118,    118,    118,    118,    118,    118,    118,    118,
                182,    182,    182,    182,    182,    182,    182,    182,    182,    182,    /* 0x3b50 */
                182,    182,    182,    182,    182,    182,    182,    182,    182,    182,
                182,    182,    182,    182,    182,    182,    182,    182,    182,    182,
                182,    182,    182,    182,    182,    182,    182,    182,    182,    182,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                62,     62,     62,     62,     62,     62,     62,     62,     62,     62,     /* 0x3b80 */
                62,     62,     62,     62,     62,     62,     62,     62,     62,     62,
                62,     62,     62,     62,     62,     62,     62,     62,     62,     62,
                62,     62,     62,     62,     62,     62,     62,     62,     62,     62,
                126,    126,    126,    126,    126,    126,    126,    126,    126,    126,    /* 0x3ba8 */
                126,    126,    126,    126,    126,    126,    126,    126,    126,    126,
                126,    126,    126,    126,    126,    126,    126,    126,    126,    126,
                126,    126,    126,    126,    126,    126,    126,    126,    126,    126,
                190,    190,    190,    190,    190,    190,    190,    190,    190,    190,    /* 0x3bd0 */
                190,    190,    190,    190,    190,    190,    190,    190,    190,    190,
                190,    190,    190,    190,    190,    190,    190,    190,    190,    190,
                190,    190,    190,    190,    190,    190,    190,    190,    190,    190,
                255,    255,    255,    255,    255,    255,    255,    255,            /* screenhole */

                7,      7,      7,      7,      7,      7,      7,      7,      7,      7,      /* 0x3c00 */
                7,      7,      7,      7,      7,      7,      7,      7,      7,      7,
                7,      7,      7,      7,      7,      7,      7,      7,      7,      7,
                7,      7,      7,      7,      7,      7,      7,      7,      7,      7,
                71,     71,     71,     71,     71,     71,     71,     71,     71,     71,     /* 0x3c28 */
                71,     71,     71,     71,     71,     71,     71,     71,     71,     71,
                71,     71,     71,     71,     71,     71,     71,     71,     71,     71,
                71,     71,     71,     71,     71,     71,     71,     71,     71,     71,
                135,    135,    135,    135,    135,    135,    135,    135,    135,    135,    /* 0x3c50 */
                135,    135,    135,    135,    135,    135,    135,    135,    135,    135,
                135,    135,    135,    135,    135,    135,    135,    135,    135,    135,
                135,    135,    135,    135,    135,    135,    135,    135,    135,    135,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                15,     15,     15,     15,     15,     15,     15,     15,     15,     15,     /* 0x3c80 */
                15,     15,     15,     15,     15,     15,     15,     15,     15,     15,
                15,     15,     15,     15,     15,     15,     15,     15,     15,     15,
                15,     15,     15,     15,     15,     15,     15,     15,     15,     15,
                79,     79,     79,     79,     79,     79,     79,     79,     79,     79,     /* 0x3ca8 */
                79,     79,     79,     79,     79,     79,     79,     79,     79,     79,
                79,     79,     79,     79,     79,     79,     79,     79,     79,     79,
                79,     79,     79,     79,     79,     79,     79,     79,     79,     79,
                143,    143,    143,    143,    143,    143,    143,    143,    143,    143,    /* 0x3cd0 */
                143,    143,    143,    143,    143,    143,    143,    143,    143,    143,
                143,    143,    143,    143,    143,    143,    143,    143,    143,    143,
                143,    143,    143,    143,    143,    143,    143,    143,    143,    143,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                23,     23,     23,     23,     23,     23,     23,     23,     23,     23,     /* 0x3d00 */
                23,     23,     23,     23,     23,     23,     23,     23,     23,     23,
                23,     23,     23,     23,     23,     23,     23,     23,     23,     23,
                23,     23,     23,     23,     23,     23,     23,     23,     23,     23,
                87,     87,     87,     87,     87,     87,     87,     87,     87,     87,     /* 0x3d28 */
                87,     87,     87,     87,     87,     87,     87,     87,     87,     87,
                87,     87,     87,     87,     87,     87,     87,     87,     87,     87,
                87,     87,     87,     87,     87,     87,     87,     87,     87,     87,
                151,    151,    151,    151,    151,    151,    151,    151,    151,    151,    /* 0x3d50 */
                151,    151,    151,    151,    151,    151,    151,    151,    151,    151,
                151,    151,    151,    151,    151,    151,    151,    151,    151,    151,
                151,    151,    151,    151,    151,    151,    151,    151,    151,    151,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                31,     31,     31,     31,     31,     31,     31,     31,     31,     31,     /* 0x3d80 */
                31,     31,     31,     31,     31,     31,     31,     31,     31,     31,
                31,     31,     31,     31,     31,     31,     31,     31,     31,     31,
                31,     31,     31,     31,     31,     31,     31,     31,     31,     31,
                95,     95,     95,     95,     95,     95,     95,     95,     95,     95,     /* 0x3da8 */
                95,     95,     95,     95,     95,     95,     95,     95,     95,     95,
                95,     95,     95,     95,     95,     95,     95,     95,     95,     95,
                95,     95,     95,     95,     95,     95,     95,     95,     95,     95,
                159,    159,    159,    159,    159,    159,    159,    159,    159,    159,    /* 0x3dd0 */
                159,    159,    159,    159,    159,    159,    159,    159,    159,    159,
                159,    159,    159,    159,    159,    159,    159,    159,    159,    159,
                159,    159,    159,    159,    159,    159,    159,    159,    159,    159,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                39,     39,     39,     39,     39,     39,     39,     39,     39,     39,     /* 0x3e00 */
                39,     39,     39,     39,     39,     39,     39,     39,     39,     39,
                39,     39,     39,     39,     39,     39,     39,     39,     39,     39,
                39,     39,     39,     39,     39,     39,     39,     39,     39,     39,
                103,    103,    103,    103,    103,    103,    103,    103,    103,    103,    /* 0x3e28 */
                103,    103,    103,    103,    103,    103,    103,    103,    103,    103,
                103,    103,    103,    103,    103,    103,    103,    103,    103,    103,
                103,    103,    103,    103,    103,    103,    103,    103,    103,    103,
                167,    167,    167,    167,    167,    167,    167,    167,    167,    167,    /* 0x3e50 */
                167,    167,    167,    167,    167,    167,    167,    167,    167,    167,
                167,    167,    167,    167,    167,    167,    167,    167,    167,    167,
                167,    167,    167,    167,    167,    167,    167,    167,    167,    167,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                47,     47,     47,     47,     47,     47,     47,     47,     47,     47,     /* 0x3e80 */
                47,     47,     47,     47,     47,     47,     47,     47,     47,     47,
                47,     47,     47,     47,     47,     47,     47,     47,     47,     47,
                47,     47,     47,     47,     47,     47,     47,     47,     47,     47,
                111,    111,    111,    111,    111,    111,    111,    111,    111,    111,    /* 0x3ea8 */
                111,    111,    111,    111,    111,    111,    111,    111,    111,    111,
                111,    111,    111,    111,    111,    111,    111,    111,    111,    111,
                111,    111,    111,    111,    111,    111,    111,    111,    111,    111,
                175,    175,    175,    175,    175,    175,    175,    175,    175,    175,    /* 0x3ed0 */
                175,    175,    175,    175,    175,    175,    175,    175,    175,    175,
                175,    175,    175,    175,    175,    175,    175,    175,    175,    175,
                175,    175,    175,    175,    175,    175,    175,    175,    175,    175,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                55,     55,     55,     55,     55,     55,     55,     55,     55,     55,     /* 0x3f00 */
                55,     55,     55,     55,     55,     55,     55,     55,     55,     55,
                55,     55,     55,     55,     55,     55,     55,     55,     55,     55,
                55,     55,     55,     55,     55,     55,     55,     55,     55,     55,
                119,    119,    119,    119,    119,    119,    119,    119,    119,    119,    /* 0x3f28 */
                119,    119,    119,    119,    119,    119,    119,    119,    119,    119,
                119,    119,    119,    119,    119,    119,    119,    119,    119,    119,
                119,    119,    119,    119,    119,    119,    119,    119,    119,    119,
                183,    183,    183,    183,    183,    183,    183,    183,    183,    183,    /* 0x3f50 */
                183,    183,    183,    183,    183,    183,    183,    183,    183,    183,
                183,    183,    183,    183,    183,    183,    183,    183,    183,    183,
                183,    183,    183,    183,    183,    183,    183,    183,    183,    183,
                255,    255,    255,    255,    255,    255,    255,    255,                    /* screenhole */
                63,     63,     63,     63,     63,     63,     63,     63,     63,     63,     /* 0x3f80 */
                63,     63,     63,     63,     63,     63,     63,     63,     63,     63,
                63,     63,     63,     63,     63,     63,     63,     63,     63,     63,
                63,     63,     63,     63,     63,     63,     63,     63,     63,     63,
                127,    127,    127,    127,    127,    127,    127,    127,    127,    127,    /* 0x3fa8 */
                127,    127,    127,    127,    127,    127,    127,    127,    127,    127,
                127,    127,    127,    127,    127,    127,    127,    127,    127,    127,
                127,    127,    127,    127,    127,    127,    127,    127,    127,    127,
                191,    191,    191,    191,    191,    191,    191,    191,    191,    191,    /* 0x3fd0 */
                191,    191,    191,    191,    191,    191,    191,    191,    191,    191,
                191,    191,    191,    191,    191,    191,    191,    191,    191,    191,
                191,    191,    191,    191,    191,    191,    191,    191,    191,    191,
                255,    255,    255,    255,    255,    255,    255,    255             /* screenhole */
              };


static unsigned int hresaddr[192] = {
                0x0000, 0x0400, 0x0800, 0x0c00, 0x1000, 0x1400, 0x1800, 0x1c00,
                0x0080, 0x0480, 0x0880, 0x0c80, 0x1080, 0x1480, 0x1880, 0x1c80,
                0x0100, 0x0500, 0x0900, 0x0d00, 0x1100, 0x1500, 0x1900, 0x1d00,
                0x0180, 0x0580, 0x0980, 0x0d80, 0x1180, 0x1580, 0x1980, 0x1d80,
                0x0200, 0x0600, 0x0a00, 0x0e00, 0x1200, 0x1600, 0x1a00, 0x1e00,
                0x0280, 0x0680, 0x0a80, 0x0e80, 0x1280, 0x1680, 0x1a80, 0x1e80,
                0x0300, 0x0700, 0x0b00, 0x0f00, 0x1300, 0x1700, 0x1b00, 0x1f00,
                0x0380, 0x0780, 0x0b80, 0x0f80, 0x1380, 0x1780, 0x1b80, 0x1f80,
                0x0028, 0x0428, 0x0828, 0x0c28, 0x1028, 0x1428, 0x1828, 0x1c28,
                0x00a8, 0x04a8, 0x08a8, 0x0ca8, 0x10a8, 0x14a8, 0x18a8, 0x1ca8,
                0x0128, 0x0528, 0x0928, 0x0d28, 0x1128, 0x1528, 0x1928, 0x1d28,
                0x01a8, 0x05a8, 0x09a8, 0x0da8, 0x11a8, 0x15a8, 0x19a8, 0x1da8,
                0x0228, 0x0628, 0x0a28, 0x0e28, 0x1228, 0x1628, 0x1a28, 0x1e28,
                0x02a8, 0x06a8, 0x0aa8, 0x0ea8, 0x12a8, 0x16a8, 0x1aa8, 0x1ea8,
                0x0328, 0x0728, 0x0b28, 0x0f28, 0x1328, 0x1728, 0x1b28, 0x1f28,
                0x03a8, 0x07a8, 0x0ba8, 0x0fa8, 0x13a8, 0x17a8, 0x1ba8, 0x1fa8,
                0x0050, 0x0450, 0x0850, 0x0c50, 0x1050, 0x1450, 0x1850, 0x1c50,
                0x00d0, 0x04d0, 0x08d0, 0x0cd0, 0x10d0, 0x14d0, 0x18d0, 0x1cd0,
                0x0150, 0x0550, 0x0950, 0x0d50, 0x1150, 0x1550, 0x1950, 0x1d50,
                0x01d0, 0x05d0, 0x09d0, 0x0dd0, 0x11d0, 0x15d0, 0x19d0, 0x1dd0,
                0x0250, 0x0650, 0x0a50, 0x0e50, 0x1250, 0x1650, 0x1a50, 0x1e50,
                0x02d0, 0x06d0, 0x0ad0, 0x0ed0, 0x12d0, 0x16d0, 0x1ad0, 0x1ed0,
                0x0350, 0x0750, 0x0b50, 0x0f50, 0x1350, 0x1750, 0x1b50, 0x1f50,
                0x03d0, 0x07d0, 0x0bd0, 0x0fd0, 0x13d0, 0x17d0, 0x1bd0, 0x1fd0
              };

	static unsigned char dhrescol[16] = {
		COL_LGR0,
		COL_LGR2,
		COL_LGR4,
		COL_LGR6,
		COL_LGR8,
		COL_LGRA,
		COL_LGRC,
		COL_LGRE,
		COL_LGR1,
		COL_LGR3,
		COL_LGR5,
		COL_LGR7,
		COL_LGR9,
		COL_LGRB,
		COL_LGRD,
		COL_LGRF
	      };


/*-------------------------------------*/


      void virtsetmode () {

	if (gm&GRX) {					/* set the display modes for both parts of the screen */
	  if (gm&HRG) {
	    if (virt80col) {
	      if (virtdhres) {
	        virtmodetop = modedhrs;
	        if (gm&SPL) {
	          virtmodedown = modetext80;
	          virtsplit = 160;
	        }
	        else {
	          virtmodedown = modedhrs;
	          virtsplit = 192;
	        }
	      }
	      else {
	        virtmodetop = modehres;
	        if (gm&SPL) {
	          virtmodedown = modetext80;
	          virtsplit = 160;
	        }
	        else {
	          virtmodedown = modehres;
	          virtsplit = 192;
	        }
	      }
	    }
	    else {
	      virtmodetop = modehres;
	      if (gm&SPL) {
	        virtmodedown = modetext40;
	        virtsplit = 160;
	      }
	      else {
	        virtmodedown = modehres;
	        virtsplit = 192;
	      }
	    }
	  }
	  else {
	    virtsplit = 0;
	    if (virt80col) {
	      if (virtdhres) {
	        virtmodetop = modelres80;
	        if (gm&SPL) {
	          virtmodedown = modetext80;
	        }
	        else {
	          virtmodedown = modelres80;
	        }
	      }
	      else {
	        virtmodetop = modelres40;
	        if (gm&SPL) {
	          virtmodedown = modetext80;
	        }
	        else {
	          virtmodedown = modelres40;
	        }
	      }
	    }
	    else {
	      virtmodetop = modelres40;
	      if (gm&SPL) {
	        virtmodedown = modetext40;
	      }
	      else {
	        virtmodedown = modelres40;
	      }
	    }
	  }
	}
	else {
	  virtsplit = 0;
	  if (virt80col) {
	    virtmodetop = modetext80;
	    virtmodedown = modetext80;
	  }
	  else {
	    virtmodetop = modetext40;
	    virtmodedown = modetext40;
	  }
	}

	if ((memstore80) || !(gm&PG2)) {			/* set the visible page */
	  virtcachemode = virtcachemode & ~cachepage;
	  virttextpage = 0x400;
	  virthrespage = 0x2000;
	}
	else {
	  virtcachemode = virtcachemode | cachepage;
	  virttextpage = 0x800;
	  virthrespage = 0x4000;
	}

      } /* virtsetmode */


/*-------------------------------------*/


#define virtcacheinit() memset(virtcache,0,192*2)


/*-------------------------------------*/


      void virtsethresmode(unsigned char mode) {

	if (mode) {	/* Set RGB */
	  virthresmode = 1;
		/* even columns */
	  colourtabe[0] = COL_HGR0;	/* 000 */
	  colourtabe[1] = COL_HGR0;	/* 100 */
	  colourtabe[2] = COL_HGR2;	/* 010 */
	  colourtabe[3] = COL_HGR3;	/* 110 */
	  colourtabe[4] = COL_HGR0;	/* 001 */
	  colourtabe[5] = COL_HGR0;	/* 101 */
	  colourtabe[6] = COL_HGR2;	/* 011 */
	  colourtabe[7] = COL_HGR3;	/* 111 */
		/* odd columns */
	  colourtabo[0] = COL_HGR0;	/* 000 */
	  colourtabo[1] = COL_HGR0;	/* 100 */
	  colourtabo[2] = COL_HGR1;	/* 010 */
	  colourtabo[3] = COL_HGR3;	/* 110 */
	  colourtabo[4] = COL_HGR0;	/* 001 */
	  colourtabo[5] = COL_HGR0;	/* 101 */
	  colourtabo[6] = COL_HGR1;	/* 011 */
	  colourtabo[7] = COL_HGR3;	/* 111 */
		/* even columns */
	  colourtabe2[0] = COL_HGR4;	/* 000 */
	  colourtabe2[1] = COL_HGR4;	/* 100 */
	  colourtabe2[2] = COL_HGR6;	/* 010 */
	  colourtabe2[3] = COL_HGR7;	/* 110 */
	  colourtabe2[4] = COL_HGR4;	/* 001 */
	  colourtabe2[5] = COL_HGR4;	/* 101 */
	  colourtabe2[6] = COL_HGR6;	/* 011 */
	  colourtabe2[7] = COL_HGR7;	/* 111 */
		/* odd columns */
	  colourtabo2[0] = COL_HGR4;	/* 000 */
	  colourtabo2[1] = COL_HGR4;	/* 100 */
	  colourtabo2[2] = COL_HGR5;	/* 010 */
	  colourtabo2[3] = COL_HGR7;	/* 110 */
	  colourtabo2[4] = COL_HGR4;	/* 001 */
	  colourtabo2[5] = COL_HGR4;	/* 101 */
	  colourtabo2[6] = COL_HGR5;	/* 011 */
	  colourtabo2[7] = COL_HGR7;	/* 111 */
	}
	else {		/* Set Standard */
	  virthresmode = 0;
		/* even columns */
	  colourtabe[0] = COL_HGR0;	/* 000 */
	  colourtabe[1] = COL_HGR0;	/* 100 */
	  colourtabe[2] = COL_HGR2;	/* 010 */
	  colourtabe[3] = COL_HGR3;	/* 110 */
	  colourtabe[4] = COL_HGR0;	/* 001 */
	  colourtabe[5] = COL_HGR1;	/* 101 */
	  colourtabe[6] = COL_HGR3;	/* 011 */
	  colourtabe[7] = COL_HGR3;	/* 111 */
		/* odd columns */
	  colourtabo[0] = COL_HGR0;	/* 000 */
	  colourtabo[1] = COL_HGR0;	/* 100 */
	  colourtabo[2] = COL_HGR1;	/* 010 */
	  colourtabo[3] = COL_HGR3;	/* 110 */
	  colourtabo[4] = COL_HGR0;	/* 001 */
	  colourtabo[5] = COL_HGR2;	/* 101 */
	  colourtabo[6] = COL_HGR3;	/* 011 */
	  colourtabo[7] = COL_HGR3;	/* 111 */
		/* even columns */
	  colourtabe2[0] = COL_HGR4;	/* 000 */
	  colourtabe2[1] = COL_HGR4;	/* 100 */
	  colourtabe2[2] = COL_HGR6;	/* 010 */
	  colourtabe2[3] = COL_HGR7;	/* 110 */
	  colourtabe2[4] = COL_HGR4;	/* 001 */
	  colourtabe2[5] = COL_HGR5;	/* 101 */
	  colourtabe2[6] = COL_HGR7;	/* 011 */
	  colourtabe2[7] = COL_HGR7;	/* 111 */
		/* odd columns */
	  colourtabo2[0] = COL_HGR4;	/* 000 */
	  colourtabo2[1] = COL_HGR4;	/* 100 */
	  colourtabo2[2] = COL_HGR5;	/* 010 */
	  colourtabo2[3] = COL_HGR7;	/* 110 */
	  colourtabo2[4] = COL_HGR4;	/* 001 */
	  colourtabo2[5] = COL_HGR6;	/* 101 */
	  colourtabo2[6] = COL_HGR7;	/* 011 */
	  colourtabo2[7] = COL_HGR7;	/* 111 */
	}

	virtcacheinit();

      } /* virtsethresmode */


/*-------------------------------------*/


      unsigned char virtgethresmode() {

	return virthresmode;

      } /*       virtgethresmode */


/*-------------------------------------*/


      void virtsetmonochrome(unsigned char mode) {

	switch (mode) {
	  case 0 :	/* colour */
	    virtmonochrome = 0;
	    virtmonocol0 = COL_TXT_WHT0;
	    virtmonocol1 = COL_TXT_WHT1;
	    virtmonocol2 = COL_TXT_WHT2;
	    virtmonocol3 = COL_TXT_WHT3;
	    virtcacheinit();
	    break;
	  case 1 :	/* monochrome white */
	    virtmonochrome = 1;
	    virtmonocol0 = COL_TXT_WHT0;
	    virtmonocol1 = COL_TXT_WHT1;
	    virtmonocol2 = COL_TXT_WHT2;
	    virtmonocol3 = COL_TXT_WHT3;
	    virtcacheinit();
	    break;
	  case 2 :	/* monochrome green */
	    virtmonochrome = 2;
	    virtmonocol0 = COL_TXT_GRN0;
	    virtmonocol1 = COL_TXT_GRN1;
	    virtmonocol2 = COL_TXT_GRN2;
	    virtmonocol3 = COL_TXT_GRN3;
	    virtcacheinit();
	    break;
	  case 3 :	/* monochrome amber */
	    virtmonochrome = 3;
	    virtmonocol0 = COL_TXT_AMB0;
	    virtmonocol1 = COL_TXT_AMB1;
	    virtmonocol2 = COL_TXT_AMB2;
	    virtmonocol3 = COL_TXT_AMB3;
	    virtcacheinit();
	    break;
	  } /* switch */

      } /* virtsetmonochrome */


/*-------------------------------------*/


      unsigned char virtgetmonochrome() {

	return virtmonochrome;

      } /* virtgetmonochrome */


/*-------------------------------------*/


      void virtpaletteset(register unsigned char index, register unsigned char r,
			  register unsigned char g,     register unsigned char b) {

	virtpaletter[index] = r;
	virtpaletteg[index] = g;
	virtpaletteb[index] = b;

      } /* virtpaletteset */


/*-------------------------------------*/


      void virtpalettesetd(register unsigned char index, register unsigned char r,
			   register unsigned char g,     register unsigned char b) {

	virtpaletter[index] = r;
	virtpaletteg[index] = g;
	virtpaletteb[index] = b;

	//outp(0x3C8,index);
	//outp(0x3C9,r >> 2);
	//outp(0x3C9,g >> 2);
	//outp(0x3C9,b >> 2);

      } /* virtpalettesetd */


  int vga2alleg(unsigned char c){
  //printf("r:%d, g:%d,, b:%d\n",virtpaletter[c],virtpaletteg[c],virtpaletteb[c]);
  return makecol(virtpaletter[c],virtpaletteg[c],virtpaletteb[c]);
  }
/*-------------------------------------*/


      void virtsetpalette(unsigned char mode) {

	switch (mode) {
	  case 0x00:			/* AppleIIgs */
	     virtpalette = 0;
	     virtpaletteset(COL_LGR0,   0,  0,  0);
	     virtpaletteset(COL_LGR1, 221,  0, 51);
	     virtpaletteset(COL_LGR2,   0,  0,153);
	     virtpaletteset(COL_LGR3, 221, 34,221);
	     virtpaletteset(COL_LGR4,   0,119, 34);
	     virtpaletteset(COL_LGR5,  85, 85, 85);
	     virtpaletteset(COL_LGR6,  34, 34,255);
	     virtpaletteset(COL_LGR7, 102,170,255);
	     virtpaletteset(COL_LGR8, 136, 85,  0);
	     virtpaletteset(COL_LGR9, 255,102,  0);
	     virtpaletteset(COL_LGRA, 170,170,170);
	     virtpaletteset(COL_LGRB, 255,153,136);
	     virtpaletteset(COL_LGRC,  17,221,  0);
	     virtpaletteset(COL_LGRD, 255,255,  0);
	     virtpaletteset(COL_LGRE,  68,255,153);
	     virtpaletteset(COL_LGRF, 255,255,255);
	     virtpaletteset(COL_HGR0,   0,  0,  0);
	     virtpaletteset(COL_HGR1,  17,221,  0);
	     virtpaletteset(COL_HGR2, 221, 34,221);
	     virtpaletteset(COL_HGR3, 255,255,255);
	     virtpaletteset(COL_HGR4,   0,  0,  0);
	     virtpaletteset(COL_HGR5, 255,102,  0);
	     virtpaletteset(COL_HGR6,  34, 34,255);
	     virtpaletteset(COL_HGR7, 255,255,255);
	    break;
	  case 0x01:			/* Standard */
	     virtpalette = 1;
	     virtpaletteset(COL_LGR0,   0,  0,  0);
	     virtpaletteset(COL_LGR1, 227, 30, 96);
	     virtpaletteset(COL_LGR2,  96, 78,189);
	     virtpaletteset(COL_LGR3, 255, 68,253);
	     virtpaletteset(COL_LGR4,   0,163, 96);
	     virtpaletteset(COL_LGR5, 156,156,156);
	     virtpaletteset(COL_LGR6,  20,207,253);
	     virtpaletteset(COL_LGR7, 208,195,255);
	     virtpaletteset(COL_LGR8,  96,114,  3);
	     virtpaletteset(COL_LGR9, 255,106, 60);
	     virtpaletteset(COL_LGRA, 156,156,156);
	     virtpaletteset(COL_LGRB, 255,160,208);
	     virtpaletteset(COL_LGRC,  20,245, 60);
	     virtpaletteset(COL_LGRD, 208,221,141);
	     virtpaletteset(COL_LGRE, 114,255,208);
	     virtpaletteset(COL_LGRF, 255,255,255);
	     virtpaletteset(COL_HGR0,   0,  0,  0);
	     virtpaletteset(COL_HGR1,  20,245, 60);
	     virtpaletteset(COL_HGR2, 255, 68,253);
	     virtpaletteset(COL_HGR3, 255,255,255);
	     virtpaletteset(COL_HGR4,   0,  0,  0);
	     virtpaletteset(COL_HGR5, 255,106, 60);
	     virtpaletteset(COL_HGR6,  20,207,253);
	     virtpaletteset(COL_HGR7, 255,255,255);
	    break;
	  case 0x02:			/* ApplePC */
	     virtpalette = 2;
	     virtpaletteset(COL_LGR0,   0,  0,  0);
	     virtpaletteset(COL_LGR1, 124, 32, 64);
	     virtpaletteset(COL_LGR2,  32, 48,124);
	     virtpaletteset(COL_LGR3, 188, 80,188);
	     virtpaletteset(COL_LGR4,   0, 92, 60);
	     virtpaletteset(COL_LGR5, 124,124,124);
	     virtpaletteset(COL_LGR6,  64,140,184);
	     virtpaletteset(COL_LGR7, 188,172,248);
	     virtpaletteset(COL_LGR8,  60, 76,  0);
	     virtpaletteset(COL_LGR9, 184,108, 64);
	     virtpaletteset(COL_LGRA, 124,124,124);
	     virtpaletteset(COL_LGRB, 248,156,188);
	     virtpaletteset(COL_LGRC,  60,168, 60);
	     virtpaletteset(COL_LGRD, 188,200,124);
	     virtpaletteset(COL_LGRE, 124,216,188);
	     virtpaletteset(COL_LGRF, 255,255,255);
	     virtpaletteset(COL_HGR0,   0,  0,  0);
	     virtpaletteset(COL_HGR1,  60,168, 60);
	     virtpaletteset(COL_HGR2, 188, 80,188);
	     virtpaletteset(COL_HGR3, 224,224,224);
	     virtpaletteset(COL_HGR4,   0,  0,  0);
	     virtpaletteset(COL_HGR5, 184,108, 64);
	     virtpaletteset(COL_HGR6,  64,140,184);
	     virtpaletteset(COL_HGR7, 224,224,224);
	     break;
	  case 0x03:			/* MESS */
	     virtpalette = 3;
	     virtpaletteset(COL_LGR0,   0,  0,  0);
	     virtpaletteset(COL_LGR1, 208,  0, 48);
	     virtpaletteset(COL_LGR2,   0,  0,144);
	     virtpaletteset(COL_LGR3, 208, 32,208);
	     virtpaletteset(COL_LGR4,   0,112, 32);
	     virtpaletteset(COL_LGR5,  80, 80, 80);
	     virtpaletteset(COL_LGR6,  32, 32,240);
	     virtpaletteset(COL_LGR7,  96,160,240);
	     virtpaletteset(COL_LGR8, 128, 80,  0);
	     virtpaletteset(COL_LGR9, 240, 96,  0);
	     virtpaletteset(COL_LGRA, 160,160,160);
	     virtpaletteset(COL_LGRB, 240,144,128);
	     virtpaletteset(COL_LGRC,  16,208,  0);
	     virtpaletteset(COL_LGRD, 240,240,  0);
	     virtpaletteset(COL_LGRE,  64,240,144);
	     virtpaletteset(COL_LGRF, 240,240,240);
	     virtpaletteset(COL_HGR0,   0,  0,  0);
	     virtpaletteset(COL_HGR1,  16,208,  0);
	     virtpaletteset(COL_HGR2, 208, 32,208);
	     virtpaletteset(COL_HGR3, 240,240,240);
	     virtpaletteset(COL_HGR4,   0,  0,  0);
	     virtpaletteset(COL_HGR5, 240, 96,  0);
	     virtpaletteset(COL_HGR6,  32, 32,240);
	     virtpaletteset(COL_HGR7, 240,240,240);
	     break;
	  case 0x04:			/* CGA/EGA 16-Color */
	    virtpalette = 4;
	    virtpaletteset(COL_LGR0,   0,  0,  0);
	    virtpaletteset(COL_LGR1, 168,  0,  0);
	    virtpaletteset(COL_LGR2,   0,  0,168);
	    virtpaletteset(COL_LGR3, 168,  0,168);
	    virtpaletteset(COL_LGR4,   0,168,168);
	    virtpaletteset(COL_LGR5, 168,168,168);
	    virtpaletteset(COL_LGR6,   0,  0,168);
	    virtpaletteset(COL_LGR7,   0,  0,255);
	    virtpaletteset(COL_LGR8, 168, 84,  0);
	    virtpaletteset(COL_LGR9, 255,255,  0);
	    virtpaletteset(COL_LGRA,  84, 84, 84);
	    virtpaletteset(COL_LGRB, 255,  0,  0);
	    virtpaletteset(COL_LGRC,   0,255,  0);
	    virtpaletteset(COL_LGRD, 255,255,  0);
	    virtpaletteset(COL_LGRE,   0,255,255);
	    virtpaletteset(COL_LGRF, 255,255,255);
	    virtpaletteset(COL_HGR0,   0,  0,  0);
	    virtpaletteset(COL_HGR1,   0,255,  0);
	    virtpaletteset(COL_HGR2, 255,  0,255);
	    virtpaletteset(COL_HGR3, 255,255,255);
	    virtpaletteset(COL_HGR4,   0,  0,  0);
	    virtpaletteset(COL_HGR5, 255,  0,  0);
	    virtpaletteset(COL_HGR6,   0,255,255);
	    virtpaletteset(COL_HGR7, 255,255,255);
	    break;
	} /* switch */

      } /* virtsetpalette */


/*-------------------------------------*/


      unsigned char virtgetpalette() {

	return virtpalette;

      } /* virtgetpalette */


/*-------------------------------------*/


      void virtputpalette() {
	register unsigned int i;

	for (i=0; i<256; i++) {
	  //outp(0x3C8,i);
	  //outp(0x3C9,virtpaletter[i] >> 2);
	  //outp(0x3C9,virtpaletteg[i] >> 2);
	  //outp(0x3C9,virtpaletteb[i] >> 2);
	}
      } /* virtputpalette */


/*-------------------------------------*/


      void virtpaletteinit() {

	virtsetpalette(1);	/* standard colours for LoRes and HiRes */

	virtpaletteset(COL_TXT_WHT0,0x00,0x00,0x00);
	virtpaletteset(COL_TXT_WHT1,0xff,0xff,0xff);
	virtpaletteset(COL_TXT_WHT2,0x00,0x00,0x00);
	virtpaletteset(COL_TXT_WHT3,0xff,0xff,0xff);
	virtpaletteset(COL_TXT_GRN0,0x00,0x00,0x00);
	virtpaletteset(COL_TXT_GRN1,0x00,0xaf,0x00);
	virtpaletteset(COL_TXT_GRN2,0x00,0x00,0x00);
	virtpaletteset(COL_TXT_GRN3,0x00,0xaf,0x00);
	virtpaletteset(COL_TXT_AMB0,0x00,0x00,0x00);
	virtpaletteset(COL_TXT_AMB1,0xbf,0x5f,0x00);
	virtpaletteset(COL_TXT_AMB2,0x00,0x00,0x00);
	virtpaletteset(COL_TXT_AMB3,0xbf,0x5f,0x00);
	virtpaletteset(COL_DRV_OFF, 0x7f,0x7f,0x7f);
	virtpaletteset(COL_DRV_ON,  0xff,0x00,0x00);
	virtpaletteset(COL_LPT_OFF, 0xff,0xff,0x00);
	virtpaletteset(COL_LPT_ON,  0x00,0xff,0x00);
	virtpaletteset(COL_DASM,    0xff,0xff,0x00);
	virtpaletteset(COL_FLAG,    0xff,0x00,0xff);
	virtpaletteset(COL_DASM80,  0xff,0x00,0xff);
	virtpaletteset(COL_FLAG80,  0xff,0xff,0x00);
	virtpaletteset(COL_HDV_OFF, 0x7f,0x7f,0x7f);
	virtpaletteset(COL_HDV_ON,  0xff,0x00,0x00);
	virtpaletteset(COL_DISKFLAG,0xff,0x00,0xff);
	virtpaletteset(COL_LPTERR,  0xff,0x00,0x00);

      } /* virtpaletteinit */


/*-------------------------------------*/


      void virtreset () {

	gm = 0;
	virt80col = 0;
	virtaltchar = 0;
	virtiou = 0x80;
	virtdhres = 0;
	virtcacheinit();
	virtsetmode();

      } /* virtreset */


/*-------------------------------------*/


      void virtinit () {

	memset(virtscreen,0,128000);		/* clear virtual screen */

	virtcacheinit();			/* clear cache */
	virtcachemode = 0;

	virtcopy      = 0;

	virtsetmonochrome(0);			/* set to colour mode */
	virtsethresmode(0);			/* set standard hres mode */
	virtpaletteinit();			/* set standard palette */

	virtreset();				/* reset softswitches */
	virtsetmode();				/* set mode and page for rasterline */

      } /* virtinit */


/*-------------------------------------*/


      void virtstore(FILE *file) {

	fwrite(&gm,sizeof(gm),1,file);
	fwrite(&virt80col,sizeof(virt80col),1,file);
	fwrite(&virtaltchar,sizeof(virtaltchar),1,file);
	fwrite(&virtiou,sizeof(virtiou),1,file);
	fwrite(&virtdhres,sizeof(virtdhres),1,file);
	fwrite(&virthresmode,sizeof(virthresmode),1,file);
	fwrite(&virtmonochrome,sizeof(virtmonochrome),1,file);
	fwrite(&virtpalette,sizeof(virtpalette),1,file);
      } /* virtstore */


/*-------------------------------------*/


      void virtrestore(FILE *file) {

	fread(&gm,sizeof(gm),1,file);
	fread(&virt80col,sizeof(virt80col),1,file);
	fread(&virtaltchar,sizeof(virtaltchar),1,file);
	fread(&virtiou,sizeof(virtiou),1,file);
	fread(&virtdhres,sizeof(virtdhres),1,file);
	fread(&virthresmode,sizeof(virthresmode),1,file);
	virtsethresmode(virthresmode);
	fread(&virtmonochrome,sizeof(virtmonochrome),1,file);
	virtsetmonochrome(virtmonochrome);
	fread(&virtpalette,sizeof(virtpalette),1,file);
	virtsetpalette(virtpalette);
	virtsetmode();
      } /* virtrestore */


/*-------------------------------------*/


void virtline (unsigned int rastline)
{
  unsigned int addr, virtptr, mode;
  register unsigned int val;
  unsigned char bit, bytes;
//  unsigned int x;
//  unsigned int y;
  void adrawptr(unsigned int ptr){
  int x,y;
  x=ptr%640;
  y=ptr/640;
  putpixel(bufferzor,x,y*2,vga2alleg(virtscreen[ptr]));
  putpixel(bufferzor,x,(y*2)+1,vga2alleg(virtscreen[ptr]));
  }

  if (rastline <= 159) {
    mode = virtmodetop;
  }
  else {
    mode = virtmodedown;
  }
  virtptr = rastline * 640 + 20 + 4*640;	/* pointer to virtual screen */
  switch (mode) {
    case modetext40 :	/* text 40 column */
               addr = textaddr[rastline] + virttextpage;
               virtvideobyte = RAM[addr];
               mode = virtcachemode | cachetext40;
               if (virtcache[rastline] == mode) { return; }
               virtcache[rastline] = mode;
               virtcopy = 1;
               for (bytes = 0; bytes < 40; bytes++) {
                 val = RAM[addr];
                 if (val >= 128) {
                   val = AppleFont[ (i18n((val+(val-128<' '?64:0))&0x7f)<<3) | (rastline & 7)];
                   for ( bit = 128; bit>1; bit=bit>>1) {
                     virtscreen[virtptr] = (val & bit) ? virtmonocol1 : virtmonocol0;
		     adrawptr(virtptr);
                     virtptr++; /* next pixel */
                     virtscreen[virtptr] = (val & bit) ? virtmonocol1 : virtmonocol0;
		     adrawptr(virtptr);
                     virtptr++; /* next pixel */
                   } /* for bit */
                 }
                 else {
                   if (val >= 64 && !virtaltchar) {
                     if (val >= 96 && !virtaltchar) { val -= 0x40; }
                     val = AppleFont[ (i18n(val)<<3) | (rastline & 7) ];
                     for ( bit = 128; bit>1; bit=bit>>1) {
                       virtscreen[virtptr] = (val & bit) ? virtmonocol2 : virtmonocol3;
		       adrawptr(virtptr);
                       virtptr++;       /* next pixel */
                       virtscreen[virtptr] = (val & bit) ? virtmonocol2 : virtmonocol3;
		       adrawptr(virtptr);
                       virtptr++;       /* next pixel */
                     } /* for bit */
                   }
                   else {
                     if (val < 32) { val += 0x40; }
                     val = AppleFont[ (i18n(val)<<3) | (rastline & 7)];
                     for ( bit = 128; bit>1; bit=bit>>1) {
                       virtscreen[virtptr] = (val & bit) ? virtmonocol0 : virtmonocol1;
		       adrawptr(virtptr);
                       virtptr++;       /* next pixel */
                       virtscreen[virtptr] = (val & bit) ? virtmonocol0 : virtmonocol1;
		       adrawptr(virtptr);
                       virtptr++;       /* next pixel */
                     } /* for bit */
                   }
                 }
                 addr++;        /* next ram address */
               } /* for x */
               return;
    case modetext80 :
               addr = textaddr[rastline] + virttextpage;
               virtvideobyte = bankram1[addr];
               mode = virtcachemode | cachetext80;
               if (virtcache[rastline] == mode) { return; }
               virtcache[rastline] = mode;
               virtcopy = 1;
               for (bytes = 0; bytes < 40; bytes++) {
                 val = bankram1[addr];
                 if (val >= 128) {
                   val = AppleFont[ (i18n((val+(val-128<' '?64:0))&0x7f)<<3) | (rastline & 7)];
                   virtscreen[virtptr] = (val & 0x80) ? virtmonocol1 : virtmonocol0;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x40) ? virtmonocol1 : virtmonocol0;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x20) ? virtmonocol1 : virtmonocol0;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x10) ? virtmonocol1 : virtmonocol0;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x08) ? virtmonocol1 : virtmonocol0;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x04) ? virtmonocol1 : virtmonocol0;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x02) ? virtmonocol1 : virtmonocol0;
		   adrawptr(virtptr);
                   virtptr++;
                 }
                 else {
                   val = AppleFont[ (i18n((val+128+(val<' '?64:0))&0x7f)<<3) | (rastline & 7)];
                   virtscreen[virtptr] = (val & 0x80) ? virtmonocol0 : virtmonocol1;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x40) ? virtmonocol0 : virtmonocol1;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x20) ? virtmonocol0 : virtmonocol1;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x10) ? virtmonocol0 : virtmonocol1;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x08) ? virtmonocol0 : virtmonocol1;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x04) ? virtmonocol0 : virtmonocol1;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x02) ? virtmonocol0 : virtmonocol1;
		   adrawptr(virtptr);
                   virtptr++;
                 }
                 val = RAM[addr];
                 if (val >= 128) {
                   val = AppleFont[ (i18n((val+(val-128<' '?64:0))&0x7f)<<3) | (rastline & 7)];
                   virtscreen[virtptr] = (val & 0x80) ? virtmonocol1 : virtmonocol0;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x40) ? virtmonocol1 : virtmonocol0;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x20) ? virtmonocol1 : virtmonocol0;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x10) ? virtmonocol1 : virtmonocol0;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x08) ? virtmonocol1 : virtmonocol0;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x04) ? virtmonocol1 : virtmonocol0;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x02) ? virtmonocol1 : virtmonocol0;
		   adrawptr(virtptr);
                   virtptr++;
                 }
                 else {
                   val = AppleFont[ (i18n((val+128+(val<' '?64:0))&0x7f)<<3) | (rastline & 7)];
                   virtscreen[virtptr] = (val & 0x80) ? virtmonocol0 : virtmonocol1;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x40) ? virtmonocol0 : virtmonocol1;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x20) ? virtmonocol0 : virtmonocol1;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x10) ? virtmonocol0 : virtmonocol1;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x08) ? virtmonocol0 : virtmonocol1;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x04) ? virtmonocol0 : virtmonocol1;
		   adrawptr(virtptr);
                   virtptr++;
                   virtscreen[virtptr] = (val & 0x02) ? virtmonocol0 : virtmonocol1;
		   adrawptr(virtptr);
                   virtptr++;
                 }
                 addr++;        /* next ram address */
               } /* for x */
               return;
    case modelres40 : { /* lores */
               addr = textaddr[rastline] + virttextpage;
               virtvideobyte = RAM[addr];
               mode = virtcachemode | cachelres40;
               if (virtcache[rastline] == mode) { return; }
               virtcache[rastline] = mode;
               virtcopy = 1;
               if ((rastline & 7) < 4) {
                 for (bytes = 0; bytes < 40; bytes++) {
                   val = (RAM[addr++] & 0xf) + COL_LGR0;
                   for (bit = 0; bit < 7; bit++) {
                     virtscreen[virtptr++] = val;
		     adrawptr(virtptr);
                     virtscreen[virtptr++] = val;
		     adrawptr(virtptr);
                   } /* for bit */
                 } /* for bytes */
               }
               else {
                 for (bytes = 0; bytes < 40; bytes++) {
                   val = (RAM[addr++] >> 4) + COL_LGR0;
                   for (bit = 0; bit < 7; bit++) {
                     virtscreen[virtptr++] = val;
		     adrawptr((virtptr-1));
                     virtscreen[virtptr++] = val;
		     adrawptr((virtptr-1));
                   } /* for bit */
                 } /* for bytes */
               }
               return;
             }
    case modelres80 : { /* lores */
               addr = textaddr[rastline] + virttextpage;
               virtvideobyte = bankram1[addr];
               mode = virtcachemode | cachelres80;
               if (virtcache[rastline] == mode) { return; }
               virtcache[rastline] = mode;
               virtcopy = 1;
               if ((rastline & 7) < 4) {
                 for (bytes = 0; bytes < 40; bytes++) {
                   val = (bankram1[addr] & 0xf) + COL_LGR0;
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   val = (RAM[addr++] & 0xf) + COL_LGR0;
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                 } /* for bytes */
               }
               else {
                 for (bytes = 0; bytes < 40; bytes++) {
                   val = (bankram1[addr] >> 4) + COL_LGR0;
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   val = (RAM[addr++] >> 4) + COL_LGR0;
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                   virtscreen[virtptr++] = val;
		    adrawptr(virtptr-1);
                 } /* for bytes */
               }
               return;
             }
    case modehres : { /* hires */
               addr = hresaddr[rastline] + virthrespage;
               virtvideobyte = RAM[addr];
               mode = virtcachemode | cachehres;
               if (virtcache[rastline] == mode) { return; }
               virtcache[rastline] = mode;
               virtcopy = 1;
               if (virtmonochrome) {
                 for (bytes = 0; bytes < 40; bytes++) {
                   val = (unsigned char)RAM[addr++];
                   for ( bit = 1; bit<128; bit=bit<<1) {
                     virtscreen[virtptr++] = (val & bit) ? virtmonocol1 : virtmonocol0;
		      adrawptr(virtptr-1);
                     virtscreen[virtptr++] = (val & bit) ? virtmonocol1 : virtmonocol0;
		      adrawptr(virtptr-1);
                   } /* for bit */
                 } /* for bytes */
               } /* if (monochrome) */
               else {
                 for (bytes = 0; bytes < 40; bytes++) {
                   val = (((unsigned char)RAM[addr-1] & 0x60) >> 5)
                       | (((unsigned char)RAM[addr]   & 0x7f) << 2)
                       | (((unsigned char)RAM[addr+1] & 0x3)  << 9);
                   if ((bytes & 1) == 0) {              /* even column */
                     if (bytes == 0) {
                       val = val & 0x7fc;       /* drop surrounding bits at left border */
                     }
                     if (RAM[addr] & 0x80) {
                       virtscreen[virtptr++] = colourtabe2[(val >> 1) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe2[(val >> 1) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo2[(val >> 2) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo2[(val >> 2) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe2[(val >> 3) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe2[(val >> 3) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo2[(val >> 4) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo2[(val >> 4) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe2[(val >> 5) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe2[(val >> 5) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo2[(val >> 6) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo2[(val >> 6) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe2[(val >> 7) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe2[(val >> 7) & 7];
		        adrawptr(virtptr-1);
                     }
                     else {
                       virtscreen[virtptr++] = colourtabe[(val >> 1) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe[(val >> 1) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo[(val >> 2) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo[(val >> 2) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe[(val >> 3) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe[(val >> 3) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo[(val >> 4) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo[(val >> 4) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe[(val >> 5) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe[(val >> 5) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo[(val >> 6) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo[(val >> 6) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe[(val >> 7) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe[(val >> 7) & 7];
		        adrawptr(virtptr-1);
                     }
                   }
                   else {                               /* odd column */
                     if (bytes == 39) {
                       val = val & 0x1ff;               /* drop surrounding bits at right border */
                     }
                     if (RAM[addr] & 0x80) {
                       virtscreen[virtptr++] = colourtabo2[(val >> 1) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo2[(val >> 1) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe2[(val >> 2) & 7];
		        adrawptr(virtptr-1); // OMG LAME LAME LAMEEEEEEEEEEE
                       virtscreen[virtptr++] = colourtabe2[(val >> 2) & 7];
		        adrawptr(virtptr-1); // OMG LAME LAME LAMEEEEEEEEEEE
                       virtscreen[virtptr++] = colourtabo2[(val >> 3) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo2[(val >> 3) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe2[(val >> 4) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe2[(val >> 4) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo2[(val >> 5) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo2[(val >> 5) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe2[(val >> 6) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe2[(val >> 6) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo2[(val >> 7) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo2[(val >> 7) & 7];
		        adrawptr(virtptr-1);
                     }
                     else {
                       virtscreen[virtptr++] = colourtabo[(val >> 1) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo[(val >> 1) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe[(val >> 2) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe[(val >> 2) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo[(val >> 3) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo[(val >> 3) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe[(val >> 4) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe[(val >> 4) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo[(val >> 5) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo[(val >> 5) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe[(val >> 6) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabe[(val >> 6) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo[(val >> 7) & 7];
		        adrawptr(virtptr-1);
                       virtscreen[virtptr++] = colourtabo[(val >> 7) & 7];
		        adrawptr(virtptr-1);
                     }
                   }
                   addr++;
                 } /* for bytes */
               } /* else if (monochrome) */
               return;
             }
    case modedhrs : { /* pseudo double hires */
               addr = hresaddr[rastline] + virthrespage;
               virtvideobyte = bankram1[addr];
               mode = virtcachemode | cachedhrs;
               if (virtcache[rastline] == mode) { return; }
               virtcache[rastline] = mode;
               virtcopy = 1;
               for (bytes = 0; bytes < 20; bytes++) {
                 val = dhrescol[ (bankram1[addr]&0xf)];
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
/*               virtscreen[virtptr++] = val;
                 virtscreen[virtptr++] = val; */
                 val = dhrescol[ ((bankram1[addr]&0x70) >> 4) | ((RAM[addr] & 0x01) << 3)];
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
/*               virtscreen[virtptr++] = val;
                 virtscreen[virtptr++] = val; */
                 val = dhrescol[ ((RAM[addr]&0x1e) >> 1)];
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
/*               virtscreen[virtptr++] = val;
                 virtscreen[virtptr++] = val; */
                 val = dhrescol[ ((RAM[addr]&0x60) >> 5) | ((bankram1[addr+1] & 0x03) << 2)];
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
/*               virtscreen[virtptr++] = val;
                 virtscreen[virtptr++] = val; */
                 addr++;
                 val = dhrescol[ ((bankram1[addr]&0x3c) >> 2)];
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
/*               virtscreen[virtptr++] = val;
                 virtscreen[virtptr++] = val; */
                 val = dhrescol[ ((bankram1[addr]&0x40) >> 6) | ((RAM[addr] & 0x7) << 1)];
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
/*               virtscreen[virtptr++] = val;
                 virtscreen[virtptr++] = val; */
                 val = dhrescol[ ((RAM[addr]&0x78) >> 3)];
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
                 virtscreen[virtptr++] = val;
		  adrawptr(virtptr-1);
/*               virtscreen[virtptr++] = val;
                 virtscreen[virtptr++] = val; */
                 addr++;
               } /* for (bytes) */
               return;
             } /* case modedhres */
  } /* switch */
} /* virtline */


/*-------------------------------------*/


      void virtscreencopy () {
	/*static unsigned char *screen=MK_FP(0xA000,0x0000);

  
	if (virtcopy) {
	  memcpy(screen,virtscreen,128000);
	  virtcopy = 0;
	}

	*/
	//evil though !
//	BITMAP *bufferzor;
//	bufferzor=create_bitmap(640,480);
	if (virtcopy) {
//	int x;
//	int y;
//	for (x=0;x < 320; x++){
//	for (y=0;y < 200; y++){
	//printf("%d",vga2alleg(virtscreen[(y*640)+x]));
//	putpixel(bufferzor,x,y,vga2alleg(virtscreen[(y*640)+x]));
//}
//}
	acquire_screen();
	blit(bufferzor,screen,0,0,0,0,640,400);
	release_screen();
	virtcopy=0;
	}
      } /* virtscreencopy */


/*-------------------------------------*/


//      void virtplot (unsigned int x, unsigned int y, unsigned char c) {
//	virtscreen[(y*320)+x]=c;
	//acquire_screen();
	//putpixel(screen,x,y,c);
	//printf("x:%d, y:%d, c:%d\n",x,y,c);
	//release_screen();

//      } /* virtplot */


/*-------------------------------------*/


      void virtwrite0400 (register unsigned int addr) {
	register unsigned int line;

	if (~(virtcachemode & cachepage)) {
	  line = textline[addr - 0x400];
	  if ((line >= virtsplit) && (line <= 191)) {
	    virtcache[line++] = 0;
	    virtcache[line++] = 0;
	    virtcache[line++] = 0;
	    virtcache[line++] = 0;
	    virtcache[line++] = 0;
	    virtcache[line++] = 0;
	    virtcache[line++] = 0;
	    virtcache[line] = 0;
	  }
	}
      } /* virtwrite0400 */


/*-------------------------------------*/


      void virtwrite0400aux (register unsigned int addr) {
	register unsigned int line;

	if (virt80col) {
	  if (~(virtcachemode & cachepage)) {
	    line = textline[addr - 0x400];
	    if ((line >= virtsplit) && (line <= 191)) {
	      virtcache[line++] = 0;
	      virtcache[line++] = 0;
	      virtcache[line++] = 0;
	      virtcache[line++] = 0;
	      virtcache[line++] = 0;
	      virtcache[line++] = 0;
	      virtcache[line++] = 0;
	      virtcache[line] = 0;
	    }
	  }
	}
      } /* virtwrite0400aux */


/*-------------------------------------*/


      void virtwrite0800 (register unsigned int addr) {
	register unsigned int line;

	if (virtcachemode & cachepage) {
	  line = textline[addr - 0x800];
	  if ((line >= virtsplit) && (line <= 191)) {
	    virtcache[line++] = 0;
	    virtcache[line++] = 0;
	    virtcache[line++] = 0;
	    virtcache[line++] = 0;
	    virtcache[line++] = 0;
	    virtcache[line++] = 0;
	    virtcache[line++] = 0;
	    virtcache[line] = 0;
	  }
	}
      } /* virtwrite0800 */


/*-------------------------------------*/


      void virtwrite0800aux (register unsigned int addr) {
	register unsigned int line;

	if (virt80col) {
	  if (virtcachemode & cachepage) {
	    line = textline[addr - 0x800];
	    if ((line >= virtsplit) && (line <= 191)) {
	      virtcache[line++] = 0;
	      virtcache[line++] = 0;
	      virtcache[line++] = 0;
	      virtcache[line++] = 0;
	      virtcache[line++] = 0;
	      virtcache[line++] = 0;
	      virtcache[line++] = 0;
	      virtcache[line] = 0;
	    }
	  }
	}
      } /* virtwrite0800aux */


/*-------------------------------------*/


      void virtwrite2000 (register unsigned int addr) {
	register unsigned int line;

	if (!(virtcachemode & cachepage)) {
	  line = hresline[addr - 0x2000];
	  if (line < virtsplit) {
	    virtcache[line] = 0;
	  }
	}
      } /* virtwrite2000 */


/*-------------------------------------*/


      void virtwrite2000aux (register unsigned int addr) {
	register unsigned int line;

	if (virtdhres) {
	  if (!(virtcachemode & cachepage)) {
	    line = hresline[addr - 0x2000];
	    if (line < virtsplit) {
	      virtcache[line] = 0;
	    }
	  }
	}
      } /* virtwrite2000aux */


/*-------------------------------------*/


      void virtwrite4000 (register unsigned int addr) {
	register unsigned int line;

	if (virtcachemode & cachepage) {
	  line = hresline[addr - 0x4000];
	  if (line < virtsplit) {
	    virtcache[line] = 0;
	  }
	}
      } /* virtwrite4000 */


/*-------------------------------------*/


      void virtwrite4000aux (register unsigned int addr) {
	register unsigned int line;

	if (virtdhres) {
	  if (virtcachemode & cachepage) {
	    line = hresline[addr - 0x4000];
	    if (line < virtsplit) {
	      virtcache[line] = 0;
	    }
	   }
	}
      } /* virtwrite4000aux */


/*-------------------------------------*/


/*void gmode (unsigned int mode)
{
  static union REGS regs;

#define VIDEO int86(16,&regs,&regs);

 regs.x.ax=mode%256;
 VIDEO;

} /* gmode */

void opengraph() {

//  gmode(0x13);
//  virtputpalette();
set_color_depth(8);
set_gfx_mode(
#ifdef __MSDOS__
              GFX_AUTODETECT
#else
              GFX_AUTODETECT_WINDOWED
#endif
                                     ,640,400,0,0);//640,480,0,0);


}
/*-------------------------------------*/


void xputcs (unsigned char c, unsigned int cx, unsigned int attr)
{
  int Y,x,y,FG,BG;
  char ch;

  FG=attr%256;
  BG=attr>>8;

  x=cx*7;
  y=192;

  for (Y=y; Y<y+8; Y++) {
    ch=AppleFont[(c*8+(Y-y))];
    virtplot (x,Y,(ch&128)?FG:BG);
    virtplot (x+1,Y,(ch&64)?FG:BG);
    virtplot (x+2,Y,(ch&32)?FG:BG);
    virtplot (x+3,Y,(ch&16)?FG:BG);
    virtplot (x+4,Y,(ch&8)?FG:BG);
    virtplot (x+5,Y,(ch&4)?FG:BG);
    virtplot (x+6,Y,(ch&2)?FG:BG);
  }
  virtcopy = 1;
} /* xputcs */

