#include "main.h"
#include "opcodes.h"
#include "log.h"

FILE * logfp, * serialfp, * memfp, * pvrfp, * intcfp;

void logmsg (char * fmt, ...)
{
#ifdef LOGGING
	char buf [4096];

	va_list args;
	va_start (args, fmt);
	vsprintf (buf, fmt, args);
	va_end (args);
 
	fprintf(logfp, "%8lx: %s", PC, buf);
//	fflush(logfp);
#endif
}

void logxmsg (int tipo, char * fmt, ...)
{
#ifdef LOGGING
	char buf [4096];
	FILE * fp;

	va_list args;
	va_start (args, fmt);
	vsprintf (buf, fmt, args);
	va_end (args);
 
	switch(tipo)
	{
		case LOG_MEM:	fp = memfp;	break;
		case LOG_PVR:	fp = pvrfp; break;
		case LOG_INTC:	fp = intcfp;	break;
		default:		fp = logfp; break;
	}
  
	fprintf(fp, "%8lx: %s", PC, buf);
//	fflush(fp);
#endif
}

int inicializar_logs()
{
/*	FILE * fp;
	int i, j; */

    unlink("logs/error.txt");
    unlink("logs/disasm.txt");
    unlink("logs/memoria.txt");
    unlink("logs/serial.txt");
    unlink("logs/pvr.txt");
    unlink("logs/intc.txt");
	
	logfp = fopen("logs/disasm.txt", "w");

	if (!logfp)
	{
		fprintf(stderr, "No se pudo abrir disasm.txt\r\n");
		return 1;
	}

	memfp = fopen("logs/memoria.txt", "w");

	if (!memfp)
	{
		fprintf(stderr, "No se pudo abrir memoria.txt\r\n");
		return 1;
	}

	serialfp = fopen("logs/serial.txt", "w");

	if (!serialfp)
	{
		fprintf(stderr, "No se pudo abrir serial.txt");
		return 1;
	}

	pvrfp = fopen("logs/pvr.txt", "w");

	if (!pvrfp)
	{
		fprintf(stderr, "No se pudo abrir pvr.txt");
		return 1;
	}

	intcfp = fopen("logs/intc.txt", "w");

	if (!intcfp)
	{
		fprintf(stderr, "No se pudo abrir intc.txt");
		return 1;
	}

/*    fp = fopen("logs/listado.txt", "w");

	for (i = 0; i < tam + 1; i += 2)
	{
		j = find_opcode(mem_base + mem_offset + i); // partimos desde 0x8c010000

		if (j != -1)
        {
			ultop[0].func = opcodes[j].logfunc;
        	ultop[0].params.pos = j;
        	memcpy(&ultop[0].params.arg, &memoria[mem_n_base + mem_offset + i], sizeof(WORD));
        	ultop[0].params.PC = mem_base + mem_offset + i;

    		(*ultop[0].func) (&(ultop[0].params));

    		fprintf(fp, "%04x %s\r\n", (DWORD) ultop[0].params.arg, lastop);
		}
		else
			fprintf(fp, "%04x ???\r\n", *(WORD *) &memoria[mem_n_base + mem_offset + i]);
	}

	fclose(fp); */
	
	return 0;
}

LOG_OPCODE2(OP_T_IMM_RN, "#%x, R%d", LSB(params->arg), BYTE2(params->arg))
LOG_OPCODE3(OP_T_AT_DISP_PC_RN, "@(%x, PC) = %lx, R%d", LSB(params->arg), LSB(params->arg)*4 + (params->PC & 0xFFFFFFFC) + 4, BYTE2(params->arg))
LOG_OPCODE2(OP_T_RM_RN, "R%d, R%d", BYTE3(params->arg), BYTE2(params->arg))
LOG_OPCODE2(OP_T_RM_AT_RN, "R%d, @R%d", BYTE3(params->arg), BYTE2(params->arg))
LOG_OPCODE2(OP_T_AT_RM_RN, "@R%d, R%d", BYTE3(params->arg), BYTE2(params->arg))
LOG_OPCODE2(OP_T_RM_AT_MIN_RN, "R%d, @-R%d", BYTE3(params->arg), BYTE2(params->arg))
LOG_OPCODE2(OP_T_AT_RM_PLUS_RN, "@R%d+, R%d", BYTE3(params->arg), BYTE2(params->arg))
LOG_OPCODE2(OP_T_R0_AT_DISP_RN, "R0, @(%x, R%d)", BYTE4(params->arg), BYTE3(params->arg))
LOG_OPCODE3(OP_T_RM_AT_DISP_RN, "R%d, @(%x, R%d)", BYTE3(params->arg), BYTE4(params->arg), BYTE2(params->arg))
LOG_OPCODE2(OP_T_AT_DISP_RM_R0, "@(%x, R%d), R0", BYTE4(params->arg), BYTE3(params->arg))
LOG_OPCODE3(OP_T_AT_DISP_RM_RN, "@(%x, R%d), R%d", BYTE4(params->arg), BYTE3(params->arg), BYTE2(params->arg))
LOG_OPCODE2(OP_T_RM_AT_R0_RN, "R%d, @(R0, R%d)", BYTE3(params->arg), BYTE2(params->arg))
LOG_OPCODE2(OP_T_AT_R0_RM_RN, "@(R0, R%d), R%d", BYTE3(params->arg), BYTE2(params->arg))
LOG_OPCODE1(OP_T_R0_AT_DISP_GBR, "R0, @(%x, GBR)", LSB(params->arg))
LOG_OPCODE1(OP_T_AT_DISP_GBR_R0, "@(%x, GBR), R0", LSB(params->arg))
LOG_OPCODE1(OP_T_AT_DISP_PC_R0, "@(%x, PC), R0", LSB(params->arg))
LOG_OPCODE1(OP_T_RN, "R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_IMM_R0, "#%x, R0", LSB(params->arg))
LOG_OPCODE0(OP_T_NA)
LOG_OPCODE2(OP_T_AT_RM_PLUS_AT_RN_PLUS, "@R%d+, @R%d+", BYTE3(params->arg), BYTE2(params->arg))
LOG_OPCODE1(OP_T_IMM_AT_R0_GBR, "#%x, @(R0, GBR)", LSB(params->arg))
LOG_OPCODE1(OP_T_AT_RN, "@R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_LABEL8, "%lx", SignExtend8(LSB(params->arg))*2 + (params->PC) + 4)
LOG_OPCODE1(OP_T_LABEL12, "%lx", SignExtend12(BYTES234(params->arg))*2 + (params->PC) + 4)
LOG_OPCODE1(OP_T_RM_SR, "R%d, SR", BYTE2(params->arg))
LOG_OPCODE1(OP_T_RM_GBR, "R%d, GBR", BYTE2(params->arg))
LOG_OPCODE1(OP_T_RM_VBR, "R%d, VBR", BYTE2(params->arg))
LOG_OPCODE1(OP_T_RM_SSR, "R%d, SSR", BYTE2(params->arg))
LOG_OPCODE1(OP_T_RM_SPC, "R%d, SPC", BYTE2(params->arg))
LOG_OPCODE1(OP_T_RM_DBR, "R%d, DBR", BYTE2(params->arg))
LOG_OPCODE2(OP_T_RM_RN_BANK, "R%d, R%d_BANK", BYTE2(params->arg), BITS57(params->arg))
LOG_OPCODE1(OP_T_AT_RM_PLUS_SR, "@R%d+, SR", BYTE2(params->arg))
LOG_OPCODE1(OP_T_AT_RM_PLUS_GBR, "@R%d+, GBR", BYTE2(params->arg))
LOG_OPCODE1(OP_T_AT_RM_PLUS_VBR, "@R%d+, VBR", BYTE2(params->arg))
LOG_OPCODE1(OP_T_AT_RM_PLUS_SSR, "@R%d+, SSR", BYTE2(params->arg))
LOG_OPCODE1(OP_T_AT_RM_PLUS_SPC, "@R%d+, SPC", BYTE2(params->arg))
LOG_OPCODE1(OP_T_AT_RM_PLUS_DBR, "@R%d+, DBR", BYTE2(params->arg))
LOG_OPCODE2(OP_T_AT_RM_PLUS_RN_BANK, "@R%d+, R%d_BANK", BYTE2(params->arg), BITS57(params->arg))
LOG_OPCODE1(OP_T_RM_MACH, "R%d, MACH", BYTE2(params->arg))
LOG_OPCODE1(OP_T_RM_MACL, "R%d, MACH", BYTE2(params->arg))
LOG_OPCODE1(OP_T_RM_PR, "R%d, PR", BYTE2(params->arg))
LOG_OPCODE1(OP_T_AT_RM_PLUS_MACH, "@R%d+, MACH", BYTE2(params->arg))
LOG_OPCODE1(OP_T_AT_RM_PLUS_MACL, "@R%d+, MACH", BYTE2(params->arg))
LOG_OPCODE1(OP_T_AT_RM_PLUS_PR, "@R%d+, PR", BYTE2(params->arg))
LOG_OPCODE1(OP_T_R0_AT_RN, "R0, @R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_SR_RN, "SR, R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_GBR_RN, "GBR, R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_VBR_RN, "VBR, R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_SSR_RN, "SSR, R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_SPC_RN, "SPC, R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_SGR_RN, "SGR, R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_DBR_RN, "DBR, R%d", BYTE2(params->arg))
LOG_OPCODE2(OP_T_RM_BANK_RN, "R%d_BANK, R%d", BITS57(params->arg), BYTE2(params->arg))
LOG_OPCODE1(OP_T_SR_AT_MIN_RN, "SR, @-R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_GBR_AT_MIN_RN, "GBR, @-R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_VBR_AT_MIN_RN, "VBR, @-R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_SSR_AT_MIN_RN, "SSR, @-R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_SPC_AT_MIN_RN, "SPC, @-R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_SGR_AT_MIN_RN, "SGR, @-R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_DBR_AT_MIN_RN, "DBR, @-R%d", BYTE2(params->arg))
LOG_OPCODE2(OP_T_RM_BANK_AT_MIN_RN, "R%d_BANK, @-R%d", BITS57(params->arg), BYTE2(params->arg))
LOG_OPCODE1(OP_T_MACH_RN, "MACH, R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_MACL_RN, "MACL, R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_PR_RN, "PR, R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_MACH_AT_MIN_RN, "MACH, @-R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_MACL_AT_MIN_RN, "MACL, @-R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_PR_AT_MIN_RN, "PR, @-R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_IMM, "#%x", LSB(params->arg))
LOG_OPCODE1(OP_T_FRN, "FR%d", BYTE2(params->arg))
LOG_OPCODE2(OP_T_FRM_FRN, "FR%d, FR%d", BYTE3(params->arg), BYTE2(params->arg))
LOG_OPCODE2(OP_T_AT_RM_FRN, "@R%d, FR%d", BYTE3(params->arg), BYTE2(params->arg))
LOG_OPCODE2(OP_T_AT_R0_RM_FRN, "@(R0, R%d), FR%d", BYTE3(params->arg), BYTE2(params->arg))
LOG_OPCODE2(OP_T_AT_RM_PLUS_FRN, "@R%d+, FR%d", BYTE3(params->arg), BYTE2(params->arg))
LOG_OPCODE2(OP_T_FRM_AT_RN, "FR%d, @R%d", BYTE3(params->arg), BYTE2(params->arg))
LOG_OPCODE2(OP_T_FRM_AT_MIN_RN, "FR%d, @-R%d", BYTE3(params->arg), BYTE2(params->arg))
LOG_OPCODE2(OP_T_FRM_AT_R0_RN, "FR%d, @(R0, R%d)", BYTE3(params->arg), BYTE2(params->arg))
LOG_OPCODE2(OP_T_DRM_DRN, "DR%d, DR%d", BITS68(params->arg), BITS1012(params->arg))
LOG_OPCODE2(OP_T_AT_RM_DRN, "@R%d, DR%d", BYTE3(params->arg), BITS1012(params->arg))
LOG_OPCODE2(OP_T_AT_R0_RM_DRN, "@(R0, R%d), DR%d", BYTE3(params->arg), BITS1012(params->arg))
LOG_OPCODE2(OP_T_AT_RM_PLUS_DRN, "@R%d+, DR%d", BYTE3(params->arg), BITS1012(params->arg))
LOG_OPCODE2(OP_T_DRM_AT_RN, "DR%d, @R%d", BITS68(params->arg), BYTE2(params->arg))
LOG_OPCODE2(OP_T_DRM_AT_MIN_RN, "DR%d, @-R%d", BITS68(params->arg), BYTE2(params->arg))
LOG_OPCODE2(OP_T_DRM_AT_R0_RN, "DR%d, @(R0, R%d)", BITS68(params->arg), BYTE2(params->arg))
LOG_OPCODE1(OP_T_FRM_FPUL, "FR%d, FPUL", BYTE2(params->arg))
LOG_OPCODE1(OP_T_FPUL_FRN, "FPUL, FR%d", BYTE2(params->arg))
LOG_OPCODE2(OP_T_FR0_FRM_FRN, "FR0, FR%d, FR%d", BYTE3(params->arg), BYTE2(params->arg))
LOG_OPCODE1(OP_T_DRN, "DR%d", BITS1012(params->arg))
LOG_OPCODE1(OP_T_DRM_FPUL, "DR%d, FPUL", BITS1012(params->arg))
LOG_OPCODE1(OP_T_FPUL_DRN, "FPUL, DR%d", BITS1012(params->arg))
LOG_OPCODE1(OP_T_RM_FPSCR, "R%d, FPSCR", BYTE2(params->arg))
LOG_OPCODE1(OP_T_RM_FPUL, "R%d, FPUL", BYTE2(params->arg))
LOG_OPCODE1(OP_T_RM_SGR, "R%d, SGR", BYTE2(params->arg))
LOG_OPCODE1(OP_T_AT_RM_PLUS_FPSCR, "@R%d+, FPSCR", BYTE2(params->arg))
LOG_OPCODE1(OP_T_AT_RM_PLUS_FPUL, "@R%d+, FPUL", BYTE2(params->arg))
LOG_OPCODE1(OP_T_AT_RM_PLUS_SGR, "@R%d+, SGR", BYTE2(params->arg))
LOG_OPCODE1(OP_T_FPSCR_RN, "FPSCR, R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_FPUL_RN, "FPUL, R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_FPSCR_AT_MIN_RN, "FPSCR, @-R%d", BYTE2(params->arg))
LOG_OPCODE1(OP_T_FPUL_AT_MIN_RN, "FPUL, @-R%d", BYTE2(params->arg))
LOG_OPCODE2(OP_T_DRM_XDN, "DR%d, XD%d", BITS68(params->arg), BITS1012(params->arg))
LOG_OPCODE2(OP_T_XDM_DRN, "XD%d, DR%d", BITS68(params->arg), BITS1012(params->arg))
LOG_OPCODE2(OP_T_XDM_XDN, "XD%d, XD%d", BITS68(params->arg), BITS1012(params->arg))
LOG_OPCODE2(OP_T_AT_RM_XDN, "@R%d, XD%d", BYTE3(params->arg), BITS1012(params->arg))
LOG_OPCODE2(OP_T_AT_RM_PLUS_XDN, "@R%d+, XD%d", BYTE3(params->arg), BITS1012(params->arg))
LOG_OPCODE2(OP_T_AT_R0_RM_XDN, "@(R0, R%d), XD%d", BYTE3(params->arg), BITS1012(params->arg))
LOG_OPCODE2(OP_T_XDM_AT_RN, "XD%d, @R%d", BITS68(params->arg), BYTE2(params->arg))
LOG_OPCODE2(OP_T_XDM_AT_MIN_RN, "XD%d, @-R%d", BITS68(params->arg), BYTE2(params->arg))
LOG_OPCODE2(OP_T_XDM_AT_R0_RN, "XD%d, @(R0, R%d)", BITS68(params->arg), BYTE2(params->arg))
LOG_OPCODE2(OP_T_FVM_FVN, "FV%d, FV%d", BITS910(params->arg), BITS1112(params->arg))
LOG_OPCODE1(OP_T_XMTRX_FVN, "XMTRX, FV%d", BITS1112(params->arg))

