/*
 * Decompiled with CFR 0.152.
 */
package frc.asm;

import frc.asm.AsmOptions;
import frc.asm.ExecASM;
import frc.asm.api.IAsmFeedback;
import frc.emul.util.Utils;
import java.io.File;
import java.io.IOException;

public class AS09_DOS_FIXED
extends ExecASM {
    private File binary;

    public final String getName() {
        return "AS09 version 1.41 (for MSDOS)";
    }

    protected boolean setup(AsmOptions asmOptions, IAsmFeedback iAsmFeedback) {
        try {
            this.binary = Utils.getUniqueFile(asmOptions.getSourcesDir(), "ParaJVE", ".ROM");
            return true;
        }
        catch (Exception exception) {
            iAsmFeedback.getErrorStream().println("*** Failed to setup AS09 assembly");
            exception.printStackTrace(iAsmFeedback.getErrorStream());
            return false;
        }
    }

    protected boolean cleanup(AsmOptions asmOptions, IAsmFeedback iAsmFeedback, boolean bl) {
        if (bl) {
            bl = false;
            if (this.binary != null && this.binary.isFile()) {
                try {
                    File file = asmOptions.getOutputFile();
                    Utils.copy(this.binary, file);
                    file.deleteOnExit();
                    bl = true;
                }
                catch (Exception exception) {
                    iAsmFeedback.getErrorStream().println("*** Failed to copy assembled ROM to target file");
                    exception.printStackTrace(iAsmFeedback.getErrorStream());
                }
            }
        }
        if (this.binary != null && this.binary.isFile()) {
            if (!this.binary.delete()) {
                this.binary.deleteOnExit();
            }
            this.binary = null;
        }
        return bl;
    }

    public final String getGenericErrorMessage(int n) {
        switch (n) {
            case -1: {
                return "User aborted";
            }
            case 0: {
                return "Source file assembled without error";
            }
            case 1: {
                return "Incorrect parameter specified on the commandline";
            }
            case 2: {
                return "Unable to open input or output file";
            }
            case 3: {
                return "Assembly error(s)";
            }
            case 4: {
                return "No memory could be allocated";
            }
        }
        return "Unknown error code (" + n + ")";
    }

    protected String[] getExecCommand(AsmOptions asmOptions) throws IOException {
        return new String[]{"bin/as09.exe", "-iq", "-lnul", "-o" + this.binary.getName(), asmOptions.getSourceFile().getName()};
    }
}

