/*
 * Decompiled with CFR 0.152.
 */
package frc.asm;

import frc.asm.AsmOptions;
import frc.asm.FeedbackAdapter;
import frc.asm.api.IAsmFeedback;
import frc.asm.api.IAsmOptions;
import frc.asm.api.IAssembler;
import java.io.File;
import javax.swing.JComponent;

public abstract class AbstractASM
implements IAssembler {
    private Object COMPLETION = new Object();
    private volatile boolean success;
    private volatile boolean completed;
    protected IAsmFeedback feedback;
    protected AsmOptions options;

    protected abstract void process();

    public abstract void abort();

    protected boolean setup(AsmOptions asmOptions, IAsmFeedback iAsmFeedback) {
        return true;
    }

    protected boolean cleanup(AsmOptions asmOptions, IAsmFeedback iAsmFeedback, boolean bl) {
        return bl;
    }

    protected AsmOptions instanciateOptions() {
        return new AsmOptions();
    }

    protected long getProcessingTimeout(AsmOptions asmOptions) {
        return asmOptions.getProcessingTimeout();
    }

    protected void prepareOptions(JComponent jComponent) {
    }

    public IAsmOptions getOptions(File file, JComponent jComponent) {
        AsmOptions asmOptions = this.instanciateOptions();
        asmOptions.setSourceFile(file);
        this.prepareOptions(jComponent);
        return asmOptions;
    }

    public synchronized boolean assemble(IAsmOptions iAsmOptions, IAsmFeedback iAsmFeedback) {
        boolean bl = false;
        this.options = (AsmOptions)iAsmOptions;
        try {
            if (this.setup(this.options, iAsmFeedback)) {
                bl = this.assembleImpl(this.options, iAsmFeedback);
            }
        }
        finally {
            bl = this.cleanup(this.options, iAsmFeedback, bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean assembleImpl(AsmOptions asmOptions, IAsmFeedback iAsmFeedback) {
        if (iAsmFeedback == null) {
            iAsmFeedback = new FeedbackAdapter();
        }
        this.feedback = iAsmFeedback;
        this.success = false;
        Object object = this.COMPLETION;
        synchronized (object) {
            block13: {
                this.completed = false;
                try {
                    try {
                        this.process();
                        try {
                            this.COMPLETION.wait(this.getProcessingTimeout(asmOptions));
                        }
                        catch (InterruptedException interruptedException) {}
                        if (!this.completed) {
                            this.completed(false);
                            iAsmFeedback.getErrorStream().println("*** Processing timeout, aborting...");
                            this.abort();
                        }
                    }
                    catch (Exception exception) {
                        iAsmFeedback.getErrorStream().println("*** Error while building source, aborting...");
                        if (!this.completed) {
                            this.completed(false);
                            this.abort();
                        }
                        iAsmFeedback.completed(this.completed && this.success);
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    iAsmFeedback.completed(this.completed && this.success);
                    throw throwable;
                }
                iAsmFeedback.completed(this.completed && this.success);
            }
        }
        return this.success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void completed(boolean bl) {
        Object object = this.COMPLETION;
        synchronized (object) {
            if (!this.completed) {
                this.success = bl;
                this.completed = true;
                this.COMPLETION.notifyAll();
            }
        }
    }
}

