/*
 * Decompiled with CFR 0.152.
 */
package frc.asm;

import frc.asm.api.IAsmOptions;
import frc.emul.util.Utils;
import java.io.File;
import java.io.IOException;

public class AsmOptions
implements IAsmOptions {
    private File source;
    private File output;
    private long timeout = 10000L;

    protected synchronized void setSourceFile(File file) {
        this.source = file;
        this.output = null;
    }

    public File getSourceFile() {
        return this.source;
    }

    public File getSourcesDir() throws IOException {
        return this.getSourceFile().getCanonicalFile().getParentFile();
    }

    public File getOutputDir() throws IOException {
        return this.getOutputFile().getCanonicalFile().getParentFile();
    }

    public File buildOutputFile(String string) throws IOException {
        return new File(this.getOutputDir(), string);
    }

    public File buildOutputFileFromExt(String string) throws IOException {
        return new File(this.getOutputDir(), this.changeExtension(string));
    }

    public void setProcessingTimeout(long l) {
        this.timeout = l;
    }

    public long getProcessingTimeout() {
        return this.timeout;
    }

    public synchronized File getOutputFile() {
        if (this.output == null) {
            this.output = new File(Utils.getTempDir(), this.changeExtension("bin"));
        }
        return this.output;
    }

    private String changeExtension(String string) {
        if (this.source == null) {
            throw new IllegalStateException("No source file specified!");
        }
        String string2 = this.source.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        return string == null ? string2 : String.valueOf(string2) + "." + string;
    }
}

