/*
 * Decompiled with CFR 0.152.
 */
package frc.asm;

import frc.asm.AbstractASM;
import frc.asm.AsmOptions;
import frc.asm.StreamRedirector;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;

public abstract class ExecASM
extends AbstractASM {
    private static final boolean dump = true;
    private volatile boolean abort;
    private Thread worker;

    public abstract String getGenericErrorMessage(int var1);

    protected abstract String[] getExecCommand(AsmOptions var1) throws Exception;

    protected final void process() {
        this.worker = new Thread("AS09 assembler"){

            public void run() {
                block8: {
                    boolean bl = false;
                    try {
                        try {
                            int n = ExecASM.this.exec(ExecASM.this.options);
                            boolean bl2 = bl = n == 0;
                            if (bl) {
                                ExecASM.this.feedback.getOutputStream().println("--- BUILDER COMPLETED SUCCESSFULLY");
                                break block8;
                            }
                            ExecASM.this.feedback.getOutputStream().println("*** BUILDER ENDED WITH ERROR #" + n + " : " + ExecASM.this.getGenericErrorMessage(n));
                        }
                        catch (Exception exception) {
                            ExecASM.this.feedback.getErrorStream().println("*** Error while invoking AS09 assembler :");
                            exception.printStackTrace(ExecASM.this.feedback.getErrorStream());
                            if (!ExecASM.this.abort) {
                                ExecASM.this.completed(bl);
                            }
                        }
                    }
                    finally {
                        if (!ExecASM.this.abort) {
                            ExecASM.this.completed(bl);
                        }
                    }
                }
            }
        };
        this.abort = false;
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void abort() {
        this.abort = true;
        if (this.worker != null && this.worker.isAlive()) {
            Thread thread = this.worker;
            synchronized (thread) {
                this.worker.interrupt();
                try {
                    this.worker.join(4000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected File getExecDir(AsmOptions asmOptions) throws IOException {
        return asmOptions.getSourceFile().getCanonicalFile().getParentFile();
    }

    private final int exec(AsmOptions asmOptions) throws Exception {
        String[] stringArray = this.getExecCommand(asmOptions);
        File file = this.getExecDir(asmOptions);
        Object object = this.feedback.getOutputStream();
        ((PrintStream)object).println("EXEC. FOLDER = [" + file.getPath() + "]");
        ((PrintStream)object).println("COMMAND LINE = " + stringArray.length + " arguments:");
        int n = 0;
        while (n < stringArray.length) {
            ((PrintStream)object).println("  #" + (n + 1) + "\t = [" + stringArray[n] + "]");
            ++n;
        }
        object = Runtime.getRuntime().exec(stringArray, null, file);
        StreamRedirector streamRedirector = new StreamRedirector(((Process)object).getInputStream(), this.feedback.getOutputStream());
        StreamRedirector streamRedirector2 = new StreamRedirector(((Process)object).getErrorStream(), this.feedback.getErrorStream());
        while (true) {
            try {
                ((Process)object).waitFor();
            }
            catch (InterruptedException interruptedException) {}
            try {
                n = ((Process)object).exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                if (!this.abort) continue;
                streamRedirector.silent();
                streamRedirector2.silent();
                System.err.println("*** Killing timed-out process...");
                ((Process)object).destroy();
                n = -1;
            }
            break;
        }
        if (!this.abort) {
            streamRedirector.join();
            streamRedirector2.join();
        }
        return n;
    }
}

