/*
 * Decompiled with CFR 0.152.
 */
package frc.asm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class StreamRedirector
implements Runnable {
    private final BufferedReader in;
    private final Thread worker;
    private PrintStream out;

    public StreamRedirector(InputStream inputStream, PrintStream printStream) {
        this.in = new BufferedReader(new InputStreamReader(inputStream));
        this.out = printStream;
        this.worker = new Thread(this);
        this.worker.start();
    }

    public final void silent() {
        this.out = null;
    }

    public final void run() {
        try {
            String string;
            while ((string = this.in.readLine()) != null) {
                PrintStream printStream = this.out;
                if (printStream == null) continue;
                printStream.println(string);
            }
            try {
                this.in.close();
            }
            catch (Exception exception) {}
        }
        catch (IOException iOException) {
            throw new RuntimeException("I/O Error when redirecting stream:", iOException);
        }
    }

    public final void join() throws InterruptedException {
        this.worker.join();
    }
}

