/*
 * Decompiled with CFR 0.152.
 */
package frc.diag;

import frc.emul.vectrex.ui.opengl.GLUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class TestJOGL
implements GLEventListener,
ActionListener {
    private final GLU glu = new GLU();
    private boolean antialiasing;
    private GLCanvas canvas;
    private double theta;

    private TestJOGL() {
    }

    private final void run(boolean bl) {
        this.antialiasing = bl;
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setRedBits(8);
        gLCapabilities.setBlueBits(8);
        gLCapabilities.setGreenBits(8);
        gLCapabilities.setAlphaBits(8);
        gLCapabilities.setDepthBits(16);
        this.canvas = new GLCanvas(gLCapabilities);
        this.canvas.addGLEventListener((GLEventListener)this);
        JFrame jFrame = new JFrame("ParaJVE Tests - JOGL library");
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add((Component)this.canvas);
        ((JComponent)jFrame.getContentPane()).setPreferredSize(new Dimension(300, 300));
        jFrame.pack();
        jFrame.setResizable(false);
        ((Component)jFrame).setVisible(true);
        new Timer(16, this).start();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.canvas.repaint();
        this.theta = (this.theta + 3.0E-4) % 1.0;
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        GLUtils.dumpInfos(gL);
        gL.glHint(3154, 4354);
        gL.glDisable(3552);
        gL.glDisable(3553);
        gL.glDisable(32879);
        gL.glDisable(2896);
        gL.glDisable(2884);
        gL.glDisable(2929);
        gL.glLineWidth(2.5f);
        gL.glDepthMask(false);
        if (this.antialiasing) {
            gL.glBlendFunc(770, 771);
            gL.glEnable(3042);
            gL.glEnable(2848);
        } else {
            gL.glDisable(3042);
            gL.glDisable(2848);
        }
        gL.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gL.glColor3f(1.0f, 1.0f, 1.0f);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL gL = gLAutoDrawable.getGL();
        gL.glViewport(n, n2, n3, n4);
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        this.glu.gluOrtho2D(-1.0, 1.001, -1.0, 1.001);
        gL.glMatrixMode(5888);
        gL.glLoadIdentity();
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        gL.glClear(16384);
        gL.glLoadIdentity();
        gL.glTranslatef(-0.45f, 0.0f, 0.0f);
        gL.glScalef(0.35f, 0.35f, 1.0f);
        gL.glTranslatef(1.25f, 0.0f, 0.0f);
        float f = (float)Math.sin(this.theta * 360.0) * 11.0f;
        gL.glRotatef(f, 0.0f, 0.0f, 1.0f);
        gL.glTranslatef(-1.25f, 0.0f, 0.0f);
        gL.glBegin(2);
        gL.glVertex2f(-0.7f, 1.0f);
        gL.glVertex2f(-1.0f, 0.7f);
        gL.glVertex2f(-1.0f, -0.7f);
        gL.glVertex2f(-0.7f, -1.0f);
        gL.glVertex2f(0.7f, -1.0f);
        gL.glVertex2f(1.0f, -0.7f);
        gL.glVertex2f(1.0f, 0.7f);
        gL.glVertex2f(0.7f, 1.0f);
        gL.glEnd();
        gL.glTranslatef(2.5f, 0.0f, 0.0f);
        gL.glBegin(1);
        gL.glVertex2f(-1.0f, 1.0f);
        gL.glVertex2f(-1.0f, -1.0f);
        gL.glVertex2f(-1.0f, 0.0f);
        gL.glVertex2f(-0.3f, 0.0f);
        gL.glEnd();
        gL.glBegin(3);
        gL.glVertex2f(1.0f, 1.0f);
        gL.glVertex2f(-0.3f, 0.0f);
        gL.glVertex2f(1.0f, -1.0f);
        gL.glEnd();
        gL.glTranslatef(2.5f, 0.0f, 0.0f);
    }

    public static final void main(String[] stringArray) {
        boolean bl = true;
        int n = stringArray.length;
        while (n-- > 0) {
            if (!stringArray[n].equalsIgnoreCase("-aa")) continue;
            bl = false;
        }
        n = 0;
        try {
            System.out.println("Starting TestJOGL ...");
            System.out.println();
            System.out.flush();
            new TestJOGL().run(bl);
            n = 1;
        }
        finally {
            if (n == 0) {
                JOptionPane.showMessageDialog(null, "Could not run the JOGL test successfully!", "ParaJVE Test Failed", 0);
            }
        }
    }
}

