/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config.data;

import frc.emul.config.Configuration;
import frc.emul.config.data.CfgItemChassis;
import frc.emul.config.data.CfgItemShaderGlow;
import frc.emul.config.data.CfgItemShaderOverlay;
import frc.emul.util.Utils;
import java.io.File;

public class CfgItemOptions
implements Cloneable {
    public static final int SAMPLING_FREQ_BASE = 11025;
    public static final float DEFAULT_SIZE_POINTS = 2.5f;
    public static final float DEFAULT_SIZE_LINES = 1.0f;
    public static final float MIN_SIZE_POINTS = 0.1f;
    public static final float MIN_SIZE_LINES = 0.1f;
    public static final float MAX_SIZE_POINTS = 6.0f;
    public static final float MAX_SIZE_LINES = 3.5f;
    public boolean firstRun = true;
    public boolean hideMenuHelp = true;
    public boolean debugMode;
    public boolean showFps;
    public boolean menuVisible = true;
    public boolean display_antialiasing = true;
    public boolean display_overlay = true;
    public boolean display_persistence = true;
    public boolean display_additive_blend = true;
    public float display_gamma = 0.9f;
    public float display_brightness = 1.0f;
    public int display_overlay_mode = -1;
    public float display_size_points = 2.5f;
    public float display_size_lines = 1.0f;
    public boolean display_wobbling = true;
    public float display_wobbling_factor = 0.125f;
    public boolean display_fullscreen;
    public boolean display_full_viewport;
    public int display_rotation;
    public int snd_samplingFreq = 44100;
    public float snd_volume = 1.0f;
    public boolean snd_enabled = true;
    public boolean snd_createThread = true;
    public boolean snd_useNano;
    public String lastPathUserSaves;
    public String lastPathSnapshots;
    public String lastPathInjections;
    public CfgItemChassis chassis = new CfgItemChassis();
    public CfgItemShaderGlow glowShader = new CfgItemShaderGlow();
    public CfgItemShaderOverlay overlayShader = new CfgItemShaderOverlay();

    public CfgItemOptions clone() {
        try {
            return (CfgItemOptions)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public void storeLastPathInjections(File file, Configuration configuration) {
        this.storePath(Path.INJECTIONS, file, configuration);
    }

    public void storeLastPathSnapshots(File file, Configuration configuration) {
        this.storePath(Path.SNAPSHOTS, file, configuration);
    }

    public void storeLastPathUserSave(File file, Configuration configuration) {
        this.storePath(Path.USER_SAVES, file, configuration);
    }

    private void storePath(Path path, File file, Configuration configuration) {
        if (file != null) {
            try {
                if (!file.isDirectory()) {
                    file = file.getParentFile();
                }
                String string = Utils.getAbsolutePath(file);
                path.set(this, string);
                if (configuration != null) {
                    configuration.setDirty(true);
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Path {
        INJECTIONS{

            void set(CfgItemOptions cfgItemOptions, String string) {
                cfgItemOptions.lastPathInjections = string;
            }
        }
        ,
        USER_SAVES{

            void set(CfgItemOptions cfgItemOptions, String string) {
                cfgItemOptions.lastPathUserSaves = string;
            }
        }
        ,
        SNAPSHOTS{

            void set(CfgItemOptions cfgItemOptions, String string) {
                cfgItemOptions.lastPathSnapshots = string;
            }
        };


        abstract void set(CfgItemOptions var1, String var2);
    }
}

