/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config.handler;

import frc.emul.config.ConfigException;
import frc.emul.config.data.CfgItemBankMenu;
import frc.emul.config.handler.CLHConfiguration;
import frc.emul.config.handler.ConfigLoaderHandler;
import frc.util.xml.XMLLoaderHandler;
import java.util.List;
import org.xml.sax.Attributes;

public class CLHCartMenus
extends ConfigLoaderHandler {
    private final Level level;

    public CLHCartMenus(CLHConfiguration cLHConfiguration) {
        super(cLHConfiguration);
        this.level = Level.ROOT;
    }

    private CLHCartMenus(CLHCartMenus cLHCartMenus) {
        super(cLHCartMenus);
        this.level = Level.MENU;
    }

    public void pushed(Attributes attributes) {
        if (Level.MENU != this.level) {
            return;
        }
        String string = CLHCartMenus.loadStr(attributes, "id", null);
        String string2 = CLHCartMenus.loadStr(attributes, "mode", "");
        CfgItemBankMenu.Mode mode = CfgItemBankMenu.Mode.getMode(string2);
        if (string == null) {
            throw new ConfigException("Empty CartMenu ID");
        }
        if (this.getConfig().getBankMenu(string) != null) {
            throw new ConfigException("Duplicate CartMenu ID \"" + string + "\"");
        }
        if (mode == null) {
            throw new ConfigException("Unsupported mode [" + string2 + "] for cartridge menu \"" + string + "\"");
        }
        int n = CLHCartMenus.loadInt(attributes, "namesSize", 0, 1, 512);
        int n2 = CLHCartMenus.loadInt(attributes, "counterSize", 1, 0, 4);
        List<CfgItemBankMenu> list = this.getConfig().bankMenus;
        CfgItemBankMenu cfgItemBankMenu = new CfgItemBankMenu();
        cfgItemBankMenu.banksCounterSize = n2;
        cfgItemBankMenu.banksNamesSize = n;
        cfgItemBankMenu.id = string;
        cfgItemBankMenu.mode = mode;
        cfgItemBankMenu.path = attributes.getValue("path");
        list.add(cfgItemBankMenu);
        cfgItemBankMenu.name = CLHCartMenus.loadStr(attributes, "name", "menu #" + list.size());
    }

    public XMLLoaderHandler getChildHandler(String string, Attributes attributes) {
        if (Level.ROOT == this.level && string.equals("cartridgeMenu")) {
            return new CLHCartMenus(this);
        }
        return super.getChildHandler(string, attributes);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Level {
        ROOT,
        MENU;

    }
}

