/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config.handler;

import frc.emul.config.data.CfgItemController;
import frc.emul.config.handler.CLHControllers;
import frc.emul.config.handler.CLHCurve;
import frc.emul.config.handler.CLHSensitivity;
import frc.emul.config.handler.ConfigLoaderHandler;
import frc.util.xml.XMLLoaderHandler;
import org.xml.sax.Attributes;

public class CLHControllerDirection
extends ConfigLoaderHandler {
    public CLHControllerDirection(CLHControllers cLHControllers) {
        super(cLHControllers);
    }

    public XMLLoaderHandler getChildHandler(String string, Attributes attributes) {
        CfgItemController cfgItemController = ((CLHControllers)this.getParent()).ctrl;
        if (string.equals("sensitivity")) {
            return new CLHSensitivity(this, cfgItemController.sensitivity);
        }
        if (string.equals("response")) {
            return new CLHCurve(this, cfgItemController.response);
        }
        return super.getChildHandler(string, attributes);
    }

    public void pushed(Attributes attributes) {
        CfgItemController cfgItemController = ((CLHControllers)this.getParent()).ctrl;
        String string = attributes.getValue("mode");
        if (string == null) {
            throw new RuntimeException("No controller direction mode specified!");
        }
        if (string.equalsIgnoreCase("POV")) {
            cfgItemController.dirMode = CfgItemController.DirControl.POV;
            cfgItemController.povID = CLHControllerDirection.getAttribute(attributes, "id", "");
        } else if (string.equalsIgnoreCase("digital")) {
            cfgItemController.dirMode = CfgItemController.DirControl.BTNS;
            cfgItemController.leftID = CLHControllerDirection.getAttribute(attributes, "left", "");
            cfgItemController.rightID = CLHControllerDirection.getAttribute(attributes, "right", "");
            cfgItemController.upID = CLHControllerDirection.getAttribute(attributes, "up", "");
            cfgItemController.downID = CLHControllerDirection.getAttribute(attributes, "down", "");
        } else if (string.equalsIgnoreCase("axis")) {
            cfgItemController.dirMode = CfgItemController.DirControl.AXIS;
            String string2 = CLHControllerDirection.getAttribute(attributes, "horizontal", "");
            String string3 = CLHControllerDirection.getAttribute(attributes, "vertical", "");
            if (string2.startsWith("-")) {
                cfgItemController.invertX = true;
                string2 = string2.substring(1);
            } else if (string2.startsWith("+")) {
                cfgItemController.invertX = false;
                string2 = string2.substring(1);
            }
            cfgItemController.axisXID = string2;
            if (string3.startsWith("-")) {
                cfgItemController.invertY = true;
                string3 = string3.substring(1);
            } else if (string3.startsWith("+")) {
                cfgItemController.invertY = false;
                string3 = string3.substring(1);
            }
            cfgItemController.axisYID = string3;
        } else {
            throw new RuntimeException("Unknown controller direction mode " + string.toUpperCase());
        }
    }
}

