/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config.handler;

import frc.emul.config.ConfigException;
import frc.emul.config.data.CfgItemBankMenu;
import frc.emul.config.data.CfgItemCartridge;
import frc.emul.config.data.CfgItemCartridgeComposite;
import frc.emul.config.data.CfgItemCartridgePart;
import frc.emul.config.data.CfgItemCartridgeStandalone;
import frc.emul.config.handler.CLHGameCartridgeBank;
import frc.emul.config.handler.CLHGameRoms;
import frc.emul.config.handler.ConfigLoaderHandler;
import frc.util.xml.XMLLoaderHandler;
import org.xml.sax.Attributes;

public class CLHGameCartridge
extends ConfigLoaderHandler {
    private CfgItemCartridgeComposite compositeCart;
    private BankMode bankMode;

    public CLHGameCartridge(CLHGameRoms cLHGameRoms) {
        super(cLHGameRoms);
    }

    public void pushed(Attributes attributes) {
        String string = CLHGameCartridge.loadStr(attributes, "bankMode", "SINGLE");
        this.bankMode = BankMode.getMode(string);
        if (this.bankMode == null) {
            throw new ConfigException("Unsupported bank mode [" + string.toUpperCase() + "]");
        }
        CLHGameRoms cLHGameRoms = (CLHGameRoms)this.getParent();
        if (BankMode.STANDARD == this.bankMode) {
            String string2 = CLHGameCartridge.getBankFilePath(attributes);
            String string3 = CLHGameCartridge.getBankZipEntry(attributes);
            CfgItemCartridgeStandalone cfgItemCartridgeStandalone = cLHGameRoms.createStandaloneCartridge();
            cfgItemCartridgeStandalone.cartridgePath = string2;
            cfgItemCartridgeStandalone.cartZipEntry = string3;
            return;
        }
        String string4 = CLHGameCartridge.loadStr(attributes, "menu", "").trim();
        this.compositeCart = cLHGameRoms.createCompositeCartridge();
        boolean bl = this.compositeCart.dualMode = BankMode.DUAL == this.bankMode;
        if (BankMode.DUAL == this.bankMode && string4.length() > 0) {
            throw new ConfigException("The " + "menu".toUpperCase() + " attribute cannot be specified when using the " + "DUAL" + " mode");
        }
        if (BankMode.MULTIPLE == this.bankMode && string4.length() > 0) {
            CfgItemBankMenu cfgItemBankMenu = this.getConfig().getBankMenu(string4);
            if (cfgItemBankMenu == null) {
                throw new ConfigException("Undefined cartridge menu ID [" + string4 + "]");
            }
            this.compositeCart.menu = cfgItemBankMenu;
        }
    }

    public void poped() {
        if (BankMode.STANDARD != this.bankMode) {
            int n = this.compositeCart.banks.size();
            if (BankMode.DUAL == this.bankMode) {
                if (n != 2) {
                    throw new ConfigException("DUAL bank mode requires exactly 2 banks (found " + n + " banks instead)");
                }
                return;
            }
            if (n < 2) {
                throw new ConfigException("MULTI bank mode requires at least 2 banks, menu included (found " + n + " bank instead)");
            }
        }
    }

    public XMLLoaderHandler getChildHandler(String string, Attributes attributes) {
        if (string.equals("bank")) {
            if (BankMode.STANDARD == this.bankMode) {
                throw new ConfigException("No [bank] sub item allowed for cartridge defined as '" + BankMode.STANDARD.id + "' bank mode");
            }
            return new CLHGameCartridgeBank(this);
        }
        return super.getChildHandler(string, attributes);
    }

    void addBank(CfgItemCartridgePart cfgItemCartridgePart) {
        if (!CfgItemCartridge.isNotBlank(cfgItemCartridgePart.label)) {
            cfgItemCartridgePart.label = "bank #" + this.compositeCart.banks.size();
        }
        this.compositeCart.banks.add(cfgItemCartridgePart);
    }

    static String getBankFilePath(Attributes attributes) {
        String string = attributes.getValue("path");
        if (!CfgItemCartridge.isNotBlank(string)) {
            throw new ConfigException("No path specified for the binary image");
        }
        return string;
    }

    static String getBankZipEntry(Attributes attributes) {
        return attributes.getValue("zipPath");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BankMode {
        STANDARD("SINGLE"),
        DUAL("DUAL"),
        MULTIPLE("MULTI");

        private final String id;

        private BankMode(String string2) {
            this.id = string2;
        }

        static BankMode getMode(String string) {
            BankMode[] bankModeArray = BankMode.values();
            int n = bankModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                BankMode bankMode = bankModeArray[n2];
                if (bankMode.id.equalsIgnoreCase(string)) {
                    return bankMode;
                }
                ++n2;
            }
            return null;
        }
    }
}

