/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config.handler;

import frc.emul.config.Configuration;
import frc.emul.config.data.CfgItemGame;
import frc.emul.config.data.CfgItemGameContainer;
import frc.emul.config.data.CfgItemGameInfo;
import frc.emul.config.data.CfgItemSeparator;
import frc.emul.config.handler.CLHConfiguration;
import frc.emul.config.handler.CLHGame;
import frc.emul.config.handler.CLHSeparator;
import frc.emul.config.handler.ConfigLoaderHandler;
import frc.util.xml.XMLLoaderHandler;
import java.io.File;
import java.util.List;
import org.xml.sax.Attributes;

public class CLHGames
extends ConfigLoaderHandler {
    private CfgItemGame selected;
    private String selectedID;

    public CLHGames(CLHConfiguration cLHConfiguration) {
        super(cLHConfiguration);
    }

    public void pushed(Attributes attributes) {
        String string;
        this.selectedID = CLHGames.getAttribute(attributes, "selected", "MINESTORM");
        String string2 = CLHGames.getAttribute(attributes, "picked", "");
        if (!"".equals(string2) && new File(string2).isFile()) {
            this.addGame(this.getConfig().createUserPickedGame(string2));
        }
        if (!"".equals(string = CLHGames.getAttribute(attributes, "source", "")) && new File(string).isFile()) {
            this.addGame(this.getConfig().createUserBuiltGame(string));
        }
    }

    public void poped() {
        List<CfgItemGameContainer> list = this.getConfig().games;
        int n = list.size();
        while (n > 0 && list.get(n - 1).isSeparator()) {
            list.remove(--n);
        }
        this.getConfig().setSelectedGame(this.selected);
    }

    public XMLLoaderHandler getChildHandler(String string, Attributes attributes) {
        if (string.equals("game")) {
            return new CLHGame(this);
        }
        if (string.equals("separator")) {
            return new CLHSeparator(this){

                protected void addSeparator(CfgItemSeparator cfgItemSeparator) {
                    CLHGames.this.addGameSeparator(cfgItemSeparator);
                }
            };
        }
        return super.getChildHandler(string, attributes);
    }

    void addGameSeparator(CfgItemSeparator cfgItemSeparator) {
        Configuration configuration = this.getConfig();
        int n = configuration.games.size();
        if (n > 0 && configuration.games.get(n - 1).isSeparator()) {
            configuration.games.remove(n - 1);
        }
        this.getConfig().games.add(new CfgItemGameContainer(cfgItemSeparator));
    }

    void addGame(CfgItemGame cfgItemGame) {
        Configuration configuration = this.getConfig();
        if (this.selectedID.equals(cfgItemGame.getID())) {
            this.selected = cfgItemGame;
        }
        if (!cfgItemGame.cartridge.picked && !cfgItemGame.cartridge.built) {
            CfgItemGameInfo cfgItemGameInfo = cfgItemGame.info;
            if (cfgItemGameInfo.category == null) {
                cfgItemGameInfo.category = configuration.getDefaultCategory();
            }
            if (cfgItemGameInfo.author == null) {
                cfgItemGameInfo.author = configuration.getDefaultAuthor();
            }
            configuration.games.add(new CfgItemGameContainer(cfgItemGame));
        }
    }
}

