/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.debug.breakpoints;

import frc.emul.api.IBreakpoint;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class AbstractBreakpoint
implements IBreakpoint {
    private PropertyChangeSupport propSupport;
    private boolean enabled;
    private int address;

    protected AbstractBreakpoint() {
        this(-1);
    }

    protected AbstractBreakpoint(int n) {
        this.address = n;
        this.enabled = true;
    }

    public String toString() {
        return this.getDebugString();
    }

    public String getHitString() {
        return this.getDisplayString();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getAddress() {
        return this.address;
    }

    public int getRange() {
        return 1;
    }

    public boolean hasCondition() {
        return false;
    }

    public void setAddress(int n) {
        int n2 = this.address;
        this.address = n;
        if (this.getPropSupport() != null) {
            this.getPropSupport().firePropertyChange("address", n2, n);
        }
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.enabled;
        this.enabled = bl;
        if (this.getPropSupport() != null) {
            this.getPropSupport().firePropertyChange("enable", bl2, bl);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propSupport != null) {
            this.propSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propSupport == null) {
            this.propSupport = new PropertyChangeSupport(this);
        }
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public String getDebugString() {
        return String.valueOf(this.isEnabled() ? "(+) " : "(-) ") + this.getDisplayString();
    }

    protected final PropertyChangeSupport getPropSupport() {
        return this.propSupport;
    }
}

