/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.debug.breakpoints;

import frc.emul.api.engine.IEngineBreakpoint;
import frc.emul.api.engine.IHitCountBreakpoint;
import frc.emul.debug.breakpoints.AbstractBreakpointWithCounter;
import frc.emul.debug.model.DebugLine;
import frc.emul.util.Utils;
import frc.emul.vectrex.Vectrex;

public class ExecutionBreakpoint
extends AbstractBreakpointWithCounter
implements IEngineBreakpoint,
IHitCountBreakpoint {
    private DebugLine dbgLine;

    public ExecutionBreakpoint(int n) {
        super(n);
    }

    public ExecutionBreakpoint(DebugLine debugLine) {
        super(debugLine.getAddress());
        this.setLine(debugLine);
    }

    public void setLine(DebugLine debugLine) {
        this.dbgLine = debugLine;
    }

    public DebugLine getLine() {
        return this.dbgLine;
    }

    public String getDisplayString() {
        StringBuffer stringBuffer = new StringBuffer(80);
        if (this.dbgLine == null) {
            stringBuffer.append("Execution at $").append(Utils.HEX4(this.getAddress()));
        } else {
            stringBuffer.append("Exec. $").append(Utils.HEX4(this.getAddress())).append(" (line ").append(this.dbgLine.getRow() + 1).append(", ").append(this.dbgLine.getSource().getName()).append(')');
        }
        return this.appendCounterDisplay(stringBuffer);
    }

    public String getHitString() {
        return "Program Counter at $" + Utils.HEX4(this.getAddress());
    }

    public void reset(Vectrex vectrex) {
        this.resetCounter();
    }

    public boolean evaluate(Vectrex vectrex) {
        return this.isEnabled() && vectrex.getCPU().getRegisters().PC() == this.getAddress() && this.hitCounter();
    }

    public boolean isTemporary() {
        return false;
    }

    public void setAddress(int n) {
        if (this.getAddress() != n && this.dbgLine != null && this.dbgLine.getAddress() != n) {
            this.dbgLine = null;
        }
        super.setAddress(n);
    }
}

