/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.debug.model;

import frc.emul.api.engine.IDebugEngine;
import frc.emul.api.engine.IDebugEventManager;
import frc.emul.api.engine.IStatus;
import frc.emul.debug.engine.StatusInfo;
import frc.emul.mc6809.MC6809;

public class DebugContext {
    private final IDebugEngine engine;
    private final IDebugEventManager evtMgr;

    public DebugContext(IDebugEngine iDebugEngine, IDebugEventManager iDebugEventManager) {
        this.engine = iDebugEngine;
        this.evtMgr = iDebugEventManager;
    }

    public IDebugEngine getEngine() {
        return this.engine;
    }

    public IDebugEventManager getEventManager() {
        return this.evtMgr;
    }

    public MC6809 getCPU() {
        return this.engine.getCore().getCPU();
    }

    public boolean canTerminate() {
        return this.engine.canTerminate();
    }

    public boolean isTerminated() {
        return this.engine.isTerminated();
    }

    public IStatus terminate() {
        if (!this.engine.terminate()) {
            return StatusInfo.error("The VM thread failed to terminate properly");
        }
        return StatusInfo.OK_STATUS;
    }

    public boolean canResume() {
        return this.engine.canResume();
    }

    public void resume() {
        this.engine.resume();
    }

    public boolean canSuspend() {
        return this.engine.canSuspend();
    }

    public boolean isSuspended() {
        return this.engine.isSuspended();
    }

    public void suspend() {
        this.engine.suspend();
    }

    public boolean canStepInto() {
        return this.engine.canStepInto();
    }

    public boolean canStepOver() {
        return this.engine.canStepOver();
    }

    public boolean canStepReturn() {
        return this.engine.canStepReturn();
    }

    public boolean isStepping() {
        return this.engine.isStepping();
    }

    public void stepInto() {
        this.engine.stepInto();
    }

    public void stepOver() {
        this.engine.stepOver();
    }

    public void stepReturn() {
        this.engine.stepReturn();
    }
}

