/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.debug.model;

import frc.emul.debug.model.DebugLine;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugSourceFile {
    private HashMap<Integer, DebugLine> lineAtRow;
    private HashMap<Integer, DebugLine> lineAtAddr;
    private String[] lines;
    private Integer maxLineWidth;
    private File source;

    public DebugSourceFile(File file) {
        this.source = file;
        this.lineAtRow = new HashMap();
        this.lineAtAddr = new HashMap();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DebugSourceFile) {
            DebugSourceFile debugSourceFile = (DebugSourceFile)object;
            return this.source == null || debugSourceFile.source == null ? this.source == debugSourceFile.source : this.source.equals(debugSourceFile.source);
        }
        return false;
    }

    public String initialise() {
        return this.lines == null ? this.loadContent() : null;
    }

    public String getName() {
        return this.source.getName();
    }

    public File getFile() {
        return this.source;
    }

    public DebugLine createDebugLine(int n, int n2) {
        int n3 = n2 - 1;
        DebugLine debugLine = new DebugLine(n, n3, this);
        this.lineAtRow.put(n3, debugLine);
        this.lineAtAddr.put(n, debugLine);
        return debugLine;
    }

    public int getLinesCount() {
        return this.lines.length;
    }

    public String getLineContent(int n) {
        return this.lines[n];
    }

    public String[] getLinesContent() {
        return this.lines;
    }

    public Collection<DebugLine> getLines() {
        return this.lineAtRow.values();
    }

    public int getMaxLineWidth() {
        if (this.maxLineWidth == null) {
            int n = 0;
            String[] stringArray = this.lines;
            int n2 = this.lines.length;
            int n3 = 0;
            while (n3 < n2) {
                String string = stringArray[n3];
                int n4 = string.length();
                if (n4 > n) {
                    n = n4;
                }
                ++n3;
            }
            this.maxLineWidth = new Integer(n);
        }
        return this.maxLineWidth;
    }

    public DebugLine getLineAtRow(int n) {
        return this.lineAtRow.get(n);
    }

    public DebugLine getLineAtAddress(int n) {
        return this.lineAtAddr.get(n);
    }

    private String loadContent() {
        ArrayList<String> arrayList;
        BufferedReader bufferedReader;
        block22: {
            bufferedReader = null;
            arrayList = new ArrayList<String>(200);
            try {
                String string;
                bufferedReader = new BufferedReader(new FileReader(this.getFile()));
                while ((string = bufferedReader.readLine()) != null) {
                    arrayList.add(string);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = "File not found : \"" + this.getFile().getAbsolutePath() + "\"";
                if (this.lines == null) {
                    this.lines = new String[0];
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
                return string;
            }
            catch (IOException iOException) {
                String string;
                block21: {
                    try {
                        string = "Failed to load content of file \"" + this.getFile().getAbsolutePath() + "\"";
                        if (this.lines != null) break block21;
                    }
                    catch (Throwable throwable) {
                        if (this.lines == null) {
                            this.lines = new String[0];
                        }
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        throw throwable;
                    }
                    this.lines = new String[0];
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException3) {}
                }
                return string;
            }
            if (this.lines != null) break block22;
            this.lines = new String[0];
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        this.lines = arrayList.toArray(new String[arrayList.size()]);
        return null;
    }
}

