/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.mc6809;

import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Operand {
    REG_A{

        public final String getName() {
            return "A";
        }

        public final boolean isReg8() {
            return true;
        }

        public final boolean isRegister() {
            return true;
        }
    }
    ,
    REG_B{

        public final String getName() {
            return "B";
        }

        public final boolean isReg8() {
            return true;
        }

        public final boolean isRegister() {
            return true;
        }
    }
    ,
    REG_D{

        public final String getName() {
            return "D";
        }

        public final boolean isReg8() {
            return false;
        }

        public final boolean isRegister() {
            return true;
        }
    }
    ,
    REG_CC{

        public final String getName() {
            return "CC";
        }

        public final boolean isReg8() {
            return true;
        }

        public final boolean isRegister() {
            return true;
        }
    }
    ,
    REG_DP{

        public final String getName() {
            return "DP";
        }

        public final boolean isReg8() {
            return true;
        }

        public final boolean isRegister() {
            return true;
        }
    }
    ,
    REG_X{

        public final String getName() {
            return "X";
        }

        public final boolean isReg8() {
            return false;
        }

        public final boolean isRegister() {
            return true;
        }
    }
    ,
    REG_Y{

        public final String getName() {
            return "Y";
        }

        public final boolean isReg8() {
            return false;
        }

        public final boolean isRegister() {
            return true;
        }
    }
    ,
    REG_U{

        public final String getName() {
            return "U";
        }

        public final boolean isReg8() {
            return false;
        }

        public final boolean isRegister() {
            return true;
        }
    }
    ,
    REG_S{

        public final String getName() {
            return "S";
        }

        public final boolean isReg8() {
            return false;
        }

        public final boolean isRegister() {
            return true;
        }
    }
    ,
    REG_PC{

        public final String getName() {
            return "PC";
        }

        public final boolean isReg8() {
            return false;
        }

        public final boolean isRegister() {
            return true;
        }
    }
    ,
    CONSTANT{

        public final boolean isReg8() {
            return false;
        }
    }
    ,
    REGISTER,
    MEMORY,
    NONE;


    private Operand() {
    }

    public boolean isRegister() {
        return false;
    }

    public String getName() {
        throw new UnsupportedOperationException("Not a register : " + (Object)((Object)this));
    }

    public boolean isReg8() {
        throw new UnsupportedOperationException("Not a register : " + (Object)((Object)this));
    }

    public boolean isReg16() {
        return !this.isReg8();
    }

    public static final EnumSet<Operand> registers() {
        return EnumSet.of(REG_A, new Operand[]{REG_B, REG_D, REG_X, REG_Y, REG_U, REG_S, REG_DP, REG_CC, REG_PC});
    }

    public static final Operand getRegister(String string) {
        for (Operand operand : Operand.registers()) {
            if (!operand.getName().equals(string)) continue;
            return operand;
        }
        return null;
    }

    /* synthetic */ Operand(String string, int n, Operand operand) {
        this();
    }
}

