/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.mc6809.dasm;

import frc.emul.api.IAddressBinder;
import frc.emul.api.IMemory;
import frc.emul.mc6809.Instruction;
import frc.emul.mc6809.Instructions;
import frc.emul.mc6809.Regs;
import frc.emul.mc6809.dasm.DasmComment;
import frc.emul.mc6809.dasm.DasmCore;
import frc.emul.mc6809.dasm.DasmParams;
import frc.emul.mc6809.dasm.DasmRegs;
import frc.emul.mc6809.dasm.IDasmRegs;
import frc.emul.util.RawMemory;
import frc.emul.util.Utils;
import frc.util.NullOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dasm {
    private static final boolean LOG_DASM_EXCEPTIONS = true;
    private static final boolean VERBOSE = true;
    private static final String LINE_HEADER = "  ";
    private static final int DATALINE_MAX_LEN = 10;
    private static final byte DATATYPE_CODE = 0;
    private static final byte DATATYPE_ANYDATA = 1;
    private static final byte DATATYPE_PTR = 2;
    private static final byte DATATYPE_MASK = 15;
    private static final byte DATAFLAG_FLUSH = 16;
    private static final byte DATATYPE_NOLABEL = 32;
    private static final byte DATATYPE_NOREF = 64;
    private static final byte DATAFLAG_NEWLINE = -128;
    private static final String COMMENT_SEPARATOR = "__________________________________________________________________";
    private static final String KEY_COMMENT = ".COMMENT ";
    private static final String KEY_NOREF = ".NOREF ";
    private static final String KEY_NOLABEL = ".NOLABEL ";
    private static final String KEY_NOTE = ".NOTE ";
    private static final String KEY_FLUSH = ".FLUSH ";
    private static final String KEY_LABEL = ".LABEL ";
    private static final String KEY_EXTERN = ".EXTERN ";
    private static final String KEY_REG = ".REG ";
    private static final String KEY_DATA = ".DATA ";
    private static final String KEY_PTR = ".PTR ";
    private static final String KEY_START = ".START ";
    private static final String KEY_STOP = ".STOP ";
    private static final String KEY_ORG = ".ORG ";
    private static final String KEY_HEADER = ".HEADER ";
    private static final String MARKER_NEWLINE = "*";
    private static final String MARKER_NO_NEWLINE = "^";
    private final IMemory mem;
    private final IAddressBinder binder;
    private final Instructions instrs;
    private DasmComment comments;
    private boolean createLabels;
    private boolean pureASM;
    private final int[] dataBytesData = new int[10];
    private int dataBytesAddr;
    private int dataBytesLen;
    private boolean lastLineEmpty;

    public Dasm(IAddressBinder iAddressBinder, boolean bl, IMemory iMemory) {
        this.mem = iMemory;
        this.binder = iAddressBinder;
        this.instrs = new Instructions(bl);
    }

    public Dasm(IAddressBinder iAddressBinder, boolean bl, byte[] byArray, int n) {
        this.mem = new RawMemory("DATA", n, byArray.length, false, true, false, false);
        this.binder = iAddressBinder;
        this.instrs = new Instructions(bl);
        this.mem.feed(byArray, 0, this.mem.getFirstAddress(), byArray.length);
    }

    public void setLabelsCreated(boolean bl) {
        this.createLabels = bl;
    }

    public void setComments(DasmComment dasmComment) {
        this.comments = dasmComment;
    }

    public void setPureASM(boolean bl) {
        this.pureASM = bl;
    }

    public synchronized void disassemble(int n, int n2, IDasmRegs iDasmRegs, byte[] byArray, HashMap<String, String> hashMap, List<Integer> list, PrintStream printStream) throws IOException {
        DasmCore dasmCore = new DasmCore(this.mem, iDasmRegs, this.binder, this.createLabels, this.pureASM);
        this.dataBytesLen = 0;
        this.emptyLine(printStream);
        int n3 = n + n2;
        while (n < n3) {
            try {
                Object object;
                Iterator iterator;
                Object object2;
                int n4 = byArray[n] & 0xFF;
                if ((n4 & 0xFFFFFF80) != 0) {
                    this.emptyLine(printStream);
                }
                if (this.comments != null && (object2 = this.comments.getNotes(n)) != null) {
                    this.flushDataBytes(printStream);
                    iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        object = (String)iterator.next();
                        printStream.println((String)object);
                    }
                    boolean bl = this.lastLineEmpty = ((String)object2.get(0)).length() > 0;
                }
                if ((object2 = this.binder.getLabel(n)) != null && !list.contains(n)) {
                    this.flushDataBytes(printStream);
                    printStream.println(String.valueOf(object2) + ":");
                    this.lastLineEmpty = false;
                }
                Object object3 = object = (n4 & 0xF) == 0 ? this.instrs.fetch(this.mem, n) : null;
                if (object == null) {
                    if ((n4 & 2) != 0) {
                        this.flushDataBytes(printStream);
                        n = this.dumpDataPointers(printStream, n, byArray, hashMap);
                        continue;
                    }
                    if ((n4 & 0x10) != 0) {
                        this.flushDataBytes(printStream);
                    }
                    this.processDataBytes(printStream, n++);
                    continue;
                }
                iterator = this.comments == null ? null : this.comments.getComment(n);
                StringBuffer stringBuffer = dasmCore.DASM((Instruction)object, n + ((Instruction)object).getOpcodeLen(), (String)((Object)iterator), (n4 & 0x40) == 0);
                this.flushDataBytes(printStream);
                printStream.println(LINE_HEADER + stringBuffer);
                this.lastLineEmpty = false;
                switch (((Instruction)object).getOpcode()) {
                    case 14: 
                    case 22: 
                    case 32: 
                    case 57: 
                    case 59: 
                    case 110: 
                    case 126: {
                        this.emptyLine(printStream);
                        break;
                    }
                    case 30: {
                        int n5 = this.mem.readS8(n + 1);
                        if (n5 == 85 || (n5 & 0xF) != 5 && (n5 & 0xF0) != 80) break;
                        this.emptyLine(printStream);
                        break;
                    }
                    case 31: {
                        if ((this.mem.readS8(n + 1) & 0xF) != 5) break;
                        this.emptyLine(printStream);
                        break;
                    }
                    case 53: 
                    case 55: {
                        if (this.mem.readS8(n + 1) >= 0) break;
                        this.emptyLine(printStream);
                        break;
                    }
                }
                n = dasmCore.getNextFetchAddress();
            }
            catch (Exception exception) {
                System.err.println("Exception while disassembling instruction at $" + Utils.HEX(4, n) + " :");
                exception.printStackTrace(System.err);
                this.processDataBytes(printStream, n++);
            }
        }
        this.flushDataBytes(printStream);
    }

    private final void processDataBytes(PrintStream printStream, int n) {
        if (this.dataBytesLen == 0) {
            this.dataBytesAddr = n;
        }
        this.dataBytesData[this.dataBytesLen++] = this.mem.readU8(n);
        if (this.dataBytesData.length == this.dataBytesLen) {
            this.flushDataBytes(printStream);
        }
    }

    private final void emptyLine(PrintStream printStream) {
        if (!this.lastLineEmpty) {
            this.flushDataBytes(printStream);
            printStream.println();
            this.lastLineEmpty = true;
        }
    }

    private final int dumpDataPointers(PrintStream printStream, int n, byte[] byArray, HashMap<String, String> hashMap) {
        String string = hashMap.get(KEY_PTR + n);
        int n2 = this.pureASM ? 56 : 53;
        int n3 = 0;
        while ((byArray[n] & 2) != 0) {
            StringBuffer stringBuffer = new StringBuffer(40).append(LINE_HEADER);
            if (this.pureASM) {
                stringBuffer.append("        dw    ");
            } else {
                Utils.HEX(4, n, stringBuffer).append(" .addr ");
            }
            int n4 = this.mem.readU16(n);
            String string2 = Utils.HEX(4, n4);
            String string3 = this.binder.getLabel(n4);
            String string4 = "";
            if (string3 == null) {
                if (this.createLabels && n4 != 0 && this.mem.isValidArea(n4, 1)) {
                    string3 = string == null ? String.valueOf(DasmCore.LABEL_HEADER) + string2 : String.valueOf(string) + string2;
                    this.binder.bind(n4, string3);
                }
                stringBuffer.append('$').append(string2);
            } else {
                string4 = "$" + string2;
                stringBuffer.append(string3);
            }
            Utils.pad(n2, ' ', stringBuffer).append("; ").append(string4);
            if (n3 > 0 || (byArray[n += 2] & 2) != 0) {
                stringBuffer.append(" -> Index ").append(n3);
            }
            ++n3;
            printStream.println(stringBuffer);
            if (this.binder.getLabel(n) != null) break;
        }
        return n;
    }

    private final void flushDataBytes(PrintStream printStream) {
        if (this.dataBytesLen != 0) {
            int n;
            StringBuffer stringBuffer = new StringBuffer(50);
            if (this.pureASM) {
                stringBuffer.append("        db    ");
                n = 0;
                while (n < this.dataBytesLen) {
                    Utils.HEX(2, this.dataBytesData[n++], stringBuffer.append(n == 1 ? "$" : ",$"));
                }
                Utils.pad(54, ' ', stringBuffer).append("; \"");
            } else {
                Utils.HEX(4, this.dataBytesAddr, stringBuffer).append(" .data");
                n = 0;
                while (n < this.dataBytesLen) {
                    Utils.HEX(2, this.dataBytesData[n++], stringBuffer.append(" $"));
                }
                Utils.pad(50, '-', stringBuffer.append(' '));
                Utils.pad(51, ' ', stringBuffer).append("; ascii \"");
            }
            n = 0;
            while (n < this.dataBytesLen) {
                char c;
                if ((c = (char)this.dataBytesData[n++]) < ' ' || c > '~') {
                    c = '.';
                }
                stringBuffer.append(c);
            }
            stringBuffer.append('\"');
            printStream.println(LINE_HEADER + stringBuffer);
            this.lastLineEmpty = false;
            this.dataBytesLen = 0;
        }
    }

    public static final boolean disassemble(String string, String string2) throws IOException {
        return Dasm.disassemble(string, string2, null);
    }

    public static final boolean disassemble(String string, String string2, String string3) throws IOException {
        return Dasm.disassemble(string, string2, string3, false, false);
    }

    public static final boolean disassemble(String string, String string2, String string3, boolean bl, boolean bl2) throws IOException {
        Object object;
        Object object2;
        DasmParams dasmParams = new DasmParams();
        if (string3 != null) {
            object2 = new File(string3);
            if (!((File)object2).isFile()) {
                System.out.println("*** Cannot find properties file : " + string3);
                return false;
            }
            System.out.println("Loading properties [" + string3 + "]");
            object = new BufferedReader(new InputStreamReader(new FileInputStream((File)object2)));
            try {
                Dasm.parsePropertiesFile((BufferedReader)object, dasmParams, bl2);
            }
            finally {
                ((BufferedReader)object).close();
            }
        }
        object2 = null;
        object = null;
        try {
            object2 = Dasm.class.getClassLoader().getResourceAsStream(string);
        }
        catch (Exception exception) {}
        if (object2 == null && !((File)(object = new File(string))).isFile()) {
            System.out.println("*** Cannot find input file : " + string);
            return false;
        }
        System.out.println("Disassembling [" + string + "]");
        if (object != null) {
            object2 = new BufferedInputStream(new FileInputStream((File)object));
        }
        if (object2 == null) {
            System.out.println("*** Error while opening input file : " + string);
            return false;
        }
        int n = 0;
        while (((InputStream)object2).read() != -1) {
            ++n;
        }
        ((InputStream)object2).close();
        object2 = new FileInputStream((File)object);
        RawMemory rawMemory = new RawMemory(string, dasmParams.org, n + 5, false, true, false, false);
        try {
            if (!rawMemory.load((InputStream)object2, true)) {
                System.out.println("*** Error while loading input file : " + string);
                return false;
            }
        }
        finally {
            ((InputStream)object2).close();
        }
        PrintStream printStream = new PrintStream(new FileOutputStream(string2));
        try {
            Dasm dasm = new Dasm(dasmParams.binder, false, rawMemory);
            dasm.setPureASM(bl2);
            n = Math.min(n - (dasmParams.startAt - dasmParams.org), dasmParams.stopAt - dasmParams.startAt);
            if (bl) {
                dasm.setLabelsCreated(true);
                dasm.disassemble(dasmParams.startAt, n, dasmParams.regs, dasmParams.types, dasmParams.props, dasmParams.extern, new PrintStream(new NullOutputStream()));
                dasm.setLabelsCreated(false);
                byte[] byArray = dasmParams.types;
                int n2 = byArray.length;
                while (n2-- > 0) {
                    if ((byArray[n2] & 0x20) == 0) continue;
                    dasmParams.binder.unbind(n2);
                }
            }
            if (!dasmParams.comments.isEmpty()) {
                dasm.setComments(dasmParams.comments);
            }
            if (bl2) {
                if (!dasmParams.extern.isEmpty()) {
                    for (int n3 : dasmParams.extern) {
                        if (rawMemory.isValidArea(n3, 1)) continue;
                        StringBuffer stringBuffer = new StringBuffer(dasmParams.binder.getLabel(n3));
                        Utils.pad(20, ' ', stringBuffer);
                        Utils.HEX(4, n3, stringBuffer.append(" EQU  $"));
                        printStream.println(stringBuffer);
                    }
                    printStream.println(" ");
                }
                printStream.println("          NOOPT");
                printStream.println("          DIRECT -1");
                printStream.println("          INCLUDE \"vectrex.i\"");
                printStream.println(";__________________________________________________________________");
            }
            dasm.disassemble(dasmParams.startAt, n, dasmParams.regs, dasmParams.types, dasmParams.props, dasmParams.extern, printStream);
        }
        finally {
            printStream.close();
        }
        return true;
    }

    private static void parsePropertiesFile(BufferedReader bufferedReader, DasmParams dasmParams, boolean bl) throws IOException {
        String string;
        DasmRegs dasmRegs = new DasmRegs();
        byte[] byArray = dasmParams.types;
        while ((string = bufferedReader.readLine()) != null) {
            int n = string.indexOf(35);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            if ((string = string.replace('\t', ' ').trim()).length() == 0) continue;
            String string2 = string.toUpperCase();
            try {
                int n2;
                int n3;
                int n4;
                if (string2.startsWith(KEY_LABEL) || string2.startsWith(KEY_EXTERN)) {
                    String string3;
                    n4 = string.indexOf(36);
                    n3 = string.indexOf(61, n4);
                    if (n3 >= 0) {
                        n2 = Integer.parseInt(string.substring(n4 + 1, n3).trim(), 16);
                        string3 = string.substring(n3 + 1).trim();
                    } else {
                        n2 = Integer.parseInt(string.substring(n4 + 1).trim(), 16);
                        string3 = String.valueOf(DasmCore.LABEL_HEADER) + Utils.HEX(4, n2);
                    }
                    if (string3.startsWith(MARKER_NEWLINE)) {
                        string3 = string3.substring(MARKER_NEWLINE.length());
                        int n5 = n2;
                        byArray[n5] = (byte)(byArray[n5] | 0xFFFFFF80);
                    }
                    if (string3.length() > 0) {
                        dasmParams.binder.bind(n2, string3);
                    }
                    if (!string2.startsWith(KEY_EXTERN)) continue;
                    dasmParams.extern.add(n2);
                    continue;
                }
                if (string2.startsWith(KEY_COMMENT)) {
                    n4 = string.indexOf(36);
                    n3 = string.indexOf(61, n4);
                    n2 = Integer.parseInt(string.substring(n4 + 1, n3).trim(), 16);
                    String string4 = string.substring(n3 + 1).trim();
                    if (string4.length() <= 0) continue;
                    dasmParams.comments.addComment(n2, string4);
                    continue;
                }
                if (string2.startsWith(KEY_FLUSH)) {
                    n4 = string.indexOf(36);
                    while (n4 >= 0) {
                        n3 = Math.min(n4 + 5, string.length());
                        int n6 = n2 = Integer.parseInt(string.substring(n4 + 1, n3), 16);
                        byArray[n6] = (byte)(byArray[n6] | 0x10);
                        n4 = string.indexOf(36, n4 + 5);
                    }
                    continue;
                }
                if (string2.startsWith(KEY_NOREF)) {
                    n4 = string.indexOf(36);
                    while (n4 >= 0) {
                        n3 = Math.min(n4 + 5, string.length());
                        int n7 = n2 = Integer.parseInt(string.substring(n4 + 1, n3), 16);
                        byArray[n7] = (byte)(byArray[n7] | 0x40);
                        n4 = string.indexOf(36, n4 + 5);
                    }
                    continue;
                }
                if (string2.startsWith(KEY_NOLABEL)) {
                    n4 = string.indexOf(36);
                    while (n4 >= 0) {
                        n3 = Math.min(n4 + 5, string.length());
                        int n8 = n2 = Integer.parseInt(string.substring(n4 + 1, n3), 16);
                        byArray[n8] = (byte)(byArray[n8] | 0x20);
                        n4 = string.indexOf(36, n4 + 5);
                    }
                    continue;
                }
                if (string2.startsWith(KEY_NOTE)) {
                    int n9;
                    n4 = string.indexOf(36);
                    n3 = string.indexOf(61, n4);
                    n2 = Integer.parseInt(string.substring(n4 + 1, n3).trim(), 16);
                    String string5 = string.substring(n3 + 1);
                    do {
                        String string6;
                        if ((n9 = string5.indexOf(92)) >= 0) {
                            string6 = string5.substring(0, n9);
                            string5 = n9 == string5.length() - 1 ? bufferedReader.readLine() : string5.substring(n9 + 1);
                        } else {
                            string6 = string5;
                        }
                        if (string6.length() > 0 && string6.charAt(string6.length() - 1) == '_') {
                            string6 = String.valueOf(string6) + COMMENT_SEPARATOR;
                        } else if (string6.equals(".")) {
                            string6 = "";
                        }
                        dasmParams.comments.addNote(n2, string6.trim());
                    } while (n9 >= 0);
                    continue;
                }
                if (string2.startsWith(KEY_REG)) {
                    n4 = string.indexOf("[$");
                    n3 = string.indexOf("-$", n4);
                    n2 = string.indexOf(93, n3);
                    int n10 = string.indexOf(36, n2);
                    String string7 = string2.substring(KEY_REG.length(), n4 - 1).trim();
                    int n11 = Integer.parseInt(string.substring(n4 + 2, n3).trim(), 16);
                    int n12 = Integer.parseInt(string.substring(n3 + 2, n2).trim(), 16);
                    int n13 = Integer.parseInt(string.substring(n10 + 1).trim(), 16);
                    dasmParams.regs = dasmRegs;
                    dasmRegs.addRegValue(Regs.getOperand(string7), n11, n12, n13);
                    continue;
                }
                if (string2.startsWith(KEY_DATA)) {
                    int n14;
                    n4 = string.indexOf("[$");
                    n3 = string.indexOf("-$", n4);
                    n2 = string.indexOf(93, n3);
                    int n15 = Integer.parseInt(string.substring(n4 + 2, n3).trim(), 16);
                    if (n15 <= (n14 = Integer.parseInt(string.substring(n3 + 2, n2).trim(), 16))) {
                        int n16 = n15;
                        byArray[n16] = (byte)(byArray[n16] | 0xFFFFFF80);
                        int n17 = n14 + 1;
                        byArray[n17] = (byte)(byArray[n17] | 0xFFFFFF80);
                        do {
                            int n18 = byArray[n14] & 0xFF;
                            n18 = n18 & 0xFFFFFFF0 | 1;
                            byArray[n14--] = (byte)n18;
                        } while (n15 <= n14);
                        n4 = string.indexOf(61, n2);
                        if (n4 > 0) {
                            String string8 = string.substring(n4 + 1).trim();
                            if (string8.startsWith(MARKER_NEWLINE)) {
                                string8 = string8.substring(MARKER_NEWLINE.length());
                            }
                            if (string8.startsWith(MARKER_NO_NEWLINE)) {
                                string8 = string8.substring(MARKER_NO_NEWLINE.length());
                                int n19 = n15;
                                byArray[n19] = (byte)(byArray[n19] & 0x7F);
                            }
                            if (string8.length() <= 0) continue;
                            dasmParams.binder.bind(n15, string8);
                            continue;
                        }
                        dasmParams.binder.bind(n15, "data_" + Utils.hex(4, n15));
                        continue;
                    }
                } else if (string2.startsWith(KEY_PTR)) {
                    int n20;
                    n4 = string.indexOf("[$");
                    n3 = string.indexOf("-$", n4);
                    n2 = string.indexOf(93, n3);
                    if (n3 < 0) {
                        n3 = n2;
                    }
                    int n21 = Integer.parseInt(string.substring(n4 + 2, n3).trim(), 16);
                    int n22 = n20 = n3 == n2 ? n21 + 1 : Integer.parseInt(string.substring(n3 + 2, n2).trim(), 16);
                    if ((n21 - n20 & 1) == 0) {
                        System.out.println("*** WARNING : Pointers area does not have an even number of bytes : {" + string + "}");
                        ++n20;
                    }
                    if (n21 <= n20) {
                        n4 = string.indexOf(44, n2);
                        if (n4 > 0) {
                            dasmParams.props.put(KEY_PTR + n21, string.substring(n4 + 1).trim());
                            string = string.substring(0, n4);
                        }
                        int n23 = n20;
                        do {
                            int n24 = byArray[n23] & 0xFF;
                            n24 = n24 & 0xFFFFFFF0 | 3;
                            byArray[n23--] = (byte)n24;
                        } while (n21 <= n23);
                        n4 = string.indexOf(61, n2);
                        if (n4 <= 0) continue;
                        String string9 = string.substring(n4 + 1).trim();
                        if (string9.startsWith(MARKER_NEWLINE)) {
                            int n25 = n21;
                            byArray[n25] = (byte)(byArray[n25] | 0xFFFFFF80);
                            string9 = string9.substring(MARKER_NEWLINE.length());
                        }
                        if (string9.endsWith(MARKER_NEWLINE)) {
                            int n26 = n20 + 1;
                            byArray[n26] = (byte)(byArray[n26] | 0xFFFFFF80);
                            string9 = string9.substring(0, string9.length() - MARKER_NEWLINE.length());
                        }
                        if (string9.length() <= 0) continue;
                        dasmParams.binder.bind(n21, string9);
                        continue;
                    }
                } else {
                    if (string2.startsWith(KEY_ORG)) {
                        n4 = string.indexOf(36);
                        dasmParams.org = Integer.parseInt(string.substring(n4 + 1), 16);
                        continue;
                    }
                    if (string2.startsWith(KEY_HEADER)) {
                        n4 = string.indexOf(34);
                        n3 = string.lastIndexOf(34);
                        if (n3 <= n4) {
                            System.out.println("*** WARNING : Discarding invalid label header : {" + string + "}");
                            continue;
                        }
                        DasmCore.LABEL_HEADER = string.substring(n4 + 1, n3);
                        continue;
                    }
                    if (string2.startsWith(KEY_START)) {
                        n4 = string.indexOf(36);
                        n3 = Integer.parseInt(string.substring(n4 + 1), 16);
                        if (bl) {
                            n2 = 0;
                            while (n2 < n3) {
                                int n27 = byArray[n2] & 0xFF;
                                n27 = n27 & 0xFFFFFFF0 | 1;
                                byArray[n2] = (byte)n27;
                                ++n2;
                            }
                            int n28 = n3;
                            byArray[n28] = (byte)(byArray[n28] | 0xFFFFFF80);
                            dasmParams.startAt = 0;
                            continue;
                        }
                        dasmParams.startAt = n3;
                        continue;
                    }
                    if (string2.startsWith(KEY_STOP)) {
                        n4 = string.indexOf(36);
                        dasmParams.stopAt = Integer.parseInt(string.substring(n4 + 1), 16);
                        continue;
                    }
                }
                System.out.println("*** WARNING : Discarding invalid property line : {" + string + "}");
            }
            catch (Exception exception) {
                System.out.println("*** ERROR while parsing property line (" + string + ")");
            }
        }
    }

    public static final void gatherDasmLabels(String string, IAddressBinder iAddressBinder) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
        try {
            Dasm.parsePropertiesFile(bufferedReader, new DasmParams(iAddressBinder), false);
        }
        finally {
            bufferedReader.close();
        }
    }

    public static final void main(String[] stringArray) throws IOException {
        Dasm.disassemble("data-dev/roms/private/provided by Rudy D/mailrd2.bin", "data-dev/bios/dasm/mailrd2.asm", "data-dev/bios/dasm.properties/mailrd2.dasm.properties", true, false);
        System.out.println("DONE");
    }

    public static final void externalMain(String[] stringArray) throws IOException {
        System.out.println("___________________________________________________");
        System.out.println("6809 DASM for Vectrex, (c)2006-2010 Franck Chevassu");
        System.out.println();
        if (stringArray.length < 2 || stringArray.length > 3) {
            System.out.println("*** ERROR : Invalid parameters count");
            System.out.println();
            System.out.println("USAGE: dasm <input-binary> <output-source> [input-dasm-properties]");
            System.out.println();
            System.out.println("EXAMPLES:  dasm  vfm.bin  vfm.asm");
            System.out.println("           dasm  vfm.bin  out\\vfm.asm  vfm.dasm");
            System.out.println();
            System.out.println("NOTES: ");
            System.out.println("1) All parameters are file paths relative to [" + new File("data/dasm/").getCanonicalPath() + "]");
            System.out.println("2) The disassembler will create two output sources:");
            System.out.println("   -> one prefixed with 'LST_' that can be loaded by ParaJVD");
            System.out.println("   -> one prefixed with 'SRC_' that should be AS09 assembler compatible");
            return;
        }
        String string = "data/dasm/" + stringArray[0];
        String string2 = "data/dasm/" + stringArray[1];
        String string3 = stringArray.length > 2 ? "data/dasm/" + stringArray[2] : null;
        File file = new File(string2).getCanonicalFile();
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        String string4 = new File(file2, "LST_" + file.getName()).getCanonicalPath();
        String string5 = new File(file2, "SRC_" + file.getName()).getCanonicalPath();
        System.out.println("DASM input file ... " + (string3 == null ? "<none>" : new File(string3).getCanonicalPath()));
        System.out.println("ROM  input file ... " + new File(string).getCanonicalPath());
        System.out.println("LST output file ... " + string4);
        System.out.println("SRC output file ... " + string5);
        System.out.println();
        System.out.println("LST-like processing...");
        Dasm.disassemble(string, string4, string3, true, false);
        System.out.println();
        System.out.println("SRC-like processing...");
        Dasm.disassemble(string, string5, string3, true, true);
        System.out.println();
        System.out.println("DONE");
    }
}

