/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.mc6809.dasm;

import frc.emul.api.IMemory;
import frc.emul.mc6809.Instruction;
import frc.emul.util.Utils;

public class DasmUtils {
    public static final boolean isStepInOpcode(Instruction instruction) {
        switch (instruction.getOpcode()) {
            case 23: 
            case 141: 
            case 157: 
            case 173: 
            case 189: {
                return true;
            }
        }
        return false;
    }

    public static final int getInstructionEndAddress(Instruction instruction, int n, IMemory iMemory) {
        int n2 = n + instruction.getOpcodeLen();
        switch (instruction.getMode()) {
            case IMPLIED: {
                switch (instruction.getOp()) {
                    case REG_U: 
                    case REG_S: 
                    case REGISTER: {
                        return n2 + 1;
                    }
                }
                return n2;
            }
            case IMMEDIATE: {
                return instruction.isTargetReg8() ? n2 + 1 : n2 + 2;
            }
            case DIRECT: 
            case RELATIVE8: {
                return n2 + 1;
            }
            case EXTENDED: 
            case RELATIVE16: {
                return n2 + 2;
            }
            case INDEXED: {
                int n3 = iMemory.readU8(n2++);
                if (n3 == 159) {
                    return n2 + 2;
                }
                if ((n3 & 0x8E) == 140) {
                    if ((n3 & 1) == 0) {
                        return n2 + 1;
                    }
                    return n2 + 2;
                }
                if (n3 < 128) {
                    return n2;
                }
                if ((n3 & 0x8C) == 128) {
                    return n2;
                }
                int n4 = n3 & 0x8F;
                if (136 == n4) {
                    return n2 + 1;
                }
                if (137 == n4) {
                    return n2 + 2;
                }
                return n2;
            }
        }
        throw new RuntimeException("Unsupported instruction mode '" + (Object)((Object)instruction.getMode()) + "' at $" + Utils.HEX(4, n));
    }
}

